# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetAppGatewayResult',
    'AwaitableGetAppGatewayResult',
    'get_app_gateway',
    'get_app_gateway_output',
]

@pulumi.output_type
class GetAppGatewayResult:
    def __init__(__self__, allocated_connections=None, create_time=None, display_name=None, host_type=None, labels=None, name=None, state=None, type=None, uid=None, update_time=None, uri=None):
        if allocated_connections and not isinstance(allocated_connections, list):
            raise TypeError("Expected argument 'allocated_connections' to be a list")
        pulumi.set(__self__, "allocated_connections", allocated_connections)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if host_type and not isinstance(host_type, str):
            raise TypeError("Expected argument 'host_type' to be a str")
        pulumi.set(__self__, "host_type", host_type)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if uri and not isinstance(uri, str):
            raise TypeError("Expected argument 'uri' to be a str")
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="allocatedConnections")
    def allocated_connections(self) -> Sequence['outputs.AllocatedConnectionResponse']:
        """
        A list of connections allocated for the Gateway
        """
        return pulumi.get(self, "allocated_connections")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Optional. An arbitrary user-provided name for the AppGateway. Cannot exceed 64 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> str:
        """
        The type of hosting used by the AppGateway.
        """
        return pulumi.get(self, "host_type")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. Resource labels to represent user provided metadata.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique resource name of the AppGateway. The name is ignored when creating an AppGateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the AppGateway.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of network connectivity used by the AppGateway.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        A unique identifier for the instance generated by the system.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Timestamp when the resource was last modified.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Server-defined URI for this resource.
        """
        return pulumi.get(self, "uri")


class AwaitableGetAppGatewayResult(GetAppGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppGatewayResult(
            allocated_connections=self.allocated_connections,
            create_time=self.create_time,
            display_name=self.display_name,
            host_type=self.host_type,
            labels=self.labels,
            name=self.name,
            state=self.state,
            type=self.type,
            uid=self.uid,
            update_time=self.update_time,
            uri=self.uri)


def get_app_gateway(app_gateway_id: Optional[str] = None,
                    location: Optional[str] = None,
                    project: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppGatewayResult:
    """
    Gets details of a single AppGateway.
    """
    __args__ = dict()
    __args__['appGatewayId'] = app_gateway_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:beyondcorp/v1alpha:getAppGateway', __args__, opts=opts, typ=GetAppGatewayResult).value

    return AwaitableGetAppGatewayResult(
        allocated_connections=__ret__.allocated_connections,
        create_time=__ret__.create_time,
        display_name=__ret__.display_name,
        host_type=__ret__.host_type,
        labels=__ret__.labels,
        name=__ret__.name,
        state=__ret__.state,
        type=__ret__.type,
        uid=__ret__.uid,
        update_time=__ret__.update_time,
        uri=__ret__.uri)


@_utilities.lift_output_func(get_app_gateway)
def get_app_gateway_output(app_gateway_id: Optional[pulumi.Input[str]] = None,
                           location: Optional[pulumi.Input[str]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppGatewayResult]:
    """
    Gets details of a single AppGateway.
    """
    ...
