# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 hyperthreading_enabled: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 logical_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs']]]] = None,
                 luns: Optional[pulumi.Input[Sequence[pulumi.Input['LunArgs']]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_template: Optional[pulumi.Input[str]] = None,
                 os_image: Optional[pulumi.Input[str]] = None,
                 pod: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[bool] hyperthreading_enabled: True if you enable hyperthreading for the server, otherwise false. The default value is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs']]] logical_interfaces: List of logical interfaces for the instance. The number of logical interfaces will be the same as number of hardware bond/nic on the chosen network template. For the non-multivlan configurations (for eg, existing servers) that use existing default network template (bondaa-bondaa), both the Instance.networks field and the Instance.logical_interfaces fields will be filled to ensure backward compatibility. For the others, only Instance.logical_interfaces will be filled.
        :param pulumi.Input[Sequence[pulumi.Input['LunArgs']]] luns: Immutable. List of LUNs associated with this server.
        :param pulumi.Input[str] machine_type: Immutable. The server type. [Available server types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        :param pulumi.Input[str] name: Immutable. The resource name of this `Instance`. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. Format: `projects/{project}/locations/{location}/instances/{instance}`
        :param pulumi.Input[str] network_template: Instance network template name. For eg, bondaa-bondaa, bondab-nic, etc. Generally, the template name follows the syntax of "bond" or "nic".
        :param pulumi.Input[str] os_image: The OS image currently installed on the server.
        :param pulumi.Input[str] pod: Immutable. Pod name. Pod is an independent part of infrastructure. Instance can be connected to the assets (networks, volumes) allocated in the same pod only.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]] volumes: Input only. List of Volumes to attach to this Instance on creation. This field won't be populated in Get/List responses.
        """
        if hyperthreading_enabled is not None:
            pulumi.set(__self__, "hyperthreading_enabled", hyperthreading_enabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logical_interfaces is not None:
            pulumi.set(__self__, "logical_interfaces", logical_interfaces)
        if luns is not None:
            pulumi.set(__self__, "luns", luns)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_template is not None:
            pulumi.set(__self__, "network_template", network_template)
        if os_image is not None:
            pulumi.set(__self__, "os_image", os_image)
        if pod is not None:
            pulumi.set(__self__, "pod", pod)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="hyperthreadingEnabled")
    def hyperthreading_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if you enable hyperthreading for the server, otherwise false. The default value is false.
        """
        return pulumi.get(self, "hyperthreading_enabled")

    @hyperthreading_enabled.setter
    def hyperthreading_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hyperthreading_enabled", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="logicalInterfaces")
    def logical_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs']]]]:
        """
        List of logical interfaces for the instance. The number of logical interfaces will be the same as number of hardware bond/nic on the chosen network template. For the non-multivlan configurations (for eg, existing servers) that use existing default network template (bondaa-bondaa), both the Instance.networks field and the Instance.logical_interfaces fields will be filled to ensure backward compatibility. For the others, only Instance.logical_interfaces will be filled.
        """
        return pulumi.get(self, "logical_interfaces")

    @logical_interfaces.setter
    def logical_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs']]]]):
        pulumi.set(self, "logical_interfaces", value)

    @property
    @pulumi.getter
    def luns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LunArgs']]]]:
        """
        Immutable. List of LUNs associated with this server.
        """
        return pulumi.get(self, "luns")

    @luns.setter
    def luns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LunArgs']]]]):
        pulumi.set(self, "luns", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The server type. [Available server types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The resource name of this `Instance`. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. Format: `projects/{project}/locations/{location}/instances/{instance}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkTemplate")
    def network_template(self) -> Optional[pulumi.Input[str]]:
        """
        Instance network template name. For eg, bondaa-bondaa, bondab-nic, etc. Generally, the template name follows the syntax of "bond" or "nic".
        """
        return pulumi.get(self, "network_template")

    @network_template.setter
    def network_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_template", value)

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> Optional[pulumi.Input[str]]:
        """
        The OS image currently installed on the server.
        """
        return pulumi.get(self, "os_image")

    @os_image.setter
    def os_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_image", value)

    @property
    @pulumi.getter
    def pod(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. Pod name. Pod is an independent part of infrastructure. Instance can be connected to the assets (networks, volumes) allocated in the same pod only.
        """
        return pulumi.get(self, "pod")

    @pod.setter
    def pod(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]:
        """
        Input only. List of Volumes to attach to this Instance on creation. This field won't be populated in Get/List responses.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hyperthreading_enabled: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 logical_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs']]]]] = None,
                 luns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LunArgs']]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_template: Optional[pulumi.Input[str]] = None,
                 os_image: Optional[pulumi.Input[str]] = None,
                 pod: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeArgs']]]]] = None,
                 __props__=None):
        """
        Create an Instance.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] hyperthreading_enabled: True if you enable hyperthreading for the server, otherwise false. The default value is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs']]]] logical_interfaces: List of logical interfaces for the instance. The number of logical interfaces will be the same as number of hardware bond/nic on the chosen network template. For the non-multivlan configurations (for eg, existing servers) that use existing default network template (bondaa-bondaa), both the Instance.networks field and the Instance.logical_interfaces fields will be filled to ensure backward compatibility. For the others, only Instance.logical_interfaces will be filled.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LunArgs']]]] luns: Immutable. List of LUNs associated with this server.
        :param pulumi.Input[str] machine_type: Immutable. The server type. [Available server types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        :param pulumi.Input[str] name: Immutable. The resource name of this `Instance`. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. Format: `projects/{project}/locations/{location}/instances/{instance}`
        :param pulumi.Input[str] network_template: Instance network template name. For eg, bondaa-bondaa, bondab-nic, etc. Generally, the template name follows the syntax of "bond" or "nic".
        :param pulumi.Input[str] os_image: The OS image currently installed on the server.
        :param pulumi.Input[str] pod: Immutable. Pod name. Pod is an independent part of infrastructure. Instance can be connected to the assets (networks, volumes) allocated in the same pod only.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeArgs']]]] volumes: Input only. List of Volumes to attach to this Instance on creation. This field won't be populated in Get/List responses.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create an Instance.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hyperthreading_enabled: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 logical_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs']]]]] = None,
                 luns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LunArgs']]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_template: Optional[pulumi.Input[str]] = None,
                 os_image: Optional[pulumi.Input[str]] = None,
                 pod: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["hyperthreading_enabled"] = hyperthreading_enabled
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["logical_interfaces"] = logical_interfaces
            __props__.__dict__["luns"] = luns
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["name"] = name
            __props__.__dict__["network_template"] = network_template
            __props__.__dict__["os_image"] = os_image
            __props__.__dict__["pod"] = pod
            __props__.__dict__["project"] = project
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["create_time"] = None
            __props__.__dict__["interactive_serial_console_enabled"] = None
            __props__.__dict__["login_info"] = None
            __props__.__dict__["networks"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Instance, __self__).__init__(
            'google-native:baremetalsolution/v2:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InstanceArgs.__new__(InstanceArgs)

        __props__.__dict__["create_time"] = None
        __props__.__dict__["hyperthreading_enabled"] = None
        __props__.__dict__["interactive_serial_console_enabled"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["logical_interfaces"] = None
        __props__.__dict__["login_info"] = None
        __props__.__dict__["luns"] = None
        __props__.__dict__["machine_type"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_template"] = None
        __props__.__dict__["networks"] = None
        __props__.__dict__["os_image"] = None
        __props__.__dict__["pod"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["update_time"] = None
        __props__.__dict__["volumes"] = None
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Create a time stamp.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="hyperthreadingEnabled")
    def hyperthreading_enabled(self) -> pulumi.Output[bool]:
        """
        True if you enable hyperthreading for the server, otherwise false. The default value is false.
        """
        return pulumi.get(self, "hyperthreading_enabled")

    @property
    @pulumi.getter(name="interactiveSerialConsoleEnabled")
    def interactive_serial_console_enabled(self) -> pulumi.Output[bool]:
        """
        True if the interactive serial console feature is enabled for the instance, false otherwise. The default value is false.
        """
        return pulumi.get(self, "interactive_serial_console_enabled")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels as key value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="logicalInterfaces")
    def logical_interfaces(self) -> pulumi.Output[Sequence['outputs.GoogleCloudBaremetalsolutionV2LogicalInterfaceResponse']]:
        """
        List of logical interfaces for the instance. The number of logical interfaces will be the same as number of hardware bond/nic on the chosen network template. For the non-multivlan configurations (for eg, existing servers) that use existing default network template (bondaa-bondaa), both the Instance.networks field and the Instance.logical_interfaces fields will be filled to ensure backward compatibility. For the others, only Instance.logical_interfaces will be filled.
        """
        return pulumi.get(self, "logical_interfaces")

    @property
    @pulumi.getter(name="loginInfo")
    def login_info(self) -> pulumi.Output[str]:
        """
        Text field about info for logging in.
        """
        return pulumi.get(self, "login_info")

    @property
    @pulumi.getter
    def luns(self) -> pulumi.Output[Sequence['outputs.LunResponse']]:
        """
        Immutable. List of LUNs associated with this server.
        """
        return pulumi.get(self, "luns")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[str]:
        """
        Immutable. The server type. [Available server types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. The resource name of this `Instance`. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. Format: `projects/{project}/locations/{location}/instances/{instance}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkTemplate")
    def network_template(self) -> pulumi.Output[str]:
        """
        Instance network template name. For eg, bondaa-bondaa, bondab-nic, etc. Generally, the template name follows the syntax of "bond" or "nic".
        """
        return pulumi.get(self, "network_template")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.NetworkResponse']]:
        """
        List of networks associated with this server.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> pulumi.Output[str]:
        """
        The OS image currently installed on the server.
        """
        return pulumi.get(self, "os_image")

    @property
    @pulumi.getter
    def pod(self) -> pulumi.Output[str]:
        """
        Immutable. Pod name. Pod is an independent part of infrastructure. Instance can be connected to the assets (networks, volumes) allocated in the same pod only.
        """
        return pulumi.get(self, "pod")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the server.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Update a time stamp.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Sequence['outputs.VolumeResponse']]:
        """
        Input only. List of Volumes to attach to this Instance on creation. This field won't be populated in Get/List responses.
        """
        return pulumi.get(self, "volumes")

