# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetClientTokenResult',
    'AwaitableGetClientTokenResult',
    'get_client_token',
]

@pulumi.output_type
class GetClientTokenResult:
    """
    Configuration values returned by getClientToken.
    """
    def __init__(__self__, access_token=None, expiry=None, refresh_token=None, token_type=None):
        if access_token and not isinstance(access_token, str):
            raise TypeError("Expected argument 'access_token' to be a str")
        pulumi.set(__self__, "access_token", access_token)
        if expiry and not isinstance(expiry, str):
            raise TypeError("Expected argument 'expiry' to be a str")
        pulumi.set(__self__, "expiry", expiry)
        if refresh_token and not isinstance(refresh_token, str):
            raise TypeError("Expected argument 'refresh_token' to be a str")
        pulumi.set(__self__, "refresh_token", refresh_token)
        if token_type and not isinstance(token_type, str):
            raise TypeError("Expected argument 'token_type' to be a str")
        pulumi.set(__self__, "token_type", token_type)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> str:
        """
        The OAuth2 access token used by the client to authenticate against the Google Cloud API.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[str]:
        """
        Expiry is the optional expiration time of the access token. If zero, TokenSource implementations will reuse the same token forever and RefreshToken or equivalent mechanisms for that TokenSource will not be used.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[str]:
        """
        RefreshToken is a token that's used by the application (as opposed to the user) to refresh the access token if it expires.
        """
        return pulumi.get(self, "refresh_token")

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> str:
        """
        The type of auth token. Possible types are "Bearer", "MAC", "Basic".
        """
        return pulumi.get(self, "token_type")


class AwaitableGetClientTokenResult(GetClientTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClientTokenResult(
            access_token=self.access_token,
            expiry=self.expiry,
            refresh_token=self.refresh_token,
            token_type=self.token_type)


def get_client_token(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClientTokenResult:
    """
    Use this function to get an Google authentication token for the current login context.
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:authorization:getClientToken', __args__, opts=opts, typ=GetClientTokenResult).value

    return AwaitableGetClientTokenResult(
        access_token=__ret__.access_token,
        expiry=__ret__.expiry,
        refresh_token=__ret__.refresh_token,
        token_type=__ret__.token_type)
