# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetOverrideResult',
    'AwaitableGetOverrideResult',
    'get_override',
    'get_override_output',
]

@pulumi.output_type
class GetOverrideResult:
    def __init__(__self__, api_proxy=None, name=None, sampling_config=None):
        if api_proxy and not isinstance(api_proxy, str):
            raise TypeError("Expected argument 'api_proxy' to be a str")
        pulumi.set(__self__, "api_proxy", api_proxy)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sampling_config and not isinstance(sampling_config, dict):
            raise TypeError("Expected argument 'sampling_config' to be a dict")
        pulumi.set(__self__, "sampling_config", sampling_config)

    @property
    @pulumi.getter(name="apiProxy")
    def api_proxy(self) -> str:
        """
        ID of the API proxy that will have its trace configuration overridden.
        """
        return pulumi.get(self, "api_proxy")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        ID of the trace configuration override specified as a system-generated UUID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="samplingConfig")
    def sampling_config(self) -> 'outputs.GoogleCloudApigeeV1TraceSamplingConfigResponse':
        """
        Trace configuration to override.
        """
        return pulumi.get(self, "sampling_config")


class AwaitableGetOverrideResult(GetOverrideResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOverrideResult(
            api_proxy=self.api_proxy,
            name=self.name,
            sampling_config=self.sampling_config)


def get_override(environment_id: Optional[str] = None,
                 organization_id: Optional[str] = None,
                 override_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOverrideResult:
    """
    Gets a trace configuration override.
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['organizationId'] = organization_id
    __args__['overrideId'] = override_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:apigee/v1:getOverride', __args__, opts=opts, typ=GetOverrideResult).value

    return AwaitableGetOverrideResult(
        api_proxy=__ret__.api_proxy,
        name=__ret__.name,
        sampling_config=__ret__.sampling_config)


@_utilities.lift_output_func(get_override)
def get_override_output(environment_id: Optional[pulumi.Input[str]] = None,
                        organization_id: Optional[pulumi.Input[str]] = None,
                        override_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOverrideResult]:
    """
    Gets a trace configuration override.
    """
    ...
