# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetEnvironmentResult',
    'AwaitableGetEnvironmentResult',
    'get_environment',
    'get_environment_output',
]

@pulumi.output_type
class GetEnvironmentResult:
    def __init__(__self__, api_proxy_type=None, created_at=None, deployment_type=None, description=None, display_name=None, forward_proxy_uri=None, last_modified_at=None, name=None, node_config=None, properties=None, state=None):
        if api_proxy_type and not isinstance(api_proxy_type, str):
            raise TypeError("Expected argument 'api_proxy_type' to be a str")
        pulumi.set(__self__, "api_proxy_type", api_proxy_type)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deployment_type and not isinstance(deployment_type, str):
            raise TypeError("Expected argument 'deployment_type' to be a str")
        pulumi.set(__self__, "deployment_type", deployment_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if forward_proxy_uri and not isinstance(forward_proxy_uri, str):
            raise TypeError("Expected argument 'forward_proxy_uri' to be a str")
        pulumi.set(__self__, "forward_proxy_uri", forward_proxy_uri)
        if last_modified_at and not isinstance(last_modified_at, str):
            raise TypeError("Expected argument 'last_modified_at' to be a str")
        pulumi.set(__self__, "last_modified_at", last_modified_at)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_config and not isinstance(node_config, dict):
            raise TypeError("Expected argument 'node_config' to be a dict")
        pulumi.set(__self__, "node_config", node_config)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="apiProxyType")
    def api_proxy_type(self) -> str:
        """
        Optional. API Proxy type supported by the environment. The type can be set when creating the Environment and cannot be changed.
        """
        return pulumi.get(self, "api_proxy_type")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Creation time of this environment as milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        Optional. Deployment type supported by the environment. The deployment type can be set when creating the environment and cannot be changed. When you enable archive deployment, you will be **prevented from performing** a [subset of actions](/apigee/docs/api-platform/local-development/overview#prevented-actions) within the environment, including: * Managing the deployment of API proxy or shared flow revisions * Creating, updating, or deleting resource files * Creating, updating, or deleting target servers
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the environment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Optional. Display name for this environment.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="forwardProxyUri")
    def forward_proxy_uri(self) -> str:
        """
        Optional. Url of the forward proxy to be applied to the runtime instances in this environment. Must be in the format of {scheme}://{hostname}:{port}. Note that scheme must be one of "http" or "https", and port must be supplied.
        """
        return pulumi.get(self, "forward_proxy_uri")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> str:
        """
        Last modification time of this environment as milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the environment. Values must match the regular expression `^[.\\\\p{Alnum}-_]{1,255}$`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> 'outputs.GoogleCloudApigeeV1NodeConfigResponse':
        """
        Optional. NodeConfig of the environment.
        """
        return pulumi.get(self, "node_config")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.GoogleCloudApigeeV1PropertiesResponse':
        """
        Optional. Key-value pairs that may be used for customizing the environment.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the environment. Values other than ACTIVE means the resource is not ready to use.
        """
        return pulumi.get(self, "state")


class AwaitableGetEnvironmentResult(GetEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentResult(
            api_proxy_type=self.api_proxy_type,
            created_at=self.created_at,
            deployment_type=self.deployment_type,
            description=self.description,
            display_name=self.display_name,
            forward_proxy_uri=self.forward_proxy_uri,
            last_modified_at=self.last_modified_at,
            name=self.name,
            node_config=self.node_config,
            properties=self.properties,
            state=self.state)


def get_environment(environment_id: Optional[str] = None,
                    organization_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentResult:
    """
    Gets environment details.
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:apigee/v1:getEnvironment', __args__, opts=opts, typ=GetEnvironmentResult).value

    return AwaitableGetEnvironmentResult(
        api_proxy_type=__ret__.api_proxy_type,
        created_at=__ret__.created_at,
        deployment_type=__ret__.deployment_type,
        description=__ret__.description,
        display_name=__ret__.display_name,
        forward_proxy_uri=__ret__.forward_proxy_uri,
        last_modified_at=__ret__.last_modified_at,
        name=__ret__.name,
        node_config=__ret__.node_config,
        properties=__ret__.properties,
        state=__ret__.state)


@_utilities.lift_output_func(get_environment)
def get_environment_output(environment_id: Optional[pulumi.Input[str]] = None,
                           organization_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnvironmentResult]:
    """
    Gets environment details.
    """
    ...
