# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetServicePerimeterResult',
    'AwaitableGetServicePerimeterResult',
    'get_service_perimeter',
    'get_service_perimeter_output',
]

@pulumi.output_type
class GetServicePerimeterResult:
    def __init__(__self__, description=None, name=None, perimeter_type=None, status=None, title=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if perimeter_type and not isinstance(perimeter_type, str):
            raise TypeError("Expected argument 'perimeter_type' to be a str")
        pulumi.set(__self__, "perimeter_type", perimeter_type)
        if status and not isinstance(status, dict):
            raise TypeError("Expected argument 'status' to be a dict")
        pulumi.set(__self__, "status", status)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the `ServicePerimeter` and its use. Does not affect behavior.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name for the ServicePerimeter. The `short_name` component must begin with a letter and only include alphanumeric and '_'. Format: `accessPolicies/{policy_id}/servicePerimeters/{short_name}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="perimeterType")
    def perimeter_type(self) -> str:
        """
        Perimeter type indicator. A single project is allowed to be a member of single regular perimeter, but multiple service perimeter bridges. A project cannot be a included in a perimeter bridge without being included in regular perimeter. For perimeter bridges, restricted/unrestricted service lists as well as access lists must be empty.
        """
        return pulumi.get(self, "perimeter_type")

    @property
    @pulumi.getter
    def status(self) -> 'outputs.ServicePerimeterConfigResponse':
        """
        Current ServicePerimeter configuration. Specifies sets of resources, restricted/unrestricted services and access levels that determine perimeter content and boundaries.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Human readable title. Must be unique within the Policy.
        """
        return pulumi.get(self, "title")


class AwaitableGetServicePerimeterResult(GetServicePerimeterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServicePerimeterResult(
            description=self.description,
            name=self.name,
            perimeter_type=self.perimeter_type,
            status=self.status,
            title=self.title)


def get_service_perimeter(access_policy_id: Optional[str] = None,
                          service_perimeter_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServicePerimeterResult:
    """
    Get a Service Perimeter by resource name.
    """
    __args__ = dict()
    __args__['accessPolicyId'] = access_policy_id
    __args__['servicePerimeterId'] = service_perimeter_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:accesscontextmanager/v1beta:getServicePerimeter', __args__, opts=opts, typ=GetServicePerimeterResult).value

    return AwaitableGetServicePerimeterResult(
        description=__ret__.description,
        name=__ret__.name,
        perimeter_type=__ret__.perimeter_type,
        status=__ret__.status,
        title=__ret__.title)


@_utilities.lift_output_func(get_service_perimeter)
def get_service_perimeter_output(access_policy_id: Optional[pulumi.Input[str]] = None,
                                 service_perimeter_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServicePerimeterResult]:
    """
    Get a Service Perimeter by resource name.
    """
    ...
