# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetServicePerimeterResult',
    'AwaitableGetServicePerimeterResult',
    'get_service_perimeter',
    'get_service_perimeter_output',
]

@pulumi.output_type
class GetServicePerimeterResult:
    def __init__(__self__, description=None, name=None, perimeter_type=None, spec=None, status=None, title=None, use_explicit_dry_run_spec=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if perimeter_type and not isinstance(perimeter_type, str):
            raise TypeError("Expected argument 'perimeter_type' to be a str")
        pulumi.set(__self__, "perimeter_type", perimeter_type)
        if spec and not isinstance(spec, dict):
            raise TypeError("Expected argument 'spec' to be a dict")
        pulumi.set(__self__, "spec", spec)
        if status and not isinstance(status, dict):
            raise TypeError("Expected argument 'status' to be a dict")
        pulumi.set(__self__, "status", status)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)
        if use_explicit_dry_run_spec and not isinstance(use_explicit_dry_run_spec, bool):
            raise TypeError("Expected argument 'use_explicit_dry_run_spec' to be a bool")
        pulumi.set(__self__, "use_explicit_dry_run_spec", use_explicit_dry_run_spec)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the `ServicePerimeter` and its use. Does not affect behavior.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name for the ServicePerimeter. The `short_name` component must begin with a letter and only include alphanumeric and '_'. Format: `accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="perimeterType")
    def perimeter_type(self) -> str:
        """
        Perimeter type indicator. A single project is allowed to be a member of single regular perimeter, but multiple service perimeter bridges. A project cannot be a included in a perimeter bridge without being included in regular perimeter. For perimeter bridges, the restricted service list as well as access level lists must be empty.
        """
        return pulumi.get(self, "perimeter_type")

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ServicePerimeterConfigResponse':
        """
        Proposed (or dry run) ServicePerimeter configuration. This configuration allows to specify and test ServicePerimeter configuration without enforcing actual access restrictions. Only allowed to be set when the "use_explicit_dry_run_spec" flag is set.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> 'outputs.ServicePerimeterConfigResponse':
        """
        Current ServicePerimeter configuration. Specifies sets of resources, restricted services and access levels that determine perimeter content and boundaries.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Human readable title. Must be unique within the Policy.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="useExplicitDryRunSpec")
    def use_explicit_dry_run_spec(self) -> bool:
        """
        Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists for all Service Perimeters, and that spec is identical to the status for those Service Perimeters. When this flag is set, it inhibits the generation of the implicit spec, thereby allowing the user to explicitly provide a configuration ("spec") to use in a dry-run version of the Service Perimeter. This allows the user to test changes to the enforced config ("status") without actually enforcing them. This testing is done through analyzing the differences between currently enforced and suggested restrictions. use_explicit_dry_run_spec must bet set to True if any of the fields in the spec are set to non-default values.
        """
        return pulumi.get(self, "use_explicit_dry_run_spec")


class AwaitableGetServicePerimeterResult(GetServicePerimeterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServicePerimeterResult(
            description=self.description,
            name=self.name,
            perimeter_type=self.perimeter_type,
            spec=self.spec,
            status=self.status,
            title=self.title,
            use_explicit_dry_run_spec=self.use_explicit_dry_run_spec)


def get_service_perimeter(access_policy_id: Optional[str] = None,
                          service_perimeter_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServicePerimeterResult:
    """
    Gets a service perimeter based on the resource name.
    """
    __args__ = dict()
    __args__['accessPolicyId'] = access_policy_id
    __args__['servicePerimeterId'] = service_perimeter_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:accesscontextmanager/v1:getServicePerimeter', __args__, opts=opts, typ=GetServicePerimeterResult).value

    return AwaitableGetServicePerimeterResult(
        description=__ret__.description,
        name=__ret__.name,
        perimeter_type=__ret__.perimeter_type,
        spec=__ret__.spec,
        status=__ret__.status,
        title=__ret__.title,
        use_explicit_dry_run_spec=__ret__.use_explicit_dry_run_spec)


@_utilities.lift_output_func(get_service_perimeter)
def get_service_perimeter_output(access_policy_id: Optional[pulumi.Input[str]] = None,
                                 service_perimeter_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServicePerimeterResult]:
    """
    Gets a service perimeter based on the resource name.
    """
    ...
