# coding: utf-8

"""
    CLOUD API

    An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.  # noqa: E501

    The version of the OpenAPI document: 5.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest
import datetime

import ionoscloud
from ionoscloud.models.data_center_entities import DataCenterEntities  # noqa: E501
from ionoscloud.rest import ApiException

class TestDataCenterEntities(unittest.TestCase):
    """DataCenterEntities unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional):
        """Test DataCenterEntities
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # model = ionoscloud.models.data_center_entities.DataCenterEntities()  # noqa: E501
        if include_optional :
            return DataCenterEntities(
                servers = ionoscloud.models.servers.Servers(
                    id = '15f67991-0f51-4efc-a8ad-ef1fb31a480c', 
                    type = "collection", 
                    href = '<RESOURCE-URI>', 
                    items = [
                        ionoscloud.models.server.Server(
                            id = '15f67991-0f51-4efc-a8ad-ef1fb31a480c', 
                            type = "server", 
                            href = '<RESOURCE-URI>', 
                            metadata = ionoscloud.models.datacenter_element_metadata.DatacenterElementMetadata(
                                etag = '45480eb3fbfc31f1d916c1eaa4abdcc3', 
                                created_date = '2015-12-04T14:34:09.809Z', 
                                created_by = 'user@example.com', 
                                created_by_user_id = 'user@example.com', 
                                last_modified_date = '2015-12-04T14:34:09.809Z', 
                                last_modified_by = 'user@example.com', 
                                last_modified_by_user_id = '63cef532-26fe-4a64-a4e0-de7c8a506c90', 
                                state = 'AVAILABLE', ), 
                            properties = ionoscloud.models.server_properties.ServerProperties(
                                name = 'My resource', 
                                cores = 4, 
                                ram = 4096, 
                                availability_zone = 'AUTO', 
                                vm_state = 'RUNNING', 
                                boot_cdrom = ionoscloud.models.resource_reference.ResourceReference(
                                    id = '', 
                                    type = "resource", 
                                    href = '<RESOURCE-URI>', ), 
                                boot_volume = ionoscloud.models.resource_reference.ResourceReference(
                                    id = '', 
                                    type = "resource", 
                                    href = '<RESOURCE-URI>', ), 
                                cpu_family = 'AMD_OPTERON', ), 
                            entities = ionoscloud.models.server_entities.ServerEntities(
                                cdroms = ionoscloud.models.cdroms.Cdroms(
                                    id = '15f67991-0f51-4efc-a8ad-ef1fb31a480c', 
                                    type = "collection", 
                                    href = '<RESOURCE-URI>', 
                                    offset = 0, 
                                    limit = 1000, 
                                    _links = ionoscloud.models.pagination_links.PaginationLinks(
                                        prev = '<PREVIOUS-PAGE-URI>', 
                                        self = '<THIS-PAGE-URI>', 
                                        next = '<NEXT-PAGE-URI>', ), ), 
                                volumes = ionoscloud.models.attached_volumes.AttachedVolumes(
                                    id = '15f67991-0f51-4efc-a8ad-ef1fb31a480c', 
                                    type = "collection", 
                                    href = '<RESOURCE-URI>', 
                                    offset = 0, 
                                    limit = 1000, ), 
                                nics = ionoscloud.models.nics.Nics(
                                    id = '15f67991-0f51-4efc-a8ad-ef1fb31a480c', 
                                    type = "collection", 
                                    href = '<RESOURCE-URI>', 
                                    offset = 0, 
                                    limit = 1000, ), ), )
                        ], 
                    offset = 0, 
                    limit = 1000, 
                    _links = ionoscloud.models.pagination_links.PaginationLinks(
                        prev = '<PREVIOUS-PAGE-URI>', 
                        self = '<THIS-PAGE-URI>', 
                        next = '<NEXT-PAGE-URI>', ), ),
                volumes = ionoscloud.models.volumes.Volumes(
                    id = '15f67991-0f51-4efc-a8ad-ef1fb31a480c', 
                    type = "collection", 
                    href = '<RESOURCE-URI>', 
                    items = [
                        ionoscloud.models.volume.Volume(
                            id = '15f67991-0f51-4efc-a8ad-ef1fb31a480c', 
                            type = "volume", 
                            href = '<RESOURCE-URI>', 
                            metadata = ionoscloud.models.datacenter_element_metadata.DatacenterElementMetadata(
                                etag = '45480eb3fbfc31f1d916c1eaa4abdcc3', 
                                created_date = '2015-12-04T14:34:09.809Z', 
                                created_by = 'user@example.com', 
                                created_by_user_id = 'user@example.com', 
                                last_modified_date = '2015-12-04T14:34:09.809Z', 
                                last_modified_by = 'user@example.com', 
                                last_modified_by_user_id = '63cef532-26fe-4a64-a4e0-de7c8a506c90', 
                                state = 'AVAILABLE', ), 
                            properties = ionoscloud.models.volume_properties.VolumeProperties(
                                name = 'My resource', 
                                type = 'HDD', 
                                size = 100.0, 
                                availability_zone = 'AUTO', 
                                image = 'd6ad1576-fde9-4696-aa41-1ebd75bdaf49', 
                                image_password = 'mypass123', 
                                image_alias = '', 
                                ssh_keys = [ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCyWh6LZ7f2wxnupVgtK2096bc69Vv9uT2A58lwN3ol0A6mxqlT0f4M1NbarVUxa+MVdxBLud5PvlkbYc9mY91OyzLGZMfVWvhAYz/tJSsDtsgRUl0GFVv332zDWk0i+mAVy0N408OORm5XqV6zvIDaiB/jopyjemUp2rnP7pXU4+98ilZw6ef9DF9y4YZ64mchL5//rcrGm1Lff3pC75X/polGONHeG6m4Vs8eIu+0epJ4PJBxO+rwRYp1zMnn90UCk21KvTcYops2cte7ouXQwkGUq3vmXxnSdvuivK/4JNoFQBsaGV974hDmloS5LOvSJjKpXs8Ed437ln712345, ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCyWh6LZ7f2wxnupVgtK2096bc69Vv9uT2A58lwN3ol0A6mxqlT0f4M1NbarVUxa+MVdxBLud5PvlkbYc9mY91OyzLGZMfVWvhAYz/tJSsDtsgRUl0GFVv332zDWk0i+mAVy0N408OORm5XqV6zvIDaiB/jopyjemUp2rnP7pXU4+98ilZw6ef9DF9y4YZ64mchL5//rcrGm1Lff3pC75X/polGONHeG6m4Vs8eIu+0epJ4PJBxO+rwRYp1zMnn90UCk21KvTcYops2cte7ouXQwkGUq3vmXxnSdvuivK/asdfghjkjhyutry545tgvbn76e4rf43], 
                                bus = 'VIRTIO', 
                                licence_type = 'LINUX', 
                                cpu_hot_plug = True, 
                                ram_hot_plug = True, 
                                nic_hot_plug = True, 
                                nic_hot_unplug = True, 
                                disc_virtio_hot_plug = True, 
                                disc_virtio_hot_unplug = True, 
                                device_number = 3, 
                                backupunit_id = '25f67991-0f51-4efc-a8ad-ef1fb31a481c', ), )
                        ], 
                    offset = 0, 
                    limit = 1000, 
                    _links = ionoscloud.models.pagination_links.PaginationLinks(
                        prev = '<PREVIOUS-PAGE-URI>', 
                        self = '<THIS-PAGE-URI>', 
                        next = '<NEXT-PAGE-URI>', ), ),
                loadbalancers = ionoscloud.models.loadbalancers.Loadbalancers(
                    id = '15f67991-0f51-4efc-a8ad-ef1fb31a480c', 
                    type = "collection", 
                    href = '<RESOURCE-URI>', 
                    items = [
                        ionoscloud.models.loadbalancer.Loadbalancer(
                            id = '15f67991-0f51-4efc-a8ad-ef1fb31a480c', 
                            type = "loadbalancer", 
                            href = '<RESOURCE-URI>', 
                            metadata = ionoscloud.models.datacenter_element_metadata.DatacenterElementMetadata(
                                etag = '45480eb3fbfc31f1d916c1eaa4abdcc3', 
                                created_date = '2015-12-04T14:34:09.809Z', 
                                created_by = 'user@example.com', 
                                created_by_user_id = 'user@example.com', 
                                last_modified_date = '2015-12-04T14:34:09.809Z', 
                                last_modified_by = 'user@example.com', 
                                last_modified_by_user_id = '63cef532-26fe-4a64-a4e0-de7c8a506c90', 
                                state = 'AVAILABLE', ), 
                            properties = ionoscloud.models.loadbalancer_properties.LoadbalancerProperties(
                                name = 'My resource', 
                                ip = '22.231.113.64', 
                                dhcp = True, ), 
                            entities = ionoscloud.models.loadbalancer_entities.LoadbalancerEntities(
                                balancednics = ionoscloud.models.balanced_nics.BalancedNics(
                                    id = '15f67991-0f51-4efc-a8ad-ef1fb31a480c', 
                                    type = "collection", 
                                    href = '<RESOURCE-URI>', 
                                    offset = 0, 
                                    limit = 1000, 
                                    _links = ionoscloud.models.pagination_links.PaginationLinks(
                                        prev = '<PREVIOUS-PAGE-URI>', 
                                        self = '<THIS-PAGE-URI>', 
                                        next = '<NEXT-PAGE-URI>', ), ), ), )
                        ], 
                    offset = 0, 
                    limit = 1000, 
                    _links = ionoscloud.models.pagination_links.PaginationLinks(
                        prev = '<PREVIOUS-PAGE-URI>', 
                        self = '<THIS-PAGE-URI>', 
                        next = '<NEXT-PAGE-URI>', ), ),
                lans = ionoscloud.models.lans.Lans(
                    id = '15f67991-0f51-4efc-a8ad-ef1fb31a480c', 
                    type = "collection", 
                    href = '<RESOURCE-URI>', 
                    items = [
                        ionoscloud.models.lan.Lan(
                            id = '5', 
                            type = "lan", 
                            href = '<RESOURCE-URI>', 
                            metadata = ionoscloud.models.datacenter_element_metadata.DatacenterElementMetadata(
                                etag = '45480eb3fbfc31f1d916c1eaa4abdcc3', 
                                created_date = '2015-12-04T14:34:09.809Z', 
                                created_by = 'user@example.com', 
                                created_by_user_id = 'user@example.com', 
                                last_modified_date = '2015-12-04T14:34:09.809Z', 
                                last_modified_by = 'user@example.com', 
                                last_modified_by_user_id = '63cef532-26fe-4a64-a4e0-de7c8a506c90', 
                                state = 'AVAILABLE', ), 
                            properties = ionoscloud.models.lan_properties.LanProperties(
                                name = 'My resource', 
                                ip_failover = [
                                    ionoscloud.models.ip_failover.IPFailover(
                                        ip = '192.18.2.231', 
                                        nic_uuid = '3c11273c-b3e1-4ca3-8134-84fd2dd4ebec', )
                                    ], 
                                pcc = '3c11273c-b3e1-4ca3-8134-84fd2dd4ebec', 
                                public = True, ), 
                            entities = ionoscloud.models.lan_entities.LanEntities(
                                nics = ionoscloud.models.lan_nics.LanNics(
                                    id = '15f67991-0f51-4efc-a8ad-ef1fb31a480c', 
                                    type = "collection", 
                                    href = '<RESOURCE-URI>', 
                                    offset = 0, 
                                    limit = 1000, 
                                    _links = ionoscloud.models.pagination_links.PaginationLinks(
                                        prev = '<PREVIOUS-PAGE-URI>', 
                                        self = '<THIS-PAGE-URI>', 
                                        next = '<NEXT-PAGE-URI>', ), ), ), )
                        ], 
                    offset = 0, 
                    limit = 1000, 
                    _links = ionoscloud.models.pagination_links.PaginationLinks(
                        prev = '<PREVIOUS-PAGE-URI>', 
                        self = '<THIS-PAGE-URI>', 
                        next = '<NEXT-PAGE-URI>', ), )
            )
        else :
            return DataCenterEntities(
        )

    def testDataCenterEntities(self):
        """Test DataCenterEntities"""
        inst_req_only = self.make_instance(include_optional=False)
        inst_req_and_optional = self.make_instance(include_optional=True)


if __name__ == '__main__':
    unittest.main()
