# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class HubResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'receiver': 'ReceiverChild',
        'location': 'LocationChild',
        'corporation': 'CorporationChild',
        'serial_number': 'str',
        'name': 'str',
        'power_type': 'HubPowerType',
        'firmware_version': 'str',
        'hub_type': 'HubType',
        'created': 'datetime',
        'updated': 'datetime',
        'triggering_enabled': 'bool',
        'ports': 'list[HubPortChild]',
        'is_online': 'bool',
        'last_update_time': 'datetime',
        'temperature': 'float',
        'voltage': 'float'
    }

    attribute_map = {
        'id': 'Id',
        'receiver': 'Receiver',
        'location': 'Location',
        'corporation': 'Corporation',
        'serial_number': 'SerialNumber',
        'name': 'Name',
        'power_type': 'PowerType',
        'firmware_version': 'FirmwareVersion',
        'hub_type': 'HubType',
        'created': 'Created',
        'updated': 'Updated',
        'triggering_enabled': 'TriggeringEnabled',
        'ports': 'Ports',
        'is_online': 'IsOnline',
        'last_update_time': 'LastUpdateTime',
        'temperature': 'Temperature',
        'voltage': 'Voltage'
    }

    def __init__(self, id=None, receiver=None, location=None, corporation=None, serial_number=None, name=None, power_type=None, firmware_version=None, hub_type=None, created=None, updated=None, triggering_enabled=None, ports=None, is_online=None, last_update_time=None, temperature=None, voltage=None):  # noqa: E501
        """HubResponse - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._receiver = None
        self._location = None
        self._corporation = None
        self._serial_number = None
        self._name = None
        self._power_type = None
        self._firmware_version = None
        self._hub_type = None
        self._created = None
        self._updated = None
        self._triggering_enabled = None
        self._ports = None
        self._is_online = None
        self._last_update_time = None
        self._temperature = None
        self._voltage = None
        self.discriminator = None
        self.id = id
        if receiver is not None:
            self.receiver = receiver
        self.location = location
        self.corporation = corporation
        self.serial_number = serial_number
        if name is not None:
            self.name = name
        if power_type is not None:
            self.power_type = power_type
        if firmware_version is not None:
            self.firmware_version = firmware_version
        if hub_type is not None:
            self.hub_type = hub_type
        self.created = created
        self.updated = updated
        self.triggering_enabled = triggering_enabled
        self.ports = ports
        if is_online is not None:
            self.is_online = is_online
        if last_update_time is not None:
            self.last_update_time = last_update_time
        if temperature is not None:
            self.temperature = temperature
        if voltage is not None:
            self.voltage = voltage

    @property
    def id(self):
        """Gets the id of this HubResponse.  # noqa: E501

        Id of the hub  # noqa: E501

        :return: The id of this HubResponse.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HubResponse.

        Id of the hub  # noqa: E501

        :param id: The id of this HubResponse.  # noqa: E501
        :type: int
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def receiver(self):
        """Gets the receiver of this HubResponse.  # noqa: E501


        :return: The receiver of this HubResponse.  # noqa: E501
        :rtype: ReceiverChild
        """
        return self._receiver

    @receiver.setter
    def receiver(self, receiver):
        """Sets the receiver of this HubResponse.


        :param receiver: The receiver of this HubResponse.  # noqa: E501
        :type: ReceiverChild
        """

        self._receiver = receiver

    @property
    def location(self):
        """Gets the location of this HubResponse.  # noqa: E501


        :return: The location of this HubResponse.  # noqa: E501
        :rtype: LocationChild
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this HubResponse.


        :param location: The location of this HubResponse.  # noqa: E501
        :type: LocationChild
        """
        if location is None:
            raise ValueError("Invalid value for `location`, must not be `None`")  # noqa: E501

        self._location = location

    @property
    def corporation(self):
        """Gets the corporation of this HubResponse.  # noqa: E501


        :return: The corporation of this HubResponse.  # noqa: E501
        :rtype: CorporationChild
        """
        return self._corporation

    @corporation.setter
    def corporation(self, corporation):
        """Sets the corporation of this HubResponse.


        :param corporation: The corporation of this HubResponse.  # noqa: E501
        :type: CorporationChild
        """
        if corporation is None:
            raise ValueError("Invalid value for `corporation`, must not be `None`")  # noqa: E501

        self._corporation = corporation

    @property
    def serial_number(self):
        """Gets the serial_number of this HubResponse.  # noqa: E501

        Serial number of the hub  # noqa: E501

        :return: The serial_number of this HubResponse.  # noqa: E501
        :rtype: str
        """
        return self._serial_number

    @serial_number.setter
    def serial_number(self, serial_number):
        """Sets the serial_number of this HubResponse.

        Serial number of the hub  # noqa: E501

        :param serial_number: The serial_number of this HubResponse.  # noqa: E501
        :type: str
        """
        if serial_number is None:
            raise ValueError("Invalid value for `serial_number`, must not be `None`")  # noqa: E501

        self._serial_number = serial_number

    @property
    def name(self):
        """Gets the name of this HubResponse.  # noqa: E501

        Name of the hub  # noqa: E501

        :return: The name of this HubResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this HubResponse.

        Name of the hub  # noqa: E501

        :param name: The name of this HubResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def power_type(self):
        """Gets the power_type of this HubResponse.  # noqa: E501


        :return: The power_type of this HubResponse.  # noqa: E501
        :rtype: HubPowerType
        """
        return self._power_type

    @power_type.setter
    def power_type(self, power_type):
        """Sets the power_type of this HubResponse.


        :param power_type: The power_type of this HubResponse.  # noqa: E501
        :type: HubPowerType
        """

        self._power_type = power_type

    @property
    def firmware_version(self):
        """Gets the firmware_version of this HubResponse.  # noqa: E501

        Firmware version of the hub  # noqa: E501

        :return: The firmware_version of this HubResponse.  # noqa: E501
        :rtype: str
        """
        return self._firmware_version

    @firmware_version.setter
    def firmware_version(self, firmware_version):
        """Sets the firmware_version of this HubResponse.

        Firmware version of the hub  # noqa: E501

        :param firmware_version: The firmware_version of this HubResponse.  # noqa: E501
        :type: str
        """

        self._firmware_version = firmware_version

    @property
    def hub_type(self):
        """Gets the hub_type of this HubResponse.  # noqa: E501


        :return: The hub_type of this HubResponse.  # noqa: E501
        :rtype: HubType
        """
        return self._hub_type

    @hub_type.setter
    def hub_type(self, hub_type):
        """Sets the hub_type of this HubResponse.


        :param hub_type: The hub_type of this HubResponse.  # noqa: E501
        :type: HubType
        """

        self._hub_type = hub_type

    @property
    def created(self):
        """Gets the created of this HubResponse.  # noqa: E501

        Date the hub was created  # noqa: E501

        :return: The created of this HubResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this HubResponse.

        Date the hub was created  # noqa: E501

        :param created: The created of this HubResponse.  # noqa: E501
        :type: datetime
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")  # noqa: E501

        self._created = created

    @property
    def updated(self):
        """Gets the updated of this HubResponse.  # noqa: E501

        Date the hub was last updated  # noqa: E501

        :return: The updated of this HubResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """Sets the updated of this HubResponse.

        Date the hub was last updated  # noqa: E501

        :param updated: The updated of this HubResponse.  # noqa: E501
        :type: datetime
        """
        if updated is None:
            raise ValueError("Invalid value for `updated`, must not be `None`")  # noqa: E501

        self._updated = updated

    @property
    def triggering_enabled(self):
        """Gets the triggering_enabled of this HubResponse.  # noqa: E501

        Is triggering enabled for the hub  # noqa: E501

        :return: The triggering_enabled of this HubResponse.  # noqa: E501
        :rtype: bool
        """
        return self._triggering_enabled

    @triggering_enabled.setter
    def triggering_enabled(self, triggering_enabled):
        """Sets the triggering_enabled of this HubResponse.

        Is triggering enabled for the hub  # noqa: E501

        :param triggering_enabled: The triggering_enabled of this HubResponse.  # noqa: E501
        :type: bool
        """
        if triggering_enabled is None:
            raise ValueError("Invalid value for `triggering_enabled`, must not be `None`")  # noqa: E501

        self._triggering_enabled = triggering_enabled

    @property
    def ports(self):
        """Gets the ports of this HubResponse.  # noqa: E501

        List of hub ports available for the hub and any nodes attached to them  # noqa: E501

        :return: The ports of this HubResponse.  # noqa: E501
        :rtype: list[HubPortChild]
        """
        return self._ports

    @ports.setter
    def ports(self, ports):
        """Sets the ports of this HubResponse.

        List of hub ports available for the hub and any nodes attached to them  # noqa: E501

        :param ports: The ports of this HubResponse.  # noqa: E501
        :type: list[HubPortChild]
        """
        if ports is None:
            raise ValueError("Invalid value for `ports`, must not be `None`")  # noqa: E501

        self._ports = ports

    @property
    def is_online(self):
        """Gets the is_online of this HubResponse.  # noqa: E501

        Online state of the hub  # noqa: E501

        :return: The is_online of this HubResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_online

    @is_online.setter
    def is_online(self, is_online):
        """Sets the is_online of this HubResponse.

        Online state of the hub  # noqa: E501

        :param is_online: The is_online of this HubResponse.  # noqa: E501
        :type: bool
        """

        self._is_online = is_online

    @property
    def last_update_time(self):
        """Gets the last_update_time of this HubResponse.  # noqa: E501

        Last time the hub reported data  # noqa: E501

        :return: The last_update_time of this HubResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._last_update_time

    @last_update_time.setter
    def last_update_time(self, last_update_time):
        """Sets the last_update_time of this HubResponse.

        Last time the hub reported data  # noqa: E501

        :param last_update_time: The last_update_time of this HubResponse.  # noqa: E501
        :type: datetime
        """

        self._last_update_time = last_update_time

    @property
    def temperature(self):
        """Gets the temperature of this HubResponse.  # noqa: E501

        Reported temperature  # noqa: E501

        :return: The temperature of this HubResponse.  # noqa: E501
        :rtype: float
        """
        return self._temperature

    @temperature.setter
    def temperature(self, temperature):
        """Sets the temperature of this HubResponse.

        Reported temperature  # noqa: E501

        :param temperature: The temperature of this HubResponse.  # noqa: E501
        :type: float
        """

        self._temperature = temperature

    @property
    def voltage(self):
        """Gets the voltage of this HubResponse.  # noqa: E501

        Reported voltage  # noqa: E501

        :return: The voltage of this HubResponse.  # noqa: E501
        :rtype: float
        """
        return self._voltage

    @voltage.setter
    def voltage(self, voltage):
        """Sets the voltage of this HubResponse.

        Reported voltage  # noqa: E501

        :param voltage: The voltage of this HubResponse.  # noqa: E501
        :type: float
        """

        self._voltage = voltage

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(HubResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HubResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
