# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class MonitoringPointsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_monitoring_point(self, **kwargs):  # noqa: E501
        """Creates a monitoringPoint  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_monitoring_point(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MonitoringPointCreateRequest body:
        :return: MonitoringPointResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_monitoring_point_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_monitoring_point_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_monitoring_point_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a monitoringPoint  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_monitoring_point_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MonitoringPointCreateRequest body:
        :return: MonitoringPointResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_monitoring_point" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/MonitoringPoints', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MonitoringPointResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_monitoring_point(self, monitoring_point_id, **kwargs):  # noqa: E501
        """Deletes a monitoringPoint  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_monitoring_point(monitoring_point_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str monitoring_point_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_monitoring_point_with_http_info(monitoring_point_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_monitoring_point_with_http_info(monitoring_point_id, **kwargs)  # noqa: E501
            return data

    def delete_monitoring_point_with_http_info(self, monitoring_point_id, **kwargs):  # noqa: E501
        """Deletes a monitoringPoint  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_monitoring_point_with_http_info(monitoring_point_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str monitoring_point_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['monitoring_point_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_monitoring_point" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'monitoring_point_id' is set
        if ('monitoring_point_id' not in params or
                params['monitoring_point_id'] is None):
            raise ValueError("Missing the required parameter `monitoring_point_id` when calling `delete_monitoring_point`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'monitoring_point_id' in params:
            path_params['monitoringPointId'] = params['monitoring_point_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/MonitoringPoints/{monitoringPointId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_monitoring_point(self, id, **kwargs):  # noqa: E501
        """Gets a Monitoring Point  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_monitoring_point(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: MonitoringPointResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_monitoring_point_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_monitoring_point_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_monitoring_point_with_http_info(self, id, **kwargs):  # noqa: E501
        """Gets a Monitoring Point  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_monitoring_point_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: MonitoringPointResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_monitoring_point" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_monitoring_point`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/MonitoringPoints/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MonitoringPointResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_monitoring_point_assignments(self, monitoring_point_id, **kwargs):  # noqa: E501
        """Gets all of the node assignment history for a monitoring point including the current assignment.  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_monitoring_point_assignments(monitoring_point_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str monitoring_point_id: The monitoringPointId to retrieve the node assignment history for. (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `IsPaused` | Boolean | `eq, neq` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `NodeId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `NodeSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `EndDate` | DateTime? | | `StartDate` | DateTime |
        :return: PagedResultsModelMonitoringPointAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_monitoring_point_assignments_with_http_info(monitoring_point_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_monitoring_point_assignments_with_http_info(monitoring_point_id, **kwargs)  # noqa: E501
            return data

    def get_monitoring_point_assignments_with_http_info(self, monitoring_point_id, **kwargs):  # noqa: E501
        """Gets all of the node assignment history for a monitoring point including the current assignment.  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_monitoring_point_assignments_with_http_info(monitoring_point_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str monitoring_point_id: The monitoringPointId to retrieve the node assignment history for. (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `IsPaused` | Boolean | `eq, neq` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `NodeId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `NodeSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `EndDate` | DateTime? | | `StartDate` | DateTime |
        :return: PagedResultsModelMonitoringPointAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['monitoring_point_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_monitoring_point_assignments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'monitoring_point_id' is set
        if ('monitoring_point_id' not in params or
                params['monitoring_point_id'] is None):
            raise ValueError("Missing the required parameter `monitoring_point_id` when calling `get_monitoring_point_assignments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'monitoring_point_id' in params:
            path_params['monitoringPointId'] = params['monitoring_point_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/MonitoringPoints/{monitoringPointId}/assignments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelMonitoringPointAssignmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_monitoring_point_current_assignment(self, monitoring_point_id, **kwargs):  # noqa: E501
        """Gets the currently assigned node to a monitoring point  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_monitoring_point_current_assignment(monitoring_point_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str monitoring_point_id: The monitoringPointId used to retrieve the current assignment (required)
        :return: MonitoringPointAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_monitoring_point_current_assignment_with_http_info(monitoring_point_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_monitoring_point_current_assignment_with_http_info(monitoring_point_id, **kwargs)  # noqa: E501
            return data

    def get_monitoring_point_current_assignment_with_http_info(self, monitoring_point_id, **kwargs):  # noqa: E501
        """Gets the currently assigned node to a monitoring point  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_monitoring_point_current_assignment_with_http_info(monitoring_point_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str monitoring_point_id: The monitoringPointId used to retrieve the current assignment (required)
        :return: MonitoringPointAssignmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['monitoring_point_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_monitoring_point_current_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'monitoring_point_id' is set
        if ('monitoring_point_id' not in params or
                params['monitoring_point_id'] is None):
            raise ValueError("Missing the required parameter `monitoring_point_id` when calling `get_monitoring_point_current_assignment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'monitoring_point_id' in params:
            path_params['monitoringPointId'] = params['monitoring_point_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/MonitoringPoints/{monitoringPointId}/assignments/current', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MonitoringPointAssignmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_monitoring_point_overview(self, **kwargs):  # noqa: E501
        """Gets an overview of monitoring point(s) which includes the node settings  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_monitoring_point_overview(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `HierarchyAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `HierarchyName` | String | `eq, neq, in, like, isnull, isnotnull` | | `MonitoringPointType` | MonitoringPointTypeCodes | `eq, neq, in` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `Node` | MonitoringPointOverviewNodeChild | `isnull, isnotnull` | | `NodeNickname` | String | `eq, neq, in, like, isnull, isnotnull` | | `NodeSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `RunningSpeedMultiplier` | Double? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `HierarchyAbbreviation` | String | | `HierarchyName` | String | | `MonitoringPointType` | MonitoringPointTypeCodes | | `Name` | String | | `NodeNickname` | String | | `NodeSerialNumber` | String | | `CurrentValue` | String | | `CurrentValue` | String | | `RunningSpeedMultiplier` | Double? |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `HierarchySearch`, `NodeNickname`, `NodeSerialNumber`.
        :return: PagedResultsModelMonitoringPointOverviewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_monitoring_point_overview_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_monitoring_point_overview_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_monitoring_point_overview_with_http_info(self, **kwargs):  # noqa: E501
        """Gets an overview of monitoring point(s) which includes the node settings  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_monitoring_point_overview_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `HierarchyAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `HierarchyName` | String | `eq, neq, in, like, isnull, isnotnull` | | `MonitoringPointType` | MonitoringPointTypeCodes | `eq, neq, in` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `Node` | MonitoringPointOverviewNodeChild | `isnull, isnotnull` | | `NodeNickname` | String | `eq, neq, in, like, isnull, isnotnull` | | `NodeSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `RunningSpeedMultiplier` | Double? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `HierarchyAbbreviation` | String | | `HierarchyName` | String | | `MonitoringPointType` | MonitoringPointTypeCodes | | `Name` | String | | `NodeNickname` | String | | `NodeSerialNumber` | String | | `CurrentValue` | String | | `CurrentValue` | String | | `RunningSpeedMultiplier` | Double? |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `HierarchySearch`, `NodeNickname`, `NodeSerialNumber`.
        :return: PagedResultsModelMonitoringPointOverviewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_ids', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_monitoring_point_overview" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/MonitoringPoints/overview', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelMonitoringPointOverviewResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_monitoring_points(self, **kwargs):  # noqa: E501
        """Gets Monitoring Points  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_monitoring_points(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Abbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `Active` | Boolean | `eq, neq` | | `Bearing` | BearingChild | `isnull, isnotnull` | | `BearingId` | Guid | `eq, neq, in` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `IsPaused` | Boolean | `eq, neq` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `MonitoringPointType` | MonitoringPointTypeCodes | `eq, neq, in` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `Node` | NodeChild | `isnull, isnotnull` | | `NodeId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `NodeSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `ParentId` | Guid | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Abbreviation` | String | | `CorporationName` | String | | `Created` | DateTime | | `LocationName` | String | | `Name` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Abbreviation`, `Name`.
        :return: PagedResultsModelMonitoringPointResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_monitoring_points_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_monitoring_points_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_monitoring_points_with_http_info(self, **kwargs):  # noqa: E501
        """Gets Monitoring Points  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_monitoring_points_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Abbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `Active` | Boolean | `eq, neq` | | `Bearing` | BearingChild | `isnull, isnotnull` | | `BearingId` | Guid | `eq, neq, in` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `IsPaused` | Boolean | `eq, neq` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `MonitoringPointType` | MonitoringPointTypeCodes | `eq, neq, in` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `Node` | NodeChild | `isnull, isnotnull` | | `NodeId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `NodeSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `ParentId` | Guid | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Abbreviation` | String | | `CorporationName` | String | | `Created` | DateTime | | `LocationName` | String | | `Name` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Abbreviation`, `Name`.
        :return: PagedResultsModelMonitoringPointResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_monitoring_points" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/MonitoringPoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelMonitoringPointResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_monitoring_point(self, monitoring_point_id, **kwargs):  # noqa: E501
        """Updates a monitoringPoint  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_monitoring_point(monitoring_point_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str monitoring_point_id: (required)
        :param MonitoringPointUpdateRequest body:
        :return: MonitoringPointResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_monitoring_point_with_http_info(monitoring_point_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_monitoring_point_with_http_info(monitoring_point_id, **kwargs)  # noqa: E501
            return data

    def update_monitoring_point_with_http_info(self, monitoring_point_id, **kwargs):  # noqa: E501
        """Updates a monitoringPoint  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_monitoring_point_with_http_info(monitoring_point_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str monitoring_point_id: (required)
        :param MonitoringPointUpdateRequest body:
        :return: MonitoringPointResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['monitoring_point_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_monitoring_point" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'monitoring_point_id' is set
        if ('monitoring_point_id' not in params or
                params['monitoring_point_id'] is None):
            raise ValueError("Missing the required parameter `monitoring_point_id` when calling `update_monitoring_point`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'monitoring_point_id' in params:
            path_params['monitoringPointId'] = params['monitoring_point_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/MonitoringPoints/{monitoringPointId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MonitoringPointResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
