# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class HardwareEventsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def export_node_low_battery_events(self, location_id, **kwargs):  # noqa: E501
        """Export Node Low Battery event logs to email  # noqa: E501

        Required permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_node_low_battery_events(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param HardwareEventStateFilter event_state:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `EventType` | HardwareAlarmLogStateTypeCodes | `eq, neq, in` | | `HardwareType` | HardwareTypeCodes | `eq, neq, in` | | `NodeId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `NodeSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `TimeAcknowledged` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` | | `TimeEntered` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `TimeExited` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` | | `TimeNotified` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` |
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `EventType` | HardwareAlarmLogStateTypeCodes | | `HardwareType` | HardwareTypeCodes | | `HierarchyName` | String | | `TimeAcknowledged` | DateTime? | | `TimeEntered` | DateTime | | `TimeExited` | DateTime? | | `TimeNotified` | DateTime? |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `HierarchyName`, `NodeSerialNumber`.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_node_low_battery_events_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_node_low_battery_events_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def export_node_low_battery_events_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """Export Node Low Battery event logs to email  # noqa: E501

        Required permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_node_low_battery_events_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param HardwareEventStateFilter event_state:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `EventType` | HardwareAlarmLogStateTypeCodes | `eq, neq, in` | | `HardwareType` | HardwareTypeCodes | `eq, neq, in` | | `NodeId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `NodeSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `TimeAcknowledged` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` | | `TimeEntered` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `TimeExited` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` | | `TimeNotified` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` |
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `EventType` | HardwareAlarmLogStateTypeCodes | | `HardwareType` | HardwareTypeCodes | | `HierarchyName` | String | | `TimeAcknowledged` | DateTime? | | `TimeEntered` | DateTime | | `TimeExited` | DateTime? | | `TimeNotified` | DateTime? |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `HierarchyName`, `NodeSerialNumber`.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id', 'event_state', 'filter', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_node_low_battery_events" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `export_node_low_battery_events`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'location_id' in params:
            query_params.append(('locationId', params['location_id']))  # noqa: E501
        if 'event_state' in params:
            query_params.append(('eventState', params['event_state']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/HardwareEvents/exportNodeLowBattery', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hardware_events_for_location(self, location_id, **kwargs):  # noqa: E501
        """Gets a listing of hardware event logs for a location.  # noqa: E501

        Required permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hardware_events_for_location(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `EventType` | String | `eq, neq, in, like, isnull, isnotnull` | | `HardwareType` | String | `eq, neq, in, like, isnull, isnotnull` | | `TimeAcked` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` | | `TimeEntered` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `TimeExited` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` | | `TimeNotified` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `EventType` | String | | `HardwareType` | String | | `TimeAcked` | DateTime? | | `TimeEntered` | DateTime | | `TimeExited` | DateTime? | | `TimeNotified` | DateTime |
        :return: PagedResultsModelHardwareEventModelV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hardware_events_for_location_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hardware_events_for_location_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def get_hardware_events_for_location_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """Gets a listing of hardware event logs for a location.  # noqa: E501

        Required permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hardware_events_for_location_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `EventType` | String | `eq, neq, in, like, isnull, isnotnull` | | `HardwareType` | String | `eq, neq, in, like, isnull, isnotnull` | | `TimeAcked` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` | | `TimeEntered` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `TimeExited` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` | | `TimeNotified` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `EventType` | String | | `HardwareType` | String | | `TimeAcked` | DateTime? | | `TimeEntered` | DateTime | | `TimeExited` | DateTime? | | `TimeNotified` | DateTime |
        :return: PagedResultsModelHardwareEventModelV3
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hardware_events_for_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `get_hardware_events_for_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'location_id' in params:
            path_params['locationId'] = params['location_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/HardwareEvents/location/{locationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelHardwareEventModelV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_low_battery_events(self, location_id, **kwargs):  # noqa: E501
        """Gets Node Low Battery event logs  # noqa: E501

        Required permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_low_battery_events(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param HardwareEventStateFilter event_state:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `EventType` | HardwareAlarmLogStateTypeCodes | `eq, neq, in` | | `HardwareType` | HardwareTypeCodes | `eq, neq, in` | | `NodeId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `NodeSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `TimeAcknowledged` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` | | `TimeEntered` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `TimeExited` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` | | `TimeNotified` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `EventType` | HardwareAlarmLogStateTypeCodes | | `HardwareType` | HardwareTypeCodes | | `HierarchyName` | String | | `TimeAcknowledged` | DateTime? | | `TimeEntered` | DateTime | | `TimeExited` | DateTime? | | `TimeNotified` | DateTime? |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `HierarchyName`, `NodeSerialNumber`.
        :return: PagedResultsModelNodeEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_low_battery_events_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_low_battery_events_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def get_node_low_battery_events_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """Gets Node Low Battery event logs  # noqa: E501

        Required permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_low_battery_events_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param HardwareEventStateFilter event_state:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `EventType` | HardwareAlarmLogStateTypeCodes | `eq, neq, in` | | `HardwareType` | HardwareTypeCodes | `eq, neq, in` | | `NodeId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `NodeSerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` | | `TimeAcknowledged` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` | | `TimeEntered` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `TimeExited` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` | | `TimeNotified` | DateTime? | `eq, neq, in, lt, gt, leq, geq, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `EventType` | HardwareAlarmLogStateTypeCodes | | `HardwareType` | HardwareTypeCodes | | `HierarchyName` | String | | `TimeAcknowledged` | DateTime? | | `TimeEntered` | DateTime | | `TimeExited` | DateTime? | | `TimeNotified` | DateTime? |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `HierarchyName`, `NodeSerialNumber`.
        :return: PagedResultsModelNodeEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id', 'event_state', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_low_battery_events" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `get_node_low_battery_events`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'location_id' in params:
            query_params.append(('locationId', params['location_id']))  # noqa: E501
        if 'event_state' in params:
            query_params.append(('eventState', params['event_state']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/HardwareEvents/NodeLowBattery', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelNodeEventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
