# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class GroupsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_bearings_for_group(self, group_id, **kwargs):  # noqa: E501
        """Gets all bearings for a group  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bearings_for_group(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Manufacturer` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `RollerCount` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Bpfi` | Double | | `Bpfo` | Double | | `Bsf` | Double | | `Ftf` | Double | | `Manufacturer` | String | | `Name` | String | | `RollerCount` | Int64 |
        :return: PagedResultsModelBearingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bearings_for_group_with_http_info(group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bearings_for_group_with_http_info(group_id, **kwargs)  # noqa: E501
            return data

    def get_bearings_for_group_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """Gets all bearings for a group  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bearings_for_group_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Manufacturer` | String | `eq, neq, in, like, isnull, isnotnull` | | `Name` | String | `eq, neq, in, like, isnull, isnotnull` | | `RollerCount` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Bpfi` | Double | | `Bpfo` | Double | | `Bsf` | Double | | `Ftf` | Double | | `Manufacturer` | String | | `Name` | String | | `RollerCount` | Int64 |
        :return: PagedResultsModelBearingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bearings_for_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params or
                params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_bearings_for_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Groups/{groupId}/bearings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelBearingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_group_alerts(self, group_id, **kwargs):  # noqa: E501
        """Please use ​GET /api​/v3.0​/Alerts  Gets the alerts for the given group  # noqa: E501

        Required Permissions:  User must have access to the Group  User must have access to the Filters  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_group_alerts(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: The group to get the alerts for (required)
        :param list[str] filter_ids:
        :param str sensor_role_type: SensorRoleType is an additional filtering component for limiting to X or Y.
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `IndicatorName` | String | | `IndicatorSortOrder` | Int32? | | `TimeOfAlert` | DateTime? |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: None.
        :return: PagedResultsModelGroupAlertsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_group_alerts_with_http_info(group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_group_alerts_with_http_info(group_id, **kwargs)  # noqa: E501
            return data

    def get_group_alerts_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """Please use ​GET /api​/v3.0​/Alerts  Gets the alerts for the given group  # noqa: E501

        Required Permissions:  User must have access to the Group  User must have access to the Filters  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_group_alerts_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: The group to get the alerts for (required)
        :param list[str] filter_ids:
        :param str sensor_role_type: SensorRoleType is an additional filtering component for limiting to X or Y.
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `IndicatorName` | String | | `IndicatorSortOrder` | Int32? | | `TimeOfAlert` | DateTime? |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: None.
        :return: PagedResultsModelGroupAlertsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'filter_ids', 'sensor_role_type', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_group_alerts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params or
                params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_group_alerts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']  # noqa: E501

        query_params = []
        if 'filter_ids' in params:
            query_params.append(('FilterIds', params['filter_ids']))  # noqa: E501
            collection_formats['FilterIds'] = 'multi'  # noqa: E501
        if 'sensor_role_type' in params:
            query_params.append(('SensorRoleType', params['sensor_role_type']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Groups/{groupId}/alerts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelGroupAlertsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_bearings_for_group(self, group_id, **kwargs):  # noqa: E501
        """Updates bearings for a group  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bearings_for_group(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: (required)
        :param UpdateBearingsForGroupRequest body:
        :return: list[BearingResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_bearings_for_group_with_http_info(group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_bearings_for_group_with_http_info(group_id, **kwargs)  # noqa: E501
            return data

    def update_bearings_for_group_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """Updates bearings for a group  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bearings_for_group_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: (required)
        :param UpdateBearingsForGroupRequest body:
        :return: list[BearingResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_bearings_for_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params or
                params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `update_bearings_for_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Groups/{groupId}/bearings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BearingResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
