# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class FilesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_file(self, **kwargs):  # noqa: E501
        """Creates a file  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContentType file_type:
        :param str display_name:
        :param str parent_folder_id:
        :param str description:
        :param str location_id:
        :param str corporation_id:
        :param list[str] group_ids:
        :param str files:
        :return: PictureFileMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_file_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_file_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_file_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a file  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ContentType file_type:
        :param str display_name:
        :param str parent_folder_id:
        :param str description:
        :param str location_id:
        :param str corporation_id:
        :param list[str] group_ids:
        :param str files:
        :return: PictureFileMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_type', 'display_name', 'parent_folder_id', 'description', 'location_id', 'corporation_id', 'group_ids', 'files']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file_type' in params:
            form_params.append(('FileType', params['file_type']))  # noqa: E501
        if 'display_name' in params:
            form_params.append(('DisplayName', params['display_name']))  # noqa: E501
        if 'parent_folder_id' in params:
            form_params.append(('ParentFolderId', params['parent_folder_id']))  # noqa: E501
        if 'description' in params:
            form_params.append(('Description', params['description']))  # noqa: E501
        if 'location_id' in params:
            form_params.append(('LocationId', params['location_id']))  # noqa: E501
        if 'corporation_id' in params:
            form_params.append(('CorporationId', params['corporation_id']))  # noqa: E501
        if 'group_ids' in params:
            form_params.append(('GroupIds', params['group_ids']))  # noqa: E501
            collection_formats['GroupIds'] = 'multi'  # noqa: E501
        if 'files' in params:
            local_var_files['files'] = params['files']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureFileMetadataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_file(self, file_id, **kwargs):  # noqa: E501
        """Deletes a file  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_id: File id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_file_with_http_info(file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_file_with_http_info(file_id, **kwargs)  # noqa: E501
            return data

    def delete_file_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Deletes a file  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_id: File id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params or
                params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `delete_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Files/{fileId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_corporation_files(self, corporation_id, **kwargs):  # noqa: E501
        """Gets all files for a corporation  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Corporation User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_corporation_files(corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str corporation_id: (required)
        :param list[str] group_ids:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Corporation` | CorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `FileType` | ContentType | `eq, neq, in` | | `IsPrimaryImage` | Boolean? | `eq, neq, isnull, isnotnull` | | `IsRootFolder` | Boolean | `eq, neq` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `ParentFolderId` | Guid? | `eq, neq, in, isnull, isnotnull` | | `TagId` | Guid | `eq, neq, in` | | `TagName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreationDate` | DateTime | | `DisplayName` | String | | `FileName` | String | | `UpdateDate` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Description`, `DisplayName`, `TagName`.
        :return: PagedResultsModelPictureFileMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_corporation_files_with_http_info(corporation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_corporation_files_with_http_info(corporation_id, **kwargs)  # noqa: E501
            return data

    def get_corporation_files_with_http_info(self, corporation_id, **kwargs):  # noqa: E501
        """Gets all files for a corporation  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Corporation User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_corporation_files_with_http_info(corporation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str corporation_id: (required)
        :param list[str] group_ids:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Corporation` | CorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `FileType` | ContentType | `eq, neq, in` | | `IsPrimaryImage` | Boolean? | `eq, neq, isnull, isnotnull` | | `IsRootFolder` | Boolean | `eq, neq` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `ParentFolderId` | Guid? | `eq, neq, in, isnull, isnotnull` | | `TagId` | Guid | `eq, neq, in` | | `TagName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreationDate` | DateTime | | `DisplayName` | String | | `FileName` | String | | `UpdateDate` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Description`, `DisplayName`, `TagName`.
        :return: PagedResultsModelPictureFileMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['corporation_id', 'group_ids', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_corporation_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'corporation_id' is set
        if ('corporation_id' not in params or
                params['corporation_id'] is None):
            raise ValueError("Missing the required parameter `corporation_id` when calling `get_corporation_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'corporation_id' in params:
            path_params['corporationId'] = params['corporation_id']  # noqa: E501

        query_params = []
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Files/corporations/{corporationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelPictureFileMetadataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file(self, id, **kwargs):  # noqa: E501
        """Gets a file  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Corporation User  Location Admin  Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: PictureFileMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_file_with_http_info(self, id, **kwargs):  # noqa: E501
        """Gets a file  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Corporation User  Location Admin  Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: PictureFileMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Files/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureFileMetadataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_object(self, object_filename, **kwargs):  # noqa: E501
        """Gets a file object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_object(object_filename, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str object_filename: Filename (key) of requested object (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_object_with_http_info(object_filename, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_object_with_http_info(object_filename, **kwargs)  # noqa: E501
            return data

    def get_file_object_with_http_info(self, object_filename, **kwargs):  # noqa: E501
        """Gets a file object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_object_with_http_info(object_filename, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str object_filename: Filename (key) of requested object (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['object_filename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'object_filename' is set
        if ('object_filename' not in params or
                params['object_filename'] is None):
            raise ValueError("Missing the required parameter `object_filename` when calling `get_file_object`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'object_filename' in params:
            path_params['objectFilename'] = params['object_filename']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Files/object/{objectFilename}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_files(self, **kwargs):  # noqa: E501
        """Get all the files  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Corporation User  Location Admin  Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_files(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Corporation` | CorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `FileType` | ContentType | `eq, neq, in` | | `IsPrimaryImage` | Boolean? | `eq, neq, isnull, isnotnull` | | `IsRootFolder` | Boolean | `eq, neq` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `ParentFolderId` | Guid? | `eq, neq, in, isnull, isnotnull` | | `TagId` | Guid | `eq, neq, in` | | `TagName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreationDate` | DateTime | | `DisplayName` | String | | `FileName` | String | | `UpdateDate` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Description`, `DisplayName`, `TagName`.
        :return: PagedResultsModelPictureFileMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_files_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_files_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_files_with_http_info(self, **kwargs):  # noqa: E501
        """Get all the files  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Corporation User  Location Admin  Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_files_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] group_ids:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Corporation` | CorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `FileType` | ContentType | `eq, neq, in` | | `IsPrimaryImage` | Boolean? | `eq, neq, isnull, isnotnull` | | `IsRootFolder` | Boolean | `eq, neq` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `ParentFolderId` | Guid? | `eq, neq, in, isnull, isnotnull` | | `TagId` | Guid | `eq, neq, in` | | `TagName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreationDate` | DateTime | | `DisplayName` | String | | `FileName` | String | | `UpdateDate` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Description`, `DisplayName`, `TagName`.
        :return: PagedResultsModelPictureFileMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_ids', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_files" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelPictureFileMetadataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_location_files(self, location_id, **kwargs):  # noqa: E501
        """Gets all files for a location  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Corporation User  Location Admin  Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_location_files(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param list[str] group_ids:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Corporation` | CorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `FileType` | ContentType | `eq, neq, in` | | `IsPrimaryImage` | Boolean? | `eq, neq, isnull, isnotnull` | | `IsRootFolder` | Boolean | `eq, neq` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `ParentFolderId` | Guid? | `eq, neq, in, isnull, isnotnull` | | `TagId` | Guid | `eq, neq, in` | | `TagName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreationDate` | DateTime | | `DisplayName` | String | | `FileName` | String | | `UpdateDate` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Description`, `DisplayName`, `TagName`.
        :return: PagedResultsModelPictureFileMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_location_files_with_http_info(location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_location_files_with_http_info(location_id, **kwargs)  # noqa: E501
            return data

    def get_location_files_with_http_info(self, location_id, **kwargs):  # noqa: E501
        """Gets all files for a location  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Corporation User  Location Admin  Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_location_files_with_http_info(location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location_id: (required)
        :param list[str] group_ids:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Corporation` | CorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `FileType` | ContentType | `eq, neq, in` | | `IsPrimaryImage` | Boolean? | `eq, neq, isnull, isnotnull` | | `IsRootFolder` | Boolean | `eq, neq` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `ParentFolderId` | Guid? | `eq, neq, in, isnull, isnotnull` | | `TagId` | Guid | `eq, neq, in` | | `TagName` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CreationDate` | DateTime | | `DisplayName` | String | | `FileName` | String | | `UpdateDate` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `Description`, `DisplayName`, `TagName`.
        :return: PagedResultsModelPictureFileMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location_id', 'group_ids', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_location_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `get_location_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'location_id' in params:
            path_params['locationId'] = params['location_id']  # noqa: E501

        query_params = []
        if 'group_ids' in params:
            query_params.append(('groupIds', params['group_ids']))  # noqa: E501
            collection_formats['groupIds'] = 'multi'  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Files/locations/{locationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelPictureFileMetadataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_files(self, **kwargs):  # noqa: E501
        """Moves files to a folder  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_files(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MoveFilesRequest body: Move Request
        :return: MoveFilesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.move_files_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.move_files_with_http_info(**kwargs)  # noqa: E501
            return data

    def move_files_with_http_info(self, **kwargs):  # noqa: E501
        """Moves files to a folder  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_files_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MoveFilesRequest body: Move Request
        :return: MoveFilesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_files" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Files/move', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MoveFilesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_file(self, file_id, **kwargs):  # noqa: E501
        """Update a file  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_file(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_id: The File id (required)
        :param FilesUpdateRequest body: Model for updating the file
        :return: PictureFileMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_file_with_http_info(file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_file_with_http_info(file_id, **kwargs)  # noqa: E501
            return data

    def update_file_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Update a file  # noqa: E501

        Required Permissions:  System Admin / Sentry  Corporation Admin  Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_file_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_id: The File id (required)
        :param FilesUpdateRequest body: Model for updating the file
        :return: PictureFileMetadataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params or
                params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `update_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Files/{fileId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PictureFileMetadataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
