(function(){suite("djblets/gravy/backboneUtils",function(){var model;beforeEach(function(){model=new Backbone.Model});describe("$.fn.bindClass",function(){var $el;beforeEach(function(){$el=$("<div/>").appendTo(document.body)});describe("Initial class value",function(){it("Adds class when true",function(){model.set("mybool",true);$el.bindClass(model,"mybool","myclass");expect($el.hasClass("myclass")).toBe(true)});it("No class when false",function(){model.set("mybool",false);$el.bindClass(model,"mybool","myclass");expect($el.hasClass("myclass")).toBe(false)});describe("With inverse",function(){it("No class when true",function(){model.set("mybool",true);$el.bindClass(model,"mybool","myclass",{inverse:true});expect($el.hasClass("myclass")).toBe(false)});it("Adds class when false",function(){model.set("mybool",false);$el.bindClass(model,"mybool","myclass",{inverse:true});expect($el.hasClass("myclass")).toBe(true)})})});describe("Model property changes",function(){it("Removes class when true -> false",function(){model.set("mybool",true);$el.bindClass(model,"mybool","myclass");model.set("mybool",false);expect($el.hasClass("myclass")).toBe(false)});it("Adds class when false -> true",function(){model.set("mybool",false);$el.bindClass(model,"mybool","myclass");model.set("mybool",true);expect($el.hasClass("myclass")).toBe(true)});describe("With inverse",function(){it("Adds class when true -> false",function(){model.set("mybool",true);$el.bindClass(model,"mybool","myclass",{inverse:true});model.set("mybool",false);expect($el.hasClass("myclass")).toBe(true)});it("Removes class when false -> true",function(){model.set("mybool",false);$el.bindClass(model,"mybool","myclass",{inverse:true});model.set("mybool",true);expect($el.hasClass("myclass")).toBe(false)})})})});describe("$.fn.bindProperty",function(){var $el,$radio1,$radio2;beforeEach(function(){$el=$("<input type='checkbox'/>").appendTo(document.body);$radio1=$('<input type="radio" name="my-radio" value="one" />').appendTo(document.body);$radio2=$('<input type="radio" name="my-radio" value="two" />').appendTo(document.body)});afterEach(function(){$el.remove();$radio1.remove();$radio2.remove()});describe("Initial property values",function(){it("Setting element's property from model property's",function(){model.set("mybool",true);$el.bindProperty("checked",model,"mybool");expect($el.prop("checked")).toBe(true)});it("Setting element's property from model property's with "+"inverse=true",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{inverse:true});expect($el.prop("checked")).toBe(true);expect(model.get("mybool")).toBe(false)});it("Setting element's property from model property with radioValue",function(){model.set("myvalue","one");$radio1.bindProperty("checked",model,"myvalue",{radioValue:"one"});$radio2.bindProperty("checked",model,"myvalue",{radioValue:"two"});expect($radio1.prop("checked")).toBe(true);expect($radio2.prop("checked")).toBe(false);expect(model.get("myvalue")).toBe("one")});it("No element changes with modelToElement=false",function(){model.set("mybool",true);$el.bindProperty("checked",model,"mybool",{modelToElement:false});expect($el.prop("checked")).toBe(false)})});describe("Model property changes",function(){it("Setting element's property",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool");expect($el.prop("checked")).toBe(false);model.set("mybool",true);expect($el.prop("checked")).toBe(true)});it("Setting element's property with inverse=true",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{inverse:true});expect($el.prop("checked")).toBe(true);model.set("mybool",true);expect($el.prop("checked")).toBe(false);expect(model.get("mybool")).toBe(true)});it("Setting element's property with radioValue",function(){model.set("myvalue","one");$radio1.bindProperty("checked",model,"myvalue",{radioValue:"one"});$radio2.bindProperty("checked",model,"myvalue",{radioValue:"two"});expect($radio1.prop("checked")).toBe(true);expect($radio2.prop("checked")).toBe(false);model.set("myvalue","two");expect($radio1.prop("checked")).toBe(false);expect($radio2.prop("checked")).toBe(true);expect(model.get("myvalue")).toBe("two")});it("No element changes with modelToElement=false",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{modelToElement:false});model.set("mybool",true);expect($el.prop("checked")).toBe(false)})});describe("Element property changes",function(){it("Setting model's property",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool");$el.click();expect($el.prop("checked")).toBe(true);expect(model.get("mybool")).toBe(true)});it("Setting model's property with inverse=true",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{inverse:true});$el.prop("checked",false);$el.click();expect($el.prop("checked")).toBe(true);expect(model.get("mybool")).toBe(false)});it("Setting model's property with radioValue",function(){model.set("myvalue","one");$radio1.bindProperty("checked",model,"myvalue",{radioValue:"one"});$radio2.bindProperty("checked",model,"myvalue",{radioValue:"two"});$radio2.click();expect($radio1.prop("checked")).toBe(false);expect($radio2.prop("checked")).toBe(true);expect(model.get("myvalue")).toBe("two")});it("No model changes with elementToModel=false",function(){model.set("mybool",false);$el.bindProperty("checked",model,"mybool",{elementToModel:false});$el.click();expect($el.prop("checked")).toBe(true);expect(model.get("mybool")).toBe(false)})});describe("Special properties",function(){it("text",function(){var $el=$("<p/>");$el.bindProperty("text",model,"text",{elementToModel:false});model.set("text","hello world!");expect($el.text()).toBe("hello world!")});it("html",function(){var $el=$("<p/>");$el.bindProperty("html",model,"html",{elementToModel:false});model.set("html","<b>hello world!</b>");expect($el.html()).toBe("<b>hello world!</b>")})})});describe("$.fn.bindVisibility",function(){var $el;beforeEach(function(){$el=$("<div/>").appendTo(document.body)});afterEach(function(){$el.remove()});describe("Showing elements",function(){it("When property is initially true",function(){$el.hide();model.set("mybool",true);$el.bindVisibility(model,"mybool");expect($el.is(":visible")).toBe(true)});it("When property is initially false with inverse=true",function(){$el.hide();model.set("mybool",false);$el.bindVisibility(model,"mybool",{inverse:true});expect($el.is(":visible")).toBe(true)});it("When property is changed to true",function(){expect($el.is(":visible")).toBe(true);model.set("mybool",false);$el.bindVisibility(model,"mybool");model.set("mybool",true);expect($el.is(":visible")).toBe(true)});it("When property is changed to false with inverse=true",function(){$el.hide();model.set("mybool",true);$el.bindVisibility(model,"mybool",{inverse:true});model.set("mybool",false);expect($el.is(":visible")).toBe(true)})});describe("Hiding elements",function(){it("When property is initially false",function(){expect($el.is(":visible")).toBe(true);model.set("mybool",false);$el.bindVisibility(model,"mybool");expect($el.is(":visible")).toBe(false)});it("When property is initially true with inverse=true",function(){expect($el.is(":visible")).toBe(true);model.set("mybool",true);$el.bindVisibility(model,"mybool",{inverse:true});expect($el.is(":visible")).toBe(false)});it("When property is changed to false",function(){$el.hide();model.set("mybool",true);$el.bindVisibility(model,"mybool");model.set("mybool",false);expect($el.is(":visible")).toBe(false)});it("When property is changed to true with inverse=true",function(){expect($el.is(":visible")).toBe(true);model.set("mybool",false);$el.bindVisibility(model,"mybool",{inverse:true});model.set("mybool",true);expect($el.is(":visible")).toBe(false)})})})});"use strict";suite("djblets/configForms/models/ListItem",function(){describe("Default actions",function(){describe("showRemove",function(){it("true",function(){const listItem=new Djblets.Config.ListItem({showRemove:true});expect(listItem.actions.length).toBe(1);expect(listItem.actions[0].id).toBe("delete")});it("false",function(){const listItem=new Djblets.Config.ListItem({showRemove:false});expect(listItem.actions.length).toBe(0)})})})});"use strict";suite("djblets/configForms/views/ListItemView",function(){describe("Rendering",function(){describe("General item display",function(){it("With editURL",function(){const item=new Djblets.Config.ListItem({editURL:"http://example.com/",text:"Label"});const itemView=new Djblets.Config.ListItemView({model:item});itemView.render();expect(itemView.$el.html().strip()).toBe(['<span class="djblets-c-config-forms-list__item-actions">',"</span>\n",'<a href="http://example.com/">Label</a>'].join(""))});it("Without editURL",function(){const item=new Djblets.Config.ListItem({text:"Label"});const itemView=new Djblets.Config.ListItemView({model:item});itemView.render();expect(itemView.$el.html().strip()).toBe(['<span class="djblets-c-config-forms-list__item-actions">',"</span>\n","Label"].join(""))})});describe("Item states",function(){const CustomItemView=Djblets.Config.ListItemView.extend({template:_.template(`<div><%- text %></div>
<div class="djblets-c-config-forms-list__item-state">
</div>`)});it("Initial render",function(){const item=new Djblets.Config.ListItem({itemState:"enabled"});const itemView=new CustomItemView({model:item});itemView.render();expect(itemView.el).toHaveClass("-is-enabled");const $stateText=itemView.$(".djblets-c-config-forms-list__item-state");expect($stateText.text()).toBe("Enabled")});it("When changed",function(){const item=new Djblets.Config.ListItem({itemState:"enabled"});const itemView=new CustomItemView({model:item});itemView.render();item.set("itemState","disabled");expect(itemView.el).toHaveClass("-is-disabled");expect(itemView.el).not.toHaveClass("-is-enabled");const $stateText=itemView.$(".djblets-c-config-forms-list__item-state");expect($stateText.text()).toBe("Disabled")})});describe("Actions",function(){it("Checkboxes",function(){const item=new Djblets.Config.ListItem({text:"Label",checkboxAttr:false,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",propName:"checkboxAttr"}]});const itemView=new Djblets.Config.ListItemView({model:item});itemView.render();expect(itemView.$("input[type=checkbox]").length).toBe(1);expect(itemView.$("label").length).toBe(1)});describe("Buttons",function(){it("Simple",function(){const item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button"}]});const itemView=new Djblets.Config.ListItemView({model:item});itemView.render();const $button=itemView.$("button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);const buttonEl=$button[0];expect($button.text()).toBe("Button");expect(buttonEl).toHaveClass("config-forms-list-action-mybutton");expect(buttonEl).not.toHaveClass("rb-icon");expect(buttonEl).not.toHaveClass("-is-danger");expect(buttonEl).not.toHaveClass("-is-primary")});it("Danger",function(){const item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button",danger:true}]});const itemView=new Djblets.Config.ListItemView({model:item});itemView.render();const $button=itemView.$("button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);const buttonEl=$button[0];expect($button.text()).toBe("Button");expect(buttonEl).toHaveClass("config-forms-list-action-mybutton");expect(buttonEl).not.toHaveClass("rb-icon");expect(buttonEl).not.toHaveClass("-is-primary");expect(buttonEl).toHaveClass("-is-danger")});it("Primary",function(){const item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button",primary:true}]});const itemView=new Djblets.Config.ListItemView({model:item});itemView.render();const $button=itemView.$("button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);const buttonEl=$button[0];expect($button.text()).toBe("Button");expect(buttonEl).toHaveClass("config-forms-list-action-mybutton");expect(buttonEl).not.toHaveClass("rb-icon");expect(buttonEl).not.toHaveClass("-is-danger");expect(buttonEl).toHaveClass("-is-primary")});it("Icon names",function(){const item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button",danger:false,iconName:"foo"}]});const itemView=new Djblets.Config.ListItemView({model:item});itemView.render();const $button=itemView.$("button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);const buttonEl=$button[0];expect($button.text()).toBe("Button");expect(buttonEl).toHaveClass("config-forms-list-action-mybutton");expect(buttonEl).not.toHaveClass("-is-danger");expect(buttonEl).not.toHaveClass("-is-primary");const $span=$button.find("span");expect($span.length).toBe(1);expect($span.hasClass("djblets-icon")).toBe(true);expect($span.hasClass("djblets-icon-foo")).toBe(true)})});describe("Menus",function(){let item;let itemView;beforeEach(function(){item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mymenu",label:"Menu",children:[{id:"mymenuitem",label:"My menu item"}]}]});itemView=new Djblets.Config.ListItemView({model:item});itemView.render()});it("Initial display",function(){const $button=itemView.$("button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);expect($button.text()).toBe("Menu ▾")});it("Opening",function(){spyOn(_,"defer").and.callFake(function(cb){cb()});spyOn(itemView,"trigger");const $action=itemView.$(".config-forms-list-action-mymenu");$action.click();const $menu=itemView.$(".djblets-c-config-forms-popup-menu");expect($menu.length).toBe(1);expect(itemView.trigger.calls.mostRecent().args[0]).toBe("actionMenuPopUp")});it("Closing",function(){spyOn(_,"defer").and.callFake(cb=>cb());const $action=itemView.$(".config-forms-list-action-mymenu");$action.click();spyOn(itemView,"trigger");$(document.body).click();expect(itemView.trigger.calls.mostRecent().args[0]).toBe("actionMenuPopDown");const $menu=itemView.$(".action-menu");expect($menu.length).toBe(0)})})});describe("Action properties",function(){describe("enabledPropName",function(){it("value == undefined",function(){const item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isEnabled"}]});const itemView=new Djblets.Config.ListItemView({model:item});itemView.render();const $action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(true)});it("value == true",function(){const item=new Djblets.Config.ListItem({text:"Label",isEnabled:true,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isEnabled"}]});const itemView=new Djblets.Config.ListItemView({model:item});itemView.render();const $action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(false)});it("value == false",function(){const item=new Djblets.Config.ListItem({text:"Label",isEnabled:false,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isEnabled"}]});const itemView=new Djblets.Config.ListItemView({model:item});itemView.render();const $action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(true)});describe("with enabledPropInverse == true",function(){it("value == undefined",function(){const item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isDisabled",enabledPropInverse:true}]});const itemView=new Djblets.Config.ListItemView({model:item});itemView.render();const $action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(false)});it("value == true",function(){const item=new Djblets.Config.ListItem({text:"Label",isDisabled:true,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isDisabled",enabledPropInverse:true}]});const itemView=new Djblets.Config.ListItemView({model:item});itemView.render();const $action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(true)});it("value == false",function(){var item=new Djblets.Config.ListItem({text:"Label",isDisabled:false,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",enabledPropName:"isDisabled",enabledPropInverse:true}]}),itemView=new Djblets.Config.ListItemView({model:item}),$action;itemView.render();$action=itemView.$(".config-forms-list-action-mycheckbox");expect($action.prop("disabled")).toBe(false)})})})})});describe("Action handlers",function(){it("Buttons",function(){var item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button"}]});const itemView=new Djblets.Config.ListItemView({model:item});itemView.actionHandlers={mybutton:"_onMyButtonClick"};itemView._onMyButtonClick=()=>{};spyOn(itemView,"_onMyButtonClick");itemView.render();const $button=itemView.$("button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);$button.click();expect(itemView._onMyButtonClick).toHaveBeenCalled()});it("Checkboxes",function(){const item=new Djblets.Config.ListItem({text:"Label",checkboxAttr:false,actions:[{id:"mycheckbox",type:"checkbox",label:"Checkbox",propName:"checkboxAttr"}]});const itemView=new Djblets.Config.ListItemView({model:item});itemView.actionHandlers={mybutton:"_onMyButtonClick"};itemView._onMyButtonClick=()=>{};spyOn(itemView,"_onMyButtonClick");itemView.render();const $checkbox=itemView.$("input[type=checkbox]");expect($checkbox.length).toBe(1);expect($checkbox.prop("checked")).toBe(false);$checkbox.prop("checked",true).triggerHandler("change");expect(item.get("checkboxAttr")).toBe(true)})})});"use strict";suite("djblets/configForms/views/ListView",function(){describe("Manages items",function(){let collection;let list;let listView;beforeEach(function(){collection=new Backbone.Collection([{text:"Item 1"},{text:"Item 2"},{text:"Item 3"}],{model:Djblets.Config.ListItem});list=new Djblets.Config.List({},{collection:collection});listView=new Djblets.Config.ListView({model:list});listView.render()});it("On render",function(){const $items=listView.$("li");expect($items.length).toBe(3);expect($items.eq(0).text().strip()).toBe("Item 1");expect($items.eq(1).text().strip()).toBe("Item 2");expect($items.eq(2).text().strip()).toBe("Item 3")});it("On add",function(){collection.add({text:"Item 4"});const $items=listView.$("li");expect($items.length).toBe(4);expect($items.eq(3).text().strip()).toBe("Item 4")});it("On remove",function(){collection.remove(collection.at(0));const $items=listView.$("li");expect($items.length).toBe(2);expect($items.eq(0).text().strip()).toBe("Item 2")});it("On reset",function(){collection.reset([{text:"Foo"},{text:"Bar"}]);const $items=listView.$("li");expect($items.length).toBe(2);expect($items.eq(0).text().strip()).toBe("Foo");expect($items.eq(1).text().strip()).toBe("Bar")})})});"use strict";suite("djblets/configForms/views/TableItemView",function(){describe("Rendering",function(){describe("Item display",function(){it("With editURL",function(){const item=new Djblets.Config.ListItem({editURL:"http://example.com/",text:"Label"});const itemView=new Djblets.Config.TableItemView({model:item});itemView.render();expect(itemView.$el.html().strip()).toBe(["<td>",'<span class="djblets-c-config-forms-list__item-actions">',"</span>\n\n",'<a href="http://example.com/">Label</a>\n\n',"</td>"].join(""))});it("Without editURL",function(){const item=new Djblets.Config.ListItem({text:"Label"});const itemView=new Djblets.Config.TableItemView({model:item});itemView.render();expect(itemView.$el.html().strip()).toBe(["<td>",'<span class="djblets-c-config-forms-list__item-actions">',"</span>\n\n","Label\n\n","</td>"].join(""))})});describe("Action placement",function(){it("Default template",function(){const item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button"}]});const itemView=new Djblets.Config.TableItemView({model:item});itemView.render();const $button=itemView.$("td:last button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);expect($button.text()).toBe("Button")});it("Custom template",function(){const CustomTableItemView=Djblets.Config.TableItemView.extend({template:_.template(`<td></td>
<td></td>`)});const item=new Djblets.Config.ListItem({text:"Label",actions:[{id:"mybutton",label:"Button"}]});const itemView=new CustomTableItemView({model:item});itemView.render();const $button=itemView.$("td:last button.djblets-c-config-forms-list__item-action");expect($button.length).toBe(1);expect($button.text()).toBe("Button")})})})});"use strict";suite("djblets/configForms/views/TableView",function(){describe("Manages rows",function(){let collection;let list;let tableView;beforeEach(function(){collection=new Backbone.Collection([{text:"Item 1"},{text:"Item 2"},{text:"Item 3"}],{model:Djblets.Config.ListItem});list=new Djblets.Config.List({},{collection:collection});tableView=new Djblets.Config.TableView({model:list});tableView.render()});it("On render",function(){const $rows=tableView.$("tr");expect($rows.length).toBe(3);expect($rows.eq(0).text().strip()).toBe("Item 1");expect($rows.eq(1).text().strip()).toBe("Item 2");expect($rows.eq(2).text().strip()).toBe("Item 3")});it("On add",function(){collection.add({text:"Item 4"});const $rows=tableView.$("tr");expect($rows.length).toBe(4);expect($rows.eq(3).text().strip()).toBe("Item 4")});it("On remove",function(){collection.remove(collection.at(0));const $rows=tableView.$("tr");expect($rows.length).toBe(2);expect($rows.eq(0).text().strip()).toBe("Item 2")});it("On reset",function(){collection.reset([{text:"Foo"},{text:"Bar"}]);const $rows=tableView.$("tr");expect($rows.length).toBe(2);expect($rows.eq(0).text().strip()).toBe("Foo");expect($rows.eq(1).text().strip()).toBe("Bar")})})});"use strict";suite("djblets/forms/models/ConditionChoice",function(){describe("Initialization",function(){it("With parse and data",function(){const choice=new Djblets.Forms.ConditionChoice({id:"my-choice",name:"My Choice",valueField:{model:{className:"Djblets.Forms.ConditionValueField",data:{myModelKey:"my-value"}},view:{className:"Djblets.Forms.ConditionValueFormFieldView",data:{myViewKey:"my-value"}}},operators:[{id:"my-op",name:"My Op",useValue:false}]},{parse:true});expect(choice.id).toBe("my-choice");expect(choice.get("name")).toBe("My Choice");expect(choice.get("valueField")).toEqual({modelClass:Djblets.Forms.ConditionValueField,modelData:{myModelKey:"my-value"},viewClass:Djblets.Forms.ConditionValueFormFieldView,viewData:{myViewKey:"my-value"}});expect(choice.operators.length).toBe(1);const op=choice.operators.at(0);expect(op.id).toBe("my-op");expect(op.get("name")).toBe("My Op");expect(op.get("useValue")).toBe(false)})});describe("Methods",function(){it("createValueField",function(){const choice=new Djblets.Forms.ConditionChoice({id:"my-choice",name:"My Choice",valueField:{modelClass:Djblets.Forms.ConditionValueField,modelData:{myModelKey:"my-value"},viewClass:Djblets.Forms.ConditionValueFormFieldView,viewData:{myViewKey:"my-value"}}});const valueField=choice.createValueField("my-field");expect(valueField.model.get("fieldName")).toBe("my-field")})})});"use strict";suite("djblets/forms/models/Condition",function(){describe("Events",function(){describe("choice changes",function(){let choice1,choice2,condition;beforeEach(function(){choice1=new Djblets.Forms.ConditionChoice({id:"my-choice-1",name:"My Choice 1"});choice1.operators.add({id:"my-op-1",name:"My Op 1"});choice2=new Djblets.Forms.ConditionChoice({id:"my-choice-1",name:"My Choice 1"});choice2.operators.add([{id:"my-op-2",name:"My Op 2"},{id:"my-op-3",name:"My Op 3"}]);condition=new Djblets.Forms.Condition({choice:choice1,operator:choice1.operators.first(),value:"abc123"});condition.set("choice",choice2)});it("Operator resets to first",function(){expect(condition.get("operator")).toBe(choice2.operators.first())});it("Value resets",function(){expect(condition.get("value")).toBe(undefined)})})})});"use strict";suite("djblets/forms/models/ConditionOperator",function(){describe("Initialization",function(){it("With parse and data",function(){const op=new Djblets.Forms.ConditionOperator({id:"my-op",name:"My Operator",useValue:true,valueField:{model:{className:"Djblets.Forms.ConditionValueField",data:{myModelKey:"my-value"}},view:{className:"Djblets.Forms.ConditionValueFormFieldView",data:{myViewKey:"my-value"}}}},{parse:true});expect(op.id).toBe("my-op");expect(op.get("name")).toBe("My Operator");expect(op.get("useValue")).toBe(true);expect(op.get("valueField")).toEqual({modelClass:Djblets.Forms.ConditionValueField,modelData:{myModelKey:"my-value"},viewClass:Djblets.Forms.ConditionValueFormFieldView,viewData:{myViewKey:"my-value"}})});it("With parse and data, but no valueField",function(){const op=new Djblets.Forms.ConditionOperator({id:"my-op",name:"My Operator",useValue:true},{parse:true});expect(op.id).toBe("my-op");expect(op.get("name")).toBe("My Operator");expect(op.get("valueField")).toBe(null);expect(op.get("useValue")).toBe(true)})});describe("createValueField",function(){it("With custom valueField",function(){const op=new Djblets.Forms.ConditionOperator({id:"my-op",name:"My Operator",valueField:{modelClass:Djblets.Forms.ConditionValueField,modelData:{myModelKey:"my-value"},viewClass:Djblets.Forms.ConditionValueFormFieldView,viewData:{myViewKey:"my-value"}}});const valueField=op.createValueField("my-field");expect(valueField.model.get("fieldName")).toBe("my-field")});it("Without custom valueField",function(){const op=new Djblets.Forms.ConditionOperator({id:"my-op",name:"My Operator"});expect(()=>op.createValueField("my-field")).toThrowError("This operator does not have a custom valueField.")})})});"use strict";suite("djblets/forms/models/ConditionSet",function(){describe("Initialization",function(){it("choicesData parsed",function(){const conditionSet=new Djblets.Forms.ConditionSet({fieldName:"my-conditions",choicesData:[{id:"my-choice",name:"My Choice"}]});expect(conditionSet.choices.length).toBe(1);expect(conditionSet.choices.at(0).id).toBe("my-choice");expect(conditionSet.get("lastID")).toBe(null)});it("conditionsData parsed",function(){const conditionSet=new Djblets.Forms.ConditionSet({choicesData:[{id:"my-choice",name:"My Choice",operators:[{id:"my-op-1",name:"My Op 1"},{id:"my-op-2",name:"My Op 2"}]}],conditionsData:[{choiceID:"my-choice",operatorID:"my-op-1",value:"abc123",valid:false,error:"My error"},{choiceID:"my-choice",operatorID:"my-op-2",value:42,valid:true}]});const conditions=conditionSet.conditions;expect(conditions.length).toBe(2);let condition=conditions.at(0);expect(condition.id).toBe(0);expect(condition.get("choice").id).toBe("my-choice");expect(condition.get("operator").id).toBe("my-op-1");expect(condition.get("value")).toBe("abc123");expect(condition.get("valid")).toBe(false);expect(condition.get("error")).toBe("My error");condition=conditions.at(1);expect(condition.id).toBe(1);expect(condition.get("choice").id).toBe("my-choice");expect(condition.get("operator").id).toBe("my-op-2");expect(condition.get("value")).toBe(42);expect(condition.get("valid")).toBe(true);expect(condition.get("error")).toBe(null);expect(conditionSet.get("lastID")).toBe(1)});it("conditionsData parsed with bad choiceID",function(){const conditionSet=new Djblets.Forms.ConditionSet({choicesData:[{id:"my-choice",name:"My Choice",operators:[{id:"my-op-1",name:"My Op 1"},{id:"my-op-2",name:"My Op 2"}]}],conditionsData:[{choiceID:"invalid-choice",operatorID:"my-op-1",value:"abc123",valid:false,error:"My error"}]});const conditions=conditionSet.conditions;expect(conditions.length).toBe(1);const condition=conditions.at(0);expect(condition.id).toBe(0);expect(condition.get("choice")).toBe(null);expect(condition.get("operator")).toBe(null);expect(condition.get("value")).toBe("abc123");expect(condition.get("valid")).toBe(false);expect(condition.get("error")).toBe("My error");expect(conditionSet.get("lastID")).toBe(0)})});describe("Adding to conditions collection",function(){let conditionSet;beforeEach(function(){conditionSet=new Djblets.Forms.ConditionSet({choicesData:[{id:"my-choice",name:"My Choice",operators:[{id:"my-op",name:"My Op"}]}]});expect(conditionSet.get("lastID")).toBe(null)});it("Using choice and operator IDs",function(){conditionSet.conditions.add({choiceID:"my-choice",operatorID:"my-op",value:"abc123",valid:false,error:"My error"});const conditions=conditionSet.conditions;expect(conditions.length).toBe(1);const condition=conditions.at(0);expect(condition.id).toBe(0);expect(condition.get("choice").id).toBe("my-choice");expect(condition.get("operator").id).toBe("my-op");expect(condition.get("value")).toBe("abc123");expect(condition.get("valid")).toBe(false);expect(condition.get("error")).toBe("My error");expect(conditionSet.get("lastID")).toBe(0)});it("Using choice instance",function(){conditionSet.conditions.add({choiceID:conditionSet.choices.at(0),operatorID:"my-op",value:"abc123",valid:false,error:"My error"});const conditions=conditionSet.conditions;expect(conditions.length).toBe(1);const condition=conditions.at(0);expect(condition.id).toBe(0);expect(condition.get("choice").id).toBe("my-choice");expect(condition.get("operator").id).toBe("my-op");expect(condition.get("value")).toBe("abc123");expect(condition.get("valid")).toBe(false);expect(condition.get("error")).toBe("My error");expect(conditionSet.get("lastID")).toBe(0)});it("Using operator instance",function(){conditionSet.conditions.add({choiceID:"my-choice",operatorID:conditionSet.choices.at(0).operators.at(0),value:"abc123",valid:false,error:"My error"});const conditions=conditionSet.conditions;expect(conditions.length).toBe(1);const condition=conditions.at(0);expect(condition.id).toBe(0);expect(condition.get("choice").id).toBe("my-choice");expect(condition.get("operator").id).toBe("my-op");expect(condition.get("value")).toBe("abc123");expect(condition.get("valid")).toBe(false);expect(condition.get("error")).toBe("My error");expect(conditionSet.get("lastID")).toBe(0)})});describe("Methods",function(){it("addNewCondition",function(){const conditionSet=new Djblets.Forms.ConditionSet({fieldName:"my-conditions",choicesData:[{id:"my-choice",name:"My Choice",operators:[{id:"my-op",name:"My Op"}]}]});const conditions=conditionSet.conditions;expect(conditions.length).toBe(0);expect(conditionSet.get("lastID")).toBe(null);conditionSet.addNewCondition();expect(conditions.length).toBe(1);expect(conditionSet.get("lastID")).toBe(0);const condition=conditions.at(0);expect(condition.id).toBe(0);expect(condition.get("choice").id).toBe("my-choice");expect(condition.get("operator").id).toBe("my-op")})})});"use strict";suite("djblets/forms/views/ConditionValueFormFieldView",function(){function makeValueField(html){return{model:{className:"Djblets.Forms.ConditionValueField",data:{fieldHTML:html}},view:{className:"Djblets.Forms.ConditionValueFormFieldView"}}}function setupConditionSetView(conditionsData){const conditionsTemplate=_.template(['<div class="conditions-field">\n',' <input type="hidden" name="my_conditions_last_id" />\n',' <div class="conditions-field-mode"></div>\n',' <div class="conditions-field-rows-container">\n','  <ul class="conditions-field-rows"></ul>\n','  <a href="#" class="conditions-field-add-condition"></a>\n'," </div>\n","</div>"].join(""));const conditionSetView=new Djblets.Forms.ConditionSetView({el:$(conditionsTemplate()),model:new Djblets.Forms.ConditionSet({fieldName:"my_conditions",choicesData:[{id:"my-choice-1",name:"My Choice 1",valueField:makeValueField('<input type="text" />'),operators:[{id:"my-op-1",name:"My Op 1",useValue:true},{id:"my-op-2",name:"My Op 2",useValue:true,valueField:makeValueField('<input type="number" />')}]},{id:"my-choice-2",name:"My Choice 2",valueField:makeValueField('<input type="email" />'),operators:[{id:"my-op-3",name:"My Op 3",useValue:true},{id:"my-op-4",name:"My Op 4",useValue:true}]}],conditionsData:conditionsData},{parse:true})});conditionSetView.render();return conditionSetView}describe("Rendering",function(){it("Loaded rows",function(){const conditionSetView=setupConditionSetView([{choiceID:"my-choice-1",operatorID:"my-op-1",value:"<test>",valid:true},{choiceID:"my-choice-2",operatorID:"my-op-4",value:42,valid:true}]);const $rows=conditionSetView.$(".conditions-field-row");expect($rows.length).toBe(2);const $lastID=conditionSetView.$("input[name=my_conditions_last_id]");expect($lastID.val()).toBe("1");let $row=$rows.eq(0);let $choice=$row.find(".conditions-field-choice");expect($choice.html()).toBe(['<select name="my_conditions_choice[0]">','<option value="my-choice-1">My Choice 1</option>','<option value="my-choice-2">My Choice 2</option>',"</select>"].join(""));expect($choice.children("select").val()).toBe("my-choice-1");let $operator=$row.find(".conditions-field-operator");expect($operator.html()).toBe(['<select name="my_conditions_operator[0]">','<option value="my-op-1">My Op 1</option>','<option value="my-op-2">My Op 2</option>',"</select>"].join(""));expect($operator.children("select").val()).toBe("my-op-1");let $value=$row.find(".conditions-field-value");let $input=$value.find("input");expect($input.parent().prop("tagName")).toBe("SPAN");expect($input.attr("type")).toBe("text");expect($input.attr("name")).toBe("my_conditions_value[0]");expect($input.val()).toBe("<test>");$row=$rows.eq(1);$choice=$row.find(".conditions-field-choice");expect($choice.html()).toBe(['<select name="my_conditions_choice[1]">','<option value="my-choice-1">My Choice 1</option>','<option value="my-choice-2">My Choice 2</option>',"</select>"].join(""));expect($choice.children("select").val()).toBe("my-choice-2");$operator=$row.find(".conditions-field-operator");expect($operator.html()).toBe(['<select name="my_conditions_operator[1]">','<option value="my-op-3">My Op 3</option>','<option value="my-op-4">My Op 4</option>',"</select>"].join(""));expect($operator.children("select").val()).toBe("my-op-4");$value=$row.find(".conditions-field-value");$input=$value.find("input");expect($input.parent().prop("tagName")).toBe("SPAN");expect($input.attr("type")).toBe("email");expect($input.attr("name")).toBe("my_conditions_value[1]");expect($input.val()).toBe("42")});it("Loaded rows with errors",function(){const conditionSetView=setupConditionSetView([{choiceID:"my-choice-1",operatorID:"my-op-1",value:"<test>",error:"This is an <error>.",valid:true}]);const $rows=conditionSetView.$(".conditions-field-row");expect($rows.length).toBe(1);const $lastID=conditionSetView.$("input[name=my_conditions_last_id]");expect($lastID.val()).toBe("0");const $row=$rows.eq(0);const $error=$row.find(".error-list li");expect($error.length).toBe(1);expect($error.html()).toBe("This is an &lt;error&gt;.")})});describe("Actions",function(){it("Add a new condition",function(){const conditionSetView=setupConditionSetView();let $rows=conditionSetView.$(".conditions-field-row");expect($rows.length).toBe(0);const $lastID=conditionSetView.$("input[name=my_conditions_last_id]");expect($lastID.val()).toBe("");spyOn(conditionSetView.model,"addNewCondition").and.callThrough();conditionSetView.$(".conditions-field-add-condition").click();expect(conditionSetView.model.addNewCondition).toHaveBeenCalled();$rows=conditionSetView.$(".conditions-field-row");expect($rows.length).toBe(1);expect($lastID.val()).toBe("0");const $row=$rows.eq(0);const $choice=$row.find(".conditions-field-choice");expect($choice.html()).toBe(['<select name="my_conditions_choice[0]">','<option value="my-choice-1">My Choice 1</option>','<option value="my-choice-2">My Choice 2</option>',"</select>"].join(""));expect($choice.children("select").val()).toBe("my-choice-1");const $operator=$row.find(".conditions-field-operator");expect($operator.html()).toBe(['<select name="my_conditions_operator[0]">','<option value="my-op-1">My Op 1</option>','<option value="my-op-2">My Op 2</option>',"</select>"].join(""));expect($operator.children("select").val()).toBe("my-op-1");const $value=$row.find(".conditions-field-value");const $input=$value.find("input");expect($input.parent().prop("tagName")).toBe("SPAN");expect($input.attr("type")).toBe("text");expect($input.attr("name")).toBe("my_conditions_value[0]");expect($input.val()).toBe("")});it("Delete a condition",function(){const conditionSetView=setupConditionSetView([{choiceID:"my-choice-1",operatorID:"my-op-1",value:"<test>",valid:true}]);let $rows=conditionSetView.$(".conditions-field-row");expect(conditionSetView.model.conditions.length).toBe(1);expect($rows.length).toBe(1);const $lastID=conditionSetView.$("input[name=my_conditions_last_id]");expect($lastID.val()).toBe("0");const condition=conditionSetView.model.conditions.at(0);spyOn(condition,"destroy").and.callThrough();$rows.eq(0).find(".conditions-field-row-delete").click();expect(condition.destroy).toHaveBeenCalled();$rows=conditionSetView.$(".conditions-field-row");expect(conditionSetView.model.conditions.length).toBe(0);expect($rows.length).toBe(0);expect($lastID.val()).toBe("0")});it("Changing a choice updates model",function(){const conditionSetView=setupConditionSetView([{choiceID:"my-choice-1",operatorID:"my-op-1",value:"<test>",valid:true}]);const $rows=conditionSetView.$(".conditions-field-row");const condition=conditionSetView.model.conditions.at(0);$rows.eq(0).find(".conditions-field-choice select").val("my-choice-2").trigger("change");expect(condition.get("choice").id).toBe("my-choice-2")});it("Changing an operator updates model",function(){const conditionSetView=setupConditionSetView([{choiceID:"my-choice-1",operatorID:"my-op-1",value:"<test>",valid:true}]);const $rows=conditionSetView.$(".conditions-field-row");const condition=conditionSetView.model.conditions.at(0);$rows.eq(0).find(".conditions-field-operator select").val("my-op-2").trigger("change");expect(condition.get("operator").id).toBe("my-op-2")})});describe("Model events",function(){let conditionSetView,conditionSet,condition,$row,$choice,$operator,$valueWrapper;beforeEach(function(){conditionSetView=setupConditionSetView([{choiceID:"my-choice-1",operatorID:"my-op-1",value:"<test>",valid:true}]);conditionSet=conditionSetView.model;condition=conditionSet.conditions.at(0);$row=conditionSetView.$(".conditions-field-row").eq(0);$choice=$row.find(".conditions-field-choice select");$operator=$row.find(".conditions-field-operator select");$valueWrapper=$row.find(".conditions-field-value");const $input=$valueWrapper.find("input");expect($input.attr("type")).toBe("text");expect($input.val()).toBe("<test>")});describe("Choice changed",function(){it("Updates UI state",function(){condition.set("choice",conditionSet.choices.get("my-choice-2"));expect($choice.val()).toBe("my-choice-2");expect($operator.val()).toBe("my-op-3");const $input=$valueWrapper.find("input");expect($input.attr("type")).toBe("email");expect($input.val()).toBe("")})});describe("Operator changed",function(){it("Updates UI state",function(){const choice=conditionSet.choices.get("my-choice-1");condition.set("operator",choice.operators.get("my-op-2"));expect($choice.val()).toBe("my-choice-1");expect($operator.val()).toBe("my-op-2");const $input=$valueWrapper.find("input");expect($input.attr("type")).toBe("number");expect($input.val()).toBe("")});it("Retains value if valueField remains",function(){const choice=conditionSet.choices.get("my-choice-2");condition.set("choice",choice);$valueWrapper.find("input").val("42");expect($operator.val()).toBe("my-op-3");condition.set("operator",choice.operators.get("my-op-4"));expect($valueWrapper.find("input").val()).toBe("42")})});describe("Value changed",function(){it("Updated UI state",function(){condition.set("value","new-value");expect($valueWrapper.find("input").val()).toBe("new-value")})})})});"use strict";suite("djblets/forms/views/ConditionValueFormFieldView",function(){function createValueField(html){const view=new Djblets.Forms.ConditionValueFormFieldView({model:new Djblets.Forms.ConditionValueField({fieldName:"my-field",fieldHTML:html})});view.render();return view}it("Rendering",function(){const view=createValueField('<input type="text" />');expect(view.$input[0].tagName).toBe("INPUT");expect(view.$input.attr("type")).toBe("text");expect(view.$input.attr("name")).toBe("my-field")});describe("Methods",function(){describe("getValue",function(){it("<input>",function(){const view=createValueField('<input type="text" value="abc123" />');expect(view.getValue()).toBe("abc123")});it("<select>",function(){const view=createValueField(["<select>",'<option value="1">One</option>','<option value="2" selected="selected">Two</option>',"</select>"].join(""));expect(view.getValue()).toBe("2")});it("<textarea>",function(){const view=createValueField("<textarea></textarea>");view.setValue("abc123");expect(view.$input.val()).toBe("abc123")})});describe("setValue",function(){it("<input>",function(){const view=createValueField('<input type="text" />');view.setValue("abc123");expect(view.$input.val()).toBe("abc123")});it("<select>",function(){const view=createValueField(["<select>",'<option value="1">One</option>','<option value="2">Two</option>',"</select>"].join(""));view.setValue("2");expect(view.$input.val()).toBe("2")});it("<textarea>",function(){const view=createValueField("<textarea></textarea>");view.setValue("abc123");expect(view.$input.val()).toBe("abc123")})})})});"use strict";suite("djblets/forms/views/ListEditView",function(){const formTemplate=_.template(`<div class="djblets-c-list-edit-widget list-edit-widget">
<input type="hidden" name="_num_rows" value="<%- renderedRows.length %>">
  <ul class="djblets-c-list-edit-widget__entries">
  <% if (renderedRows.length > 0) { %>
    <% renderedRows.forEach(function(row, i) { %>
    <li class="djblets-c-list-edit-widget__entry"
        data-list-index="<%- i %>">
    <%= row %>
    <a href="#" class="djblets-c-list-edit-widget__remove-item"
        role="button">
    <span class="fa fa-times"></span>
    </a>
    </li>
  <% }); %>
  <% } else { %>
    <li class="djblets-c-list-edit-widget__entry" data-list-index="0">
    <%= renderedDefaultRow %>
    <a href="#" class="djblets-c-list-edit-widget__remove-item"></a>
    </li>
  <% } %>
  </ul>
 <button class="djblets-c-list-edit-widget__add-item btn" role="button">
 <span class="fa fa-plus"></span>
 </button>
</div>`);const makeView=function makeView(){let renderedRows=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];let renderedDefaultRow=arguments.length>1&&arguments[1]!==undefined?arguments[1]:`<input type="text"
class="djblets-c-list-edit-widget__input"
name="_value[0]" />`;const $el=$(formTemplate({renderedRows:renderedRows,renderedDefaultRow:renderedDefaultRow})).appendTo($testsScratch);const view=new Djblets.Forms.ListEditView({el:$el,renderedDefaultRow:renderedDefaultRow,fieldName:"",removeText:"Remove this item."});view.render();return[view,view.$('input[name="_num_rows"]')]};describe("Removal",function(){it("With no values",function(){const[view,$numRows]=makeView([]);expect($numRows.val()).toEqual("1");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(1);expect(view.$(".djblets-c-list-edit-widget__input").val()).toEqual("");expect(view.$(".djblets-c-list-edit-widget__input").attr("name")).toEqual("_value[0]");view.$(".djblets-c-list-edit-widget__remove-item").click();expect($numRows.val()).toEqual("1");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(1);expect(view.$(".djblets-c-list-edit-widget__input").val()).toEqual("");expect(view.$(".djblets-c-list-edit-widget__input").attr("name")).toEqual("_value[0]")});it("With one value",function(){const[view,$numRows]=makeView([`<input type="text"
class="djblets-c-list-edit-widget__input"
name="_value[0]"
value="One" />`]);expect($numRows.val()).toEqual("1");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(1);expect(view.$(".djblets-c-list-edit-widget__input").val()).toEqual("One");expect(view.$(".djblets-c-list-edit-widget__input").attr("name")).toEqual("_value[0]");view.$(".djblets-c-list-edit-widget__remove-item").click();expect($numRows.val()).toEqual("1");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(1);expect(view.$(".djblets-c-list-edit-widget__input").val()).toEqual("");expect(view.$(".djblets-c-list-edit-widget__input").attr("name")).toEqual("_value[0]")});it("With multiple values",function(){const[view,$numRows]=makeView([`<input type="text"
class="djblets-c-list-edit-widget__input"
name="_value[0]"
value="One" />`,`<input type="text"
class="djblets-c-list-edit-widget__input"
name="_value[1]"
value="Two" />`,`<input type="text"
class="djblets-c-list-edit-widget__input"
name="_value[2]"
value="Three" />`]);expect($numRows.val()).toEqual("3");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(3);expect(view.$(".djblets-c-list-edit-widget__remove-item").length).toEqual(3);let $inputOne=view.$(".djblets-c-list-edit-widget__input").eq(0);expect($inputOne.val()).toEqual("One");expect($inputOne.attr("name")).toEqual("_value[0]");let $inputTwo=view.$(".djblets-c-list-edit-widget__input").eq(1);expect($inputTwo.val()).toEqual("Two");expect($inputTwo.attr("name")).toEqual("_value[1]");let $inputThree=view.$(".djblets-c-list-edit-widget__input").eq(2);expect($inputThree.val()).toEqual("Three");expect($inputThree.attr("name")).toEqual("_value[2]");view.$(".djblets-c-list-edit-widget__remove-item").eq(1).click();expect($numRows.val()).toEqual("2");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(2);expect(view.$(".djblets-c-list-edit-widget__remove-item").length).toEqual(2);$inputOne=view.$(".djblets-c-list-edit-widget__input").eq(0);expect($inputOne.val()).toEqual("One");expect($inputOne.attr("name")).toEqual("_value[0]");$inputTwo=view.$(".djblets-c-list-edit-widget__input").eq(1);expect($inputTwo.val()).toEqual("Three");expect($inputTwo.attr("name")).toEqual("_value[1]");view.$(".djblets-c-list-edit-widget__remove-item").eq(1).click();expect($numRows.val()).toEqual("1");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(1);expect(view.$(".djblets-c-list-edit-widget__remove-item").length).toEqual(1);$inputOne=view.$(".djblets-c-list-edit-widget__input").eq(0);expect($inputOne.val()).toEqual("One");expect($inputOne.attr("name")).toEqual("_value[0]");view.$(".djblets-c-list-edit-widget__remove-item").click();expect($numRows.val()).toEqual("1");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(1);$inputOne=view.$(".djblets-c-list-edit-widget__input").eq(0);expect($inputOne.val()).toEqual("");expect($inputOne.attr("name")).toEqual("_value[0]")})});describe("Addition",function(){it("With values",function(){const[view,$numRows]=makeView([`<input type="text"
class="djblets-c-list-edit-widget__input"
name="_value[0]"
value="One" />`,`<input type="text"
class="djblets-c-list-edit-widget__input"
name="_value[1]"
value="Two" />`,`<input type="text"
class="djblets-c-list-edit-widget__input"
name="_value[2]"
value="Three" />`]);view.$(".djblets-c-list-edit-widget__add-item").click();expect($numRows.val()).toEqual("4");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(4);let $inputOne=view.$(".djblets-c-list-edit-widget__input").eq(0);expect($inputOne.val()).toEqual("One");expect($inputOne.attr("name")).toEqual("_value[0]");let $inputTwo=view.$(".djblets-c-list-edit-widget__input").eq(1);expect($inputTwo.val()).toEqual("Two");expect($inputTwo.attr("name")).toEqual("_value[1]");let $inputThree=view.$(".djblets-c-list-edit-widget__input").eq(2);expect($inputThree.val()).toEqual("Three");expect($inputThree.attr("name")).toEqual("_value[2]");let $inputFour=view.$(".djblets-c-list-edit-widget__input").eq(3);expect($inputFour.val()).toEqual("");expect($inputFour.attr("name")).toEqual("_value[3]")});it("With no values",function(){const[view,$numRows]=makeView([]);view.$(".djblets-c-list-edit-widget__add-item").click();expect($numRows.val()).toEqual("2");expect(view.$(".djblets-c-list-edit-widget__entry").length).toEqual(2);let $inputOne=view.$(".djblets-c-list-edit-widget__input").eq(0);expect($inputOne.val()).toEqual("");expect($inputOne.attr("name")).toEqual("_value[0]");let $inputTwo=view.$(".djblets-c-list-edit-widget__input").eq(1);expect($inputTwo.val()).toEqual("");expect($inputTwo.attr("name")).toEqual("_value[1]")})})});"use strict";suite("djblets/integrations/views/AddIntegrationPopupView",function(){describe("Rendering",function(){it("With integrations",function(){const view=new Djblets.AddIntegrationPopupView({integrations:[{addURL:"int1/add/",description:"Int1 Description",iconSrc:"data:test,int1",iconSrcSet:"data:test,int1 1x, data:test,int1@2x 2x",id:"int1",name:"Int1"},{addURL:"int2/add/",description:"Int2 Description",iconSrc:"data:test,int2",iconSrcSet:"data:test,int2 1x, data:test,int2@2x 2x",id:"int2",name:"Int2"}]});view.render();expect(view.$el.hasClass("-is-empty")).toBe(false);const $items=view.$el.find(".djblets-c-integration");expect($items.length).toBe(2);let $item=$items.eq(0);expect($item.children("a").attr("href")).toBe("int1/add/");expect($item.find(".djblets-c-integration__name").text()).toBe("Int1");expect($item.find(".djblets-c-integration__description").text().trim()).toBe("Int1 Description");let $icon=$item.find(".djblets-c-integration__icon");expect($icon.attr("src")).toBe("data:test,int1");expect($icon.attr("srcset")).toBe("data:test,int1 1x, data:test,int1@2x 2x");$item=$items.eq(1);expect($item.children("a").attr("href")).toBe("int2/add/");expect($item.find(".djblets-c-integration__name").text()).toBe("Int2");expect($item.find(".djblets-c-integration__description").text().trim()).toBe("Int2 Description");$icon=$item.find(".djblets-c-integration__icon");expect($icon.attr("src")).toBe("data:test,int2");expect($icon.attr("srcset")).toBe("data:test,int2 1x, data:test,int2@2x 2x")});it("Without integrations",function(){const view=new Djblets.AddIntegrationPopupView({integrations:[]});view.render();expect(view.$el.hasClass("-is-empty")).toBe(true);const $empty=view.$(".djblets-c-integrations-popup__empty");expect($empty.length).toBe(1);expect($empty.text().trim()).toBe("There are no integrations currently installed.")})})});"use strict";suite("djblets/integrations/views/IntegrationConfigListView",function(){const template=_.template(`<div class="djblets-c-integration-configs">
 <div class="djblets-l-config-forms-container">
  <table class="djblets-c-config-forms-list"></table>
 </div>
</div>`);let collection;let view;beforeEach(function(){const $el=$(template()).appendTo($testsScratch);view=new Djblets.IntegrationConfigListView({el:$el,configs:[{editURL:"configs/1/",enabled:true,id:1,integrationID:"int1",name:"Config 1"},{editURL:"configs/2/",enabled:true,id:2,integrationID:"int2",name:"Config 2"},{editURL:"configs/3/",enabled:false,id:3,integrationID:"int3",name:"Config 3"},{editURL:"configs/4/",enabled:true,id:4,integrationID:"int1",name:"Config 4"}],integrationIDs:["int1","int2","int3"],integrationsMap:{int1:{addURL:"int1/add/",description:"Int1 Description",iconSrc:"data:test,int1",iconSrcSet:"data:test,int1 1x, data:test,int1@2x 2x",id:"int1",name:"Int1"},int2:{addURL:"int2/add/",description:"Int2 Description",iconSrc:"data:test,int2",iconSrcSet:"data:test,int2 1x, data:test,int2@2x 2x",id:"int2",name:"Int2"},int3:{addURL:"int3/add/",description:"Int3 Description",iconSrc:"data:test,int3",iconSrcSet:"data:test,int3 1x, data:test,int3@2x 2x",id:"int3",name:"Int3"}}});view.render();collection=view.list.collection});describe("Configurations",function(){let $row1;let $row2;let $row3;let $row4;beforeEach(function(){const $rows=view.listView.$("tr");expect($rows.length).toBe(4);$row1=$rows.eq(0);$row2=$rows.eq(1);$row3=$rows.eq(2);$row4=$rows.eq(3)});describe("Rendering",function(){it("Icon",function(){const $icon1=$row1.find(".djblets-c-integration-config__name img");const $icon2=$row2.find(".djblets-c-integration-config__name img");const $icon3=$row3.find(".djblets-c-integration-config__name img");const $icon4=$row4.find(".djblets-c-integration-config__name img");expect($icon1.attr("src")).toBe("data:test,int1");expect($icon2.attr("src")).toBe("data:test,int2");expect($icon3.attr("src")).toBe("data:test,int3");expect($icon4.attr("src")).toBe("data:test,int1");expect($icon1.attr("srcset")).toBe("data:test,int1 1x, data:test,int1@2x 2x");expect($icon2.attr("srcset")).toBe("data:test,int2 1x, data:test,int2@2x 2x");expect($icon3.attr("srcset")).toBe("data:test,int3 1x, data:test,int3@2x 2x");expect($icon4.attr("srcset")).toBe("data:test,int1 1x, data:test,int1@2x 2x")});it("Name",function(){const $name1=$row1.find(".djblets-c-integration-config__name a");const $name2=$row2.find(".djblets-c-integration-config__name a");const $name3=$row3.find(".djblets-c-integration-config__name a");const $name4=$row4.find(".djblets-c-integration-config__name a");expect($name1.text()).toBe("Config 1");expect($name2.text()).toBe("Config 2");expect($name3.text()).toBe("Config 3");expect($name4.text()).toBe("Config 4");expect($name1.attr("href")).toBe("configs/1/");expect($name2.attr("href")).toBe("configs/2/");expect($name3.attr("href")).toBe("configs/3/");expect($name4.attr("href")).toBe("configs/4/")});it("Integration name",function(){const $intName1=$row1.find(".djblets-c-integration-config__integration-name");const $intName2=$row2.find(".djblets-c-integration-config__integration-name");const $intName3=$row3.find(".djblets-c-integration-config__integration-name");const $intName4=$row4.find(".djblets-c-integration-config__integration-name");expect($intName1.text().trim()).toBe("Int1");expect($intName2.text().trim()).toBe("Int2");expect($intName3.text().trim()).toBe("Int3");expect($intName4.text().trim()).toBe("Int1")});it("Status",function(){expect($row1.hasClass("-is-enabled")).toBe(true);expect($row2.hasClass("-is-enabled")).toBe(true);expect($row3.hasClass("-is-enabled")).toBe(false);expect($row4.hasClass("-is-enabled")).toBe(true);expect($row1.hasClass("-is-disabled")).toBe(false);expect($row2.hasClass("-is-disabled")).toBe(false);expect($row3.hasClass("-is-disabled")).toBe(true);expect($row4.hasClass("-is-disabled")).toBe(false);expect($row1.find(".djblets-c-config-forms-list__item-state").text()).toBe("Enabled");expect($row2.find(".djblets-c-config-forms-list__item-state").text()).toBe("Enabled");expect($row3.find(".djblets-c-config-forms-list__item-state").text()).toBe("Disabled");expect($row4.find(".djblets-c-config-forms-list__item-state").text()).toBe("Enabled")})});describe("Actions",function(){it("Delete",function(){const config=collection.at(0);spyOn(config,"destroy").and.callThrough();spyOn(config,"sync");spyOn($.fn,"modalBox").and.callFake(options=>options.buttons[1].click());$row1.find(".config-forms-list-action-delete").click();expect($.fn.modalBox).toHaveBeenCalled();expect(config.destroy).toHaveBeenCalled();expect(collection.length).toBe(3);expect(view.listView.$("tr").length).toBe(3)})})})});"use strict";suite("djblets/utils/urls",function(){describe("buildURL",function(){it("With just baseURL",function(){const url=Djblets.buildURL({baseURL:"https://example.com/abc123/"});expect(url).toBe("https://example.com/abc123/")});describe("With anchor",function(){it('With leading "#"',function(){const url=Djblets.buildURL({baseURL:"https://example.com/abc123/",anchor:"#my-anchor"});expect(url).toBe("https://example.com/abc123/#my-anchor")});it('Without leading "#"',function(){const url=Djblets.buildURL({baseURL:"https://example.com/abc123/",anchor:"my-anchor"});expect(url).toBe("https://example.com/abc123/#my-anchor")})});describe("With queryData",function(){describe("As string",function(){it('With leading "?"',function(){const url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:"?a=b&c=d"});expect(url).toBe("https://example.com/abc123/?a=b&c=d")});it('Without leading "?"',function(){const url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:"a=b&c=d"});expect(url).toBe("https://example.com/abc123/?a=b&c=d")});it("Empty",function(){const url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:""});expect(url).toBe("https://example.com/abc123/")})});describe("As object",function(){it("With value",function(){const url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:{a:"b"}});expect(url).toBe("https://example.com/abc123/?a=b")});it("Empty",function(){const url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:{}});expect(url).toBe("https://example.com/abc123/")})});describe("As array",function(){it("With value",function(){const url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:[{name:"a",value:"b"},{name:"c",value:"d"}]});expect(url).toBe("https://example.com/abc123/?a=b&c=d")});it("Empty",function(){const url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:[]});expect(url).toBe("https://example.com/abc123/")})})});it("With all options",function(){const url=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:"a=b&c=d",anchor:"my-anchor"});expect(url).toBe("https://example.com/abc123/?a=b&c=d#my-anchor")})});describe("parseQueryString",function(){it("Empty query string",function(){expect(Djblets.parseQueryString("")).toEqual({})});it("Basic query strings",function(){expect(Djblets.parseQueryString("?a=b&c=d&e=f")).toEqual({a:"b",c:"d",e:"f"})});it("Keys without values",function(){expect(Djblets.parseQueryString("?abc=def&ghi")).toEqual({abc:"def",ghi:null})});describe("Multiple values for keys",function(){it("With allowMultiValue=true",function(){const queryString=Djblets.parseQueryString("?a=1&a=2&a=3&b=4",{allowMultiValue:true});expect(queryString).toEqual({a:["1","2","3"],b:"4"})});it("Without allowMultiValue=true",function(){expect(Djblets.parseQueryString("?a=1&a=2&a=3&b=4")).toEqual({a:"3",b:"4"})})})})})}).call(this);
