(function(){window.Djblets=window.Djblets||{};Djblets.Config={};"use strict";Djblets.Config.ListItems=Backbone.Collection.extend({initialize(models,options){this.options=options},fetch(options){this.trigger("fetching");Backbone.Collection.prototype.fetch.call(this,options)}});"use strict";Djblets.Config.ListItem=Backbone.Model.extend({defaults:{text:null,editURL:null,showRemove:false,canRemove:true,loading:false,removeLabel:gettext("Remove"),itemState:null},itemStateTexts:{disabled:gettext("Disabled"),enabled:gettext("Enabled"),error:gettext("Error")},initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};this.actions=options.actions||[];if(this.get("showRemove")){this.actions.push({id:"delete",label:this.get("removeLabel"),danger:true,enabled:this.get("canRemove")})}},setActions(actions){this.actions=actions;this.trigger("actionsChanged")}});Djblets.Config.List=Backbone.Model.extend();"use strict";Djblets.Config.ListItemView=Backbone.View.extend({tagName:"li",className:"djblets-c-config-forms-list__item",iconBaseClassName:"djblets-icon",itemStateClasses:{disabled:"-is-disabled",enabled:"-is-enabled",error:"-has-error"},actionHandlers:{},template:_.template(`<% if (editURL) { %>
<a href="<%- editURL %>"><%- text %></a>
<% } else { %>
<%- text %>
<% } %>`),initialize(){this.listenTo(this.model,"actionsChanged",this.render);this.listenTo(this.model,"request",this.showSpinner);this.listenTo(this.model,"sync",this.hideSpinner);this.listenTo(this.model,"destroy",this.remove);this.$spinnerParent=null;this.$spinner=null},render(){const model=this.model;this.$el.empty().append(this.template(_.defaults(model.attributes,this.getRenderContext())));this._$itemState=this.$(".djblets-c-config-forms-list__item-state");this.listenTo(model,"change:itemState",this._onItemStateChanged);this._onItemStateChanged();this.addActions(this.getActionsParent());return this},getRenderContext(){return{}},remove(){this.$el.fadeOut("normal",()=>Backbone.View.prototype.remove.call(this))},getActionsParent(){return this.$el},showSpinner(){if(this.$spinner){return}this.$el.attr("aria-busy","true");this.$spinner=$("<span>").addClass("djblets-o-spinner").attr("aria-hidden","true").prependTo(this.$spinnerParent).hide().css("visibility","visible").fadeIn()},hideSpinner(){if(!this.$spinner){return}this.$spinner.fadeOut("slow",()=>{this.$spinner.remove();this.$spinner=null});this.$el.removeAttr("aria-busy")},addActions($parentEl){const $actions=$("<span>").addClass("djblets-c-config-forms-list__item-actions");this.model.actions.forEach(action=>{const $action=this._buildActionEl(action).appendTo($actions);if(action.children){if(action.label){$action.append(" &#9662;")}$action.click(()=>_.defer(()=>this._showActionDropdown(action,$action)))}});this.$spinnerParent=$actions;$actions.prependTo($parentEl)},_showActionDropdown(action,$action){const actionPos=$action.position();const $menu=$("<div/>").css({minWidth:$action.outerWidth(),position:"absolute"}).addClass("djblets-c-config-forms-popup-menu").click(e=>e.stopPropagation());const $items=$("<ul/>").addClass("djblets-c-config-forms-popup-menu__items").appendTo($menu);const actionLeft=actionPos.left+$action.getExtents("m","l");action.children.forEach(childAction=>$("<li/>").addClass("djblets-c-config-forms-popup-menu__item "+`config-forms-list-action-row-${childAction.id}`).append(this._buildActionEl(childAction)).appendTo($items));this.trigger("actionMenuPopUp",{action:action,$action:$action,$menu:$menu});$menu.appendTo($action.parent());const winWidth=$(window).width();const paneWidth=$menu.width();$menu.move($action.offset().left+paneWidth>winWidth?actionLeft+$action.innerWidth()-paneWidth:actionLeft,actionPos.top+$action.outerHeight(),"absolute");$(document).one("click",()=>{this.trigger("actionMenuPopDown",{action:action,$action:$action,$menu:$menu});$menu.remove()})},_buildActionEl(action){const enabled=action.enabled!==false;const actionHandlerName=enabled?this.actionHandlers[action.id]:null;const isCheckbox=action.type==="checkbox";const isRadio=action.type==="radio";let $action;let $result;if(isCheckbox||isRadio){const inputID=_.uniqueId("action_"+action.type);$action=$("<input/>").attr({name:action.name,type:action.type,id:inputID});const $label=$("<label>").attr("for",inputID).text(action.label);if(action.id){$label.addClass(`config-forms-list-action-label-${action.id}`)}$result=$("<span/>").append($action).append($label);if(action.propName){if(isCheckbox){$action.bindProperty("checked",this.model,action.propName)}else if(isRadio){$action.bindProperty("checked",this.model,action.propName,{radioValue:action.radioValue})}}if(action.enabledPropName){$action.bindProperty("disabled",this.model,action.enabledPropName,{inverse:action.enabledPropInverse!==true})}if(actionHandlerName){const actionHandler=_.debounce(_.bind(this[actionHandlerName],this),50,true);$action.change(actionHandler);if(isRadio&&action.dispatchOnClick){$action.click(actionHandler)}}}else{if(action.url){$action=$('<a class="btn" role="button">').attr("href",action.url)}else{$action=$('<button type="button">')}$result=$action;if(action.label){$action.text(action.label)}if(action.ariaLabel){$action.attr("aria-label",action.ariaLabel)}if(action.iconName){$action.prepend($("<span>").addClass(this.iconBaseClassName).addClass(`${this.iconBaseClassName}-${action.iconName}`))}if(actionHandlerName){$action.click(evt=>{evt.preventDefault();evt.stopPropagation();this._onActionButtonClicked(evt,actionHandlerName,$action)})}}$action.addClass("djblets-c-config-forms-list__item-action");if(action.id){$action.addClass(`config-forms-list-action-${action.id}`)}if(action.danger){$action.addClass("-is-danger")}if(action.primary){$action.addClass("-is-primary")}if(!enabled){$action.prop("disabled",true)}return $result},_onItemStateChanged(){const model=this.model;const oldItemState=model.previous("itemState");const itemState=model.get("itemState");if(oldItemState){this.$el.removeClass(this.itemStateClasses[oldItemState])}if(itemState){this.$el.addClass(this.itemStateClasses[itemState]);this._$itemState.text(model.itemStateTexts[itemState])}},_onActionButtonClicked(evt,actionHandlerName,$action){const promise=this[actionHandlerName].call(this,evt);if(promise&&typeof promise.then==="function"){$action.prop("disabled",true);const childrenHTML=$action.html();$action.empty();const $spinner=$('<span class="djblets-o-spinner">').appendTo($action);promise.finally(()=>{$spinner.remove();$action.html(childrenHTML);$action.prop("disabled",false)})}}});"use strict";Djblets.Config.ListView=Backbone.View.extend({tagName:"ul",className:"djblets-c-config-forms-list",defaultItemView:Djblets.Config.ListItemView,initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const collection=this.model.collection;this.ItemView=options.ItemView||this.defaultItemView;this.views=[];this.animateItems=!!options.animateItems;this.once("rendered",()=>{this.listenTo(collection,"add",this._addItem);this.listenTo(collection,"remove",this._removeItem);this.listenTo(collection,"reset",this._renderItems)})},getBody(){return this.$el},render(){this.$listBody=this.getBody();this._renderItems();this.trigger("rendered");return this},_addItem(item,collection){let options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};const animateItem=options.animate!==false;const view=new this.ItemView({model:item});view.render();if(this.animateItems&&animateItem){view.$el.fadeIn()}this.$listBody.append(view.$el);this.views.push(view)},_removeItem(item,collection){let options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};const animateItem=options.animate!==false;const view=_.find(this.views,view=>view.model===item);if(view){this.views=_.without(this.views,view);if(this.animateItems&&animateItem){view.$el.fadeOut(function(){view.remove()})}else{view.remove()}}},_renderItems(){this.views.forEach(function(view){view.remove()});this.views=[];this.$listBody.empty();this.model.collection.each(item=>{this._addItem(item,item.collection,{animate:false})})}});"use strict";Djblets.Config.PagesView=Backbone.View.extend({initialize(){this.router=new Backbone.Router({routes:{":pageID":"page"}});this.listenTo(this.router,"route:page",this._onPageChanged);this._$activeNav=null;this._$activePage=null;this._preserveMessages=true},render(){this._$pageNavs=this.$(".djblets-c-config-forms-page-nav__item");this._$pages=this.$(".djblets-c-config-forms-subpage");this._$activeNav=this._$pageNavs.eq(0).addClass("-is-active");this._$activePage=this._$pages.eq(0).addClass("-is-active");Backbone.history.start({root:window.location.pathname});return this},_onPageChanged(pageID){this._$activeNav.removeClass("-is-active");this._$activePage.removeClass("-is-active");this._$activePage=$(`#page_${pageID}`);if(this._$activePage.length===0){this.router.navigate(this._$pageNavs.find("a").attr("href").substr(1),{trigger:true,replace:true})}else{this._$activeNav=this._$pageNavs.filter(`:has(a[href="#${pageID}"])`).addClass("-is-active");this._$activePage.addClass("-is-active");if(!this._preserveMessages){$("#messages").remove()}this._preserveMessages=false}}});"use strict";Djblets.Config.TableItemView=Djblets.Config.ListItemView.extend({tagName:"tr",template:_.template(`<td>
<% if (editURL) { %>
<a href="<%- editURL %>"><%- text %></a>
<% } else { %>
<%- text %>
<% } %>
</td>`),getActionsParent(){return this.$("td:last")}});"use strict";Djblets.Config.TableView=Djblets.Config.ListView.extend({tagName:"table",defaultItemView:Djblets.Config.TableItemView,render(){const $body=this.getBody();if($body.length===0){this.$el.append("<tbody>")}return Djblets.Config.ListView.prototype.render.call(this)},getBody(){return this.$("tbody")}})}).call(this);
