# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetCaPoolResult',
    'AwaitableGetCaPoolResult',
    'get_ca_pool',
    'get_ca_pool_output',
]

@pulumi.output_type
class GetCaPoolResult:
    def __init__(__self__, issuance_policy=None, labels=None, name=None, publishing_options=None, tier=None):
        if issuance_policy and not isinstance(issuance_policy, dict):
            raise TypeError("Expected argument 'issuance_policy' to be a dict")
        pulumi.set(__self__, "issuance_policy", issuance_policy)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if publishing_options and not isinstance(publishing_options, dict):
            raise TypeError("Expected argument 'publishing_options' to be a dict")
        pulumi.set(__self__, "publishing_options", publishing_options)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter(name="issuancePolicy")
    def issuance_policy(self) -> 'outputs.IssuancePolicyResponse':
        """
        Optional. The IssuancePolicy to control how Certificates will be issued from this CaPool.
        """
        return pulumi.get(self, "issuance_policy")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. Labels with user-defined metadata.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name for this CaPool in the format `projects/*/locations/*/caPools/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publishingOptions")
    def publishing_options(self) -> 'outputs.PublishingOptionsResponse':
        """
        Optional. The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.
        """
        return pulumi.get(self, "publishing_options")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        Immutable. The Tier of this CaPool.
        """
        return pulumi.get(self, "tier")


class AwaitableGetCaPoolResult(GetCaPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCaPoolResult(
            issuance_policy=self.issuance_policy,
            labels=self.labels,
            name=self.name,
            publishing_options=self.publishing_options,
            tier=self.tier)


def get_ca_pool(ca_pool_id: Optional[str] = None,
                location: Optional[str] = None,
                project: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCaPoolResult:
    """
    Returns a CaPool.
    """
    __args__ = dict()
    __args__['caPoolId'] = ca_pool_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:privateca/v1:getCaPool', __args__, opts=opts, typ=GetCaPoolResult).value

    return AwaitableGetCaPoolResult(
        issuance_policy=__ret__.issuance_policy,
        labels=__ret__.labels,
        name=__ret__.name,
        publishing_options=__ret__.publishing_options,
        tier=__ret__.tier)


@_utilities.lift_output_func(get_ca_pool)
def get_ca_pool_output(ca_pool_id: Optional[pulumi.Input[str]] = None,
                       location: Optional[pulumi.Input[str]] = None,
                       project: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCaPoolResult]:
    """
    Returns a CaPool.
    """
    ...
