# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetJobResult',
    'AwaitableGetJobResult',
    'get_job',
    'get_job_output',
]

@pulumi.output_type
class GetJobResult:
    def __init__(__self__, addresses=None, application_info=None, company=None, company_display_name=None, compensation_info=None, custom_attributes=None, degree_types=None, department=None, derived_info=None, description=None, employment_types=None, incentives=None, job_benefits=None, job_end_time=None, job_level=None, job_start_time=None, language_code=None, name=None, posting_create_time=None, posting_expire_time=None, posting_publish_time=None, posting_region=None, posting_update_time=None, processing_options=None, promotion_value=None, qualifications=None, requisition_id=None, responsibilities=None, title=None, visibility=None):
        if addresses and not isinstance(addresses, list):
            raise TypeError("Expected argument 'addresses' to be a list")
        pulumi.set(__self__, "addresses", addresses)
        if application_info and not isinstance(application_info, dict):
            raise TypeError("Expected argument 'application_info' to be a dict")
        pulumi.set(__self__, "application_info", application_info)
        if company and not isinstance(company, str):
            raise TypeError("Expected argument 'company' to be a str")
        pulumi.set(__self__, "company", company)
        if company_display_name and not isinstance(company_display_name, str):
            raise TypeError("Expected argument 'company_display_name' to be a str")
        pulumi.set(__self__, "company_display_name", company_display_name)
        if compensation_info and not isinstance(compensation_info, dict):
            raise TypeError("Expected argument 'compensation_info' to be a dict")
        pulumi.set(__self__, "compensation_info", compensation_info)
        if custom_attributes and not isinstance(custom_attributes, dict):
            raise TypeError("Expected argument 'custom_attributes' to be a dict")
        pulumi.set(__self__, "custom_attributes", custom_attributes)
        if degree_types and not isinstance(degree_types, list):
            raise TypeError("Expected argument 'degree_types' to be a list")
        pulumi.set(__self__, "degree_types", degree_types)
        if department and not isinstance(department, str):
            raise TypeError("Expected argument 'department' to be a str")
        pulumi.set(__self__, "department", department)
        if derived_info and not isinstance(derived_info, dict):
            raise TypeError("Expected argument 'derived_info' to be a dict")
        pulumi.set(__self__, "derived_info", derived_info)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if employment_types and not isinstance(employment_types, list):
            raise TypeError("Expected argument 'employment_types' to be a list")
        pulumi.set(__self__, "employment_types", employment_types)
        if incentives and not isinstance(incentives, str):
            raise TypeError("Expected argument 'incentives' to be a str")
        pulumi.set(__self__, "incentives", incentives)
        if job_benefits and not isinstance(job_benefits, list):
            raise TypeError("Expected argument 'job_benefits' to be a list")
        pulumi.set(__self__, "job_benefits", job_benefits)
        if job_end_time and not isinstance(job_end_time, str):
            raise TypeError("Expected argument 'job_end_time' to be a str")
        pulumi.set(__self__, "job_end_time", job_end_time)
        if job_level and not isinstance(job_level, str):
            raise TypeError("Expected argument 'job_level' to be a str")
        pulumi.set(__self__, "job_level", job_level)
        if job_start_time and not isinstance(job_start_time, str):
            raise TypeError("Expected argument 'job_start_time' to be a str")
        pulumi.set(__self__, "job_start_time", job_start_time)
        if language_code and not isinstance(language_code, str):
            raise TypeError("Expected argument 'language_code' to be a str")
        pulumi.set(__self__, "language_code", language_code)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if posting_create_time and not isinstance(posting_create_time, str):
            raise TypeError("Expected argument 'posting_create_time' to be a str")
        pulumi.set(__self__, "posting_create_time", posting_create_time)
        if posting_expire_time and not isinstance(posting_expire_time, str):
            raise TypeError("Expected argument 'posting_expire_time' to be a str")
        pulumi.set(__self__, "posting_expire_time", posting_expire_time)
        if posting_publish_time and not isinstance(posting_publish_time, str):
            raise TypeError("Expected argument 'posting_publish_time' to be a str")
        pulumi.set(__self__, "posting_publish_time", posting_publish_time)
        if posting_region and not isinstance(posting_region, str):
            raise TypeError("Expected argument 'posting_region' to be a str")
        pulumi.set(__self__, "posting_region", posting_region)
        if posting_update_time and not isinstance(posting_update_time, str):
            raise TypeError("Expected argument 'posting_update_time' to be a str")
        pulumi.set(__self__, "posting_update_time", posting_update_time)
        if processing_options and not isinstance(processing_options, dict):
            raise TypeError("Expected argument 'processing_options' to be a dict")
        pulumi.set(__self__, "processing_options", processing_options)
        if promotion_value and not isinstance(promotion_value, int):
            raise TypeError("Expected argument 'promotion_value' to be a int")
        pulumi.set(__self__, "promotion_value", promotion_value)
        if qualifications and not isinstance(qualifications, str):
            raise TypeError("Expected argument 'qualifications' to be a str")
        pulumi.set(__self__, "qualifications", qualifications)
        if requisition_id and not isinstance(requisition_id, str):
            raise TypeError("Expected argument 'requisition_id' to be a str")
        pulumi.set(__self__, "requisition_id", requisition_id)
        if responsibilities and not isinstance(responsibilities, str):
            raise TypeError("Expected argument 'responsibilities' to be a str")
        pulumi.set(__self__, "responsibilities", responsibilities)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)
        if visibility and not isinstance(visibility, str):
            raise TypeError("Expected argument 'visibility' to be a str")
        if visibility is not None:
            warnings.warn("""Deprecated. The job is only visible to the owner. The visibility of the job. Defaults to Visibility.ACCOUNT_ONLY if not specified.""", DeprecationWarning)
            pulumi.log.warn("""visibility is deprecated: Deprecated. The job is only visible to the owner. The visibility of the job. Defaults to Visibility.ACCOUNT_ONLY if not specified.""")

        pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence[str]:
        """
        Strongly recommended for the best service experience. Location(s) where the employer is looking to hire for this job posting. Specifying the full street address(es) of the hiring location enables better API results, especially job searches by commute time. At most 50 locations are allowed for best search performance. If a job has more locations, it is suggested to split it into multiple jobs with unique requisition_ids (e.g. 'ReqA' becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same company, language_code and requisition_id are not allowed. If the original requisition_id must be preserved, a custom field should be used for storage. It is also suggested to group the locations that close to each other in the same job for better search experience. Jobs with multiple addresses must have their addresses with the same LocationType to allow location filtering to work properly. (For example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View, CA, USA" and "London, UK" may not have location filters applied correctly at search time since the first is a LocationType.STREET_ADDRESS and the second is a LocationType.LOCALITY.) If a job needs to have multiple addresses, it is suggested to split it into multiple jobs with same LocationTypes. The maximum number of allowed characters is 500.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="applicationInfo")
    def application_info(self) -> 'outputs.ApplicationInfoResponse':
        """
        Job application information.
        """
        return pulumi.get(self, "application_info")

    @property
    @pulumi.getter
    def company(self) -> str:
        """
        The resource name of the company listing the job. The format is "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For example, "projects/foo/tenants/bar/companies/baz".
        """
        return pulumi.get(self, "company")

    @property
    @pulumi.getter(name="companyDisplayName")
    def company_display_name(self) -> str:
        """
        Display name of the company listing the job.
        """
        return pulumi.get(self, "company_display_name")

    @property
    @pulumi.getter(name="compensationInfo")
    def compensation_info(self) -> 'outputs.CompensationInfoResponse':
        """
        Job compensation information (a.k.a. "pay rate") i.e., the compensation that will paid to the employee.
        """
        return pulumi.get(self, "compensation_info")

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Mapping[str, str]:
        """
        A map of fields to hold both filterable and non-filterable custom job attributes that are not covered by the provided structured fields. The keys of the map are strings up to 64 bytes and must match the pattern: `a-zA-Z*`. For example, key0LikeThis or KEY_1_LIKE_THIS. At most 100 filterable and at most 100 unfilterable keys are supported. For filterable `string_values`, across all keys at most 200 values are allowed, with each string no more than 255 characters. For unfilterable `string_values`, the maximum total size of `string_values` across all keys is 50KB.
        """
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="degreeTypes")
    def degree_types(self) -> Sequence[str]:
        """
        The desired education degrees for the job, such as Bachelors, Masters.
        """
        return pulumi.get(self, "degree_types")

    @property
    @pulumi.getter
    def department(self) -> str:
        """
        The department or functional area within the company with the open position. The maximum number of allowed characters is 255.
        """
        return pulumi.get(self, "department")

    @property
    @pulumi.getter(name="derivedInfo")
    def derived_info(self) -> 'outputs.JobDerivedInfoResponse':
        """
        Derived details about the job posting.
        """
        return pulumi.get(self, "derived_info")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the job, which typically includes a multi-paragraph description of the company and related information. Separate fields are provided on the job object for responsibilities, qualifications, and other job characteristics. Use of these separate job fields is recommended. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 100,000.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="employmentTypes")
    def employment_types(self) -> Sequence[str]:
        """
        The employment type(s) of a job, for example, full time or part time.
        """
        return pulumi.get(self, "employment_types")

    @property
    @pulumi.getter
    def incentives(self) -> str:
        """
        A description of bonus, commission, and other compensation incentives associated with the job not including salary or pay. The maximum number of allowed characters is 10,000.
        """
        return pulumi.get(self, "incentives")

    @property
    @pulumi.getter(name="jobBenefits")
    def job_benefits(self) -> Sequence[str]:
        """
        The benefits included with the job.
        """
        return pulumi.get(self, "job_benefits")

    @property
    @pulumi.getter(name="jobEndTime")
    def job_end_time(self) -> str:
        """
        The end timestamp of the job. Typically this field is used for contracting engagements. Invalid timestamps are ignored.
        """
        return pulumi.get(self, "job_end_time")

    @property
    @pulumi.getter(name="jobLevel")
    def job_level(self) -> str:
        """
        The experience level associated with the job, such as "Entry Level".
        """
        return pulumi.get(self, "job_level")

    @property
    @pulumi.getter(name="jobStartTime")
    def job_start_time(self) -> str:
        """
        The start timestamp of the job in UTC time zone. Typically this field is used for contracting engagements. Invalid timestamps are ignored.
        """
        return pulumi.get(self, "job_start_time")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        The language of the posting. This field is distinct from any requirements for fluency that are associated with the job. Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn". For more information, see [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){: class="external" target="_blank" }. If this field is unspecified and Job.description is present, detected language code based on Job.description is assigned, otherwise defaults to 'en_US'.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required during job update. The resource name for the job. This is generated by the service when a job is created. The format is "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For example, "projects/foo/tenants/bar/jobs/baz". Use of this field in job queries and API calls is preferred over the use of requisition_id since this value is unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="postingCreateTime")
    def posting_create_time(self) -> str:
        """
        The timestamp when this job posting was created.
        """
        return pulumi.get(self, "posting_create_time")

    @property
    @pulumi.getter(name="postingExpireTime")
    def posting_expire_time(self) -> str:
        """
        Strongly recommended for the best service experience. The expiration timestamp of the job. After this timestamp, the job is marked as expired, and it no longer appears in search results. The expired job can't be listed by the ListJobs API, but it can be retrieved with the GetJob API or updated with the UpdateJob API or deleted with the DeleteJob API. An expired job can be updated and opened again by using a future expiration timestamp. Updating an expired job fails if there is another existing open job with same company, language_code and requisition_id. The expired jobs are retained in our system for 90 days. However, the overall expired job count cannot exceed 3 times the maximum number of open jobs over previous 7 days. If this threshold is exceeded, expired jobs are cleaned out in order of earliest expire time. Expired jobs are no longer accessible after they are cleaned out. Invalid timestamps are ignored, and treated as expire time not provided. If the timestamp is before the instant request is made, the job is treated as expired immediately on creation. This kind of job can not be updated. And when creating a job with past timestamp, the posting_publish_time must be set before posting_expire_time. The purpose of this feature is to allow other objects, such as Application, to refer a job that didn't exist in the system prior to becoming expired. If you want to modify a job that was expired on creation, delete it and create a new one. If this value isn't provided at the time of job creation or is invalid, the job posting expires after 30 days from the job's creation time. For example, if the job was created on 2017/01/01 13:00AM UTC with an unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC. If this value isn't provided on job update, it depends on the field masks set by UpdateJobRequest.update_mask. If the field masks include job_end_time, or the masks are empty meaning that every field is updated, the job posting expires after 30 days from the job's last update time. Otherwise the expiration date isn't updated.
        """
        return pulumi.get(self, "posting_expire_time")

    @property
    @pulumi.getter(name="postingPublishTime")
    def posting_publish_time(self) -> str:
        """
        The timestamp this job posting was most recently published. The default value is the time the request arrives at the server. Invalid timestamps are ignored.
        """
        return pulumi.get(self, "posting_publish_time")

    @property
    @pulumi.getter(name="postingRegion")
    def posting_region(self) -> str:
        """
        The job PostingRegion (for example, state, country) throughout which the job is available. If this field is set, a LocationFilter in a search query within the job region finds this job posting if an exact location match isn't specified. If this field is set to PostingRegion.NATION or PostingRegion.ADMINISTRATIVE_AREA, setting job Job.addresses to the same location level as this field is strongly recommended.
        """
        return pulumi.get(self, "posting_region")

    @property
    @pulumi.getter(name="postingUpdateTime")
    def posting_update_time(self) -> str:
        """
        The timestamp when this job posting was last updated.
        """
        return pulumi.get(self, "posting_update_time")

    @property
    @pulumi.getter(name="processingOptions")
    def processing_options(self) -> 'outputs.ProcessingOptionsResponse':
        """
        Options for job processing.
        """
        return pulumi.get(self, "processing_options")

    @property
    @pulumi.getter(name="promotionValue")
    def promotion_value(self) -> int:
        """
        A promotion value of the job, as determined by the client. The value determines the sort order of the jobs returned when searching for jobs using the featured jobs search call, with higher promotional values being returned first and ties being resolved by relevance sort. Only the jobs with a promotionValue >0 are returned in a FEATURED_JOB_SEARCH. Default value is 0, and negative values are treated as 0.
        """
        return pulumi.get(self, "promotion_value")

    @property
    @pulumi.getter
    def qualifications(self) -> str:
        """
        A description of the qualifications required to perform the job. The use of this field is recommended as an alternative to using the more general description field. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 10,000.
        """
        return pulumi.get(self, "qualifications")

    @property
    @pulumi.getter(name="requisitionId")
    def requisition_id(self) -> str:
        """
        The requisition ID, also referred to as the posting ID, is assigned by the client to identify a job. This field is intended to be used by clients for client identification and tracking of postings. A job isn't allowed to be created if there is another job with the same company, language_code and requisition_id. The maximum number of allowed characters is 255.
        """
        return pulumi.get(self, "requisition_id")

    @property
    @pulumi.getter
    def responsibilities(self) -> str:
        """
        A description of job responsibilities. The use of this field is recommended as an alternative to using the more general description field. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 10,000.
        """
        return pulumi.get(self, "responsibilities")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        The title of the job, such as "Software Engineer" The maximum number of allowed characters is 500.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def visibility(self) -> str:
        """
        Deprecated. The job is only visible to the owner. The visibility of the job. Defaults to Visibility.ACCOUNT_ONLY if not specified.
        """
        return pulumi.get(self, "visibility")


class AwaitableGetJobResult(GetJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobResult(
            addresses=self.addresses,
            application_info=self.application_info,
            company=self.company,
            company_display_name=self.company_display_name,
            compensation_info=self.compensation_info,
            custom_attributes=self.custom_attributes,
            degree_types=self.degree_types,
            department=self.department,
            derived_info=self.derived_info,
            description=self.description,
            employment_types=self.employment_types,
            incentives=self.incentives,
            job_benefits=self.job_benefits,
            job_end_time=self.job_end_time,
            job_level=self.job_level,
            job_start_time=self.job_start_time,
            language_code=self.language_code,
            name=self.name,
            posting_create_time=self.posting_create_time,
            posting_expire_time=self.posting_expire_time,
            posting_publish_time=self.posting_publish_time,
            posting_region=self.posting_region,
            posting_update_time=self.posting_update_time,
            processing_options=self.processing_options,
            promotion_value=self.promotion_value,
            qualifications=self.qualifications,
            requisition_id=self.requisition_id,
            responsibilities=self.responsibilities,
            title=self.title,
            visibility=self.visibility)


def get_job(job_id: Optional[str] = None,
            project: Optional[str] = None,
            tenant_id: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobResult:
    """
    Retrieves the specified job, whose status is OPEN or recently EXPIRED within the last 90 days.
    """
    __args__ = dict()
    __args__['jobId'] = job_id
    __args__['project'] = project
    __args__['tenantId'] = tenant_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:jobs/v4:getJob', __args__, opts=opts, typ=GetJobResult).value

    return AwaitableGetJobResult(
        addresses=__ret__.addresses,
        application_info=__ret__.application_info,
        company=__ret__.company,
        company_display_name=__ret__.company_display_name,
        compensation_info=__ret__.compensation_info,
        custom_attributes=__ret__.custom_attributes,
        degree_types=__ret__.degree_types,
        department=__ret__.department,
        derived_info=__ret__.derived_info,
        description=__ret__.description,
        employment_types=__ret__.employment_types,
        incentives=__ret__.incentives,
        job_benefits=__ret__.job_benefits,
        job_end_time=__ret__.job_end_time,
        job_level=__ret__.job_level,
        job_start_time=__ret__.job_start_time,
        language_code=__ret__.language_code,
        name=__ret__.name,
        posting_create_time=__ret__.posting_create_time,
        posting_expire_time=__ret__.posting_expire_time,
        posting_publish_time=__ret__.posting_publish_time,
        posting_region=__ret__.posting_region,
        posting_update_time=__ret__.posting_update_time,
        processing_options=__ret__.processing_options,
        promotion_value=__ret__.promotion_value,
        qualifications=__ret__.qualifications,
        requisition_id=__ret__.requisition_id,
        responsibilities=__ret__.responsibilities,
        title=__ret__.title,
        visibility=__ret__.visibility)


@_utilities.lift_output_func(get_job)
def get_job_output(job_id: Optional[pulumi.Input[str]] = None,
                   project: Optional[pulumi.Input[Optional[str]]] = None,
                   tenant_id: Optional[pulumi.Input[str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetJobResult]:
    """
    Retrieves the specified job, whose status is OPEN or recently EXPIRED within the last 90 days.
    """
    ...
