# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetAnnotationResult',
    'AwaitableGetAnnotationResult',
    'get_annotation',
    'get_annotation_output',
]

@pulumi.output_type
class GetAnnotationResult:
    def __init__(__self__, annotation_source=None, custom_data=None, image_annotation=None, name=None, resource_annotation=None, text_annotation=None):
        if annotation_source and not isinstance(annotation_source, dict):
            raise TypeError("Expected argument 'annotation_source' to be a dict")
        pulumi.set(__self__, "annotation_source", annotation_source)
        if custom_data and not isinstance(custom_data, dict):
            raise TypeError("Expected argument 'custom_data' to be a dict")
        pulumi.set(__self__, "custom_data", custom_data)
        if image_annotation and not isinstance(image_annotation, dict):
            raise TypeError("Expected argument 'image_annotation' to be a dict")
        pulumi.set(__self__, "image_annotation", image_annotation)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_annotation and not isinstance(resource_annotation, dict):
            raise TypeError("Expected argument 'resource_annotation' to be a dict")
        pulumi.set(__self__, "resource_annotation", resource_annotation)
        if text_annotation and not isinstance(text_annotation, dict):
            raise TypeError("Expected argument 'text_annotation' to be a dict")
        pulumi.set(__self__, "text_annotation", text_annotation)

    @property
    @pulumi.getter(name="annotationSource")
    def annotation_source(self) -> 'outputs.AnnotationSourceResponse':
        """
        Details of the source.
        """
        return pulumi.get(self, "annotation_source")

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Mapping[str, str]:
        """
        Additional information for this annotation record, such as annotator and verifier information or study campaign.
        """
        return pulumi.get(self, "custom_data")

    @property
    @pulumi.getter(name="imageAnnotation")
    def image_annotation(self) -> 'outputs.ImageAnnotationResponse':
        """
        Annotations for images. For example, bounding polygons.
        """
        return pulumi.get(self, "image_annotation")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name of the Annotation, of the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotationStores/{annotation_store_id}/annotations/{annotation_id}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceAnnotation")
    def resource_annotation(self) -> 'outputs.ResourceAnnotationResponse':
        """
        Annotations for resource. For example, classification tags.
        """
        return pulumi.get(self, "resource_annotation")

    @property
    @pulumi.getter(name="textAnnotation")
    def text_annotation(self) -> 'outputs.SensitiveTextAnnotationResponse':
        """
        Annotations for sensitive texts. For example, a range that describes the location of sensitive text.
        """
        return pulumi.get(self, "text_annotation")


class AwaitableGetAnnotationResult(GetAnnotationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAnnotationResult(
            annotation_source=self.annotation_source,
            custom_data=self.custom_data,
            image_annotation=self.image_annotation,
            name=self.name,
            resource_annotation=self.resource_annotation,
            text_annotation=self.text_annotation)


def get_annotation(annotation_id: Optional[str] = None,
                   annotation_store_id: Optional[str] = None,
                   dataset_id: Optional[str] = None,
                   location: Optional[str] = None,
                   project: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAnnotationResult:
    """
    Gets an Annotation.
    """
    __args__ = dict()
    __args__['annotationId'] = annotation_id
    __args__['annotationStoreId'] = annotation_store_id
    __args__['datasetId'] = dataset_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:healthcare/v1beta1:getAnnotation', __args__, opts=opts, typ=GetAnnotationResult).value

    return AwaitableGetAnnotationResult(
        annotation_source=__ret__.annotation_source,
        custom_data=__ret__.custom_data,
        image_annotation=__ret__.image_annotation,
        name=__ret__.name,
        resource_annotation=__ret__.resource_annotation,
        text_annotation=__ret__.text_annotation)


@_utilities.lift_output_func(get_annotation)
def get_annotation_output(annotation_id: Optional[pulumi.Input[str]] = None,
                          annotation_store_id: Optional[pulumi.Input[str]] = None,
                          dataset_id: Optional[pulumi.Input[str]] = None,
                          location: Optional[pulumi.Input[str]] = None,
                          project: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAnnotationResult]:
    """
    Gets an Annotation.
    """
    ...
