# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettingsArgs',
    'GoogleCloudDialogflowCxV3AdvancedSettingsArgs',
    'GoogleCloudDialogflowCxV3AudioInputArgs',
    'GoogleCloudDialogflowCxV3ConversationTurnUserInputArgs',
    'GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutputArgs',
    'GoogleCloudDialogflowCxV3ConversationTurnArgs',
    'GoogleCloudDialogflowCxV3DtmfInputArgs',
    'GoogleCloudDialogflowCxV3EntityTypeEntityArgs',
    'GoogleCloudDialogflowCxV3EntityTypeExcludedPhraseArgs',
    'GoogleCloudDialogflowCxV3EnvironmentTestCasesConfigArgs',
    'GoogleCloudDialogflowCxV3EnvironmentVersionConfigArgs',
    'GoogleCloudDialogflowCxV3EventHandlerArgs',
    'GoogleCloudDialogflowCxV3EventInputArgs',
    'GoogleCloudDialogflowCxV3ExperimentDefinitionArgs',
    'GoogleCloudDialogflowCxV3ExperimentResultConfidenceIntervalArgs',
    'GoogleCloudDialogflowCxV3ExperimentResultMetricArgs',
    'GoogleCloudDialogflowCxV3ExperimentResultVersionMetricsArgs',
    'GoogleCloudDialogflowCxV3ExperimentResultArgs',
    'GoogleCloudDialogflowCxV3FormParameterFillBehaviorArgs',
    'GoogleCloudDialogflowCxV3FormParameterArgs',
    'GoogleCloudDialogflowCxV3FormArgs',
    'GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContentArgs',
    'GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseArgs',
    'GoogleCloudDialogflowCxV3FulfillmentConditionalCasesArgs',
    'GoogleCloudDialogflowCxV3FulfillmentSetParameterActionArgs',
    'GoogleCloudDialogflowCxV3FulfillmentArgs',
    'GoogleCloudDialogflowCxV3InputAudioConfigArgs',
    'GoogleCloudDialogflowCxV3IntentInputArgs',
    'GoogleCloudDialogflowCxV3IntentParameterArgs',
    'GoogleCloudDialogflowCxV3IntentTrainingPhrasePartArgs',
    'GoogleCloudDialogflowCxV3IntentTrainingPhraseArgs',
    'GoogleCloudDialogflowCxV3IntentArgs',
    'GoogleCloudDialogflowCxV3NluSettingsArgs',
    'GoogleCloudDialogflowCxV3PageArgs',
    'GoogleCloudDialogflowCxV3QueryInputArgs',
    'GoogleCloudDialogflowCxV3ResponseMessageConversationSuccessArgs',
    'GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoffArgs',
    'GoogleCloudDialogflowCxV3ResponseMessageOutputAudioTextArgs',
    'GoogleCloudDialogflowCxV3ResponseMessagePlayAudioArgs',
    'GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCallArgs',
    'GoogleCloudDialogflowCxV3ResponseMessageTextArgs',
    'GoogleCloudDialogflowCxV3ResponseMessageArgs',
    'GoogleCloudDialogflowCxV3RolloutConfigRolloutStepArgs',
    'GoogleCloudDialogflowCxV3RolloutConfigArgs',
    'GoogleCloudDialogflowCxV3RolloutStateArgs',
    'GoogleCloudDialogflowCxV3SecuritySettingsInsightsExportSettingsArgs',
    'GoogleCloudDialogflowCxV3SpeechToTextSettingsArgs',
    'GoogleCloudDialogflowCxV3TestCaseResultArgs',
    'GoogleCloudDialogflowCxV3TestConfigArgs',
    'GoogleCloudDialogflowCxV3TextInputArgs',
    'GoogleCloudDialogflowCxV3TransitionRouteArgs',
    'GoogleCloudDialogflowCxV3VariantsHistoryArgs',
    'GoogleCloudDialogflowCxV3VersionVariantsVariantArgs',
    'GoogleCloudDialogflowCxV3VersionVariantsArgs',
    'GoogleCloudDialogflowCxV3WebhookGenericWebServiceArgs',
    'GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfigArgs',
    'GoogleRpcStatusArgs',
]

@pulumi.input_type
class GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettingsArgs:
    def __init__(__self__, *,
                 enable_interaction_logging: Optional[pulumi.Input[bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[bool]] = None):
        """
        Define behaviors on logging.
        :param pulumi.Input[bool] enable_interaction_logging: If true, DF Interaction logging is currently enabled.
        :param pulumi.Input[bool] enable_stackdriver_logging: If true, StackDriver logging is currently enabled.
        """
        if enable_interaction_logging is not None:
            pulumi.set(__self__, "enable_interaction_logging", enable_interaction_logging)
        if enable_stackdriver_logging is not None:
            pulumi.set(__self__, "enable_stackdriver_logging", enable_stackdriver_logging)

    @property
    @pulumi.getter(name="enableInteractionLogging")
    def enable_interaction_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, DF Interaction logging is currently enabled.
        """
        return pulumi.get(self, "enable_interaction_logging")

    @enable_interaction_logging.setter
    def enable_interaction_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_interaction_logging", value)

    @property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, StackDriver logging is currently enabled.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @enable_stackdriver_logging.setter
    def enable_stackdriver_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_stackdriver_logging", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3AdvancedSettingsArgs:
    def __init__(__self__, *,
                 logging_settings: Optional[pulumi.Input['GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettingsArgs']] = None):
        """
        Hierarchical advanced settings for agent/flow/page/fulfillment/parameter. Settings exposed at lower level overrides the settings exposed at higher level. Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        :param pulumi.Input['GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettingsArgs'] logging_settings: Settings for logging. Settings for Dialogflow History, Contact Center messages, StackDriver logs, and speech logging. Exposed at the following levels: - Agent level.
        """
        if logging_settings is not None:
            pulumi.set(__self__, "logging_settings", logging_settings)

    @property
    @pulumi.getter(name="loggingSettings")
    def logging_settings(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettingsArgs']]:
        """
        Settings for logging. Settings for Dialogflow History, Contact Center messages, StackDriver logs, and speech logging. Exposed at the following levels: - Agent level.
        """
        return pulumi.get(self, "logging_settings")

    @logging_settings.setter
    def logging_settings(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettingsArgs']]):
        pulumi.set(self, "logging_settings", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3AudioInputArgs:
    def __init__(__self__, *,
                 config: pulumi.Input['GoogleCloudDialogflowCxV3InputAudioConfigArgs'],
                 audio: Optional[pulumi.Input[str]] = None):
        """
        Represents the natural speech audio to be processed.
        :param pulumi.Input['GoogleCloudDialogflowCxV3InputAudioConfigArgs'] config: Instructs the speech recognizer how to process the speech audio.
        :param pulumi.Input[str] audio: The natural language speech audio to be processed. A single request can contain up to 1 minute of speech audio data. The transcribed text cannot contain more than 256 bytes. For non-streaming audio detect intent, both `config` and `audio` must be provided. For streaming audio detect intent, `config` must be provided in the first request and `audio` must be provided in all following requests.
        """
        pulumi.set(__self__, "config", config)
        if audio is not None:
            pulumi.set(__self__, "audio", audio)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input['GoogleCloudDialogflowCxV3InputAudioConfigArgs']:
        """
        Instructs the speech recognizer how to process the speech audio.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['GoogleCloudDialogflowCxV3InputAudioConfigArgs']):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def audio(self) -> Optional[pulumi.Input[str]]:
        """
        The natural language speech audio to be processed. A single request can contain up to 1 minute of speech audio data. The transcribed text cannot contain more than 256 bytes. For non-streaming audio detect intent, both `config` and `audio` must be provided. For streaming audio detect intent, `config` must be provided in the first request and `audio` must be provided in all following requests.
        """
        return pulumi.get(self, "audio")

    @audio.setter
    def audio(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audio", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ConversationTurnUserInputArgs:
    def __init__(__self__, *,
                 enable_sentiment_analysis: Optional[pulumi.Input[bool]] = None,
                 injected_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input: Optional[pulumi.Input['GoogleCloudDialogflowCxV3QueryInputArgs']] = None,
                 is_webhook_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The input from the human user.
        :param pulumi.Input[bool] enable_sentiment_analysis: Whether sentiment analysis is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] injected_parameters: Parameters that need to be injected into the conversation during intent detection.
        :param pulumi.Input['GoogleCloudDialogflowCxV3QueryInputArgs'] input: Supports text input, event input, dtmf input in the test case.
        :param pulumi.Input[bool] is_webhook_enabled: If webhooks should be allowed to trigger in response to the user utterance. Often if parameters are injected, webhooks should not be enabled.
        """
        if enable_sentiment_analysis is not None:
            pulumi.set(__self__, "enable_sentiment_analysis", enable_sentiment_analysis)
        if injected_parameters is not None:
            pulumi.set(__self__, "injected_parameters", injected_parameters)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if is_webhook_enabled is not None:
            pulumi.set(__self__, "is_webhook_enabled", is_webhook_enabled)

    @property
    @pulumi.getter(name="enableSentimentAnalysis")
    def enable_sentiment_analysis(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether sentiment analysis is enabled.
        """
        return pulumi.get(self, "enable_sentiment_analysis")

    @enable_sentiment_analysis.setter
    def enable_sentiment_analysis(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_sentiment_analysis", value)

    @property
    @pulumi.getter(name="injectedParameters")
    def injected_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Parameters that need to be injected into the conversation during intent detection.
        """
        return pulumi.get(self, "injected_parameters")

    @injected_parameters.setter
    def injected_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "injected_parameters", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3QueryInputArgs']]:
        """
        Supports text input, event input, dtmf input in the test case.
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3QueryInputArgs']]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="isWebhookEnabled")
    def is_webhook_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If webhooks should be allowed to trigger in response to the user utterance. Often if parameters are injected, webhooks should not be enabled.
        """
        return pulumi.get(self, "is_webhook_enabled")

    @is_webhook_enabled.setter
    def is_webhook_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_webhook_enabled", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutputArgs:
    def __init__(__self__, *,
                 diagnostic_info: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 current_page: Optional[pulumi.Input['GoogleCloudDialogflowCxV3PageArgs']] = None,
                 session_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input['GoogleRpcStatusArgs']] = None,
                 text_responses: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageTextArgs']]]] = None,
                 triggered_intent: Optional[pulumi.Input['GoogleCloudDialogflowCxV3IntentArgs']] = None):
        """
        The output from the virtual agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] diagnostic_info: Input only. The diagnostic info output for the turn. Required to calculate the testing coverage.
        :param pulumi.Input['GoogleCloudDialogflowCxV3PageArgs'] current_page: The Page on which the utterance was spoken. Only name and displayName will be set.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] session_parameters: The session parameters available to the bot at this point.
        :param pulumi.Input['GoogleRpcStatusArgs'] status: Response error from the agent in the test result. If set, other output is empty.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageTextArgs']]] text_responses: The text responses from the agent for the turn.
        :param pulumi.Input['GoogleCloudDialogflowCxV3IntentArgs'] triggered_intent: The Intent that triggered the response. Only name and displayName will be set.
        """
        pulumi.set(__self__, "diagnostic_info", diagnostic_info)
        if current_page is not None:
            pulumi.set(__self__, "current_page", current_page)
        if session_parameters is not None:
            pulumi.set(__self__, "session_parameters", session_parameters)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if text_responses is not None:
            pulumi.set(__self__, "text_responses", text_responses)
        if triggered_intent is not None:
            pulumi.set(__self__, "triggered_intent", triggered_intent)

    @property
    @pulumi.getter(name="diagnosticInfo")
    def diagnostic_info(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        Input only. The diagnostic info output for the turn. Required to calculate the testing coverage.
        """
        return pulumi.get(self, "diagnostic_info")

    @diagnostic_info.setter
    def diagnostic_info(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "diagnostic_info", value)

    @property
    @pulumi.getter(name="currentPage")
    def current_page(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3PageArgs']]:
        """
        The Page on which the utterance was spoken. Only name and displayName will be set.
        """
        return pulumi.get(self, "current_page")

    @current_page.setter
    def current_page(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3PageArgs']]):
        pulumi.set(self, "current_page", value)

    @property
    @pulumi.getter(name="sessionParameters")
    def session_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The session parameters available to the bot at this point.
        """
        return pulumi.get(self, "session_parameters")

    @session_parameters.setter
    def session_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "session_parameters", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['GoogleRpcStatusArgs']]:
        """
        Response error from the agent in the test result. If set, other output is empty.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['GoogleRpcStatusArgs']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="textResponses")
    def text_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageTextArgs']]]]:
        """
        The text responses from the agent for the turn.
        """
        return pulumi.get(self, "text_responses")

    @text_responses.setter
    def text_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageTextArgs']]]]):
        pulumi.set(self, "text_responses", value)

    @property
    @pulumi.getter(name="triggeredIntent")
    def triggered_intent(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3IntentArgs']]:
        """
        The Intent that triggered the response. Only name and displayName will be set.
        """
        return pulumi.get(self, "triggered_intent")

    @triggered_intent.setter
    def triggered_intent(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3IntentArgs']]):
        pulumi.set(self, "triggered_intent", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ConversationTurnArgs:
    def __init__(__self__, *,
                 user_input: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ConversationTurnUserInputArgs']] = None,
                 virtual_agent_output: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutputArgs']] = None):
        """
        One interaction between a human and virtual agent. The human provides some input and the virtual agent provides a response.
        :param pulumi.Input['GoogleCloudDialogflowCxV3ConversationTurnUserInputArgs'] user_input: The user input.
        :param pulumi.Input['GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutputArgs'] virtual_agent_output: The virtual agent output.
        """
        if user_input is not None:
            pulumi.set(__self__, "user_input", user_input)
        if virtual_agent_output is not None:
            pulumi.set(__self__, "virtual_agent_output", virtual_agent_output)

    @property
    @pulumi.getter(name="userInput")
    def user_input(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3ConversationTurnUserInputArgs']]:
        """
        The user input.
        """
        return pulumi.get(self, "user_input")

    @user_input.setter
    def user_input(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ConversationTurnUserInputArgs']]):
        pulumi.set(self, "user_input", value)

    @property
    @pulumi.getter(name="virtualAgentOutput")
    def virtual_agent_output(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutputArgs']]:
        """
        The virtual agent output.
        """
        return pulumi.get(self, "virtual_agent_output")

    @virtual_agent_output.setter
    def virtual_agent_output(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutputArgs']]):
        pulumi.set(self, "virtual_agent_output", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3DtmfInputArgs:
    def __init__(__self__, *,
                 digits: Optional[pulumi.Input[str]] = None,
                 finish_digit: Optional[pulumi.Input[str]] = None):
        """
        Represents the input for dtmf event.
        :param pulumi.Input[str] digits: The dtmf digits.
        :param pulumi.Input[str] finish_digit: The finish digit (if any).
        """
        if digits is not None:
            pulumi.set(__self__, "digits", digits)
        if finish_digit is not None:
            pulumi.set(__self__, "finish_digit", finish_digit)

    @property
    @pulumi.getter
    def digits(self) -> Optional[pulumi.Input[str]]:
        """
        The dtmf digits.
        """
        return pulumi.get(self, "digits")

    @digits.setter
    def digits(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "digits", value)

    @property
    @pulumi.getter(name="finishDigit")
    def finish_digit(self) -> Optional[pulumi.Input[str]]:
        """
        The finish digit (if any).
        """
        return pulumi.get(self, "finish_digit")

    @finish_digit.setter
    def finish_digit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "finish_digit", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3EntityTypeEntityArgs:
    def __init__(__self__, *,
                 synonyms: pulumi.Input[Sequence[pulumi.Input[str]]],
                 value: pulumi.Input[str]):
        """
        An **entity entry** for an associated entity type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] synonyms: A collection of value synonyms. For example, if the entity type is *vegetable*, and `value` is *scallions*, a synonym could be *green onions*. For `KIND_LIST` entity types: * This collection must contain exactly one synonym equal to `value`.
        :param pulumi.Input[str] value: The primary value associated with this entity entry. For example, if the entity type is *vegetable*, the value could be *scallions*. For `KIND_MAP` entity types: * A canonical value to be used in place of synonyms. For `KIND_LIST` entity types: * A string that can contain references to other entity types (with or without aliases).
        """
        pulumi.set(__self__, "synonyms", synonyms)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def synonyms(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A collection of value synonyms. For example, if the entity type is *vegetable*, and `value` is *scallions*, a synonym could be *green onions*. For `KIND_LIST` entity types: * This collection must contain exactly one synonym equal to `value`.
        """
        return pulumi.get(self, "synonyms")

    @synonyms.setter
    def synonyms(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "synonyms", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The primary value associated with this entity entry. For example, if the entity type is *vegetable*, the value could be *scallions*. For `KIND_MAP` entity types: * A canonical value to be used in place of synonyms. For `KIND_LIST` entity types: * A string that can contain references to other entity types (with or without aliases).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3EntityTypeExcludedPhraseArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str]):
        """
        An excluded entity phrase that should not be matched.
        :param pulumi.Input[str] value: The word or phrase to be excluded.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The word or phrase to be excluded.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3EnvironmentTestCasesConfigArgs:
    def __init__(__self__, *,
                 enable_continuous_run: Optional[pulumi.Input[bool]] = None,
                 enable_predeployment_run: Optional[pulumi.Input[bool]] = None,
                 test_cases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration for continuous tests.
        :param pulumi.Input[bool] enable_continuous_run: Whether to run test cases in TestCasesConfig.test_cases periodically. Default false. If set to true, run once a day.
        :param pulumi.Input[bool] enable_predeployment_run: Whether to run test cases in TestCasesConfig.test_cases before deploying a flow version to the environment. Default false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] test_cases: A list of test case names to run. They should be under the same agent. Format of each test case name: `projects//locations/ /agents//testCases/`
        """
        if enable_continuous_run is not None:
            pulumi.set(__self__, "enable_continuous_run", enable_continuous_run)
        if enable_predeployment_run is not None:
            pulumi.set(__self__, "enable_predeployment_run", enable_predeployment_run)
        if test_cases is not None:
            pulumi.set(__self__, "test_cases", test_cases)

    @property
    @pulumi.getter(name="enableContinuousRun")
    def enable_continuous_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to run test cases in TestCasesConfig.test_cases periodically. Default false. If set to true, run once a day.
        """
        return pulumi.get(self, "enable_continuous_run")

    @enable_continuous_run.setter
    def enable_continuous_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_continuous_run", value)

    @property
    @pulumi.getter(name="enablePredeploymentRun")
    def enable_predeployment_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to run test cases in TestCasesConfig.test_cases before deploying a flow version to the environment. Default false.
        """
        return pulumi.get(self, "enable_predeployment_run")

    @enable_predeployment_run.setter
    def enable_predeployment_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_predeployment_run", value)

    @property
    @pulumi.getter(name="testCases")
    def test_cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of test case names to run. They should be under the same agent. Format of each test case name: `projects//locations/ /agents//testCases/`
        """
        return pulumi.get(self, "test_cases")

    @test_cases.setter
    def test_cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "test_cases", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3EnvironmentVersionConfigArgs:
    def __init__(__self__, *,
                 version: pulumi.Input[str]):
        """
        Configuration for the version.
        :param pulumi.Input[str] version: Format: projects//locations//agents//flows//versions/.
        """
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Format: projects//locations//agents//flows//versions/.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3EventHandlerArgs:
    def __init__(__self__, *,
                 event: pulumi.Input[str],
                 target_flow: Optional[pulumi.Input[str]] = None,
                 target_page: Optional[pulumi.Input[str]] = None,
                 trigger_fulfillment: Optional[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs']] = None):
        """
        An event handler specifies an event that can be handled during a session. When the specified event happens, the following actions are taken in order: * If there is a `trigger_fulfillment` associated with the event, it will be called. * If there is a `target_page` associated with the event, the session will transition into the specified page. * If there is a `target_flow` associated with the event, the session will transition into the specified flow.
        :param pulumi.Input[str] event: The name of the event to handle.
        :param pulumi.Input[str] target_flow: The target flow to transition to. Format: `projects//locations//agents//flows/`.
        :param pulumi.Input[str] target_page: The target page to transition to. Format: `projects//locations//agents//flows//pages/`.
        :param pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs'] trigger_fulfillment: The fulfillment to call when the event occurs. Handling webhook errors with a fulfillment enabled with webhook could cause infinite loop. It is invalid to specify such fulfillment for a handler handling webhooks.
        """
        pulumi.set(__self__, "event", event)
        if target_flow is not None:
            pulumi.set(__self__, "target_flow", target_flow)
        if target_page is not None:
            pulumi.set(__self__, "target_page", target_page)
        if trigger_fulfillment is not None:
            pulumi.set(__self__, "trigger_fulfillment", trigger_fulfillment)

    @property
    @pulumi.getter
    def event(self) -> pulumi.Input[str]:
        """
        The name of the event to handle.
        """
        return pulumi.get(self, "event")

    @event.setter
    def event(self, value: pulumi.Input[str]):
        pulumi.set(self, "event", value)

    @property
    @pulumi.getter(name="targetFlow")
    def target_flow(self) -> Optional[pulumi.Input[str]]:
        """
        The target flow to transition to. Format: `projects//locations//agents//flows/`.
        """
        return pulumi.get(self, "target_flow")

    @target_flow.setter
    def target_flow(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_flow", value)

    @property
    @pulumi.getter(name="targetPage")
    def target_page(self) -> Optional[pulumi.Input[str]]:
        """
        The target page to transition to. Format: `projects//locations//agents//flows//pages/`.
        """
        return pulumi.get(self, "target_page")

    @target_page.setter
    def target_page(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_page", value)

    @property
    @pulumi.getter(name="triggerFulfillment")
    def trigger_fulfillment(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs']]:
        """
        The fulfillment to call when the event occurs. Handling webhook errors with a fulfillment enabled with webhook could cause infinite loop. It is invalid to specify such fulfillment for a handler handling webhooks.
        """
        return pulumi.get(self, "trigger_fulfillment")

    @trigger_fulfillment.setter
    def trigger_fulfillment(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs']]):
        pulumi.set(self, "trigger_fulfillment", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3EventInputArgs:
    def __init__(__self__, *,
                 event: Optional[pulumi.Input[str]] = None):
        """
        Represents the event to trigger.
        :param pulumi.Input[str] event: Name of the event.
        """
        if event is not None:
            pulumi.set(__self__, "event", event)

    @property
    @pulumi.getter
    def event(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the event.
        """
        return pulumi.get(self, "event")

    @event.setter
    def event(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ExperimentDefinitionArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input[str]] = None,
                 version_variants: Optional[pulumi.Input['GoogleCloudDialogflowCxV3VersionVariantsArgs']] = None):
        """
        Definition of the experiment.
        :param pulumi.Input[str] condition: The condition defines which subset of sessions are selected for this experiment. If not specified, all sessions are eligible. E.g. "query_input.language_code=en" See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
        :param pulumi.Input['GoogleCloudDialogflowCxV3VersionVariantsArgs'] version_variants: The flow versions as the variants of this experiment.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if version_variants is not None:
            pulumi.set(__self__, "version_variants", version_variants)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        The condition defines which subset of sessions are selected for this experiment. If not specified, all sessions are eligible. E.g. "query_input.language_code=en" See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="versionVariants")
    def version_variants(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3VersionVariantsArgs']]:
        """
        The flow versions as the variants of this experiment.
        """
        return pulumi.get(self, "version_variants")

    @version_variants.setter
    def version_variants(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3VersionVariantsArgs']]):
        pulumi.set(self, "version_variants", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ExperimentResultConfidenceIntervalArgs:
    def __init__(__self__, *,
                 confidence_level: Optional[pulumi.Input[float]] = None,
                 lower_bound: Optional[pulumi.Input[float]] = None,
                 ratio: Optional[pulumi.Input[float]] = None,
                 upper_bound: Optional[pulumi.Input[float]] = None):
        """
        A confidence interval is a range of possible values for the experiment objective you are trying to measure.
        :param pulumi.Input[float] confidence_level: The confidence level used to construct the interval, i.e. there is X% chance that the true value is within this interval.
        :param pulumi.Input[float] lower_bound: Lower bound of the interval.
        :param pulumi.Input[float] ratio: The percent change between an experiment metric's value and the value for its control.
        :param pulumi.Input[float] upper_bound: Upper bound of the interval.
        """
        if confidence_level is not None:
            pulumi.set(__self__, "confidence_level", confidence_level)
        if lower_bound is not None:
            pulumi.set(__self__, "lower_bound", lower_bound)
        if ratio is not None:
            pulumi.set(__self__, "ratio", ratio)
        if upper_bound is not None:
            pulumi.set(__self__, "upper_bound", upper_bound)

    @property
    @pulumi.getter(name="confidenceLevel")
    def confidence_level(self) -> Optional[pulumi.Input[float]]:
        """
        The confidence level used to construct the interval, i.e. there is X% chance that the true value is within this interval.
        """
        return pulumi.get(self, "confidence_level")

    @confidence_level.setter
    def confidence_level(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "confidence_level", value)

    @property
    @pulumi.getter(name="lowerBound")
    def lower_bound(self) -> Optional[pulumi.Input[float]]:
        """
        Lower bound of the interval.
        """
        return pulumi.get(self, "lower_bound")

    @lower_bound.setter
    def lower_bound(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "lower_bound", value)

    @property
    @pulumi.getter
    def ratio(self) -> Optional[pulumi.Input[float]]:
        """
        The percent change between an experiment metric's value and the value for its control.
        """
        return pulumi.get(self, "ratio")

    @ratio.setter
    def ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ratio", value)

    @property
    @pulumi.getter(name="upperBound")
    def upper_bound(self) -> Optional[pulumi.Input[float]]:
        """
        Upper bound of the interval.
        """
        return pulumi.get(self, "upper_bound")

    @upper_bound.setter
    def upper_bound(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "upper_bound", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ExperimentResultMetricArgs:
    def __init__(__self__, *,
                 confidence_interval: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultConfidenceIntervalArgs']] = None,
                 count: Optional[pulumi.Input[float]] = None,
                 count_type: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultMetricCountType']] = None,
                 ratio: Optional[pulumi.Input[float]] = None,
                 type: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultMetricType']] = None):
        """
        Metric and corresponding confidence intervals.
        :param pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultConfidenceIntervalArgs'] confidence_interval: The probability that the treatment is better than all other treatments in the experiment
        :param pulumi.Input[float] count: Count value of a metric.
        :param pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultMetricCountType'] count_type: Count-based metric type. Only one of type or count_type is specified in each Metric.
        :param pulumi.Input[float] ratio: Ratio value of a metric.
        :param pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultMetricType'] type: Ratio-based metric type. Only one of type or count_type is specified in each Metric.
        """
        if confidence_interval is not None:
            pulumi.set(__self__, "confidence_interval", confidence_interval)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if count_type is not None:
            pulumi.set(__self__, "count_type", count_type)
        if ratio is not None:
            pulumi.set(__self__, "ratio", ratio)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="confidenceInterval")
    def confidence_interval(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultConfidenceIntervalArgs']]:
        """
        The probability that the treatment is better than all other treatments in the experiment
        """
        return pulumi.get(self, "confidence_interval")

    @confidence_interval.setter
    def confidence_interval(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultConfidenceIntervalArgs']]):
        pulumi.set(self, "confidence_interval", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[float]]:
        """
        Count value of a metric.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="countType")
    def count_type(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultMetricCountType']]:
        """
        Count-based metric type. Only one of type or count_type is specified in each Metric.
        """
        return pulumi.get(self, "count_type")

    @count_type.setter
    def count_type(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultMetricCountType']]):
        pulumi.set(self, "count_type", value)

    @property
    @pulumi.getter
    def ratio(self) -> Optional[pulumi.Input[float]]:
        """
        Ratio value of a metric.
        """
        return pulumi.get(self, "ratio")

    @ratio.setter
    def ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ratio", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultMetricType']]:
        """
        Ratio-based metric type. Only one of type or count_type is specified in each Metric.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultMetricType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ExperimentResultVersionMetricsArgs:
    def __init__(__self__, *,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultMetricArgs']]]] = None,
                 session_count: Optional[pulumi.Input[int]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Version variant and associated metrics.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultMetricArgs']]] metrics: The metrics and corresponding confidence intervals in the inference result.
        :param pulumi.Input[int] session_count: Number of sessions that were allocated to this version.
        :param pulumi.Input[str] version: The name of the flow Version. Format: `projects//locations//agents//flows//versions/`.
        """
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if session_count is not None:
            pulumi.set(__self__, "session_count", session_count)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultMetricArgs']]]]:
        """
        The metrics and corresponding confidence intervals in the inference result.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter(name="sessionCount")
    def session_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of sessions that were allocated to this version.
        """
        return pulumi.get(self, "session_count")

    @session_count.setter
    def session_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_count", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the flow Version. Format: `projects//locations//agents//flows//versions/`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ExperimentResultArgs:
    def __init__(__self__, *,
                 last_update_time: Optional[pulumi.Input[str]] = None,
                 version_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultVersionMetricsArgs']]]] = None):
        """
        The inference result which includes an objective metric to optimize and the confidence interval.
        :param pulumi.Input[str] last_update_time: The last time the experiment's stats data was updated. Will have default value if stats have never been computed for this experiment.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultVersionMetricsArgs']]] version_metrics: Version variants and metrics.
        """
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if version_metrics is not None:
            pulumi.set(__self__, "version_metrics", version_metrics)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last time the experiment's stats data was updated. Will have default value if stats have never been computed for this experiment.
        """
        return pulumi.get(self, "last_update_time")

    @last_update_time.setter
    def last_update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_update_time", value)

    @property
    @pulumi.getter(name="versionMetrics")
    def version_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultVersionMetricsArgs']]]]:
        """
        Version variants and metrics.
        """
        return pulumi.get(self, "version_metrics")

    @version_metrics.setter
    def version_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ExperimentResultVersionMetricsArgs']]]]):
        pulumi.set(self, "version_metrics", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3FormParameterFillBehaviorArgs:
    def __init__(__self__, *,
                 initial_prompt_fulfillment: pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs'],
                 reprompt_event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3EventHandlerArgs']]]] = None):
        """
        Configuration for how the filling of a parameter should be handled.
        :param pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs'] initial_prompt_fulfillment: The fulfillment to provide the initial prompt that the agent can present to the user in order to fill the parameter.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3EventHandlerArgs']]] reprompt_event_handlers: The handlers for parameter-level events, used to provide reprompt for the parameter or transition to a different page/flow. The supported events are: * `sys.no-match-`, where N can be from 1 to 6 * `sys.no-match-default` * `sys.no-input-`, where N can be from 1 to 6 * `sys.no-input-default` * `sys.invalid-parameter` `initial_prompt_fulfillment` provides the first prompt for the parameter. If the user's response does not fill the parameter, a no-match/no-input event will be triggered, and the fulfillment associated with the `sys.no-match-1`/`sys.no-input-1` handler (if defined) will be called to provide a prompt. The `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to the next no-match/no-input event, and so on. A `sys.no-match-default` or `sys.no-input-default` handler will be used to handle all following no-match/no-input events after all numbered no-match/no-input handlers for the parameter are consumed. A `sys.invalid-parameter` handler can be defined to handle the case where the parameter values have been `invalidated` by webhook. For example, if the user's response fill the parameter, however the parameter was invalidated by webhook, the fulfillment associated with the `sys.invalid-parameter` handler (if defined) will be called to provide a prompt. If the event handler for the corresponding event can't be found on the parameter, `initial_prompt_fulfillment` will be re-prompted.
        """
        pulumi.set(__self__, "initial_prompt_fulfillment", initial_prompt_fulfillment)
        if reprompt_event_handlers is not None:
            pulumi.set(__self__, "reprompt_event_handlers", reprompt_event_handlers)

    @property
    @pulumi.getter(name="initialPromptFulfillment")
    def initial_prompt_fulfillment(self) -> pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs']:
        """
        The fulfillment to provide the initial prompt that the agent can present to the user in order to fill the parameter.
        """
        return pulumi.get(self, "initial_prompt_fulfillment")

    @initial_prompt_fulfillment.setter
    def initial_prompt_fulfillment(self, value: pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs']):
        pulumi.set(self, "initial_prompt_fulfillment", value)

    @property
    @pulumi.getter(name="repromptEventHandlers")
    def reprompt_event_handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3EventHandlerArgs']]]]:
        """
        The handlers for parameter-level events, used to provide reprompt for the parameter or transition to a different page/flow. The supported events are: * `sys.no-match-`, where N can be from 1 to 6 * `sys.no-match-default` * `sys.no-input-`, where N can be from 1 to 6 * `sys.no-input-default` * `sys.invalid-parameter` `initial_prompt_fulfillment` provides the first prompt for the parameter. If the user's response does not fill the parameter, a no-match/no-input event will be triggered, and the fulfillment associated with the `sys.no-match-1`/`sys.no-input-1` handler (if defined) will be called to provide a prompt. The `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to the next no-match/no-input event, and so on. A `sys.no-match-default` or `sys.no-input-default` handler will be used to handle all following no-match/no-input events after all numbered no-match/no-input handlers for the parameter are consumed. A `sys.invalid-parameter` handler can be defined to handle the case where the parameter values have been `invalidated` by webhook. For example, if the user's response fill the parameter, however the parameter was invalidated by webhook, the fulfillment associated with the `sys.invalid-parameter` handler (if defined) will be called to provide a prompt. If the event handler for the corresponding event can't be found on the parameter, `initial_prompt_fulfillment` will be re-prompted.
        """
        return pulumi.get(self, "reprompt_event_handlers")

    @reprompt_event_handlers.setter
    def reprompt_event_handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3EventHandlerArgs']]]]):
        pulumi.set(self, "reprompt_event_handlers", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3FormParameterArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 entity_type: pulumi.Input[str],
                 fill_behavior: pulumi.Input['GoogleCloudDialogflowCxV3FormParameterFillBehaviorArgs'],
                 default_value: Optional[Any] = None,
                 is_list: Optional[pulumi.Input[bool]] = None,
                 redact: Optional[pulumi.Input[bool]] = None,
                 required: Optional[pulumi.Input[bool]] = None):
        """
        Represents a form parameter.
        :param pulumi.Input[str] display_name: The human-readable name of the parameter, unique within the form.
        :param pulumi.Input[str] entity_type: The entity type of the parameter. Format: `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or `projects//locations//agents//entityTypes/` for developer entity types.
        :param pulumi.Input['GoogleCloudDialogflowCxV3FormParameterFillBehaviorArgs'] fill_behavior: Defines fill behavior for the parameter.
        :param Any default_value: The default value of an optional parameter. If the parameter is required, the default value will be ignored.
        :param pulumi.Input[bool] is_list: Indicates whether the parameter represents a list of values.
        :param pulumi.Input[bool] redact: Indicates whether the parameter content should be redacted in log. If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
        :param pulumi.Input[bool] required: Indicates whether the parameter is required. Optional parameters will not trigger prompts; however, they are filled if the user specifies them. Required parameters must be filled before form filling concludes.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "fill_behavior", fill_behavior)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if is_list is not None:
            pulumi.set(__self__, "is_list", is_list)
        if redact is not None:
            pulumi.set(__self__, "redact", redact)
        if required is not None:
            pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The human-readable name of the parameter, unique within the form.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Input[str]:
        """
        The entity type of the parameter. Format: `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or `projects//locations//agents//entityTypes/` for developer entity types.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_type", value)

    @property
    @pulumi.getter(name="fillBehavior")
    def fill_behavior(self) -> pulumi.Input['GoogleCloudDialogflowCxV3FormParameterFillBehaviorArgs']:
        """
        Defines fill behavior for the parameter.
        """
        return pulumi.get(self, "fill_behavior")

    @fill_behavior.setter
    def fill_behavior(self, value: pulumi.Input['GoogleCloudDialogflowCxV3FormParameterFillBehaviorArgs']):
        pulumi.set(self, "fill_behavior", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[Any]:
        """
        The default value of an optional parameter. If the parameter is required, the default value will be ignored.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[Any]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter(name="isList")
    def is_list(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the parameter represents a list of values.
        """
        return pulumi.get(self, "is_list")

    @is_list.setter
    def is_list(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_list", value)

    @property
    @pulumi.getter
    def redact(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the parameter content should be redacted in log. If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
        """
        return pulumi.get(self, "redact")

    @redact.setter
    def redact(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "redact", value)

    @property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the parameter is required. Optional parameters will not trigger prompts; however, they are filled if the user specifies them. Required parameters must be filled before form filling concludes.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "required", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3FormArgs:
    def __init__(__self__, *,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FormParameterArgs']]]] = None):
        """
        A form is a data model that groups related parameters that can be collected from the user. The process in which the agent prompts the user and collects parameter values from the user is called form filling. A form can be added to a page. When form filling is done, the filled parameters will be written to the session.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FormParameterArgs']]] parameters: Parameters to collect from the user.
        """
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FormParameterArgs']]]]:
        """
        Parameters to collect from the user.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FormParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContentArgs:
    def __init__(__self__, *,
                 additional_cases: Optional[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesArgs']] = None,
                 message: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageArgs']] = None):
        """
        The list of messages or conditional cases to activate for this case.
        :param pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesArgs'] additional_cases: Additional cases to be evaluated.
        :param pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageArgs'] message: Returned message.
        """
        if additional_cases is not None:
            pulumi.set(__self__, "additional_cases", additional_cases)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter(name="additionalCases")
    def additional_cases(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesArgs']]:
        """
        Additional cases to be evaluated.
        """
        return pulumi.get(self, "additional_cases")

    @additional_cases.setter
    def additional_cases(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesArgs']]):
        pulumi.set(self, "additional_cases", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageArgs']]:
        """
        Returned message.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageArgs']]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseArgs:
    def __init__(__self__, *,
                 case_content: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContentArgs']]]] = None,
                 condition: Optional[pulumi.Input[str]] = None):
        """
        Each case has a Boolean condition. When it is evaluated to be True, the corresponding messages will be selected and evaluated recursively.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContentArgs']]] case_content: A list of case content.
        :param pulumi.Input[str] condition: The condition to activate and select this case. Empty means the condition is always true. The condition is evaluated against form parameters or session parameters. See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
        """
        if case_content is not None:
            pulumi.set(__self__, "case_content", case_content)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter(name="caseContent")
    def case_content(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContentArgs']]]]:
        """
        A list of case content.
        """
        return pulumi.get(self, "case_content")

    @case_content.setter
    def case_content(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContentArgs']]]]):
        pulumi.set(self, "case_content", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        The condition to activate and select this case. Empty means the condition is always true. The condition is evaluated against form parameters or session parameters. See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3FulfillmentConditionalCasesArgs:
    def __init__(__self__, *,
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseArgs']]]] = None):
        """
        A list of cascading if-else conditions. Cases are mutually exclusive. The first one with a matching condition is selected, all the rest ignored.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseArgs']]] cases: A list of cascading if-else conditions.
        """
        if cases is not None:
            pulumi.set(__self__, "cases", cases)

    @property
    @pulumi.getter
    def cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseArgs']]]]:
        """
        A list of cascading if-else conditions.
        """
        return pulumi.get(self, "cases")

    @cases.setter
    def cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseArgs']]]]):
        pulumi.set(self, "cases", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3FulfillmentSetParameterActionArgs:
    def __init__(__self__, *,
                 parameter: Optional[pulumi.Input[str]] = None,
                 value: Optional[Any] = None):
        """
        Setting a parameter value.
        :param pulumi.Input[str] parameter: Display name of the parameter.
        :param Any value: The new value of the parameter. A null value clears the parameter.
        """
        if parameter is not None:
            pulumi.set(__self__, "parameter", parameter)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def parameter(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the parameter.
        """
        return pulumi.get(self, "parameter")

    @parameter.setter
    def parameter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        """
        The new value of the parameter. A null value clears the parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[Any]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3FulfillmentArgs:
    def __init__(__self__, *,
                 conditional_cases: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesArgs']]]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageArgs']]]] = None,
                 return_partial_responses: Optional[pulumi.Input[bool]] = None,
                 set_parameter_actions: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentSetParameterActionArgs']]]] = None,
                 tag: Optional[pulumi.Input[str]] = None,
                 webhook: Optional[pulumi.Input[str]] = None):
        """
        A fulfillment can do one or more of the following actions at the same time: * Generate rich message responses. * Set parameter values. * Call the webhook. Fulfillments can be called at various stages in the Page or Form lifecycle. For example, when a DetectIntentRequest drives a session to enter a new page, the page's entry fulfillment can add a static response to the QueryResult in the returning DetectIntentResponse, call the webhook (for example, to load user data from a database), or both.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesArgs']]] conditional_cases: Conditional cases for this fulfillment.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageArgs']]] messages: The list of rich message responses to present to the user.
        :param pulumi.Input[bool] return_partial_responses: Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentSetParameterActionArgs']]] set_parameter_actions: Set parameter values before executing the webhook.
        :param pulumi.Input[str] tag: The tag used by the webhook to identify which fulfillment is being called. This field is required if `webhook` is specified.
        :param pulumi.Input[str] webhook: The webhook to call. Format: `projects//locations//agents//webhooks/`.
        """
        if conditional_cases is not None:
            pulumi.set(__self__, "conditional_cases", conditional_cases)
        if messages is not None:
            pulumi.set(__self__, "messages", messages)
        if return_partial_responses is not None:
            pulumi.set(__self__, "return_partial_responses", return_partial_responses)
        if set_parameter_actions is not None:
            pulumi.set(__self__, "set_parameter_actions", set_parameter_actions)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @property
    @pulumi.getter(name="conditionalCases")
    def conditional_cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesArgs']]]]:
        """
        Conditional cases for this fulfillment.
        """
        return pulumi.get(self, "conditional_cases")

    @conditional_cases.setter
    def conditional_cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentConditionalCasesArgs']]]]):
        pulumi.set(self, "conditional_cases", value)

    @property
    @pulumi.getter
    def messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageArgs']]]]:
        """
        The list of rich message responses to present to the user.
        """
        return pulumi.get(self, "messages")

    @messages.setter
    def messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageArgs']]]]):
        pulumi.set(self, "messages", value)

    @property
    @pulumi.getter(name="returnPartialResponses")
    def return_partial_responses(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
        """
        return pulumi.get(self, "return_partial_responses")

    @return_partial_responses.setter
    def return_partial_responses(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "return_partial_responses", value)

    @property
    @pulumi.getter(name="setParameterActions")
    def set_parameter_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentSetParameterActionArgs']]]]:
        """
        Set parameter values before executing the webhook.
        """
        return pulumi.get(self, "set_parameter_actions")

    @set_parameter_actions.setter
    def set_parameter_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentSetParameterActionArgs']]]]):
        pulumi.set(self, "set_parameter_actions", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        The tag used by the webhook to identify which fulfillment is being called. This field is required if `webhook` is specified.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)

    @property
    @pulumi.getter
    def webhook(self) -> Optional[pulumi.Input[str]]:
        """
        The webhook to call. Format: `projects//locations//agents//webhooks/`.
        """
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3InputAudioConfigArgs:
    def __init__(__self__, *,
                 audio_encoding: pulumi.Input['GoogleCloudDialogflowCxV3InputAudioConfigAudioEncoding'],
                 enable_word_info: Optional[pulumi.Input[bool]] = None,
                 model: Optional[pulumi.Input[str]] = None,
                 model_variant: Optional[pulumi.Input['GoogleCloudDialogflowCxV3InputAudioConfigModelVariant']] = None,
                 phrase_hints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sample_rate_hertz: Optional[pulumi.Input[int]] = None,
                 single_utterance: Optional[pulumi.Input[bool]] = None):
        """
        Instructs the speech recognizer on how to process the audio content.
        :param pulumi.Input['GoogleCloudDialogflowCxV3InputAudioConfigAudioEncoding'] audio_encoding: Audio encoding of the audio content to process.
        :param pulumi.Input[bool] enable_word_info: Optional. If `true`, Dialogflow returns SpeechWordInfo in StreamingRecognitionResult with information about the recognized speech words, e.g. start and end time offsets. If false or unspecified, Speech doesn't return any word-level information.
        :param pulumi.Input[str] model: Optional. Which Speech model to select for the given request. Select the model best suited to your domain to get best results. If a model is not explicitly specified, then we auto-select a model based on the parameters in the InputAudioConfig. If enhanced speech model is enabled for the agent and an enhanced version of the specified model for the language does not exist, then the speech is recognized using the standard version of the specified model. Refer to [Cloud Speech API documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model) for more details.
        :param pulumi.Input['GoogleCloudDialogflowCxV3InputAudioConfigModelVariant'] model_variant: Optional. Which variant of the Speech model to use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] phrase_hints: Optional. A list of strings containing words and phrases that the speech recognizer should recognize with higher likelihood. See [the Cloud Speech documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints) for more details.
        :param pulumi.Input[int] sample_rate_hertz: Sample rate (in Hertz) of the audio content sent in the query. Refer to [Cloud Speech API documentation](https://cloud.google.com/speech-to-text/docs/basics) for more details.
        :param pulumi.Input[bool] single_utterance: Optional. If `false` (default), recognition does not cease until the client closes the stream. If `true`, the recognizer will detect a single spoken utterance in input audio. Recognition ceases when it detects the audio's voice has stopped or paused. In this case, once a detected intent is received, the client should close the stream and start a new request with a new stream as needed. Note: This setting is relevant only for streaming methods.
        """
        pulumi.set(__self__, "audio_encoding", audio_encoding)
        if enable_word_info is not None:
            pulumi.set(__self__, "enable_word_info", enable_word_info)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if model_variant is not None:
            pulumi.set(__self__, "model_variant", model_variant)
        if phrase_hints is not None:
            pulumi.set(__self__, "phrase_hints", phrase_hints)
        if sample_rate_hertz is not None:
            pulumi.set(__self__, "sample_rate_hertz", sample_rate_hertz)
        if single_utterance is not None:
            pulumi.set(__self__, "single_utterance", single_utterance)

    @property
    @pulumi.getter(name="audioEncoding")
    def audio_encoding(self) -> pulumi.Input['GoogleCloudDialogflowCxV3InputAudioConfigAudioEncoding']:
        """
        Audio encoding of the audio content to process.
        """
        return pulumi.get(self, "audio_encoding")

    @audio_encoding.setter
    def audio_encoding(self, value: pulumi.Input['GoogleCloudDialogflowCxV3InputAudioConfigAudioEncoding']):
        pulumi.set(self, "audio_encoding", value)

    @property
    @pulumi.getter(name="enableWordInfo")
    def enable_word_info(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If `true`, Dialogflow returns SpeechWordInfo in StreamingRecognitionResult with information about the recognized speech words, e.g. start and end time offsets. If false or unspecified, Speech doesn't return any word-level information.
        """
        return pulumi.get(self, "enable_word_info")

    @enable_word_info.setter
    def enable_word_info(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_word_info", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Which Speech model to select for the given request. Select the model best suited to your domain to get best results. If a model is not explicitly specified, then we auto-select a model based on the parameters in the InputAudioConfig. If enhanced speech model is enabled for the agent and an enhanced version of the specified model for the language does not exist, then the speech is recognized using the standard version of the specified model. Refer to [Cloud Speech API documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model) for more details.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter(name="modelVariant")
    def model_variant(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3InputAudioConfigModelVariant']]:
        """
        Optional. Which variant of the Speech model to use.
        """
        return pulumi.get(self, "model_variant")

    @model_variant.setter
    def model_variant(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3InputAudioConfigModelVariant']]):
        pulumi.set(self, "model_variant", value)

    @property
    @pulumi.getter(name="phraseHints")
    def phrase_hints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. A list of strings containing words and phrases that the speech recognizer should recognize with higher likelihood. See [the Cloud Speech documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints) for more details.
        """
        return pulumi.get(self, "phrase_hints")

    @phrase_hints.setter
    def phrase_hints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "phrase_hints", value)

    @property
    @pulumi.getter(name="sampleRateHertz")
    def sample_rate_hertz(self) -> Optional[pulumi.Input[int]]:
        """
        Sample rate (in Hertz) of the audio content sent in the query. Refer to [Cloud Speech API documentation](https://cloud.google.com/speech-to-text/docs/basics) for more details.
        """
        return pulumi.get(self, "sample_rate_hertz")

    @sample_rate_hertz.setter
    def sample_rate_hertz(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sample_rate_hertz", value)

    @property
    @pulumi.getter(name="singleUtterance")
    def single_utterance(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If `false` (default), recognition does not cease until the client closes the stream. If `true`, the recognizer will detect a single spoken utterance in input audio. Recognition ceases when it detects the audio's voice has stopped or paused. In this case, once a detected intent is received, the client should close the stream and start a new request with a new stream as needed. Note: This setting is relevant only for streaming methods.
        """
        return pulumi.get(self, "single_utterance")

    @single_utterance.setter
    def single_utterance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_utterance", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3IntentInputArgs:
    def __init__(__self__, *,
                 intent: pulumi.Input[str]):
        """
        Represents the intent to trigger programmatically rather than as a result of natural language processing.
        :param pulumi.Input[str] intent: The unique identifier of the intent. Format: `projects//locations//agents//intents/`.
        """
        pulumi.set(__self__, "intent", intent)

    @property
    @pulumi.getter
    def intent(self) -> pulumi.Input[str]:
        """
        The unique identifier of the intent. Format: `projects//locations//agents//intents/`.
        """
        return pulumi.get(self, "intent")

    @intent.setter
    def intent(self, value: pulumi.Input[str]):
        pulumi.set(self, "intent", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3IntentParameterArgs:
    def __init__(__self__, *,
                 entity_type: pulumi.Input[str],
                 id: pulumi.Input[str],
                 is_list: Optional[pulumi.Input[bool]] = None,
                 redact: Optional[pulumi.Input[bool]] = None):
        """
        Represents an intent parameter.
        :param pulumi.Input[str] entity_type: The entity type of the parameter. Format: `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or `projects//locations//agents//entityTypes/` for developer entity types.
        :param pulumi.Input[str] id: The unique identifier of the parameter. This field is used by training phrases to annotate their parts.
        :param pulumi.Input[bool] is_list: Indicates whether the parameter represents a list of values.
        :param pulumi.Input[bool] redact: Indicates whether the parameter content should be redacted in log. If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
        """
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "id", id)
        if is_list is not None:
            pulumi.set(__self__, "is_list", is_list)
        if redact is not None:
            pulumi.set(__self__, "redact", redact)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Input[str]:
        """
        The entity type of the parameter. Format: `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or `projects//locations//agents//entityTypes/` for developer entity types.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_type", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The unique identifier of the parameter. This field is used by training phrases to annotate their parts.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="isList")
    def is_list(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the parameter represents a list of values.
        """
        return pulumi.get(self, "is_list")

    @is_list.setter
    def is_list(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_list", value)

    @property
    @pulumi.getter
    def redact(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the parameter content should be redacted in log. If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
        """
        return pulumi.get(self, "redact")

    @redact.setter
    def redact(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "redact", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3IntentTrainingPhrasePartArgs:
    def __init__(__self__, *,
                 text: pulumi.Input[str],
                 parameter_id: Optional[pulumi.Input[str]] = None):
        """
        Represents a part of a training phrase.
        :param pulumi.Input[str] text: The text for this part.
        :param pulumi.Input[str] parameter_id: The parameter used to annotate this part of the training phrase. This field is required for annotated parts of the training phrase.
        """
        pulumi.set(__self__, "text", text)
        if parameter_id is not None:
            pulumi.set(__self__, "parameter_id", parameter_id)

    @property
    @pulumi.getter
    def text(self) -> pulumi.Input[str]:
        """
        The text for this part.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: pulumi.Input[str]):
        pulumi.set(self, "text", value)

    @property
    @pulumi.getter(name="parameterId")
    def parameter_id(self) -> Optional[pulumi.Input[str]]:
        """
        The parameter used to annotate this part of the training phrase. This field is required for annotated parts of the training phrase.
        """
        return pulumi.get(self, "parameter_id")

    @parameter_id.setter
    def parameter_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_id", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3IntentTrainingPhraseArgs:
    def __init__(__self__, *,
                 parts: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3IntentTrainingPhrasePartArgs']]],
                 repeat_count: Optional[pulumi.Input[int]] = None):
        """
        Represents an example that the agent is trained on to identify the intent.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3IntentTrainingPhrasePartArgs']]] parts: The ordered list of training phrase parts. The parts are concatenated in order to form the training phrase. Note: The API does not automatically annotate training phrases like the Dialogflow Console does. Note: Do not forget to include whitespace at part boundaries, so the training phrase is well formatted when the parts are concatenated. If the training phrase does not need to be annotated with parameters, you just need a single part with only the Part.text field set. If you want to annotate the training phrase, you must create multiple parts, where the fields of each part are populated in one of two ways: - `Part.text` is set to a part of the phrase that has no parameters. - `Part.text` is set to a part of the phrase that you want to annotate, and the `parameter_id` field is set.
        :param pulumi.Input[int] repeat_count: Indicates how many times this example was added to the intent.
        """
        pulumi.set(__self__, "parts", parts)
        if repeat_count is not None:
            pulumi.set(__self__, "repeat_count", repeat_count)

    @property
    @pulumi.getter
    def parts(self) -> pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3IntentTrainingPhrasePartArgs']]]:
        """
        The ordered list of training phrase parts. The parts are concatenated in order to form the training phrase. Note: The API does not automatically annotate training phrases like the Dialogflow Console does. Note: Do not forget to include whitespace at part boundaries, so the training phrase is well formatted when the parts are concatenated. If the training phrase does not need to be annotated with parameters, you just need a single part with only the Part.text field set. If you want to annotate the training phrase, you must create multiple parts, where the fields of each part are populated in one of two ways: - `Part.text` is set to a part of the phrase that has no parameters. - `Part.text` is set to a part of the phrase that you want to annotate, and the `parameter_id` field is set.
        """
        return pulumi.get(self, "parts")

    @parts.setter
    def parts(self, value: pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3IntentTrainingPhrasePartArgs']]]):
        pulumi.set(self, "parts", value)

    @property
    @pulumi.getter(name="repeatCount")
    def repeat_count(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates how many times this example was added to the intent.
        """
        return pulumi.get(self, "repeat_count")

    @repeat_count.setter
    def repeat_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "repeat_count", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3IntentArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 is_fallback: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3IntentParameterArgs']]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 training_phrases: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3IntentTrainingPhraseArgs']]]] = None):
        """
        An intent represents a user's intent to interact with a conversational agent. You can provide information for the Dialogflow API to use to match user input to an intent by adding training phrases (i.e., examples of user input) to your intent.
        :param pulumi.Input[str] display_name: The human-readable name of the intent, unique within the agent.
        :param pulumi.Input[str] description: Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
        :param pulumi.Input[bool] is_fallback: Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation. Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes. Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys.contextual" means the intent is a contextual intent.
        :param pulumi.Input[str] name: The unique identifier of the intent. Required for the Intents.UpdateIntent method. Intents.CreateIntent populates the name automatically. Format: `projects//locations//agents//intents/`.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3IntentParameterArgs']]] parameters: The collection of parameters associated with the intent.
        :param pulumi.Input[int] priority: The priority of this intent. Higher numbers represent higher priorities. - If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the `Normal` priority in the console. - If the supplied value is negative, the intent is ignored in runtime detect intent requests.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3IntentTrainingPhraseArgs']]] training_phrases: The collection of training phrases the agent is trained on to identify the intent.
        """
        pulumi.set(__self__, "display_name", display_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_fallback is not None:
            pulumi.set(__self__, "is_fallback", is_fallback)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if training_phrases is not None:
            pulumi.set(__self__, "training_phrases", training_phrases)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The human-readable name of the intent, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isFallback")
    def is_fallback(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation. Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
        """
        return pulumi.get(self, "is_fallback")

    @is_fallback.setter
    def is_fallback(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_fallback", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes. Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys.contextual" means the intent is a contextual intent.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the intent. Required for the Intents.UpdateIntent method. Intents.CreateIntent populates the name automatically. Format: `projects//locations//agents//intents/`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3IntentParameterArgs']]]]:
        """
        The collection of parameters associated with the intent.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3IntentParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of this intent. Higher numbers represent higher priorities. - If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the `Normal` priority in the console. - If the supplied value is negative, the intent is ignored in runtime detect intent requests.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="trainingPhrases")
    def training_phrases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3IntentTrainingPhraseArgs']]]]:
        """
        The collection of training phrases the agent is trained on to identify the intent.
        """
        return pulumi.get(self, "training_phrases")

    @training_phrases.setter
    def training_phrases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3IntentTrainingPhraseArgs']]]]):
        pulumi.set(self, "training_phrases", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3NluSettingsArgs:
    def __init__(__self__, *,
                 classification_threshold: Optional[pulumi.Input[float]] = None,
                 model_training_mode: Optional[pulumi.Input['GoogleCloudDialogflowCxV3NluSettingsModelTrainingMode']] = None,
                 model_type: Optional[pulumi.Input['GoogleCloudDialogflowCxV3NluSettingsModelType']] = None):
        """
        Settings related to NLU.
        :param pulumi.Input[float] classification_threshold: To filter out false positive results and still get variety in matched natural language inputs for your agent, you can tune the machine learning classification threshold. If the returned score value is less than the threshold value, then a no-match event will be triggered. The score values range from 0.0 (completely uncertain) to 1.0 (completely certain). If set to 0.0, the default of 0.3 is used.
        :param pulumi.Input['GoogleCloudDialogflowCxV3NluSettingsModelTrainingMode'] model_training_mode: Indicates NLU model training mode.
        :param pulumi.Input['GoogleCloudDialogflowCxV3NluSettingsModelType'] model_type: Indicates the type of NLU model.
        """
        if classification_threshold is not None:
            pulumi.set(__self__, "classification_threshold", classification_threshold)
        if model_training_mode is not None:
            pulumi.set(__self__, "model_training_mode", model_training_mode)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)

    @property
    @pulumi.getter(name="classificationThreshold")
    def classification_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        To filter out false positive results and still get variety in matched natural language inputs for your agent, you can tune the machine learning classification threshold. If the returned score value is less than the threshold value, then a no-match event will be triggered. The score values range from 0.0 (completely uncertain) to 1.0 (completely certain). If set to 0.0, the default of 0.3 is used.
        """
        return pulumi.get(self, "classification_threshold")

    @classification_threshold.setter
    def classification_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "classification_threshold", value)

    @property
    @pulumi.getter(name="modelTrainingMode")
    def model_training_mode(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3NluSettingsModelTrainingMode']]:
        """
        Indicates NLU model training mode.
        """
        return pulumi.get(self, "model_training_mode")

    @model_training_mode.setter
    def model_training_mode(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3NluSettingsModelTrainingMode']]):
        pulumi.set(self, "model_training_mode", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3NluSettingsModelType']]:
        """
        Indicates the type of NLU model.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3NluSettingsModelType']]):
        pulumi.set(self, "model_type", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3PageArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 entry_fulfillment: Optional[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs']] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3EventHandlerArgs']]]] = None,
                 form: Optional[pulumi.Input['GoogleCloudDialogflowCxV3FormArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 transition_route_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transition_routes: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3TransitionRouteArgs']]]] = None):
        """
        A Dialogflow CX conversation (session) can be described and visualized as a state machine. The states of a CX session are represented by pages. For each flow, you define many pages, where your combined pages can handle a complete conversation on the topics the flow is designed for. At any given moment, exactly one page is the current page, the current page is considered active, and the flow associated with that page is considered active. Every flow has a special start page. When a flow initially becomes active, the start page page becomes the current page. For each conversational turn, the current page will either stay the same or transition to another page. You configure each page to collect information from the end-user that is relevant for the conversational state represented by the page. For more information, see the [Page guide](https://cloud.google.com/dialogflow/cx/docs/concept/page).
        :param pulumi.Input[str] display_name: The human-readable name of the page, unique within the agent.
        :param pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs'] entry_fulfillment: The fulfillment to call when the session is entering the page.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3EventHandlerArgs']]] event_handlers: Handlers associated with the page to handle events such as webhook errors, no match or no input.
        :param pulumi.Input['GoogleCloudDialogflowCxV3FormArgs'] form: The form associated with the page, used for collecting parameters relevant to the page.
        :param pulumi.Input[str] name: The unique identifier of the page. Required for the Pages.UpdatePage method. Pages.CreatePage populates the name automatically. Format: `projects//locations//agents//flows//pages/`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transition_route_groups: Ordered list of `TransitionRouteGroups` associated with the page. Transition route groups must be unique within a page. * If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route -> page's transition route group -> flow's transition routes. * If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence. Format:`projects//locations//agents//flows//transitionRouteGroups/`.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3TransitionRouteArgs']]] transition_routes: A list of transitions for the transition rules of this page. They route the conversation to another page in the same flow, or another flow. When we are in a certain page, the TransitionRoutes are evalauted in the following order: * TransitionRoutes defined in the page with intent specified. * TransitionRoutes defined in the transition route groups with intent specified. * TransitionRoutes defined in flow with intent specified. * TransitionRoutes defined in the transition route groups with intent specified. * TransitionRoutes defined in the page with only condition specified. * TransitionRoutes defined in the transition route groups with only condition specified.
        """
        pulumi.set(__self__, "display_name", display_name)
        if entry_fulfillment is not None:
            pulumi.set(__self__, "entry_fulfillment", entry_fulfillment)
        if event_handlers is not None:
            pulumi.set(__self__, "event_handlers", event_handlers)
        if form is not None:
            pulumi.set(__self__, "form", form)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if transition_route_groups is not None:
            pulumi.set(__self__, "transition_route_groups", transition_route_groups)
        if transition_routes is not None:
            pulumi.set(__self__, "transition_routes", transition_routes)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The human-readable name of the page, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="entryFulfillment")
    def entry_fulfillment(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs']]:
        """
        The fulfillment to call when the session is entering the page.
        """
        return pulumi.get(self, "entry_fulfillment")

    @entry_fulfillment.setter
    def entry_fulfillment(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs']]):
        pulumi.set(self, "entry_fulfillment", value)

    @property
    @pulumi.getter(name="eventHandlers")
    def event_handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3EventHandlerArgs']]]]:
        """
        Handlers associated with the page to handle events such as webhook errors, no match or no input.
        """
        return pulumi.get(self, "event_handlers")

    @event_handlers.setter
    def event_handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3EventHandlerArgs']]]]):
        pulumi.set(self, "event_handlers", value)

    @property
    @pulumi.getter
    def form(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3FormArgs']]:
        """
        The form associated with the page, used for collecting parameters relevant to the page.
        """
        return pulumi.get(self, "form")

    @form.setter
    def form(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3FormArgs']]):
        pulumi.set(self, "form", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the page. Required for the Pages.UpdatePage method. Pages.CreatePage populates the name automatically. Format: `projects//locations//agents//flows//pages/`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="transitionRouteGroups")
    def transition_route_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Ordered list of `TransitionRouteGroups` associated with the page. Transition route groups must be unique within a page. * If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route -> page's transition route group -> flow's transition routes. * If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence. Format:`projects//locations//agents//flows//transitionRouteGroups/`.
        """
        return pulumi.get(self, "transition_route_groups")

    @transition_route_groups.setter
    def transition_route_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "transition_route_groups", value)

    @property
    @pulumi.getter(name="transitionRoutes")
    def transition_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3TransitionRouteArgs']]]]:
        """
        A list of transitions for the transition rules of this page. They route the conversation to another page in the same flow, or another flow. When we are in a certain page, the TransitionRoutes are evalauted in the following order: * TransitionRoutes defined in the page with intent specified. * TransitionRoutes defined in the transition route groups with intent specified. * TransitionRoutes defined in flow with intent specified. * TransitionRoutes defined in the transition route groups with intent specified. * TransitionRoutes defined in the page with only condition specified. * TransitionRoutes defined in the transition route groups with only condition specified.
        """
        return pulumi.get(self, "transition_routes")

    @transition_routes.setter
    def transition_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3TransitionRouteArgs']]]]):
        pulumi.set(self, "transition_routes", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3QueryInputArgs:
    def __init__(__self__, *,
                 language_code: pulumi.Input[str],
                 audio: Optional[pulumi.Input['GoogleCloudDialogflowCxV3AudioInputArgs']] = None,
                 dtmf: Optional[pulumi.Input['GoogleCloudDialogflowCxV3DtmfInputArgs']] = None,
                 event: Optional[pulumi.Input['GoogleCloudDialogflowCxV3EventInputArgs']] = None,
                 intent: Optional[pulumi.Input['GoogleCloudDialogflowCxV3IntentInputArgs']] = None,
                 text: Optional[pulumi.Input['GoogleCloudDialogflowCxV3TextInputArgs']] = None):
        """
        Represents the query input. It can contain one of: 1. A conversational query in the form of text. 2. An intent query that specifies which intent to trigger. 3. Natural language speech audio to be processed. 4. An event to be triggered. 
        :param pulumi.Input[str] language_code: The language of the input. See [Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list of the currently supported language codes. Note that queries in the same session do not necessarily need to specify the same language.
        :param pulumi.Input['GoogleCloudDialogflowCxV3AudioInputArgs'] audio: The natural language speech audio to be processed.
        :param pulumi.Input['GoogleCloudDialogflowCxV3DtmfInputArgs'] dtmf: The DTMF event to be handled.
        :param pulumi.Input['GoogleCloudDialogflowCxV3EventInputArgs'] event: The event to be triggered.
        :param pulumi.Input['GoogleCloudDialogflowCxV3IntentInputArgs'] intent: The intent to be triggered.
        :param pulumi.Input['GoogleCloudDialogflowCxV3TextInputArgs'] text: The natural language text to be processed.
        """
        pulumi.set(__self__, "language_code", language_code)
        if audio is not None:
            pulumi.set(__self__, "audio", audio)
        if dtmf is not None:
            pulumi.set(__self__, "dtmf", dtmf)
        if event is not None:
            pulumi.set(__self__, "event", event)
        if intent is not None:
            pulumi.set(__self__, "intent", intent)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Input[str]:
        """
        The language of the input. See [Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list of the currently supported language codes. Note that queries in the same session do not necessarily need to specify the same language.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def audio(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3AudioInputArgs']]:
        """
        The natural language speech audio to be processed.
        """
        return pulumi.get(self, "audio")

    @audio.setter
    def audio(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3AudioInputArgs']]):
        pulumi.set(self, "audio", value)

    @property
    @pulumi.getter
    def dtmf(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3DtmfInputArgs']]:
        """
        The DTMF event to be handled.
        """
        return pulumi.get(self, "dtmf")

    @dtmf.setter
    def dtmf(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3DtmfInputArgs']]):
        pulumi.set(self, "dtmf", value)

    @property
    @pulumi.getter
    def event(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3EventInputArgs']]:
        """
        The event to be triggered.
        """
        return pulumi.get(self, "event")

    @event.setter
    def event(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3EventInputArgs']]):
        pulumi.set(self, "event", value)

    @property
    @pulumi.getter
    def intent(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3IntentInputArgs']]:
        """
        The intent to be triggered.
        """
        return pulumi.get(self, "intent")

    @intent.setter
    def intent(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3IntentInputArgs']]):
        pulumi.set(self, "intent", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3TextInputArgs']]:
        """
        The natural language text to be processed.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3TextInputArgs']]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ResponseMessageConversationSuccessArgs:
    def __init__(__self__, *,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Indicates that the conversation succeeded, i.e., the bot handled the issue that the customer talked to it about. Dialogflow only uses this to determine which conversations should be counted as successful and doesn't process the metadata in this message in any way. Note that Dialogflow also considers conversations that get to the conversation end page as successful even if they don't return ConversationSuccess. You may set this, for example: * In the entry_fulfillment of a Page if entering the page indicates that the conversation succeeded. * In a webhook response when you determine that you handled the customer issue.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Custom metadata. Dialogflow doesn't impose any structure on this.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Custom metadata. Dialogflow doesn't impose any structure on this.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoffArgs:
    def __init__(__self__, *,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Indicates that the conversation should be handed off to a live agent. Dialogflow only uses this to determine which conversations were handed off to a human agent for measurement purposes. What else to do with this signal is up to you and your handoff procedures. You may set this, for example: * In the entry_fulfillment of a Page if entering the page indicates something went extremely wrong in the conversation. * In a webhook response when you determine that the customer issue can only be handled by a human.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Custom metadata for your handoff procedure. Dialogflow doesn't impose any structure on this.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Custom metadata for your handoff procedure. Dialogflow doesn't impose any structure on this.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ResponseMessageOutputAudioTextArgs:
    def __init__(__self__, *,
                 ssml: Optional[pulumi.Input[str]] = None,
                 text: Optional[pulumi.Input[str]] = None):
        """
        A text or ssml response that is preferentially used for TTS output audio synthesis, as described in the comment on the ResponseMessage message.
        :param pulumi.Input[str] ssml: The SSML text to be synthesized. For more information, see [SSML](/speech/text-to-speech/docs/ssml).
        :param pulumi.Input[str] text: The raw text to be synthesized.
        """
        if ssml is not None:
            pulumi.set(__self__, "ssml", ssml)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def ssml(self) -> Optional[pulumi.Input[str]]:
        """
        The SSML text to be synthesized. For more information, see [SSML](/speech/text-to-speech/docs/ssml).
        """
        return pulumi.get(self, "ssml")

    @ssml.setter
    def ssml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssml", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        The raw text to be synthesized.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ResponseMessagePlayAudioArgs:
    def __init__(__self__, *,
                 audio_uri: pulumi.Input[str]):
        """
        Specifies an audio clip to be played by the client as part of the response.
        :param pulumi.Input[str] audio_uri: URI of the audio clip. Dialogflow does not impose any validation on this value. It is specific to the client that reads it.
        """
        pulumi.set(__self__, "audio_uri", audio_uri)

    @property
    @pulumi.getter(name="audioUri")
    def audio_uri(self) -> pulumi.Input[str]:
        """
        URI of the audio clip. Dialogflow does not impose any validation on this value. It is specific to the client that reads it.
        """
        return pulumi.get(self, "audio_uri")

    @audio_uri.setter
    def audio_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "audio_uri", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCallArgs:
    def __init__(__self__, *,
                 phone_number: Optional[pulumi.Input[str]] = None):
        """
        Represents the signal that telles the client to transfer the phone call connected to the agent to a third-party endpoint.
        :param pulumi.Input[str] phone_number: Transfer the call to a phone number in [E.164 format](https://en.wikipedia.org/wiki/E.164).
        """
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[str]]:
        """
        Transfer the call to a phone number in [E.164 format](https://en.wikipedia.org/wiki/E.164).
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ResponseMessageTextArgs:
    def __init__(__self__, *,
                 text: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The text response message.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] text: A collection of text responses.
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A collection of text responses.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3ResponseMessageArgs:
    def __init__(__self__, *,
                 conversation_success: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageConversationSuccessArgs']] = None,
                 live_agent_handoff: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoffArgs']] = None,
                 output_audio_text: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageOutputAudioTextArgs']] = None,
                 payload: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 play_audio: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessagePlayAudioArgs']] = None,
                 telephony_transfer_call: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCallArgs']] = None,
                 text: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageTextArgs']] = None):
        """
        Represents a response message that can be returned by a conversational agent. Response messages are also used for output audio synthesis. The approach is as follows: * If at least one OutputAudioText response is present, then all OutputAudioText responses are linearly concatenated, and the result is used for output audio synthesis. * If the OutputAudioText responses are a mixture of text and SSML, then the concatenated result is treated as SSML; otherwise, the result is treated as either text or SSML as appropriate. The agent designer should ideally use either text or SSML consistently throughout the bot design. * Otherwise, all Text responses are linearly concatenated, and the result is used for output audio synthesis. This approach allows for more sophisticated user experience scenarios, where the text displayed to the user may differ from what is heard.
        :param pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageConversationSuccessArgs'] conversation_success: Indicates that the conversation succeeded.
        :param pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoffArgs'] live_agent_handoff: Hands off conversation to a human agent.
        :param pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageOutputAudioTextArgs'] output_audio_text: A text or ssml response that is preferentially used for TTS output audio synthesis, as described in the comment on the ResponseMessage message.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] payload: Returns a response containing a custom, platform-specific payload.
        :param pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessagePlayAudioArgs'] play_audio: Signal that the client should play an audio clip hosted at a client-specific URI. Dialogflow uses this to construct mixed_audio. However, Dialogflow itself does not try to read or process the URI in any way.
        :param pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCallArgs'] telephony_transfer_call: A signal that the client should transfer the phone call connected to this agent to a third-party endpoint.
        :param pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageTextArgs'] text: Returns a text response.
        """
        if conversation_success is not None:
            pulumi.set(__self__, "conversation_success", conversation_success)
        if live_agent_handoff is not None:
            pulumi.set(__self__, "live_agent_handoff", live_agent_handoff)
        if output_audio_text is not None:
            pulumi.set(__self__, "output_audio_text", output_audio_text)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if play_audio is not None:
            pulumi.set(__self__, "play_audio", play_audio)
        if telephony_transfer_call is not None:
            pulumi.set(__self__, "telephony_transfer_call", telephony_transfer_call)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="conversationSuccess")
    def conversation_success(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageConversationSuccessArgs']]:
        """
        Indicates that the conversation succeeded.
        """
        return pulumi.get(self, "conversation_success")

    @conversation_success.setter
    def conversation_success(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageConversationSuccessArgs']]):
        pulumi.set(self, "conversation_success", value)

    @property
    @pulumi.getter(name="liveAgentHandoff")
    def live_agent_handoff(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoffArgs']]:
        """
        Hands off conversation to a human agent.
        """
        return pulumi.get(self, "live_agent_handoff")

    @live_agent_handoff.setter
    def live_agent_handoff(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoffArgs']]):
        pulumi.set(self, "live_agent_handoff", value)

    @property
    @pulumi.getter(name="outputAudioText")
    def output_audio_text(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageOutputAudioTextArgs']]:
        """
        A text or ssml response that is preferentially used for TTS output audio synthesis, as described in the comment on the ResponseMessage message.
        """
        return pulumi.get(self, "output_audio_text")

    @output_audio_text.setter
    def output_audio_text(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageOutputAudioTextArgs']]):
        pulumi.set(self, "output_audio_text", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Returns a response containing a custom, platform-specific payload.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="playAudio")
    def play_audio(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessagePlayAudioArgs']]:
        """
        Signal that the client should play an audio clip hosted at a client-specific URI. Dialogflow uses this to construct mixed_audio. However, Dialogflow itself does not try to read or process the URI in any way.
        """
        return pulumi.get(self, "play_audio")

    @play_audio.setter
    def play_audio(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessagePlayAudioArgs']]):
        pulumi.set(self, "play_audio", value)

    @property
    @pulumi.getter(name="telephonyTransferCall")
    def telephony_transfer_call(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCallArgs']]:
        """
        A signal that the client should transfer the phone call connected to this agent to a third-party endpoint.
        """
        return pulumi.get(self, "telephony_transfer_call")

    @telephony_transfer_call.setter
    def telephony_transfer_call(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCallArgs']]):
        pulumi.set(self, "telephony_transfer_call", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageTextArgs']]:
        """
        Returns a text response.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3ResponseMessageTextArgs']]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3RolloutConfigRolloutStepArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 min_duration: Optional[pulumi.Input[str]] = None,
                 traffic_percent: Optional[pulumi.Input[int]] = None):
        """
        A single rollout step with specified traffic allocation.
        :param pulumi.Input[str] display_name: The name of the rollout step;
        :param pulumi.Input[str] min_duration: The minimum time that this step should last. Should be longer than 1 hour. If not set, the default minimum duration for each step will be 1 hour.
        :param pulumi.Input[int] traffic_percent: The percentage of traffic allocated to the flow version of this rollout step. (0%, 100%].
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if min_duration is not None:
            pulumi.set(__self__, "min_duration", min_duration)
        if traffic_percent is not None:
            pulumi.set(__self__, "traffic_percent", traffic_percent)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rollout step;
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="minDuration")
    def min_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum time that this step should last. Should be longer than 1 hour. If not set, the default minimum duration for each step will be 1 hour.
        """
        return pulumi.get(self, "min_duration")

    @min_duration.setter
    def min_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_duration", value)

    @property
    @pulumi.getter(name="trafficPercent")
    def traffic_percent(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of traffic allocated to the flow version of this rollout step. (0%, 100%].
        """
        return pulumi.get(self, "traffic_percent")

    @traffic_percent.setter
    def traffic_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "traffic_percent", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3RolloutConfigArgs:
    def __init__(__self__, *,
                 failure_condition: Optional[pulumi.Input[str]] = None,
                 rollout_condition: Optional[pulumi.Input[str]] = None,
                 rollout_steps: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3RolloutConfigRolloutStepArgs']]]] = None):
        """
        The configuration for auto rollout.
        :param pulumi.Input[str] failure_condition: The conditions that are used to evaluate the failure of a rollout step. If not specified, no rollout steps will fail. E.g. "containment_rate < 10% OR average_turn_count < 3". See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
        :param pulumi.Input[str] rollout_condition: The conditions that are used to evaluate the success of a rollout step. If not specified, all rollout steps will proceed to the next one unless failure conditions are met. E.g. "containment_rate > 60% AND callback_rate < 20%". See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3RolloutConfigRolloutStepArgs']]] rollout_steps: Steps to roll out a flow version. Steps should be sorted by percentage in ascending order.
        """
        if failure_condition is not None:
            pulumi.set(__self__, "failure_condition", failure_condition)
        if rollout_condition is not None:
            pulumi.set(__self__, "rollout_condition", rollout_condition)
        if rollout_steps is not None:
            pulumi.set(__self__, "rollout_steps", rollout_steps)

    @property
    @pulumi.getter(name="failureCondition")
    def failure_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The conditions that are used to evaluate the failure of a rollout step. If not specified, no rollout steps will fail. E.g. "containment_rate < 10% OR average_turn_count < 3". See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
        """
        return pulumi.get(self, "failure_condition")

    @failure_condition.setter
    def failure_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failure_condition", value)

    @property
    @pulumi.getter(name="rolloutCondition")
    def rollout_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The conditions that are used to evaluate the success of a rollout step. If not specified, all rollout steps will proceed to the next one unless failure conditions are met. E.g. "containment_rate > 60% AND callback_rate < 20%". See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
        """
        return pulumi.get(self, "rollout_condition")

    @rollout_condition.setter
    def rollout_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rollout_condition", value)

    @property
    @pulumi.getter(name="rolloutSteps")
    def rollout_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3RolloutConfigRolloutStepArgs']]]]:
        """
        Steps to roll out a flow version. Steps should be sorted by percentage in ascending order.
        """
        return pulumi.get(self, "rollout_steps")

    @rollout_steps.setter
    def rollout_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3RolloutConfigRolloutStepArgs']]]]):
        pulumi.set(self, "rollout_steps", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3RolloutStateArgs:
    def __init__(__self__, *,
                 start_time: Optional[pulumi.Input[str]] = None,
                 step: Optional[pulumi.Input[str]] = None,
                 step_index: Optional[pulumi.Input[int]] = None):
        """
        State of the auto-rollout process.
        :param pulumi.Input[str] start_time: Start time of the current step.
        :param pulumi.Input[str] step: Display name of the current auto rollout step.
        :param pulumi.Input[int] step_index: Index of the current step in the auto rollout steps list.
        """
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if step_index is not None:
            pulumi.set(__self__, "step_index", step_index)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Start time of the current step.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def step(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the current auto rollout step.
        """
        return pulumi.get(self, "step")

    @step.setter
    def step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step", value)

    @property
    @pulumi.getter(name="stepIndex")
    def step_index(self) -> Optional[pulumi.Input[int]]:
        """
        Index of the current step in the auto rollout steps list.
        """
        return pulumi.get(self, "step_index")

    @step_index.setter
    def step_index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "step_index", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3SecuritySettingsInsightsExportSettingsArgs:
    def __init__(__self__, *,
                 enable_insights_export: Optional[pulumi.Input[bool]] = None):
        """
        Settings for exporting conversations to [Insights](https://cloud.google.com/contact-center/insights/docs).
        :param pulumi.Input[bool] enable_insights_export: If enabled, we will automatically exports conversations to Insights and Insights runs its analyzers.
        """
        if enable_insights_export is not None:
            pulumi.set(__self__, "enable_insights_export", enable_insights_export)

    @property
    @pulumi.getter(name="enableInsightsExport")
    def enable_insights_export(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled, we will automatically exports conversations to Insights and Insights runs its analyzers.
        """
        return pulumi.get(self, "enable_insights_export")

    @enable_insights_export.setter
    def enable_insights_export(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_insights_export", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3SpeechToTextSettingsArgs:
    def __init__(__self__, *,
                 enable_speech_adaptation: Optional[pulumi.Input[bool]] = None):
        """
        Settings related to speech recognition.
        :param pulumi.Input[bool] enable_speech_adaptation: Whether to use speech adaptation for speech recognition.
        """
        if enable_speech_adaptation is not None:
            pulumi.set(__self__, "enable_speech_adaptation", enable_speech_adaptation)

    @property
    @pulumi.getter(name="enableSpeechAdaptation")
    def enable_speech_adaptation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use speech adaptation for speech recognition.
        """
        return pulumi.get(self, "enable_speech_adaptation")

    @enable_speech_adaptation.setter
    def enable_speech_adaptation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_speech_adaptation", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3TestCaseResultArgs:
    def __init__(__self__, *,
                 conversation_turns: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ConversationTurnArgs']]]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 test_result: Optional[pulumi.Input['GoogleCloudDialogflowCxV3TestCaseResultTestResult']] = None,
                 test_time: Optional[pulumi.Input[str]] = None):
        """
        Represents a result from running a test case in an agent environment.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ConversationTurnArgs']]] conversation_turns: The conversation turns uttered during the test case replay in chronological order.
        :param pulumi.Input[str] environment: Environment where the test was run. If not set, it indicates the draft environment.
        :param pulumi.Input[str] name: The resource name for the test case result. Format: `projects//locations//agents//testCases/ /results/`.
        :param pulumi.Input['GoogleCloudDialogflowCxV3TestCaseResultTestResult'] test_result: Whether the test case passed in the agent environment.
        :param pulumi.Input[str] test_time: The time that the test was run.
        """
        if conversation_turns is not None:
            pulumi.set(__self__, "conversation_turns", conversation_turns)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if test_result is not None:
            pulumi.set(__self__, "test_result", test_result)
        if test_time is not None:
            pulumi.set(__self__, "test_time", test_time)

    @property
    @pulumi.getter(name="conversationTurns")
    def conversation_turns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ConversationTurnArgs']]]]:
        """
        The conversation turns uttered during the test case replay in chronological order.
        """
        return pulumi.get(self, "conversation_turns")

    @conversation_turns.setter
    def conversation_turns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3ConversationTurnArgs']]]]):
        pulumi.set(self, "conversation_turns", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        Environment where the test was run. If not set, it indicates the draft environment.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for the test case result. Format: `projects//locations//agents//testCases/ /results/`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="testResult")
    def test_result(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3TestCaseResultTestResult']]:
        """
        Whether the test case passed in the agent environment.
        """
        return pulumi.get(self, "test_result")

    @test_result.setter
    def test_result(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3TestCaseResultTestResult']]):
        pulumi.set(self, "test_result", value)

    @property
    @pulumi.getter(name="testTime")
    def test_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the test was run.
        """
        return pulumi.get(self, "test_time")

    @test_time.setter
    def test_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_time", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3TestConfigArgs:
    def __init__(__self__, *,
                 flow: Optional[pulumi.Input[str]] = None,
                 page: Optional[pulumi.Input[str]] = None,
                 tracking_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents configurations for a test case.
        :param pulumi.Input[str] flow: Flow name to start the test case with. Format: `projects//locations//agents//flows/`. Only one of `flow` and `page` should be set to indicate the starting point of the test case. If both are set, `page` takes precedence over `flow`. If neither is set, the test case will start with start page on the default start flow.
        :param pulumi.Input[str] page: The page to start the test case with. Format: `projects//locations//agents//flows//pages/`. Only one of `flow` and `page` should be set to indicate the starting point of the test case. If both are set, `page` takes precedence over `flow`. If neither is set, the test case will start with start page on the default start flow.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tracking_parameters: Session parameters to be compared when calculating differences.
        """
        if flow is not None:
            pulumi.set(__self__, "flow", flow)
        if page is not None:
            pulumi.set(__self__, "page", page)
        if tracking_parameters is not None:
            pulumi.set(__self__, "tracking_parameters", tracking_parameters)

    @property
    @pulumi.getter
    def flow(self) -> Optional[pulumi.Input[str]]:
        """
        Flow name to start the test case with. Format: `projects//locations//agents//flows/`. Only one of `flow` and `page` should be set to indicate the starting point of the test case. If both are set, `page` takes precedence over `flow`. If neither is set, the test case will start with start page on the default start flow.
        """
        return pulumi.get(self, "flow")

    @flow.setter
    def flow(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flow", value)

    @property
    @pulumi.getter
    def page(self) -> Optional[pulumi.Input[str]]:
        """
        The page to start the test case with. Format: `projects//locations//agents//flows//pages/`. Only one of `flow` and `page` should be set to indicate the starting point of the test case. If both are set, `page` takes precedence over `flow`. If neither is set, the test case will start with start page on the default start flow.
        """
        return pulumi.get(self, "page")

    @page.setter
    def page(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "page", value)

    @property
    @pulumi.getter(name="trackingParameters")
    def tracking_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Session parameters to be compared when calculating differences.
        """
        return pulumi.get(self, "tracking_parameters")

    @tracking_parameters.setter
    def tracking_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tracking_parameters", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3TextInputArgs:
    def __init__(__self__, *,
                 text: pulumi.Input[str]):
        """
        Represents the natural language text to be processed.
        :param pulumi.Input[str] text: The UTF-8 encoded natural language text to be processed. Text length must not exceed 256 characters.
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> pulumi.Input[str]:
        """
        The UTF-8 encoded natural language text to be processed. Text length must not exceed 256 characters.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: pulumi.Input[str]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3TransitionRouteArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input[str]] = None,
                 intent: Optional[pulumi.Input[str]] = None,
                 target_flow: Optional[pulumi.Input[str]] = None,
                 target_page: Optional[pulumi.Input[str]] = None,
                 trigger_fulfillment: Optional[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs']] = None):
        """
        A transition route specifies a intent that can be matched and/or a data condition that can be evaluated during a session. When a specified transition is matched, the following actions are taken in order: * If there is a `trigger_fulfillment` associated with the transition, it will be called. * If there is a `target_page` associated with the transition, the session will transition into the specified page. * If there is a `target_flow` associated with the transition, the session will transition into the specified flow.
        :param pulumi.Input[str] condition: The condition to evaluate against form parameters or session parameters. See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition). At least one of `intent` or `condition` must be specified. When both `intent` and `condition` are specified, the transition can only happen when both are fulfilled.
        :param pulumi.Input[str] intent: The unique identifier of an Intent. Format: `projects//locations//agents//intents/`. Indicates that the transition can only happen when the given intent is matched. At least one of `intent` or `condition` must be specified. When both `intent` and `condition` are specified, the transition can only happen when both are fulfilled.
        :param pulumi.Input[str] target_flow: The target flow to transition to. Format: `projects//locations//agents//flows/`.
        :param pulumi.Input[str] target_page: The target page to transition to. Format: `projects//locations//agents//flows//pages/`.
        :param pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs'] trigger_fulfillment: The fulfillment to call when the condition is satisfied. At least one of `trigger_fulfillment` and `target` must be specified. When both are defined, `trigger_fulfillment` is executed first.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if intent is not None:
            pulumi.set(__self__, "intent", intent)
        if target_flow is not None:
            pulumi.set(__self__, "target_flow", target_flow)
        if target_page is not None:
            pulumi.set(__self__, "target_page", target_page)
        if trigger_fulfillment is not None:
            pulumi.set(__self__, "trigger_fulfillment", trigger_fulfillment)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        The condition to evaluate against form parameters or session parameters. See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition). At least one of `intent` or `condition` must be specified. When both `intent` and `condition` are specified, the transition can only happen when both are fulfilled.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def intent(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of an Intent. Format: `projects//locations//agents//intents/`. Indicates that the transition can only happen when the given intent is matched. At least one of `intent` or `condition` must be specified. When both `intent` and `condition` are specified, the transition can only happen when both are fulfilled.
        """
        return pulumi.get(self, "intent")

    @intent.setter
    def intent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intent", value)

    @property
    @pulumi.getter(name="targetFlow")
    def target_flow(self) -> Optional[pulumi.Input[str]]:
        """
        The target flow to transition to. Format: `projects//locations//agents//flows/`.
        """
        return pulumi.get(self, "target_flow")

    @target_flow.setter
    def target_flow(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_flow", value)

    @property
    @pulumi.getter(name="targetPage")
    def target_page(self) -> Optional[pulumi.Input[str]]:
        """
        The target page to transition to. Format: `projects//locations//agents//flows//pages/`.
        """
        return pulumi.get(self, "target_page")

    @target_page.setter
    def target_page(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_page", value)

    @property
    @pulumi.getter(name="triggerFulfillment")
    def trigger_fulfillment(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs']]:
        """
        The fulfillment to call when the condition is satisfied. At least one of `trigger_fulfillment` and `target` must be specified. When both are defined, `trigger_fulfillment` is executed first.
        """
        return pulumi.get(self, "trigger_fulfillment")

    @trigger_fulfillment.setter
    def trigger_fulfillment(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3FulfillmentArgs']]):
        pulumi.set(self, "trigger_fulfillment", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3VariantsHistoryArgs:
    def __init__(__self__, *,
                 update_time: Optional[pulumi.Input[str]] = None,
                 version_variants: Optional[pulumi.Input['GoogleCloudDialogflowCxV3VersionVariantsArgs']] = None):
        """
        The history of variants update.
        :param pulumi.Input[str] update_time: Update time of the variants.
        :param pulumi.Input['GoogleCloudDialogflowCxV3VersionVariantsArgs'] version_variants: The flow versions as the variants.
        """
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if version_variants is not None:
            pulumi.set(__self__, "version_variants", version_variants)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Update time of the variants.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="versionVariants")
    def version_variants(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3VersionVariantsArgs']]:
        """
        The flow versions as the variants.
        """
        return pulumi.get(self, "version_variants")

    @version_variants.setter
    def version_variants(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3VersionVariantsArgs']]):
        pulumi.set(self, "version_variants", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3VersionVariantsVariantArgs:
    def __init__(__self__, *,
                 is_control_group: Optional[pulumi.Input[bool]] = None,
                 traffic_allocation: Optional[pulumi.Input[float]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        A single flow version with specified traffic allocation.
        :param pulumi.Input[bool] is_control_group: Whether the variant is for the control group.
        :param pulumi.Input[float] traffic_allocation: Percentage of the traffic which should be routed to this version of flow. Traffic allocation for a single flow must sum up to 1.0.
        :param pulumi.Input[str] version: The name of the flow version. Format: `projects//locations//agents//flows//versions/`.
        """
        if is_control_group is not None:
            pulumi.set(__self__, "is_control_group", is_control_group)
        if traffic_allocation is not None:
            pulumi.set(__self__, "traffic_allocation", traffic_allocation)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="isControlGroup")
    def is_control_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the variant is for the control group.
        """
        return pulumi.get(self, "is_control_group")

    @is_control_group.setter
    def is_control_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_control_group", value)

    @property
    @pulumi.getter(name="trafficAllocation")
    def traffic_allocation(self) -> Optional[pulumi.Input[float]]:
        """
        Percentage of the traffic which should be routed to this version of flow. Traffic allocation for a single flow must sum up to 1.0.
        """
        return pulumi.get(self, "traffic_allocation")

    @traffic_allocation.setter
    def traffic_allocation(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "traffic_allocation", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the flow version. Format: `projects//locations//agents//flows//versions/`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3VersionVariantsArgs:
    def __init__(__self__, *,
                 variants: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3VersionVariantsVariantArgs']]]] = None):
        """
        A list of flow version variants.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3VersionVariantsVariantArgs']]] variants: A list of flow version variants.
        """
        if variants is not None:
            pulumi.set(__self__, "variants", variants)

    @property
    @pulumi.getter
    def variants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3VersionVariantsVariantArgs']]]]:
        """
        A list of flow version variants.
        """
        return pulumi.get(self, "variants")

    @variants.setter
    def variants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowCxV3VersionVariantsVariantArgs']]]]):
        pulumi.set(self, "variants", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3WebhookGenericWebServiceArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str],
                 allowed_ca_certs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 request_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Represents configuration for a generic web service.
        :param pulumi.Input[str] uri: The webhook URI for receiving POST requests. It must use https protocol.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_ca_certs: Optional. Specifies a list of allowed custom CA certificates (in DER format) for HTTPS verification. This overrides the default SSL trust store. If this is empty or unspecified, Dialogflow will use Google's default trust store to verify certificates. N.B. Make sure the HTTPS server certificates are signed with "subject alt name". For instance a certificate can be self-signed using the following command, openssl x509 -req -days 200 -in example.com.csr \ -signkey example.com.key \ -out example.com.crt \ -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
        :param pulumi.Input[str] password: The password for HTTP Basic authentication.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] request_headers: The HTTP request headers to send together with webhook requests.
        :param pulumi.Input[str] username: The user name for HTTP Basic authentication.
        """
        pulumi.set(__self__, "uri", uri)
        if allowed_ca_certs is not None:
            pulumi.set(__self__, "allowed_ca_certs", allowed_ca_certs)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The webhook URI for receiving POST requests. It must use https protocol.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter(name="allowedCaCerts")
    def allowed_ca_certs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Specifies a list of allowed custom CA certificates (in DER format) for HTTPS verification. This overrides the default SSL trust store. If this is empty or unspecified, Dialogflow will use Google's default trust store to verify certificates. N.B. Make sure the HTTPS server certificates are signed with "subject alt name". For instance a certificate can be self-signed using the following command, openssl x509 -req -days 200 -in example.com.csr \ -signkey example.com.key \ -out example.com.crt \ -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
        """
        return pulumi.get(self, "allowed_ca_certs")

    @allowed_ca_certs.setter
    def allowed_ca_certs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_ca_certs", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for HTTP Basic authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The HTTP request headers to send together with webhook requests.
        """
        return pulumi.get(self, "request_headers")

    @request_headers.setter
    def request_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "request_headers", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The user name for HTTP Basic authentication.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfigArgs:
    def __init__(__self__, *,
                 service: pulumi.Input[str],
                 generic_web_service: Optional[pulumi.Input['GoogleCloudDialogflowCxV3WebhookGenericWebServiceArgs']] = None):
        """
        Represents configuration for a [Service Directory](https://cloud.google.com/service-directory) service.
        :param pulumi.Input[str] service: The name of [Service Directory](https://cloud.google.com/service-directory) service. Format: `projects//locations//namespaces//services/`. `Location ID` of the service directory must be the same as the location of the agent.
        :param pulumi.Input['GoogleCloudDialogflowCxV3WebhookGenericWebServiceArgs'] generic_web_service: Generic Service configuration of this webhook.
        """
        pulumi.set(__self__, "service", service)
        if generic_web_service is not None:
            pulumi.set(__self__, "generic_web_service", generic_web_service)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        The name of [Service Directory](https://cloud.google.com/service-directory) service. Format: `projects//locations//namespaces//services/`. `Location ID` of the service directory must be the same as the location of the agent.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="genericWebService")
    def generic_web_service(self) -> Optional[pulumi.Input['GoogleCloudDialogflowCxV3WebhookGenericWebServiceArgs']]:
        """
        Generic Service configuration of this webhook.
        """
        return pulumi.get(self, "generic_web_service")

    @generic_web_service.setter
    def generic_web_service(self, value: Optional[pulumi.Input['GoogleCloudDialogflowCxV3WebhookGenericWebServiceArgs']]):
        pulumi.set(self, "generic_web_service", value)


@pulumi.input_type
class GoogleRpcStatusArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param pulumi.Input[int] code: The status code, which should be an enum value of google.rpc.Code.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param pulumi.Input[str] message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


