# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsResponse',
    'GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsResponse',
    'GoogleCloudDataplexV1AssetDiscoverySpecResponse',
    'GoogleCloudDataplexV1AssetDiscoveryStatusResponse',
    'GoogleCloudDataplexV1AssetDiscoveryStatusStatsResponse',
    'GoogleCloudDataplexV1AssetResourceSpecResponse',
    'GoogleCloudDataplexV1AssetResourceStatusResponse',
    'GoogleCloudDataplexV1AssetSecurityStatusResponse',
    'GoogleCloudDataplexV1AssetStatusResponse',
    'GoogleCloudDataplexV1ContentNotebookResponse',
    'GoogleCloudDataplexV1ContentSqlScriptResponse',
    'GoogleCloudDataplexV1EntityCompatibilityStatusCompatibilityResponse',
    'GoogleCloudDataplexV1EntityCompatibilityStatusResponse',
    'GoogleCloudDataplexV1EnvironmentEndpointsResponse',
    'GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesResponse',
    'GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeResponse',
    'GoogleCloudDataplexV1EnvironmentInfrastructureSpecResponse',
    'GoogleCloudDataplexV1EnvironmentSessionSpecResponse',
    'GoogleCloudDataplexV1EnvironmentSessionStatusResponse',
    'GoogleCloudDataplexV1LakeMetastoreResponse',
    'GoogleCloudDataplexV1LakeMetastoreStatusResponse',
    'GoogleCloudDataplexV1SchemaPartitionFieldResponse',
    'GoogleCloudDataplexV1SchemaResponse',
    'GoogleCloudDataplexV1SchemaSchemaFieldResponse',
    'GoogleCloudDataplexV1StorageFormatCsvOptionsResponse',
    'GoogleCloudDataplexV1StorageFormatJsonOptionsResponse',
    'GoogleCloudDataplexV1StorageFormatResponse',
    'GoogleCloudDataplexV1TaskExecutionSpecResponse',
    'GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesResponse',
    'GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeResponse',
    'GoogleCloudDataplexV1TaskInfrastructureSpecResponse',
    'GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkResponse',
    'GoogleCloudDataplexV1TaskSparkTaskConfigResponse',
    'GoogleCloudDataplexV1TaskTriggerSpecResponse',
    'GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsResponse',
    'GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsResponse',
    'GoogleCloudDataplexV1ZoneDiscoverySpecResponse',
    'GoogleCloudDataplexV1ZoneResourceSpecResponse',
    'GoogleIamV1AuditConfigResponse',
    'GoogleIamV1AuditLogConfigResponse',
    'GoogleIamV1BindingResponse',
    'GoogleTypeExprResponse',
]

@pulumi.output_type
class GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsResponse(dict):
    """
    Describe CSV and similar semi-structured data formats.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableTypeInference":
            suggest = "disable_type_inference"
        elif key == "headerRows":
            suggest = "header_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delimiter: str,
                 disable_type_inference: bool,
                 encoding: str,
                 header_rows: int):
        """
        Describe CSV and similar semi-structured data formats.
        :param str delimiter: Optional. The delimiter being used to separate values. This defaults to ','.
        :param bool disable_type_inference: Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
        :param str encoding: Optional. The character encoding of the data. The default is UTF-8.
        :param int header_rows: Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
        """
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "disable_type_inference", disable_type_inference)
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "header_rows", header_rows)

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        Optional. The delimiter being used to separate values. This defaults to ','.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="disableTypeInference")
    def disable_type_inference(self) -> bool:
        """
        Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
        """
        return pulumi.get(self, "disable_type_inference")

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        Optional. The character encoding of the data. The default is UTF-8.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="headerRows")
    def header_rows(self) -> int:
        """
        Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
        """
        return pulumi.get(self, "header_rows")


@pulumi.output_type
class GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsResponse(dict):
    """
    Describe JSON data format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableTypeInference":
            suggest = "disable_type_inference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_type_inference: bool,
                 encoding: str):
        """
        Describe JSON data format.
        :param bool disable_type_inference: Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
        :param str encoding: Optional. The character encoding of the data. The default is UTF-8.
        """
        pulumi.set(__self__, "disable_type_inference", disable_type_inference)
        pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter(name="disableTypeInference")
    def disable_type_inference(self) -> bool:
        """
        Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
        """
        return pulumi.get(self, "disable_type_inference")

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        Optional. The character encoding of the data. The default is UTF-8.
        """
        return pulumi.get(self, "encoding")


@pulumi.output_type
class GoogleCloudDataplexV1AssetDiscoverySpecResponse(dict):
    """
    Settings to manage the metadata discovery and publishing for an asset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "csvOptions":
            suggest = "csv_options"
        elif key == "excludePatterns":
            suggest = "exclude_patterns"
        elif key == "includePatterns":
            suggest = "include_patterns"
        elif key == "jsonOptions":
            suggest = "json_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1AssetDiscoverySpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1AssetDiscoverySpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1AssetDiscoverySpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 csv_options: 'outputs.GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsResponse',
                 enabled: bool,
                 exclude_patterns: Sequence[str],
                 include_patterns: Sequence[str],
                 json_options: 'outputs.GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsResponse',
                 schedule: str):
        """
        Settings to manage the metadata discovery and publishing for an asset.
        :param 'GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsResponse' csv_options: Optional. Configuration for CSV data.
        :param bool enabled: Optional. Whether discovery is enabled.
        :param Sequence[str] exclude_patterns: Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        :param Sequence[str] include_patterns: Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        :param 'GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsResponse' json_options: Optional. Configuration for Json data.
        :param str schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
        """
        pulumi.set(__self__, "csv_options", csv_options)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "exclude_patterns", exclude_patterns)
        pulumi.set(__self__, "include_patterns", include_patterns)
        pulumi.set(__self__, "json_options", json_options)
        pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter(name="csvOptions")
    def csv_options(self) -> 'outputs.GoogleCloudDataplexV1AssetDiscoverySpecCsvOptionsResponse':
        """
        Optional. Configuration for CSV data.
        """
        return pulumi.get(self, "csv_options")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Optional. Whether discovery is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="excludePatterns")
    def exclude_patterns(self) -> Sequence[str]:
        """
        Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        """
        return pulumi.get(self, "exclude_patterns")

    @property
    @pulumi.getter(name="includePatterns")
    def include_patterns(self) -> Sequence[str]:
        """
        Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        """
        return pulumi.get(self, "include_patterns")

    @property
    @pulumi.getter(name="jsonOptions")
    def json_options(self) -> 'outputs.GoogleCloudDataplexV1AssetDiscoverySpecJsonOptionsResponse':
        """
        Optional. Configuration for Json data.
        """
        return pulumi.get(self, "json_options")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class GoogleCloudDataplexV1AssetDiscoveryStatusResponse(dict):
    """
    Status of discovery for an asset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastRunDuration":
            suggest = "last_run_duration"
        elif key == "lastRunTime":
            suggest = "last_run_time"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1AssetDiscoveryStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1AssetDiscoveryStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1AssetDiscoveryStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_run_duration: str,
                 last_run_time: str,
                 message: str,
                 state: str,
                 stats: 'outputs.GoogleCloudDataplexV1AssetDiscoveryStatusStatsResponse',
                 update_time: str):
        """
        Status of discovery for an asset.
        :param str last_run_duration: The duration of the last discovery run.
        :param str last_run_time: The start time of the last discovery run.
        :param str message: Additional information about the current state.
        :param str state: The current status of the discovery feature.
        :param 'GoogleCloudDataplexV1AssetDiscoveryStatusStatsResponse' stats: Data Stats of the asset reported by discovery.
        :param str update_time: Last update time of the status.
        """
        pulumi.set(__self__, "last_run_duration", last_run_duration)
        pulumi.set(__self__, "last_run_time", last_run_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "stats", stats)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="lastRunDuration")
    def last_run_duration(self) -> str:
        """
        The duration of the last discovery run.
        """
        return pulumi.get(self, "last_run_duration")

    @property
    @pulumi.getter(name="lastRunTime")
    def last_run_time(self) -> str:
        """
        The start time of the last discovery run.
        """
        return pulumi.get(self, "last_run_time")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Additional information about the current state.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current status of the discovery feature.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def stats(self) -> 'outputs.GoogleCloudDataplexV1AssetDiscoveryStatusStatsResponse':
        """
        Data Stats of the asset reported by discovery.
        """
        return pulumi.get(self, "stats")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Last update time of the status.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GoogleCloudDataplexV1AssetDiscoveryStatusStatsResponse(dict):
    """
    The aggregated data statistics for the asset reported by discovery.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataItems":
            suggest = "data_items"
        elif key == "dataSize":
            suggest = "data_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1AssetDiscoveryStatusStatsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1AssetDiscoveryStatusStatsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1AssetDiscoveryStatusStatsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_items: str,
                 data_size: str,
                 filesets: str,
                 tables: str):
        """
        The aggregated data statistics for the asset reported by discovery.
        :param str data_items: The count of data items within the referenced resource.
        :param str data_size: The number of stored data bytes within the referenced resource.
        :param str filesets: The count of fileset entities within the referenced resource.
        :param str tables: The count of table entities within the referenced resource.
        """
        pulumi.set(__self__, "data_items", data_items)
        pulumi.set(__self__, "data_size", data_size)
        pulumi.set(__self__, "filesets", filesets)
        pulumi.set(__self__, "tables", tables)

    @property
    @pulumi.getter(name="dataItems")
    def data_items(self) -> str:
        """
        The count of data items within the referenced resource.
        """
        return pulumi.get(self, "data_items")

    @property
    @pulumi.getter(name="dataSize")
    def data_size(self) -> str:
        """
        The number of stored data bytes within the referenced resource.
        """
        return pulumi.get(self, "data_size")

    @property
    @pulumi.getter
    def filesets(self) -> str:
        """
        The count of fileset entities within the referenced resource.
        """
        return pulumi.get(self, "filesets")

    @property
    @pulumi.getter
    def tables(self) -> str:
        """
        The count of table entities within the referenced resource.
        """
        return pulumi.get(self, "tables")


@pulumi.output_type
class GoogleCloudDataplexV1AssetResourceSpecResponse(dict):
    """
    Identifies the cloud resource that is referenced by this asset.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        Identifies the cloud resource that is referenced by this asset.
        :param str name: Immutable. Relative name of the cloud resource that contains the data that is being managed within a lake. For example: projects/{project_number}/buckets/{bucket_id} projects/{project_number}/datasets/{dataset_id}
        :param str type: Immutable. Type of resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. Relative name of the cloud resource that contains the data that is being managed within a lake. For example: projects/{project_number}/buckets/{bucket_id} projects/{project_number}/datasets/{dataset_id}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Immutable. Type of resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDataplexV1AssetResourceStatusResponse(dict):
    """
    Status of the resource referenced by an asset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1AssetResourceStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1AssetResourceStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1AssetResourceStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: str,
                 state: str,
                 update_time: str):
        """
        Status of the resource referenced by an asset.
        :param str message: Additional information about the current state.
        :param str state: The current state of the managed resource.
        :param str update_time: Last update time of the status.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Additional information about the current state.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the managed resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Last update time of the status.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GoogleCloudDataplexV1AssetSecurityStatusResponse(dict):
    """
    Security policy status of the asset. Data security policy, i.e., readers, writers & owners, should be specified in the lake/zone/asset IAM policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1AssetSecurityStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1AssetSecurityStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1AssetSecurityStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: str,
                 state: str,
                 update_time: str):
        """
        Security policy status of the asset. Data security policy, i.e., readers, writers & owners, should be specified in the lake/zone/asset IAM policy.
        :param str message: Additional information about the current state.
        :param str state: The current state of the security policy applied to the attached resource.
        :param str update_time: Last update time of the status.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Additional information about the current state.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the security policy applied to the attached resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Last update time of the status.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GoogleCloudDataplexV1AssetStatusResponse(dict):
    """
    Aggregated status of the underlying assets of a lake or zone.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeAssets":
            suggest = "active_assets"
        elif key == "securityPolicyApplyingAssets":
            suggest = "security_policy_applying_assets"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1AssetStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1AssetStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1AssetStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_assets: int,
                 security_policy_applying_assets: int,
                 update_time: str):
        """
        Aggregated status of the underlying assets of a lake or zone.
        :param int active_assets: Number of active assets.
        :param int security_policy_applying_assets: Number of assets that are in process of updating the security policy on attached resources.
        :param str update_time: Last update time of the status.
        """
        pulumi.set(__self__, "active_assets", active_assets)
        pulumi.set(__self__, "security_policy_applying_assets", security_policy_applying_assets)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="activeAssets")
    def active_assets(self) -> int:
        """
        Number of active assets.
        """
        return pulumi.get(self, "active_assets")

    @property
    @pulumi.getter(name="securityPolicyApplyingAssets")
    def security_policy_applying_assets(self) -> int:
        """
        Number of assets that are in process of updating the security policy on attached resources.
        """
        return pulumi.get(self, "security_policy_applying_assets")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Last update time of the status.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GoogleCloudDataplexV1ContentNotebookResponse(dict):
    """
    Configuration for Notebook content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kernelType":
            suggest = "kernel_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1ContentNotebookResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1ContentNotebookResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1ContentNotebookResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kernel_type: str):
        """
        Configuration for Notebook content.
        :param str kernel_type: Kernel Type of the notebook.
        """
        pulumi.set(__self__, "kernel_type", kernel_type)

    @property
    @pulumi.getter(name="kernelType")
    def kernel_type(self) -> str:
        """
        Kernel Type of the notebook.
        """
        return pulumi.get(self, "kernel_type")


@pulumi.output_type
class GoogleCloudDataplexV1ContentSqlScriptResponse(dict):
    """
    Configuration for the Sql Script content.
    """
    def __init__(__self__, *,
                 engine: str):
        """
        Configuration for the Sql Script content.
        :param str engine: Query Engine to be used for the Sql Query.
        """
        pulumi.set(__self__, "engine", engine)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Query Engine to be used for the Sql Query.
        """
        return pulumi.get(self, "engine")


@pulumi.output_type
class GoogleCloudDataplexV1EntityCompatibilityStatusCompatibilityResponse(dict):
    """
    Provides compatibility information for a specific metadata store.
    """
    def __init__(__self__, *,
                 compatible: bool,
                 reason: str):
        """
        Provides compatibility information for a specific metadata store.
        :param bool compatible: Whether the entity is compatible and can be represented in the metadata store.
        :param str reason: Provides additional detail if the entity is incompatible with the metadata store.
        """
        pulumi.set(__self__, "compatible", compatible)
        pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def compatible(self) -> bool:
        """
        Whether the entity is compatible and can be represented in the metadata store.
        """
        return pulumi.get(self, "compatible")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        Provides additional detail if the entity is incompatible with the metadata store.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class GoogleCloudDataplexV1EntityCompatibilityStatusResponse(dict):
    """
    Provides compatibility information for various metadata stores.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hiveMetastore":
            suggest = "hive_metastore"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1EntityCompatibilityStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1EntityCompatibilityStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1EntityCompatibilityStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bigquery: 'outputs.GoogleCloudDataplexV1EntityCompatibilityStatusCompatibilityResponse',
                 hive_metastore: 'outputs.GoogleCloudDataplexV1EntityCompatibilityStatusCompatibilityResponse'):
        """
        Provides compatibility information for various metadata stores.
        :param 'GoogleCloudDataplexV1EntityCompatibilityStatusCompatibilityResponse' bigquery: Whether this entity is compatible with BigQuery.
        :param 'GoogleCloudDataplexV1EntityCompatibilityStatusCompatibilityResponse' hive_metastore: Whether this entity is compatible with Hive Metastore.
        """
        pulumi.set(__self__, "bigquery", bigquery)
        pulumi.set(__self__, "hive_metastore", hive_metastore)

    @property
    @pulumi.getter
    def bigquery(self) -> 'outputs.GoogleCloudDataplexV1EntityCompatibilityStatusCompatibilityResponse':
        """
        Whether this entity is compatible with BigQuery.
        """
        return pulumi.get(self, "bigquery")

    @property
    @pulumi.getter(name="hiveMetastore")
    def hive_metastore(self) -> 'outputs.GoogleCloudDataplexV1EntityCompatibilityStatusCompatibilityResponse':
        """
        Whether this entity is compatible with Hive Metastore.
        """
        return pulumi.get(self, "hive_metastore")


@pulumi.output_type
class GoogleCloudDataplexV1EnvironmentEndpointsResponse(dict):
    def __init__(__self__, *,
                 notebooks: str,
                 sql: str):
        """
        :param str notebooks: URI to serve notebook APIs
        :param str sql: URI to serve SQL APIs
        """
        pulumi.set(__self__, "notebooks", notebooks)
        pulumi.set(__self__, "sql", sql)

    @property
    @pulumi.getter
    def notebooks(self) -> str:
        """
        URI to serve notebook APIs
        """
        return pulumi.get(self, "notebooks")

    @property
    @pulumi.getter
    def sql(self) -> str:
        """
        URI to serve SQL APIs
        """
        return pulumi.get(self, "sql")


@pulumi.output_type
class GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesResponse(dict):
    """
    Compute resources associated with the analyze interactive workloads.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "nodeCount":
            suggest = "node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: int,
                 max_node_count: int,
                 node_count: int):
        """
        Compute resources associated with the analyze interactive workloads.
        :param int disk_size_gb: Optional. Size in GB of the disk. Default is 100 GB.
        :param int max_node_count: Optional. Max configurable nodes. If max_node_count > node_count, then auto-scaling is enabled.
        :param int node_count: Optional. Total number of nodes in the sessions created for this environment.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "node_count", node_count)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> int:
        """
        Optional. Size in GB of the disk. Default is 100 GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        """
        Optional. Max configurable nodes. If max_node_count > node_count, then auto-scaling is enabled.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        Optional. Total number of nodes in the sessions created for this environment.
        """
        return pulumi.get(self, "node_count")


@pulumi.output_type
class GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeResponse(dict):
    """
    Software Runtime Configuration to run Analyze.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageVersion":
            suggest = "image_version"
        elif key == "javaLibraries":
            suggest = "java_libraries"
        elif key == "pythonPackages":
            suggest = "python_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_version: str,
                 java_libraries: Sequence[str],
                 properties: Mapping[str, str],
                 python_packages: Sequence[str]):
        """
        Software Runtime Configuration to run Analyze.
        :param str image_version: Dataplex Image version.
        :param Sequence[str] java_libraries: Optional. List of Java jars to be included in the runtime environment. Valid input includes Cloud Storage URIs to Jar binaries. For example, gs://bucket-name/my/path/to/file.jar
        :param Mapping[str, str] properties: Optional. Spark properties to provide configuration for use in sessions created for this environment. The properties to set on daemon config files. Property keys are specified in prefix:property format. The prefix must be "spark".
        :param Sequence[str] python_packages: Optional. A list of python packages to be installed. Valid formats include Cloud Storage URI to a PIP installable library. For example, gs://bucket-name/my/path/to/lib.tar.gz
        """
        pulumi.set(__self__, "image_version", image_version)
        pulumi.set(__self__, "java_libraries", java_libraries)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "python_packages", python_packages)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> str:
        """
        Dataplex Image version.
        """
        return pulumi.get(self, "image_version")

    @property
    @pulumi.getter(name="javaLibraries")
    def java_libraries(self) -> Sequence[str]:
        """
        Optional. List of Java jars to be included in the runtime environment. Valid input includes Cloud Storage URIs to Jar binaries. For example, gs://bucket-name/my/path/to/file.jar
        """
        return pulumi.get(self, "java_libraries")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. Spark properties to provide configuration for use in sessions created for this environment. The properties to set on daemon config files. Property keys are specified in prefix:property format. The prefix must be "spark".
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="pythonPackages")
    def python_packages(self) -> Sequence[str]:
        """
        Optional. A list of python packages to be installed. Valid formats include Cloud Storage URI to a PIP installable library. For example, gs://bucket-name/my/path/to/lib.tar.gz
        """
        return pulumi.get(self, "python_packages")


@pulumi.output_type
class GoogleCloudDataplexV1EnvironmentInfrastructureSpecResponse(dict):
    """
    Configuration for the underlying infrastructure used to run workloads.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osImage":
            suggest = "os_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1EnvironmentInfrastructureSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1EnvironmentInfrastructureSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1EnvironmentInfrastructureSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute: 'outputs.GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesResponse',
                 os_image: 'outputs.GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeResponse'):
        """
        Configuration for the underlying infrastructure used to run workloads.
        :param 'GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesResponse' compute: Optional. Compute resources needed for analyze interactive workloads.
        :param 'GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeResponse' os_image: Software Runtime Configuration for analyze interactive workloads.
        """
        pulumi.set(__self__, "compute", compute)
        pulumi.set(__self__, "os_image", os_image)

    @property
    @pulumi.getter
    def compute(self) -> 'outputs.GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResourcesResponse':
        """
        Optional. Compute resources needed for analyze interactive workloads.
        """
        return pulumi.get(self, "compute")

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> 'outputs.GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntimeResponse':
        """
        Software Runtime Configuration for analyze interactive workloads.
        """
        return pulumi.get(self, "os_image")


@pulumi.output_type
class GoogleCloudDataplexV1EnvironmentSessionSpecResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableFastStartup":
            suggest = "enable_fast_startup"
        elif key == "maxIdleDuration":
            suggest = "max_idle_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1EnvironmentSessionSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1EnvironmentSessionSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1EnvironmentSessionSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_fast_startup: bool,
                 max_idle_duration: str):
        """
        :param bool enable_fast_startup: Optional. If True, this causes sessions to be pre-created and available for faster startup to enable interactive exploration use-cases. This defaults to False to avoid additional billed charges. These can only be set to True for the environment with name set to "default", and with default configuration.
        :param str max_idle_duration: Optional. The idle time configuration of the session. The session will be auto-terminated at the end of this period.
        """
        pulumi.set(__self__, "enable_fast_startup", enable_fast_startup)
        pulumi.set(__self__, "max_idle_duration", max_idle_duration)

    @property
    @pulumi.getter(name="enableFastStartup")
    def enable_fast_startup(self) -> bool:
        """
        Optional. If True, this causes sessions to be pre-created and available for faster startup to enable interactive exploration use-cases. This defaults to False to avoid additional billed charges. These can only be set to True for the environment with name set to "default", and with default configuration.
        """
        return pulumi.get(self, "enable_fast_startup")

    @property
    @pulumi.getter(name="maxIdleDuration")
    def max_idle_duration(self) -> str:
        """
        Optional. The idle time configuration of the session. The session will be auto-terminated at the end of this period.
        """
        return pulumi.get(self, "max_idle_duration")


@pulumi.output_type
class GoogleCloudDataplexV1EnvironmentSessionStatusResponse(dict):
    def __init__(__self__, *,
                 active: bool):
        """
        :param bool active: Queries over sessions to mark whether the environment is currently active or not
        """
        pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def active(self) -> bool:
        """
        Queries over sessions to mark whether the environment is currently active or not
        """
        return pulumi.get(self, "active")


@pulumi.output_type
class GoogleCloudDataplexV1LakeMetastoreResponse(dict):
    """
    Settings to manage association of Dataproc Metastore with a lake.
    """
    def __init__(__self__, *,
                 service: str):
        """
        Settings to manage association of Dataproc Metastore with a lake.
        :param str service: Optional. A relative reference to the Dataproc Metastore (https://cloud.google.com/dataproc-metastore/docs) service associated with the lake: projects/{project_id}/locations/{location_id}/services/{service_id}
        """
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Optional. A relative reference to the Dataproc Metastore (https://cloud.google.com/dataproc-metastore/docs) service associated with the lake: projects/{project_id}/locations/{location_id}/services/{service_id}
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GoogleCloudDataplexV1LakeMetastoreStatusResponse(dict):
    """
    Status of Lake and Dataproc Metastore service instance association.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1LakeMetastoreStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1LakeMetastoreStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1LakeMetastoreStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: str,
                 message: str,
                 state: str,
                 update_time: str):
        """
        Status of Lake and Dataproc Metastore service instance association.
        :param str endpoint: The URI of the endpoint used to access the Metastore service.
        :param str message: Additional information about the current status.
        :param str state: Current state of association.
        :param str update_time: Last update time of the metastore status of the lake.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The URI of the endpoint used to access the Metastore service.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Additional information about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of association.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Last update time of the metastore status of the lake.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GoogleCloudDataplexV1SchemaPartitionFieldResponse(dict):
    """
    Represents a key field within the entity's partition structure. You could have up to 20 partition fields, but only the first 10 partitions have the filtering ability due to performance consideration. Note: Partition fields are immutable.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        Represents a key field within the entity's partition structure. You could have up to 20 partition fields, but only the first 10 partitions have the filtering ability due to performance consideration. Note: Partition fields are immutable.
        :param str name: Partition field name must consist of letters, numbers, and underscores only, with a maximum of length of 256 characters, and must begin with a letter or underscore..
        :param str type: Immutable. The type of field.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Partition field name must consist of letters, numbers, and underscores only, with a maximum of length of 256 characters, and must begin with a letter or underscore..
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Immutable. The type of field.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDataplexV1SchemaResponse(dict):
    """
    Schema information describing the structure and layout of the data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionFields":
            suggest = "partition_fields"
        elif key == "partitionStyle":
            suggest = "partition_style"
        elif key == "userManaged":
            suggest = "user_managed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1SchemaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1SchemaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1SchemaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fields: Sequence['outputs.GoogleCloudDataplexV1SchemaSchemaFieldResponse'],
                 partition_fields: Sequence['outputs.GoogleCloudDataplexV1SchemaPartitionFieldResponse'],
                 partition_style: str,
                 user_managed: bool):
        """
        Schema information describing the structure and layout of the data.
        :param Sequence['GoogleCloudDataplexV1SchemaSchemaFieldResponse'] fields: Optional. The sequence of fields describing data in table entities. Note: BigQuery SchemaFields are immutable.
        :param Sequence['GoogleCloudDataplexV1SchemaPartitionFieldResponse'] partition_fields: Optional. The sequence of fields describing the partition structure in entities. If this field is empty, there are no partitions within the data.
        :param str partition_style: Optional. The structure of paths containing partition data within the entity.
        :param bool user_managed: Set to true if user-managed or false if managed by Dataplex. The default is false (managed by Dataplex). Set to falseto enable Dataplex discovery to update the schema. including new data discovery, schema inference, and schema evolution. Users retain the ability to input and edit the schema. Dataplex treats schema input by the user as though produced by a previous Dataplex discovery operation, and it will evolve the schema and take action based on that treatment. Set to true to fully manage the entity schema. This setting guarantees that Dataplex will not change schema fields.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "partition_fields", partition_fields)
        pulumi.set(__self__, "partition_style", partition_style)
        pulumi.set(__self__, "user_managed", user_managed)

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.GoogleCloudDataplexV1SchemaSchemaFieldResponse']:
        """
        Optional. The sequence of fields describing data in table entities. Note: BigQuery SchemaFields are immutable.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="partitionFields")
    def partition_fields(self) -> Sequence['outputs.GoogleCloudDataplexV1SchemaPartitionFieldResponse']:
        """
        Optional. The sequence of fields describing the partition structure in entities. If this field is empty, there are no partitions within the data.
        """
        return pulumi.get(self, "partition_fields")

    @property
    @pulumi.getter(name="partitionStyle")
    def partition_style(self) -> str:
        """
        Optional. The structure of paths containing partition data within the entity.
        """
        return pulumi.get(self, "partition_style")

    @property
    @pulumi.getter(name="userManaged")
    def user_managed(self) -> bool:
        """
        Set to true if user-managed or false if managed by Dataplex. The default is false (managed by Dataplex). Set to falseto enable Dataplex discovery to update the schema. including new data discovery, schema inference, and schema evolution. Users retain the ability to input and edit the schema. Dataplex treats schema input by the user as though produced by a previous Dataplex discovery operation, and it will evolve the schema and take action based on that treatment. Set to true to fully manage the entity schema. This setting guarantees that Dataplex will not change schema fields.
        """
        return pulumi.get(self, "user_managed")


@pulumi.output_type
class GoogleCloudDataplexV1SchemaSchemaFieldResponse(dict):
    """
    Represents a column field within a table schema.
    """
    def __init__(__self__, *,
                 description: str,
                 fields: Sequence['outputs.GoogleCloudDataplexV1SchemaSchemaFieldResponse'],
                 mode: str,
                 name: str,
                 type: str):
        """
        Represents a column field within a table schema.
        :param str description: Optional. User friendly field description. Must be less than or equal to 1024 characters.
        :param Sequence['GoogleCloudDataplexV1SchemaSchemaFieldResponse'] fields: Optional. Any nested field for complex types.
        :param str mode: Additional field semantics.
        :param str name: The name of the field. Must contain only letters, numbers and underscores, with a maximum length of 767 characters, and must begin with a letter or underscore.
        :param str type: The type of field.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. User friendly field description. Must be less than or equal to 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.GoogleCloudDataplexV1SchemaSchemaFieldResponse']:
        """
        Optional. Any nested field for complex types.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Additional field semantics.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the field. Must contain only letters, numbers and underscores, with a maximum length of 767 characters, and must begin with a letter or underscore.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of field.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDataplexV1StorageFormatCsvOptionsResponse(dict):
    """
    Describes CSV and similar semi-structured data formats.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerRows":
            suggest = "header_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1StorageFormatCsvOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1StorageFormatCsvOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1StorageFormatCsvOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delimiter: str,
                 encoding: str,
                 header_rows: int,
                 quote: str):
        """
        Describes CSV and similar semi-structured data formats.
        :param str delimiter: Optional. The delimiter used to separate values. Defaults to ','.
        :param str encoding: Optional. The character encoding of the data. Accepts "US-ASCII", "UTF-8", and "ISO-8859-1". Defaults to UTF-8 if unspecified.
        :param int header_rows: Optional. The number of rows to interpret as header rows that should be skipped when reading data rows. Defaults to 0.
        :param str quote: Optional. The character used to quote column values. Accepts '"' (double quotation mark) or ''' (single quotation mark). Defaults to '"' (double quotation mark) if unspecified.
        """
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "header_rows", header_rows)
        pulumi.set(__self__, "quote", quote)

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        Optional. The delimiter used to separate values. Defaults to ','.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        Optional. The character encoding of the data. Accepts "US-ASCII", "UTF-8", and "ISO-8859-1". Defaults to UTF-8 if unspecified.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="headerRows")
    def header_rows(self) -> int:
        """
        Optional. The number of rows to interpret as header rows that should be skipped when reading data rows. Defaults to 0.
        """
        return pulumi.get(self, "header_rows")

    @property
    @pulumi.getter
    def quote(self) -> str:
        """
        Optional. The character used to quote column values. Accepts '"' (double quotation mark) or ''' (single quotation mark). Defaults to '"' (double quotation mark) if unspecified.
        """
        return pulumi.get(self, "quote")


@pulumi.output_type
class GoogleCloudDataplexV1StorageFormatJsonOptionsResponse(dict):
    """
    Describes JSON data format.
    """
    def __init__(__self__, *,
                 encoding: str):
        """
        Describes JSON data format.
        :param str encoding: Optional. The character encoding of the data. Accepts "US-ASCII", "UTF-8" and "ISO-8859-1". Defaults to UTF-8 if not specified.
        """
        pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        Optional. The character encoding of the data. Accepts "US-ASCII", "UTF-8" and "ISO-8859-1". Defaults to UTF-8 if not specified.
        """
        return pulumi.get(self, "encoding")


@pulumi.output_type
class GoogleCloudDataplexV1StorageFormatResponse(dict):
    """
    Describes the format of the data within its storage location.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compressionFormat":
            suggest = "compression_format"
        elif key == "mimeType":
            suggest = "mime_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1StorageFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1StorageFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1StorageFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compression_format: str,
                 csv: 'outputs.GoogleCloudDataplexV1StorageFormatCsvOptionsResponse',
                 format: str,
                 json: 'outputs.GoogleCloudDataplexV1StorageFormatJsonOptionsResponse',
                 mime_type: str):
        """
        Describes the format of the data within its storage location.
        :param str compression_format: Optional. The compression type associated with the stored data. If unspecified, the data is uncompressed.
        :param 'GoogleCloudDataplexV1StorageFormatCsvOptionsResponse' csv: Optional. Additional information about CSV formatted data.
        :param str format: The data format associated with the stored data, which represents content type values. The value is inferred from mime type.
        :param 'GoogleCloudDataplexV1StorageFormatJsonOptionsResponse' json: Optional. Additional information about CSV formatted data.
        :param str mime_type: The mime type descriptor for the data. Must match the pattern {type}/{subtype}. Supported values: application/x-parquet application/x-avro application/x-orc application/x-tfrecord application/json application/{subtypes} text/csv text/ image/{image subtype} video/{video subtype} audio/{audio subtype}
        """
        pulumi.set(__self__, "compression_format", compression_format)
        pulumi.set(__self__, "csv", csv)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "json", json)
        pulumi.set(__self__, "mime_type", mime_type)

    @property
    @pulumi.getter(name="compressionFormat")
    def compression_format(self) -> str:
        """
        Optional. The compression type associated with the stored data. If unspecified, the data is uncompressed.
        """
        return pulumi.get(self, "compression_format")

    @property
    @pulumi.getter
    def csv(self) -> 'outputs.GoogleCloudDataplexV1StorageFormatCsvOptionsResponse':
        """
        Optional. Additional information about CSV formatted data.
        """
        return pulumi.get(self, "csv")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        The data format associated with the stored data, which represents content type values. The value is inferred from mime type.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def json(self) -> 'outputs.GoogleCloudDataplexV1StorageFormatJsonOptionsResponse':
        """
        Optional. Additional information about CSV formatted data.
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> str:
        """
        The mime type descriptor for the data. Must match the pattern {type}/{subtype}. Supported values: application/x-parquet application/x-avro application/x-orc application/x-tfrecord application/json application/{subtypes} text/csv text/ image/{image subtype} video/{video subtype} audio/{audio subtype}
        """
        return pulumi.get(self, "mime_type")


@pulumi.output_type
class GoogleCloudDataplexV1TaskExecutionSpecResponse(dict):
    """
    Execution related settings, like retry and service_account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxJobExecutionLifetime":
            suggest = "max_job_execution_lifetime"
        elif key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1TaskExecutionSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1TaskExecutionSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1TaskExecutionSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Mapping[str, str],
                 max_job_execution_lifetime: str,
                 service_account: str):
        """
        Execution related settings, like retry and service_account.
        :param Mapping[str, str] args: Optional. The arguments to pass to the task. The args can use placeholders of the format ${placeholder} as part of key/value string. These will be interpolated before passing the args to the driver. Currently supported placeholders: - ${task_id} - ${job_time} To pass positional args, set the key as TASK_ARGS. The value should be a comma-separated string of all the positional arguments. To use a delimiter other than comma, refer to https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case of other keys being present in the args, then TASK_ARGS will be passed as the last argument.
        :param str max_job_execution_lifetime: Optional. The maximum duration after which the job execution is expired.
        :param str service_account: Service account to use to execute a task. If not provided, the default Compute service account for the project is used.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "max_job_execution_lifetime", max_job_execution_lifetime)
        pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter
    def args(self) -> Mapping[str, str]:
        """
        Optional. The arguments to pass to the task. The args can use placeholders of the format ${placeholder} as part of key/value string. These will be interpolated before passing the args to the driver. Currently supported placeholders: - ${task_id} - ${job_time} To pass positional args, set the key as TASK_ARGS. The value should be a comma-separated string of all the positional arguments. To use a delimiter other than comma, refer to https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case of other keys being present in the args, then TASK_ARGS will be passed as the last argument.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="maxJobExecutionLifetime")
    def max_job_execution_lifetime(self) -> str:
        """
        Optional. The maximum duration after which the job execution is expired.
        """
        return pulumi.get(self, "max_job_execution_lifetime")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Service account to use to execute a task. If not provided, the default Compute service account for the project is used.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesResponse(dict):
    """
    Batch compute resources associated with the task.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executorsCount":
            suggest = "executors_count"
        elif key == "maxExecutorsCount":
            suggest = "max_executors_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 executors_count: int,
                 max_executors_count: int):
        """
        Batch compute resources associated with the task.
        :param int executors_count: Optional. Total number of job executors.
        :param int max_executors_count: Optional. Max configurable executors. If max_executors_count > executors_count, then auto-scaling is enabled.
        """
        pulumi.set(__self__, "executors_count", executors_count)
        pulumi.set(__self__, "max_executors_count", max_executors_count)

    @property
    @pulumi.getter(name="executorsCount")
    def executors_count(self) -> int:
        """
        Optional. Total number of job executors.
        """
        return pulumi.get(self, "executors_count")

    @property
    @pulumi.getter(name="maxExecutorsCount")
    def max_executors_count(self) -> int:
        """
        Optional. Max configurable executors. If max_executors_count > executors_count, then auto-scaling is enabled.
        """
        return pulumi.get(self, "max_executors_count")


@pulumi.output_type
class GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeResponse(dict):
    """
    Container Image Runtime Configuration used with Batch execution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "javaJars":
            suggest = "java_jars"
        elif key == "pythonPackages":
            suggest = "python_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 java_jars: Sequence[str],
                 properties: Mapping[str, str],
                 python_packages: Sequence[str]):
        """
        Container Image Runtime Configuration used with Batch execution.
        :param Sequence[str] java_jars: Optional. A list of Java JARS to add to the classpath. Valid input includes Cloud Storage URIs to Jar binaries. For example, gs://bucket-name/my/path/to/file.jar
        :param Mapping[str, str] properties: Optional. Override to common configuration of open source components installed on the Dataproc cluster. The properties to set on daemon config files. Property keys are specified in prefix:property format, for example core:hadoop.tmp.dir. For more information, see Cluster properties (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        :param Sequence[str] python_packages: Optional. A list of python packages to be installed. Valid formats include Cloud Storage URI to a PIP installable library. For example, gs://bucket-name/my/path/to/lib.tar.gz
        """
        pulumi.set(__self__, "java_jars", java_jars)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "python_packages", python_packages)

    @property
    @pulumi.getter(name="javaJars")
    def java_jars(self) -> Sequence[str]:
        """
        Optional. A list of Java JARS to add to the classpath. Valid input includes Cloud Storage URIs to Jar binaries. For example, gs://bucket-name/my/path/to/file.jar
        """
        return pulumi.get(self, "java_jars")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. Override to common configuration of open source components installed on the Dataproc cluster. The properties to set on daemon config files. Property keys are specified in prefix:property format, for example core:hadoop.tmp.dir. For more information, see Cluster properties (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="pythonPackages")
    def python_packages(self) -> Sequence[str]:
        """
        Optional. A list of python packages to be installed. Valid formats include Cloud Storage URI to a PIP installable library. For example, gs://bucket-name/my/path/to/lib.tar.gz
        """
        return pulumi.get(self, "python_packages")


@pulumi.output_type
class GoogleCloudDataplexV1TaskInfrastructureSpecResponse(dict):
    """
    Configuration for the underlying infrastructure used to run workloads.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerImage":
            suggest = "container_image"
        elif key == "vpcNetwork":
            suggest = "vpc_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1TaskInfrastructureSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1TaskInfrastructureSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1TaskInfrastructureSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch: 'outputs.GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesResponse',
                 container_image: 'outputs.GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeResponse',
                 vpc_network: 'outputs.GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkResponse'):
        """
        Configuration for the underlying infrastructure used to run workloads.
        :param 'GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesResponse' batch: Compute resources needed for a Task when using Dataproc Serverless.
        :param 'GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeResponse' container_image: Container Image Runtime Configuration.
        :param 'GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkResponse' vpc_network: Vpc network.
        """
        pulumi.set(__self__, "batch", batch)
        pulumi.set(__self__, "container_image", container_image)
        pulumi.set(__self__, "vpc_network", vpc_network)

    @property
    @pulumi.getter
    def batch(self) -> 'outputs.GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResourcesResponse':
        """
        Compute resources needed for a Task when using Dataproc Serverless.
        """
        return pulumi.get(self, "batch")

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> 'outputs.GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntimeResponse':
        """
        Container Image Runtime Configuration.
        """
        return pulumi.get(self, "container_image")

    @property
    @pulumi.getter(name="vpcNetwork")
    def vpc_network(self) -> 'outputs.GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkResponse':
        """
        Vpc network.
        """
        return pulumi.get(self, "vpc_network")


@pulumi.output_type
class GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkResponse(dict):
    """
    Cloud VPC Network used to run the infrastructure.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkTags":
            suggest = "network_tags"
        elif key == "subNetwork":
            suggest = "sub_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network: str,
                 network_tags: Sequence[str],
                 sub_network: str):
        """
        Cloud VPC Network used to run the infrastructure.
        :param str network: Optional. The Cloud VPC network in which the job is run. By default, the Cloud VPC network named Default within the project is used.
        :param Sequence[str] network_tags: Optional. List of network tags to apply to the job.
        :param str sub_network: Optional. The Cloud VPC sub-network in which the job is run.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "network_tags", network_tags)
        pulumi.set(__self__, "sub_network", sub_network)

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        Optional. The Cloud VPC network in which the job is run. By default, the Cloud VPC network named Default within the project is used.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Sequence[str]:
        """
        Optional. List of network tags to apply to the job.
        """
        return pulumi.get(self, "network_tags")

    @property
    @pulumi.getter(name="subNetwork")
    def sub_network(self) -> str:
        """
        Optional. The Cloud VPC sub-network in which the job is run.
        """
        return pulumi.get(self, "sub_network")


@pulumi.output_type
class GoogleCloudDataplexV1TaskSparkTaskConfigResponse(dict):
    """
    User-specified config for running a Spark task.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "infrastructureSpec":
            suggest = "infrastructure_spec"
        elif key == "mainClass":
            suggest = "main_class"
        elif key == "mainJarFileUri":
            suggest = "main_jar_file_uri"
        elif key == "pythonScriptFile":
            suggest = "python_script_file"
        elif key == "sqlScript":
            suggest = "sql_script"
        elif key == "sqlScriptFile":
            suggest = "sql_script_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1TaskSparkTaskConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1TaskSparkTaskConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1TaskSparkTaskConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Sequence[str],
                 file_uris: Sequence[str],
                 infrastructure_spec: 'outputs.GoogleCloudDataplexV1TaskInfrastructureSpecResponse',
                 main_class: str,
                 main_jar_file_uri: str,
                 python_script_file: str,
                 sql_script: str,
                 sql_script_file: str):
        """
        User-specified config for running a Spark task.
        :param Sequence[str] archive_uris: Optional. Cloud Storage URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[str] file_uris: Optional. Cloud Storage URIs of files to be placed in the working directory of each executor.
        :param 'GoogleCloudDataplexV1TaskInfrastructureSpecResponse' infrastructure_spec: Optional. Infrastructure specification for the execution.
        :param str main_class: The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in jar_file_uris. The execution args are passed in as a sequence of named process arguments (--key=value).
        :param str main_jar_file_uri: The Cloud Storage URI of the jar file that contains the main class. The execution args are passed in as a sequence of named process arguments (--key=value).
        :param str python_script_file: The Gcloud Storage URI of the main Python file to use as the driver. Must be a .py file. The execution args are passed in as a sequence of named process arguments (--key=value).
        :param str sql_script: The query text. The execution args are used to declare a set of script variables (set key="value";).
        :param str sql_script_file: A reference to a query file. This can be the Cloud Storage URI of the query file or it can the path to a SqlScript Content. The execution args are used to declare a set of script variables (set key="value";).
        """
        pulumi.set(__self__, "archive_uris", archive_uris)
        pulumi.set(__self__, "file_uris", file_uris)
        pulumi.set(__self__, "infrastructure_spec", infrastructure_spec)
        pulumi.set(__self__, "main_class", main_class)
        pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        pulumi.set(__self__, "python_script_file", python_script_file)
        pulumi.set(__self__, "sql_script", sql_script)
        pulumi.set(__self__, "sql_script_file", sql_script_file)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Sequence[str]:
        """
        Optional. Cloud Storage URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Sequence[str]:
        """
        Optional. Cloud Storage URIs of files to be placed in the working directory of each executor.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="infrastructureSpec")
    def infrastructure_spec(self) -> 'outputs.GoogleCloudDataplexV1TaskInfrastructureSpecResponse':
        """
        Optional. Infrastructure specification for the execution.
        """
        return pulumi.get(self, "infrastructure_spec")

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> str:
        """
        The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in jar_file_uris. The execution args are passed in as a sequence of named process arguments (--key=value).
        """
        return pulumi.get(self, "main_class")

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> str:
        """
        The Cloud Storage URI of the jar file that contains the main class. The execution args are passed in as a sequence of named process arguments (--key=value).
        """
        return pulumi.get(self, "main_jar_file_uri")

    @property
    @pulumi.getter(name="pythonScriptFile")
    def python_script_file(self) -> str:
        """
        The Gcloud Storage URI of the main Python file to use as the driver. Must be a .py file. The execution args are passed in as a sequence of named process arguments (--key=value).
        """
        return pulumi.get(self, "python_script_file")

    @property
    @pulumi.getter(name="sqlScript")
    def sql_script(self) -> str:
        """
        The query text. The execution args are used to declare a set of script variables (set key="value";).
        """
        return pulumi.get(self, "sql_script")

    @property
    @pulumi.getter(name="sqlScriptFile")
    def sql_script_file(self) -> str:
        """
        A reference to a query file. This can be the Cloud Storage URI of the query file or it can the path to a SqlScript Content. The execution args are used to declare a set of script variables (set key="value";).
        """
        return pulumi.get(self, "sql_script_file")


@pulumi.output_type
class GoogleCloudDataplexV1TaskTriggerSpecResponse(dict):
    """
    Task scheduling and trigger settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRetries":
            suggest = "max_retries"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1TaskTriggerSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1TaskTriggerSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1TaskTriggerSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: bool,
                 max_retries: int,
                 schedule: str,
                 start_time: str,
                 type: str):
        """
        Task scheduling and trigger settings.
        :param bool disabled: Optional. Prevent the task from executing. This does not cancel already running tasks. It is intended to temporarily disable RECURRING tasks.
        :param int max_retries: Optional. Number of retry attempts before aborting. Set to zero to never attempt to retry a failed task.
        :param str schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running tasks periodically. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *". This field is required for RECURRING tasks.
        :param str start_time: Optional. The first run of the task will be after this time. If not specified, the task will run shortly after being submitted if ON_DEMAND and based on the schedule if RECURRING.
        :param str type: Immutable. Trigger type of the user-specified Task.
        """
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "max_retries", max_retries)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Optional. Prevent the task from executing. This does not cancel already running tasks. It is intended to temporarily disable RECURRING tasks.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> int:
        """
        Optional. Number of retry attempts before aborting. Set to zero to never attempt to retry a failed task.
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running tasks periodically. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *". This field is required for RECURRING tasks.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Optional. The first run of the task will be after this time. If not specified, the task will run shortly after being submitted if ON_DEMAND and based on the schedule if RECURRING.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Immutable. Trigger type of the user-specified Task.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsResponse(dict):
    """
    Describe CSV and similar semi-structured data formats.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableTypeInference":
            suggest = "disable_type_inference"
        elif key == "headerRows":
            suggest = "header_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delimiter: str,
                 disable_type_inference: bool,
                 encoding: str,
                 header_rows: int):
        """
        Describe CSV and similar semi-structured data formats.
        :param str delimiter: Optional. The delimiter being used to separate values. This defaults to ','.
        :param bool disable_type_inference: Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
        :param str encoding: Optional. The character encoding of the data. The default is UTF-8.
        :param int header_rows: Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
        """
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "disable_type_inference", disable_type_inference)
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "header_rows", header_rows)

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        Optional. The delimiter being used to separate values. This defaults to ','.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="disableTypeInference")
    def disable_type_inference(self) -> bool:
        """
        Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
        """
        return pulumi.get(self, "disable_type_inference")

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        Optional. The character encoding of the data. The default is UTF-8.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="headerRows")
    def header_rows(self) -> int:
        """
        Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
        """
        return pulumi.get(self, "header_rows")


@pulumi.output_type
class GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsResponse(dict):
    """
    Describe JSON data format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableTypeInference":
            suggest = "disable_type_inference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_type_inference: bool,
                 encoding: str):
        """
        Describe JSON data format.
        :param bool disable_type_inference: Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
        :param str encoding: Optional. The character encoding of the data. The default is UTF-8.
        """
        pulumi.set(__self__, "disable_type_inference", disable_type_inference)
        pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter(name="disableTypeInference")
    def disable_type_inference(self) -> bool:
        """
        Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
        """
        return pulumi.get(self, "disable_type_inference")

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        Optional. The character encoding of the data. The default is UTF-8.
        """
        return pulumi.get(self, "encoding")


@pulumi.output_type
class GoogleCloudDataplexV1ZoneDiscoverySpecResponse(dict):
    """
    Settings to manage the metadata discovery and publishing in a zone.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "csvOptions":
            suggest = "csv_options"
        elif key == "excludePatterns":
            suggest = "exclude_patterns"
        elif key == "includePatterns":
            suggest = "include_patterns"
        elif key == "jsonOptions":
            suggest = "json_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1ZoneDiscoverySpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1ZoneDiscoverySpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1ZoneDiscoverySpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 csv_options: 'outputs.GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsResponse',
                 enabled: bool,
                 exclude_patterns: Sequence[str],
                 include_patterns: Sequence[str],
                 json_options: 'outputs.GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsResponse',
                 schedule: str):
        """
        Settings to manage the metadata discovery and publishing in a zone.
        :param 'GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsResponse' csv_options: Optional. Configuration for CSV data.
        :param bool enabled: Whether discovery is enabled.
        :param Sequence[str] exclude_patterns: Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        :param Sequence[str] include_patterns: Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        :param 'GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsResponse' json_options: Optional. Configuration for Json data.
        :param str schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
        """
        pulumi.set(__self__, "csv_options", csv_options)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "exclude_patterns", exclude_patterns)
        pulumi.set(__self__, "include_patterns", include_patterns)
        pulumi.set(__self__, "json_options", json_options)
        pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter(name="csvOptions")
    def csv_options(self) -> 'outputs.GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptionsResponse':
        """
        Optional. Configuration for CSV data.
        """
        return pulumi.get(self, "csv_options")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether discovery is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="excludePatterns")
    def exclude_patterns(self) -> Sequence[str]:
        """
        Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        """
        return pulumi.get(self, "exclude_patterns")

    @property
    @pulumi.getter(name="includePatterns")
    def include_patterns(self) -> Sequence[str]:
        """
        Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
        """
        return pulumi.get(self, "include_patterns")

    @property
    @pulumi.getter(name="jsonOptions")
    def json_options(self) -> 'outputs.GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptionsResponse':
        """
        Optional. Configuration for Json data.
        """
        return pulumi.get(self, "json_options")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class GoogleCloudDataplexV1ZoneResourceSpecResponse(dict):
    """
    Settings for resources attached as assets within a zone.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationType":
            suggest = "location_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDataplexV1ZoneResourceSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDataplexV1ZoneResourceSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDataplexV1ZoneResourceSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location_type: str):
        """
        Settings for resources attached as assets within a zone.
        :param str location_type: Immutable. The location type of the resources that are allowed to be attached to the assets within this zone.
        """
        pulumi.set(__self__, "location_type", location_type)

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> str:
        """
        Immutable. The location type of the resources that are allowed to be attached to the assets within this zone.
        """
        return pulumi.get(self, "location_type")


@pulumi.output_type
class GoogleIamV1AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs.If there are AuditConfigs for both allServices and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted.Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.GoogleIamV1AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs.If there are AuditConfigs for both allServices and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted.Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param Sequence['GoogleIamV1AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, storage.googleapis.com, cloudsql.googleapis.com. allServices is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.GoogleIamV1AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, storage.googleapis.com, cloudsql.googleapis.com. allServices is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GoogleIamV1AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GoogleIamV1BindingResponse(dict):
    """
    Associates members, or principals, with a role.
    """
    def __init__(__self__, *,
                 condition: 'outputs.GoogleTypeExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates members, or principals, with a role.
        :param 'GoogleTypeExprResponse' condition: The condition that is associated with this binding.If the condition evaluates to true, then this binding applies to the current request.If the condition evaluates to false, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Cloud Platform resource. members can have the following values: allUsers: A special identifier that represents anyone who is on the internet; with or without a Google account. allAuthenticatedUsers: A special identifier that represents anyone who is authenticated with a Google account or a service account. user:{emailid}: An email address that represents a specific Google account. For example, alice@example.com . serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a user that has been recently deleted. For example, alice@example.com?uid=123456789012345678901. If the user is recovered, this value reverts to user:{emailid} and the recovered user retains the role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the service account is undeleted, this value reverts to serviceAccount:{emailid} and the undeleted service account retains the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, admins@example.com?uid=123456789012345678901. If the group is recovered, this value reverts to group:{emailid} and the recovered group retains the role in the binding. domain:{domain}: The G Suite domain (primary) that represents all the users of that domain. For example, google.com or example.com.
        :param str role: Role that is assigned to the list of members, or principals. For example, roles/viewer, roles/editor, or roles/owner.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.GoogleTypeExprResponse':
        """
        The condition that is associated with this binding.If the condition evaluates to true, then this binding applies to the current request.If the condition evaluates to false, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. members can have the following values: allUsers: A special identifier that represents anyone who is on the internet; with or without a Google account. allAuthenticatedUsers: A special identifier that represents anyone who is authenticated with a Google account or a service account. user:{emailid}: An email address that represents a specific Google account. For example, alice@example.com . serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a user that has been recently deleted. For example, alice@example.com?uid=123456789012345678901. If the user is recovered, this value reverts to user:{emailid} and the recovered user retains the role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the service account is undeleted, this value reverts to serviceAccount:{emailid} and the undeleted service account retains the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, admins@example.com?uid=123456789012345678901. If the group is recovered, this value reverts to group:{emailid} and the recovered group retains the role in the binding. domain:{domain}: The G Suite domain (primary) that represents all the users of that domain. For example, google.com or example.com.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of members, or principals. For example, roles/viewer, roles/editor, or roles/owner.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GoogleTypeExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec.Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec.Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


