# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GoogleCloudContactcenterinsightsV1AnalysisResponse',
    'GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadataResponse',
    'GoogleCloudContactcenterinsightsV1AnalysisResultResponse',
    'GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse',
    'GoogleCloudContactcenterinsightsV1AnswerFeedbackResponse',
    'GoogleCloudContactcenterinsightsV1ArticleSuggestionDataResponse',
    'GoogleCloudContactcenterinsightsV1CallAnnotationResponse',
    'GoogleCloudContactcenterinsightsV1ConversationCallMetadataResponse',
    'GoogleCloudContactcenterinsightsV1ConversationDataSourceResponse',
    'GoogleCloudContactcenterinsightsV1ConversationLevelSentimentResponse',
    'GoogleCloudContactcenterinsightsV1ConversationParticipantResponse',
    'GoogleCloudContactcenterinsightsV1ConversationTranscriptResponse',
    'GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadataResponse',
    'GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentResponse',
    'GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfoResponse',
    'GoogleCloudContactcenterinsightsV1DialogflowInteractionDataResponse',
    'GoogleCloudContactcenterinsightsV1DialogflowSourceResponse',
    'GoogleCloudContactcenterinsightsV1EntityMentionDataResponse',
    'GoogleCloudContactcenterinsightsV1ExactMatchConfigResponse',
    'GoogleCloudContactcenterinsightsV1FaqAnswerDataResponse',
    'GoogleCloudContactcenterinsightsV1GcsSourceResponse',
    'GoogleCloudContactcenterinsightsV1HoldDataResponse',
    'GoogleCloudContactcenterinsightsV1IntentMatchDataResponse',
    'GoogleCloudContactcenterinsightsV1InterruptionDataResponse',
    'GoogleCloudContactcenterinsightsV1IssueAssignmentResponse',
    'GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigResponse',
    'GoogleCloudContactcenterinsightsV1IssueModelLabelStatsResponse',
    'GoogleCloudContactcenterinsightsV1IssueModelResultResponse',
    'GoogleCloudContactcenterinsightsV1PhraseMatchDataResponse',
    'GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigResponse',
    'GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupResponse',
    'GoogleCloudContactcenterinsightsV1PhraseMatchRuleResponse',
    'GoogleCloudContactcenterinsightsV1RuntimeAnnotationResponse',
    'GoogleCloudContactcenterinsightsV1SentimentDataResponse',
    'GoogleCloudContactcenterinsightsV1SilenceDataResponse',
    'GoogleCloudContactcenterinsightsV1SmartComposeSuggestionDataResponse',
    'GoogleCloudContactcenterinsightsV1SmartReplyDataResponse',
]

@pulumi.output_type
class GoogleCloudContactcenterinsightsV1AnalysisResponse(dict):
    """
    The analysis resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisResult":
            suggest = "analysis_result"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "requestTime":
            suggest = "request_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1AnalysisResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1AnalysisResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1AnalysisResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_result: 'outputs.GoogleCloudContactcenterinsightsV1AnalysisResultResponse',
                 create_time: str,
                 name: str,
                 request_time: str):
        """
        The analysis resource.
        :param 'GoogleCloudContactcenterinsightsV1AnalysisResultResponse' analysis_result: The result of the analysis, which is populated when the analysis finishes.
        :param str create_time: The time at which the analysis was created, which occurs when the long-running operation completes.
        :param str name: Immutable. The resource name of the analysis. Format: projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
        :param str request_time: The time at which the analysis was requested.
        """
        pulumi.set(__self__, "analysis_result", analysis_result)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "request_time", request_time)

    @property
    @pulumi.getter(name="analysisResult")
    def analysis_result(self) -> 'outputs.GoogleCloudContactcenterinsightsV1AnalysisResultResponse':
        """
        The result of the analysis, which is populated when the analysis finishes.
        """
        return pulumi.get(self, "analysis_result")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the analysis was created, which occurs when the long-running operation completes.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. The resource name of the analysis. Format: projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requestTime")
    def request_time(self) -> str:
        """
        The time at which the analysis was requested.
        """
        return pulumi.get(self, "request_time")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadataResponse(dict):
    """
    Call-specific metadata created during analysis.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issueModelResult":
            suggest = "issue_model_result"
        elif key == "phraseMatchers":
            suggest = "phrase_matchers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Sequence['outputs.GoogleCloudContactcenterinsightsV1CallAnnotationResponse'],
                 entities: Mapping[str, str],
                 intents: Mapping[str, str],
                 issue_model_result: 'outputs.GoogleCloudContactcenterinsightsV1IssueModelResultResponse',
                 phrase_matchers: Mapping[str, str],
                 sentiments: Sequence['outputs.GoogleCloudContactcenterinsightsV1ConversationLevelSentimentResponse']):
        """
        Call-specific metadata created during analysis.
        :param Sequence['GoogleCloudContactcenterinsightsV1CallAnnotationResponse'] annotations: A list of call annotations that apply to this call.
        :param Mapping[str, str] entities: All the entities in the call.
        :param Mapping[str, str] intents: All the matched intents in the call.
        :param 'GoogleCloudContactcenterinsightsV1IssueModelResultResponse' issue_model_result: Overall conversation-level issue modeling result.
        :param Mapping[str, str] phrase_matchers: All the matched phrase matchers in the call.
        :param Sequence['GoogleCloudContactcenterinsightsV1ConversationLevelSentimentResponse'] sentiments: Overall conversation-level sentiment for each channel of the call.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "entities", entities)
        pulumi.set(__self__, "intents", intents)
        pulumi.set(__self__, "issue_model_result", issue_model_result)
        pulumi.set(__self__, "phrase_matchers", phrase_matchers)
        pulumi.set(__self__, "sentiments", sentiments)

    @property
    @pulumi.getter
    def annotations(self) -> Sequence['outputs.GoogleCloudContactcenterinsightsV1CallAnnotationResponse']:
        """
        A list of call annotations that apply to this call.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def entities(self) -> Mapping[str, str]:
        """
        All the entities in the call.
        """
        return pulumi.get(self, "entities")

    @property
    @pulumi.getter
    def intents(self) -> Mapping[str, str]:
        """
        All the matched intents in the call.
        """
        return pulumi.get(self, "intents")

    @property
    @pulumi.getter(name="issueModelResult")
    def issue_model_result(self) -> 'outputs.GoogleCloudContactcenterinsightsV1IssueModelResultResponse':
        """
        Overall conversation-level issue modeling result.
        """
        return pulumi.get(self, "issue_model_result")

    @property
    @pulumi.getter(name="phraseMatchers")
    def phrase_matchers(self) -> Mapping[str, str]:
        """
        All the matched phrase matchers in the call.
        """
        return pulumi.get(self, "phrase_matchers")

    @property
    @pulumi.getter
    def sentiments(self) -> Sequence['outputs.GoogleCloudContactcenterinsightsV1ConversationLevelSentimentResponse']:
        """
        Overall conversation-level sentiment for each channel of the call.
        """
        return pulumi.get(self, "sentiments")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1AnalysisResultResponse(dict):
    """
    The result of an analysis.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callAnalysisMetadata":
            suggest = "call_analysis_metadata"
        elif key == "endTime":
            suggest = "end_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1AnalysisResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1AnalysisResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1AnalysisResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 call_analysis_metadata: 'outputs.GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadataResponse',
                 end_time: str):
        """
        The result of an analysis.
        :param 'GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadataResponse' call_analysis_metadata: Call-specific metadata created by the analysis.
        :param str end_time: The time at which the analysis ended.
        """
        pulumi.set(__self__, "call_analysis_metadata", call_analysis_metadata)
        pulumi.set(__self__, "end_time", end_time)

    @property
    @pulumi.getter(name="callAnalysisMetadata")
    def call_analysis_metadata(self) -> 'outputs.GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadataResponse':
        """
        Call-specific metadata created by the analysis.
        """
        return pulumi.get(self, "call_analysis_metadata")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The time at which the analysis ended.
        """
        return pulumi.get(self, "end_time")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse(dict):
    """
    A point in a conversation that marks the start or the end of an annotation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transcriptIndex":
            suggest = "transcript_index"
        elif key == "wordIndex":
            suggest = "word_index"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 transcript_index: int,
                 word_index: int):
        """
        A point in a conversation that marks the start or the end of an annotation.
        :param int transcript_index: The index in the sequence of transcribed pieces of the conversation where the boundary is located. This index starts at zero.
        :param int word_index: The word index of this boundary with respect to the first word in the transcript piece. This index starts at zero.
        """
        pulumi.set(__self__, "transcript_index", transcript_index)
        pulumi.set(__self__, "word_index", word_index)

    @property
    @pulumi.getter(name="transcriptIndex")
    def transcript_index(self) -> int:
        """
        The index in the sequence of transcribed pieces of the conversation where the boundary is located. This index starts at zero.
        """
        return pulumi.get(self, "transcript_index")

    @property
    @pulumi.getter(name="wordIndex")
    def word_index(self) -> int:
        """
        The word index of this boundary with respect to the first word in the transcript piece. This index starts at zero.
        """
        return pulumi.get(self, "word_index")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1AnswerFeedbackResponse(dict):
    """
    The feedback that the customer has about a certain answer in the conversation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "correctnessLevel":
            suggest = "correctness_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1AnswerFeedbackResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1AnswerFeedbackResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1AnswerFeedbackResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clicked: bool,
                 correctness_level: str,
                 displayed: bool):
        """
        The feedback that the customer has about a certain answer in the conversation.
        :param bool clicked: Indicates whether an answer or item was clicked by the human agent.
        :param str correctness_level: The correctness level of an answer.
        :param bool displayed: Indicates whether an answer or item was displayed to the human agent in the agent desktop UI.
        """
        pulumi.set(__self__, "clicked", clicked)
        pulumi.set(__self__, "correctness_level", correctness_level)
        pulumi.set(__self__, "displayed", displayed)

    @property
    @pulumi.getter
    def clicked(self) -> bool:
        """
        Indicates whether an answer or item was clicked by the human agent.
        """
        return pulumi.get(self, "clicked")

    @property
    @pulumi.getter(name="correctnessLevel")
    def correctness_level(self) -> str:
        """
        The correctness level of an answer.
        """
        return pulumi.get(self, "correctness_level")

    @property
    @pulumi.getter
    def displayed(self) -> bool:
        """
        Indicates whether an answer or item was displayed to the human agent in the agent desktop UI.
        """
        return pulumi.get(self, "displayed")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1ArticleSuggestionDataResponse(dict):
    """
    Agent Assist Article Suggestion data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceScore":
            suggest = "confidence_score"
        elif key == "queryRecord":
            suggest = "query_record"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1ArticleSuggestionDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1ArticleSuggestionDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1ArticleSuggestionDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence_score: float,
                 metadata: Mapping[str, str],
                 query_record: str,
                 source: str,
                 title: str,
                 uri: str):
        """
        Agent Assist Article Suggestion data.
        :param float confidence_score: The system's confidence score that this article is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
        :param Mapping[str, str] metadata: Map that contains metadata about the Article Suggestion and the document that it originates from.
        :param str query_record: Name of the query record. Format: projects/{project}/locations/{location}/queryRecords/{query_record}
        :param str source: The knowledge document that this answer was extracted from. Format: projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}
        :param str title: Article title.
        :param str uri: Article URI.
        """
        pulumi.set(__self__, "confidence_score", confidence_score)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "query_record", query_record)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="confidenceScore")
    def confidence_score(self) -> float:
        """
        The system's confidence score that this article is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
        """
        return pulumi.get(self, "confidence_score")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Map that contains metadata about the Article Suggestion and the document that it originates from.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="queryRecord")
    def query_record(self) -> str:
        """
        Name of the query record. Format: projects/{project}/locations/{location}/queryRecords/{query_record}
        """
        return pulumi.get(self, "query_record")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The knowledge document that this answer was extracted from. Format: projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Article title.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Article URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1CallAnnotationResponse(dict):
    """
    A piece of metadata that applies to a window of a call.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "annotationEndBoundary":
            suggest = "annotation_end_boundary"
        elif key == "annotationStartBoundary":
            suggest = "annotation_start_boundary"
        elif key == "channelTag":
            suggest = "channel_tag"
        elif key == "entityMentionData":
            suggest = "entity_mention_data"
        elif key == "holdData":
            suggest = "hold_data"
        elif key == "intentMatchData":
            suggest = "intent_match_data"
        elif key == "interruptionData":
            suggest = "interruption_data"
        elif key == "phraseMatchData":
            suggest = "phrase_match_data"
        elif key == "sentimentData":
            suggest = "sentiment_data"
        elif key == "silenceData":
            suggest = "silence_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1CallAnnotationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1CallAnnotationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1CallAnnotationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotation_end_boundary: 'outputs.GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse',
                 annotation_start_boundary: 'outputs.GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse',
                 channel_tag: int,
                 entity_mention_data: 'outputs.GoogleCloudContactcenterinsightsV1EntityMentionDataResponse',
                 hold_data: 'outputs.GoogleCloudContactcenterinsightsV1HoldDataResponse',
                 intent_match_data: 'outputs.GoogleCloudContactcenterinsightsV1IntentMatchDataResponse',
                 interruption_data: 'outputs.GoogleCloudContactcenterinsightsV1InterruptionDataResponse',
                 phrase_match_data: 'outputs.GoogleCloudContactcenterinsightsV1PhraseMatchDataResponse',
                 sentiment_data: 'outputs.GoogleCloudContactcenterinsightsV1SentimentDataResponse',
                 silence_data: 'outputs.GoogleCloudContactcenterinsightsV1SilenceDataResponse'):
        """
        A piece of metadata that applies to a window of a call.
        :param 'GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse' annotation_end_boundary: The boundary in the conversation where the annotation ends, inclusive.
        :param 'GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse' annotation_start_boundary: The boundary in the conversation where the annotation starts, inclusive.
        :param int channel_tag: The channel of the audio where the annotation occurs. For single-channel audio, this field is not populated.
        :param 'GoogleCloudContactcenterinsightsV1EntityMentionDataResponse' entity_mention_data: Data specifying an entity mention.
        :param 'GoogleCloudContactcenterinsightsV1HoldDataResponse' hold_data: Data specifying a hold.
        :param 'GoogleCloudContactcenterinsightsV1IntentMatchDataResponse' intent_match_data: Data specifying an intent match.
        :param 'GoogleCloudContactcenterinsightsV1InterruptionDataResponse' interruption_data: Data specifying an interruption.
        :param 'GoogleCloudContactcenterinsightsV1PhraseMatchDataResponse' phrase_match_data: Data specifying a phrase match.
        :param 'GoogleCloudContactcenterinsightsV1SentimentDataResponse' sentiment_data: Data specifying sentiment.
        :param 'GoogleCloudContactcenterinsightsV1SilenceDataResponse' silence_data: Data specifying silence.
        """
        pulumi.set(__self__, "annotation_end_boundary", annotation_end_boundary)
        pulumi.set(__self__, "annotation_start_boundary", annotation_start_boundary)
        pulumi.set(__self__, "channel_tag", channel_tag)
        pulumi.set(__self__, "entity_mention_data", entity_mention_data)
        pulumi.set(__self__, "hold_data", hold_data)
        pulumi.set(__self__, "intent_match_data", intent_match_data)
        pulumi.set(__self__, "interruption_data", interruption_data)
        pulumi.set(__self__, "phrase_match_data", phrase_match_data)
        pulumi.set(__self__, "sentiment_data", sentiment_data)
        pulumi.set(__self__, "silence_data", silence_data)

    @property
    @pulumi.getter(name="annotationEndBoundary")
    def annotation_end_boundary(self) -> 'outputs.GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse':
        """
        The boundary in the conversation where the annotation ends, inclusive.
        """
        return pulumi.get(self, "annotation_end_boundary")

    @property
    @pulumi.getter(name="annotationStartBoundary")
    def annotation_start_boundary(self) -> 'outputs.GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse':
        """
        The boundary in the conversation where the annotation starts, inclusive.
        """
        return pulumi.get(self, "annotation_start_boundary")

    @property
    @pulumi.getter(name="channelTag")
    def channel_tag(self) -> int:
        """
        The channel of the audio where the annotation occurs. For single-channel audio, this field is not populated.
        """
        return pulumi.get(self, "channel_tag")

    @property
    @pulumi.getter(name="entityMentionData")
    def entity_mention_data(self) -> 'outputs.GoogleCloudContactcenterinsightsV1EntityMentionDataResponse':
        """
        Data specifying an entity mention.
        """
        return pulumi.get(self, "entity_mention_data")

    @property
    @pulumi.getter(name="holdData")
    def hold_data(self) -> 'outputs.GoogleCloudContactcenterinsightsV1HoldDataResponse':
        """
        Data specifying a hold.
        """
        return pulumi.get(self, "hold_data")

    @property
    @pulumi.getter(name="intentMatchData")
    def intent_match_data(self) -> 'outputs.GoogleCloudContactcenterinsightsV1IntentMatchDataResponse':
        """
        Data specifying an intent match.
        """
        return pulumi.get(self, "intent_match_data")

    @property
    @pulumi.getter(name="interruptionData")
    def interruption_data(self) -> 'outputs.GoogleCloudContactcenterinsightsV1InterruptionDataResponse':
        """
        Data specifying an interruption.
        """
        return pulumi.get(self, "interruption_data")

    @property
    @pulumi.getter(name="phraseMatchData")
    def phrase_match_data(self) -> 'outputs.GoogleCloudContactcenterinsightsV1PhraseMatchDataResponse':
        """
        Data specifying a phrase match.
        """
        return pulumi.get(self, "phrase_match_data")

    @property
    @pulumi.getter(name="sentimentData")
    def sentiment_data(self) -> 'outputs.GoogleCloudContactcenterinsightsV1SentimentDataResponse':
        """
        Data specifying sentiment.
        """
        return pulumi.get(self, "sentiment_data")

    @property
    @pulumi.getter(name="silenceData")
    def silence_data(self) -> 'outputs.GoogleCloudContactcenterinsightsV1SilenceDataResponse':
        """
        Data specifying silence.
        """
        return pulumi.get(self, "silence_data")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1ConversationCallMetadataResponse(dict):
    """
    Call-specific metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentChannel":
            suggest = "agent_channel"
        elif key == "customerChannel":
            suggest = "customer_channel"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1ConversationCallMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationCallMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationCallMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_channel: int,
                 customer_channel: int):
        """
        Call-specific metadata.
        :param int agent_channel: The audio channel that contains the agent.
        :param int customer_channel: The audio channel that contains the customer.
        """
        pulumi.set(__self__, "agent_channel", agent_channel)
        pulumi.set(__self__, "customer_channel", customer_channel)

    @property
    @pulumi.getter(name="agentChannel")
    def agent_channel(self) -> int:
        """
        The audio channel that contains the agent.
        """
        return pulumi.get(self, "agent_channel")

    @property
    @pulumi.getter(name="customerChannel")
    def customer_channel(self) -> int:
        """
        The audio channel that contains the customer.
        """
        return pulumi.get(self, "customer_channel")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1ConversationDataSourceResponse(dict):
    """
    The conversation source, which is a combination of transcript and audio.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dialogflowSource":
            suggest = "dialogflow_source"
        elif key == "gcsSource":
            suggest = "gcs_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1ConversationDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dialogflow_source: 'outputs.GoogleCloudContactcenterinsightsV1DialogflowSourceResponse',
                 gcs_source: 'outputs.GoogleCloudContactcenterinsightsV1GcsSourceResponse'):
        """
        The conversation source, which is a combination of transcript and audio.
        :param 'GoogleCloudContactcenterinsightsV1DialogflowSourceResponse' dialogflow_source: The source when the conversation comes from Dialogflow.
        :param 'GoogleCloudContactcenterinsightsV1GcsSourceResponse' gcs_source: A Cloud Storage location specification for the audio and transcript.
        """
        pulumi.set(__self__, "dialogflow_source", dialogflow_source)
        pulumi.set(__self__, "gcs_source", gcs_source)

    @property
    @pulumi.getter(name="dialogflowSource")
    def dialogflow_source(self) -> 'outputs.GoogleCloudContactcenterinsightsV1DialogflowSourceResponse':
        """
        The source when the conversation comes from Dialogflow.
        """
        return pulumi.get(self, "dialogflow_source")

    @property
    @pulumi.getter(name="gcsSource")
    def gcs_source(self) -> 'outputs.GoogleCloudContactcenterinsightsV1GcsSourceResponse':
        """
        A Cloud Storage location specification for the audio and transcript.
        """
        return pulumi.get(self, "gcs_source")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1ConversationLevelSentimentResponse(dict):
    """
    One channel of conversation-level sentiment data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelTag":
            suggest = "channel_tag"
        elif key == "sentimentData":
            suggest = "sentiment_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1ConversationLevelSentimentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationLevelSentimentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationLevelSentimentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_tag: int,
                 sentiment_data: 'outputs.GoogleCloudContactcenterinsightsV1SentimentDataResponse'):
        """
        One channel of conversation-level sentiment data.
        :param int channel_tag: The channel of the audio that the data applies to.
        :param 'GoogleCloudContactcenterinsightsV1SentimentDataResponse' sentiment_data: Data specifying sentiment.
        """
        pulumi.set(__self__, "channel_tag", channel_tag)
        pulumi.set(__self__, "sentiment_data", sentiment_data)

    @property
    @pulumi.getter(name="channelTag")
    def channel_tag(self) -> int:
        """
        The channel of the audio that the data applies to.
        """
        return pulumi.get(self, "channel_tag")

    @property
    @pulumi.getter(name="sentimentData")
    def sentiment_data(self) -> 'outputs.GoogleCloudContactcenterinsightsV1SentimentDataResponse':
        """
        Data specifying sentiment.
        """
        return pulumi.get(self, "sentiment_data")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1ConversationParticipantResponse(dict):
    """
    The call participant speaking for a given utterance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dialogflowParticipant":
            suggest = "dialogflow_participant"
        elif key == "dialogflowParticipantName":
            suggest = "dialogflow_participant_name"
        elif key == "obfuscatedExternalUserId":
            suggest = "obfuscated_external_user_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1ConversationParticipantResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationParticipantResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationParticipantResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dialogflow_participant: str,
                 dialogflow_participant_name: str,
                 obfuscated_external_user_id: str,
                 role: str,
                 user_id: str):
        """
        The call participant speaking for a given utterance.
        :param str dialogflow_participant: Deprecated. Use `dialogflow_participant_name` instead. The name of the Dialogflow participant. Format: projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
        :param str dialogflow_participant_name: The name of the participant provided by Dialogflow. Format: projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
        :param str obfuscated_external_user_id: Obfuscated user ID from Dialogflow.
        :param str role: The role of the participant.
        :param str user_id: A user-specified ID representing the participant.
        """
        pulumi.set(__self__, "dialogflow_participant", dialogflow_participant)
        pulumi.set(__self__, "dialogflow_participant_name", dialogflow_participant_name)
        pulumi.set(__self__, "obfuscated_external_user_id", obfuscated_external_user_id)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="dialogflowParticipant")
    def dialogflow_participant(self) -> str:
        """
        Deprecated. Use `dialogflow_participant_name` instead. The name of the Dialogflow participant. Format: projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
        """
        return pulumi.get(self, "dialogflow_participant")

    @property
    @pulumi.getter(name="dialogflowParticipantName")
    def dialogflow_participant_name(self) -> str:
        """
        The name of the participant provided by Dialogflow. Format: projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
        """
        return pulumi.get(self, "dialogflow_participant_name")

    @property
    @pulumi.getter(name="obfuscatedExternalUserId")
    def obfuscated_external_user_id(self) -> str:
        """
        Obfuscated user ID from Dialogflow.
        """
        return pulumi.get(self, "obfuscated_external_user_id")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role of the participant.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        A user-specified ID representing the participant.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1ConversationTranscriptResponse(dict):
    """
    A message representing the transcript of a conversation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transcriptSegments":
            suggest = "transcript_segments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1ConversationTranscriptResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationTranscriptResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationTranscriptResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 transcript_segments: Sequence['outputs.GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentResponse']):
        """
        A message representing the transcript of a conversation.
        :param Sequence['GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentResponse'] transcript_segments: A list of sequential transcript segments that comprise the conversation.
        """
        pulumi.set(__self__, "transcript_segments", transcript_segments)

    @property
    @pulumi.getter(name="transcriptSegments")
    def transcript_segments(self) -> Sequence['outputs.GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentResponse']:
        """
        A list of sequential transcript segments that comprise the conversation.
        """
        return pulumi.get(self, "transcript_segments")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadataResponse(dict):
    """
    Metadata from Dialogflow relating to the current transcript segment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "smartReplyAllowlistCovered":
            suggest = "smart_reply_allowlist_covered"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 smart_reply_allowlist_covered: bool):
        """
        Metadata from Dialogflow relating to the current transcript segment.
        :param bool smart_reply_allowlist_covered: Whether the transcript segment was covered under the configured smart reply allowlist in Agent Assist.
        """
        pulumi.set(__self__, "smart_reply_allowlist_covered", smart_reply_allowlist_covered)

    @property
    @pulumi.getter(name="smartReplyAllowlistCovered")
    def smart_reply_allowlist_covered(self) -> bool:
        """
        Whether the transcript segment was covered under the configured smart reply allowlist in Agent Assist.
        """
        return pulumi.get(self, "smart_reply_allowlist_covered")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentResponse(dict):
    """
    A segment of a full transcript.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelTag":
            suggest = "channel_tag"
        elif key == "dialogflowSegmentMetadata":
            suggest = "dialogflow_segment_metadata"
        elif key == "languageCode":
            suggest = "language_code"
        elif key == "messageTime":
            suggest = "message_time"
        elif key == "segmentParticipant":
            suggest = "segment_participant"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_tag: int,
                 confidence: float,
                 dialogflow_segment_metadata: 'outputs.GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadataResponse',
                 language_code: str,
                 message_time: str,
                 segment_participant: 'outputs.GoogleCloudContactcenterinsightsV1ConversationParticipantResponse',
                 sentiment: 'outputs.GoogleCloudContactcenterinsightsV1SentimentDataResponse',
                 text: str,
                 words: Sequence['outputs.GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfoResponse']):
        """
        A segment of a full transcript.
        :param int channel_tag: For conversations derived from multi-channel audio, this is the channel number corresponding to the audio from that channel. For audioChannelCount = N, its output values can range from '1' to 'N'. A channel tag of 0 indicates that the audio is mono.
        :param float confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of this segment. A default value of 0.0 indicates that the value is unset.
        :param 'GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadataResponse' dialogflow_segment_metadata: CCAI metadata relating to the current transcript segment.
        :param str language_code: The language code of this segment as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example: "en-US".
        :param str message_time: The time that the message occurred, if provided.
        :param 'GoogleCloudContactcenterinsightsV1ConversationParticipantResponse' segment_participant: The participant of this segment.
        :param 'GoogleCloudContactcenterinsightsV1SentimentDataResponse' sentiment: The sentiment for this transcript segment.
        :param str text: The text of this segment.
        :param Sequence['GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfoResponse'] words: A list of the word-specific information for each word in the segment.
        """
        pulumi.set(__self__, "channel_tag", channel_tag)
        pulumi.set(__self__, "confidence", confidence)
        pulumi.set(__self__, "dialogflow_segment_metadata", dialogflow_segment_metadata)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "message_time", message_time)
        pulumi.set(__self__, "segment_participant", segment_participant)
        pulumi.set(__self__, "sentiment", sentiment)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "words", words)

    @property
    @pulumi.getter(name="channelTag")
    def channel_tag(self) -> int:
        """
        For conversations derived from multi-channel audio, this is the channel number corresponding to the audio from that channel. For audioChannelCount = N, its output values can range from '1' to 'N'. A channel tag of 0 indicates that the audio is mono.
        """
        return pulumi.get(self, "channel_tag")

    @property
    @pulumi.getter
    def confidence(self) -> float:
        """
        A confidence estimate between 0.0 and 1.0 of the fidelity of this segment. A default value of 0.0 indicates that the value is unset.
        """
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter(name="dialogflowSegmentMetadata")
    def dialogflow_segment_metadata(self) -> 'outputs.GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadataResponse':
        """
        CCAI metadata relating to the current transcript segment.
        """
        return pulumi.get(self, "dialogflow_segment_metadata")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        The language code of this segment as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example: "en-US".
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="messageTime")
    def message_time(self) -> str:
        """
        The time that the message occurred, if provided.
        """
        return pulumi.get(self, "message_time")

    @property
    @pulumi.getter(name="segmentParticipant")
    def segment_participant(self) -> 'outputs.GoogleCloudContactcenterinsightsV1ConversationParticipantResponse':
        """
        The participant of this segment.
        """
        return pulumi.get(self, "segment_participant")

    @property
    @pulumi.getter
    def sentiment(self) -> 'outputs.GoogleCloudContactcenterinsightsV1SentimentDataResponse':
        """
        The sentiment for this transcript segment.
        """
        return pulumi.get(self, "sentiment")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        The text of this segment.
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def words(self) -> Sequence['outputs.GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfoResponse']:
        """
        A list of the word-specific information for each word in the segment.
        """
        return pulumi.get(self, "words")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfoResponse(dict):
    """
    Word-level info for words in a transcript.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endOffset":
            suggest = "end_offset"
        elif key == "startOffset":
            suggest = "start_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence: float,
                 end_offset: str,
                 start_offset: str,
                 word: str):
        """
        Word-level info for words in a transcript.
        :param float confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of this word. A default value of 0.0 indicates that the value is unset.
        :param str end_offset: Time offset of the end of this word relative to the beginning of the total conversation.
        :param str start_offset: Time offset of the start of this word relative to the beginning of the total conversation.
        :param str word: The word itself. Includes punctuation marks that surround the word.
        """
        pulumi.set(__self__, "confidence", confidence)
        pulumi.set(__self__, "end_offset", end_offset)
        pulumi.set(__self__, "start_offset", start_offset)
        pulumi.set(__self__, "word", word)

    @property
    @pulumi.getter
    def confidence(self) -> float:
        """
        A confidence estimate between 0.0 and 1.0 of the fidelity of this word. A default value of 0.0 indicates that the value is unset.
        """
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter(name="endOffset")
    def end_offset(self) -> str:
        """
        Time offset of the end of this word relative to the beginning of the total conversation.
        """
        return pulumi.get(self, "end_offset")

    @property
    @pulumi.getter(name="startOffset")
    def start_offset(self) -> str:
        """
        Time offset of the start of this word relative to the beginning of the total conversation.
        """
        return pulumi.get(self, "start_offset")

    @property
    @pulumi.getter
    def word(self) -> str:
        """
        The word itself. Includes punctuation marks that surround the word.
        """
        return pulumi.get(self, "word")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1DialogflowInteractionDataResponse(dict):
    """
    Dialogflow interaction data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dialogflowIntentId":
            suggest = "dialogflow_intent_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1DialogflowInteractionDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1DialogflowInteractionDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1DialogflowInteractionDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence: float,
                 dialogflow_intent_id: str):
        """
        Dialogflow interaction data.
        :param float confidence: The confidence of the match ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
        :param str dialogflow_intent_id: The Dialogflow intent resource path. Format: projects/{project}/agent/{agent}/intents/{intent}
        """
        pulumi.set(__self__, "confidence", confidence)
        pulumi.set(__self__, "dialogflow_intent_id", dialogflow_intent_id)

    @property
    @pulumi.getter
    def confidence(self) -> float:
        """
        The confidence of the match ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
        """
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter(name="dialogflowIntentId")
    def dialogflow_intent_id(self) -> str:
        """
        The Dialogflow intent resource path. Format: projects/{project}/agent/{agent}/intents/{intent}
        """
        return pulumi.get(self, "dialogflow_intent_id")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1DialogflowSourceResponse(dict):
    """
    A Dialogflow source of conversation data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioUri":
            suggest = "audio_uri"
        elif key == "dialogflowConversation":
            suggest = "dialogflow_conversation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1DialogflowSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1DialogflowSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1DialogflowSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_uri: str,
                 dialogflow_conversation: str):
        """
        A Dialogflow source of conversation data.
        :param str audio_uri: Cloud Storage URI that points to a file that contains the conversation audio.
        :param str dialogflow_conversation: The name of the Dialogflow conversation that this conversation resource is derived from. Format: projects/{project}/locations/{location}/conversations/{conversation}
        """
        pulumi.set(__self__, "audio_uri", audio_uri)
        pulumi.set(__self__, "dialogflow_conversation", dialogflow_conversation)

    @property
    @pulumi.getter(name="audioUri")
    def audio_uri(self) -> str:
        """
        Cloud Storage URI that points to a file that contains the conversation audio.
        """
        return pulumi.get(self, "audio_uri")

    @property
    @pulumi.getter(name="dialogflowConversation")
    def dialogflow_conversation(self) -> str:
        """
        The name of the Dialogflow conversation that this conversation resource is derived from. Format: projects/{project}/locations/{location}/conversations/{conversation}
        """
        return pulumi.get(self, "dialogflow_conversation")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1EntityMentionDataResponse(dict):
    """
    The data for an entity mention annotation. This represents a mention of an `Entity` in the conversation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityUniqueId":
            suggest = "entity_unique_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1EntityMentionDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1EntityMentionDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1EntityMentionDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_unique_id: str,
                 sentiment: 'outputs.GoogleCloudContactcenterinsightsV1SentimentDataResponse',
                 type: str):
        """
        The data for an entity mention annotation. This represents a mention of an `Entity` in the conversation.
        :param str entity_unique_id: The key of this entity in conversation entities. Can be used to retrieve the exact `Entity` this mention is attached to.
        :param 'GoogleCloudContactcenterinsightsV1SentimentDataResponse' sentiment: Sentiment expressed for this mention of the entity.
        :param str type: The type of the entity mention.
        """
        pulumi.set(__self__, "entity_unique_id", entity_unique_id)
        pulumi.set(__self__, "sentiment", sentiment)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="entityUniqueId")
    def entity_unique_id(self) -> str:
        """
        The key of this entity in conversation entities. Can be used to retrieve the exact `Entity` this mention is attached to.
        """
        return pulumi.get(self, "entity_unique_id")

    @property
    @pulumi.getter
    def sentiment(self) -> 'outputs.GoogleCloudContactcenterinsightsV1SentimentDataResponse':
        """
        Sentiment expressed for this mention of the entity.
        """
        return pulumi.get(self, "sentiment")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the entity mention.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1ExactMatchConfigResponse(dict):
    """
    Exact match configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1ExactMatchConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1ExactMatchConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1ExactMatchConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_sensitive: bool):
        """
        Exact match configuration.
        :param bool case_sensitive: Whether to consider case sensitivity when performing an exact match.
        """
        pulumi.set(__self__, "case_sensitive", case_sensitive)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> bool:
        """
        Whether to consider case sensitivity when performing an exact match.
        """
        return pulumi.get(self, "case_sensitive")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1FaqAnswerDataResponse(dict):
    """
    Agent Assist frequently-asked-question answer data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceScore":
            suggest = "confidence_score"
        elif key == "queryRecord":
            suggest = "query_record"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1FaqAnswerDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1FaqAnswerDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1FaqAnswerDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 answer: str,
                 confidence_score: float,
                 metadata: Mapping[str, str],
                 query_record: str,
                 question: str,
                 source: str):
        """
        Agent Assist frequently-asked-question answer data.
        :param str answer: The piece of text from the `source` knowledge base document.
        :param float confidence_score: The system's confidence score that this answer is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
        :param Mapping[str, str] metadata: Map that contains metadata about the FAQ answer and the document that it originates from.
        :param str query_record: Name of the query record. Format: projects/{project}/locations/{location}/queryRecords/{query_record}.
        :param str question: The corresponding FAQ question.
        :param str source: The knowledge document that this answer was extracted from. Format: projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
        """
        pulumi.set(__self__, "answer", answer)
        pulumi.set(__self__, "confidence_score", confidence_score)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "query_record", query_record)
        pulumi.set(__self__, "question", question)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def answer(self) -> str:
        """
        The piece of text from the `source` knowledge base document.
        """
        return pulumi.get(self, "answer")

    @property
    @pulumi.getter(name="confidenceScore")
    def confidence_score(self) -> float:
        """
        The system's confidence score that this answer is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
        """
        return pulumi.get(self, "confidence_score")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Map that contains metadata about the FAQ answer and the document that it originates from.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="queryRecord")
    def query_record(self) -> str:
        """
        Name of the query record. Format: projects/{project}/locations/{location}/queryRecords/{query_record}.
        """
        return pulumi.get(self, "query_record")

    @property
    @pulumi.getter
    def question(self) -> str:
        """
        The corresponding FAQ question.
        """
        return pulumi.get(self, "question")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The knowledge document that this answer was extracted from. Format: projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1GcsSourceResponse(dict):
    """
    A Cloud Storage source of conversation data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioUri":
            suggest = "audio_uri"
        elif key == "transcriptUri":
            suggest = "transcript_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1GcsSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1GcsSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1GcsSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_uri: str,
                 transcript_uri: str):
        """
        A Cloud Storage source of conversation data.
        :param str audio_uri: Cloud Storage URI that points to a file that contains the conversation audio.
        :param str transcript_uri: Immutable. Cloud Storage URI that points to a file that contains the conversation transcript.
        """
        pulumi.set(__self__, "audio_uri", audio_uri)
        pulumi.set(__self__, "transcript_uri", transcript_uri)

    @property
    @pulumi.getter(name="audioUri")
    def audio_uri(self) -> str:
        """
        Cloud Storage URI that points to a file that contains the conversation audio.
        """
        return pulumi.get(self, "audio_uri")

    @property
    @pulumi.getter(name="transcriptUri")
    def transcript_uri(self) -> str:
        """
        Immutable. Cloud Storage URI that points to a file that contains the conversation transcript.
        """
        return pulumi.get(self, "transcript_uri")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1HoldDataResponse(dict):
    """
    The data for a hold annotation.
    """
    def __init__(__self__):
        """
        The data for a hold annotation.
        """
        pass


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1IntentMatchDataResponse(dict):
    """
    The data for an intent match. Represents an intent match for a text segment in the conversation. A text segment can be part of a sentence, a complete sentence, or an utterance with multiple sentences.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intentUniqueId":
            suggest = "intent_unique_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1IntentMatchDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1IntentMatchDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1IntentMatchDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intent_unique_id: str):
        """
        The data for an intent match. Represents an intent match for a text segment in the conversation. A text segment can be part of a sentence, a complete sentence, or an utterance with multiple sentences.
        :param str intent_unique_id: The id of the matched intent. Can be used to retrieve the corresponding intent information.
        """
        pulumi.set(__self__, "intent_unique_id", intent_unique_id)

    @property
    @pulumi.getter(name="intentUniqueId")
    def intent_unique_id(self) -> str:
        """
        The id of the matched intent. Can be used to retrieve the corresponding intent information.
        """
        return pulumi.get(self, "intent_unique_id")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1InterruptionDataResponse(dict):
    """
    The data for an interruption annotation.
    """
    def __init__(__self__):
        """
        The data for an interruption annotation.
        """
        pass


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1IssueAssignmentResponse(dict):
    """
    Information about the issue.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1IssueAssignmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1IssueAssignmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1IssueAssignmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 issue: str,
                 score: float):
        """
        Information about the issue.
        :param str display_name: Immutable. Display name of the assigned issue. This field is set at time of analyis and immutable since then.
        :param str issue: Resource name of the assigned issue.
        :param float score: Score indicating the likelihood of the issue assignment. currently bounded on [0,1].
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "issue", issue)
        pulumi.set(__self__, "score", score)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Immutable. Display name of the assigned issue. This field is set at time of analyis and immutable since then.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def issue(self) -> str:
        """
        Resource name of the assigned issue.
        """
        return pulumi.get(self, "issue")

    @property
    @pulumi.getter
    def score(self) -> float:
        """
        Score indicating the likelihood of the issue assignment. currently bounded on [0,1].
        """
        return pulumi.get(self, "score")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigResponse(dict):
    """
    Configs for the input data used to create the issue model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trainingConversationsCount":
            suggest = "training_conversations_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: str,
                 medium: str,
                 training_conversations_count: str):
        """
        Configs for the input data used to create the issue model.
        :param str filter: A filter to reduce the conversations used for training the model to a specific subset.
        :param str medium: Medium of conversations used in training data. This field is being deprecated. To specify the medium to be used in training a new issue model, set the `medium` field on `filter`.
        :param str training_conversations_count: Number of conversations used in training. Output only.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "medium", medium)
        pulumi.set(__self__, "training_conversations_count", training_conversations_count)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        A filter to reduce the conversations used for training the model to a specific subset.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def medium(self) -> str:
        """
        Medium of conversations used in training data. This field is being deprecated. To specify the medium to be used in training a new issue model, set the `medium` field on `filter`.
        """
        return pulumi.get(self, "medium")

    @property
    @pulumi.getter(name="trainingConversationsCount")
    def training_conversations_count(self) -> str:
        """
        Number of conversations used in training. Output only.
        """
        return pulumi.get(self, "training_conversations_count")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1IssueModelLabelStatsResponse(dict):
    """
    Aggregated statistics about an issue model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analyzedConversationsCount":
            suggest = "analyzed_conversations_count"
        elif key == "issueStats":
            suggest = "issue_stats"
        elif key == "unclassifiedConversationsCount":
            suggest = "unclassified_conversations_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1IssueModelLabelStatsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1IssueModelLabelStatsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1IssueModelLabelStatsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analyzed_conversations_count: str,
                 issue_stats: Mapping[str, str],
                 unclassified_conversations_count: str):
        """
        Aggregated statistics about an issue model.
        :param str analyzed_conversations_count: Number of conversations the issue model has analyzed at this point in time.
        :param Mapping[str, str] issue_stats: Statistics on each issue. Key is the issue's resource name.
        :param str unclassified_conversations_count: Number of analyzed conversations for which no issue was applicable at this point in time.
        """
        pulumi.set(__self__, "analyzed_conversations_count", analyzed_conversations_count)
        pulumi.set(__self__, "issue_stats", issue_stats)
        pulumi.set(__self__, "unclassified_conversations_count", unclassified_conversations_count)

    @property
    @pulumi.getter(name="analyzedConversationsCount")
    def analyzed_conversations_count(self) -> str:
        """
        Number of conversations the issue model has analyzed at this point in time.
        """
        return pulumi.get(self, "analyzed_conversations_count")

    @property
    @pulumi.getter(name="issueStats")
    def issue_stats(self) -> Mapping[str, str]:
        """
        Statistics on each issue. Key is the issue's resource name.
        """
        return pulumi.get(self, "issue_stats")

    @property
    @pulumi.getter(name="unclassifiedConversationsCount")
    def unclassified_conversations_count(self) -> str:
        """
        Number of analyzed conversations for which no issue was applicable at this point in time.
        """
        return pulumi.get(self, "unclassified_conversations_count")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1IssueModelResultResponse(dict):
    """
    Issue Modeling result on a conversation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issueModel":
            suggest = "issue_model"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1IssueModelResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1IssueModelResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1IssueModelResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issue_model: str,
                 issues: Sequence['outputs.GoogleCloudContactcenterinsightsV1IssueAssignmentResponse']):
        """
        Issue Modeling result on a conversation.
        :param str issue_model: Issue model that generates the result. Format: projects/{project}/locations/{location}/issueModels/{issue_model}
        :param Sequence['GoogleCloudContactcenterinsightsV1IssueAssignmentResponse'] issues: All the matched issues.
        """
        pulumi.set(__self__, "issue_model", issue_model)
        pulumi.set(__self__, "issues", issues)

    @property
    @pulumi.getter(name="issueModel")
    def issue_model(self) -> str:
        """
        Issue model that generates the result. Format: projects/{project}/locations/{location}/issueModels/{issue_model}
        """
        return pulumi.get(self, "issue_model")

    @property
    @pulumi.getter
    def issues(self) -> Sequence['outputs.GoogleCloudContactcenterinsightsV1IssueAssignmentResponse']:
        """
        All the matched issues.
        """
        return pulumi.get(self, "issues")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1PhraseMatchDataResponse(dict):
    """
    The data for a matched phrase matcher. Represents information identifying a phrase matcher for a given match.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "phraseMatcher":
            suggest = "phrase_matcher"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1PhraseMatchDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1PhraseMatchDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1PhraseMatchDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 phrase_matcher: str):
        """
        The data for a matched phrase matcher. Represents information identifying a phrase matcher for a given match.
        :param str display_name: The human-readable name of the phrase matcher.
        :param str phrase_matcher: The unique identifier (the resource name) of the phrase matcher.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "phrase_matcher", phrase_matcher)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The human-readable name of the phrase matcher.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="phraseMatcher")
    def phrase_matcher(self) -> str:
        """
        The unique identifier (the resource name) of the phrase matcher.
        """
        return pulumi.get(self, "phrase_matcher")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigResponse(dict):
    """
    Configuration information of a phrase match rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exactMatchConfig":
            suggest = "exact_match_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exact_match_config: 'outputs.GoogleCloudContactcenterinsightsV1ExactMatchConfigResponse'):
        """
        Configuration information of a phrase match rule.
        :param 'GoogleCloudContactcenterinsightsV1ExactMatchConfigResponse' exact_match_config: The configuration for the exact match rule.
        """
        pulumi.set(__self__, "exact_match_config", exact_match_config)

    @property
    @pulumi.getter(name="exactMatchConfig")
    def exact_match_config(self) -> 'outputs.GoogleCloudContactcenterinsightsV1ExactMatchConfigResponse':
        """
        The configuration for the exact match rule.
        """
        return pulumi.get(self, "exact_match_config")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupResponse(dict):
    """
    A message representing a rule in the phrase matcher.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phraseMatchRules":
            suggest = "phrase_match_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 phrase_match_rules: Sequence['outputs.GoogleCloudContactcenterinsightsV1PhraseMatchRuleResponse'],
                 type: str):
        """
        A message representing a rule in the phrase matcher.
        :param Sequence['GoogleCloudContactcenterinsightsV1PhraseMatchRuleResponse'] phrase_match_rules: A list of phase match rules that are included in this group.
        :param str type: The type of this phrase match rule group.
        """
        pulumi.set(__self__, "phrase_match_rules", phrase_match_rules)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="phraseMatchRules")
    def phrase_match_rules(self) -> Sequence['outputs.GoogleCloudContactcenterinsightsV1PhraseMatchRuleResponse']:
        """
        A list of phase match rules that are included in this group.
        """
        return pulumi.get(self, "phrase_match_rules")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this phrase match rule group.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1PhraseMatchRuleResponse(dict):
    """
    The data for a phrase match rule.
    """
    def __init__(__self__, *,
                 config: 'outputs.GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigResponse',
                 negated: bool,
                 query: str):
        """
        The data for a phrase match rule.
        :param 'GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigResponse' config: Provides additional information about the rule that specifies how to apply the rule.
        :param bool negated: Specifies whether the phrase must be missing from the transcript segment or present in the transcript segment.
        :param str query: The phrase to be matched.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "negated", negated)
        pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def config(self) -> 'outputs.GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigResponse':
        """
        Provides additional information about the rule that specifies how to apply the rule.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def negated(self) -> bool:
        """
        Specifies whether the phrase must be missing from the transcript segment or present in the transcript segment.
        """
        return pulumi.get(self, "negated")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        The phrase to be matched.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1RuntimeAnnotationResponse(dict):
    """
    An annotation that was generated during the customer and agent interaction.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "annotationId":
            suggest = "annotation_id"
        elif key == "answerFeedback":
            suggest = "answer_feedback"
        elif key == "articleSuggestion":
            suggest = "article_suggestion"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "dialogflowInteraction":
            suggest = "dialogflow_interaction"
        elif key == "endBoundary":
            suggest = "end_boundary"
        elif key == "faqAnswer":
            suggest = "faq_answer"
        elif key == "smartComposeSuggestion":
            suggest = "smart_compose_suggestion"
        elif key == "smartReply":
            suggest = "smart_reply"
        elif key == "startBoundary":
            suggest = "start_boundary"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1RuntimeAnnotationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1RuntimeAnnotationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1RuntimeAnnotationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotation_id: str,
                 answer_feedback: 'outputs.GoogleCloudContactcenterinsightsV1AnswerFeedbackResponse',
                 article_suggestion: 'outputs.GoogleCloudContactcenterinsightsV1ArticleSuggestionDataResponse',
                 create_time: str,
                 dialogflow_interaction: 'outputs.GoogleCloudContactcenterinsightsV1DialogflowInteractionDataResponse',
                 end_boundary: 'outputs.GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse',
                 faq_answer: 'outputs.GoogleCloudContactcenterinsightsV1FaqAnswerDataResponse',
                 smart_compose_suggestion: 'outputs.GoogleCloudContactcenterinsightsV1SmartComposeSuggestionDataResponse',
                 smart_reply: 'outputs.GoogleCloudContactcenterinsightsV1SmartReplyDataResponse',
                 start_boundary: 'outputs.GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse'):
        """
        An annotation that was generated during the customer and agent interaction.
        :param str annotation_id: The unique identifier of the annotation. Format: projects/{project}/locations/{location}/conversationDatasets/{dataset}/conversationDataItems/{data_item}/conversationAnnotations/{annotation}
        :param 'GoogleCloudContactcenterinsightsV1AnswerFeedbackResponse' answer_feedback: The feedback that the customer has about the answer in `data`.
        :param 'GoogleCloudContactcenterinsightsV1ArticleSuggestionDataResponse' article_suggestion: Agent Assist Article Suggestion data.
        :param str create_time: The time at which this annotation was created.
        :param 'GoogleCloudContactcenterinsightsV1DialogflowInteractionDataResponse' dialogflow_interaction: Dialogflow interaction data.
        :param 'GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse' end_boundary: The boundary in the conversation where the annotation ends, inclusive.
        :param 'GoogleCloudContactcenterinsightsV1FaqAnswerDataResponse' faq_answer: Agent Assist FAQ answer data.
        :param 'GoogleCloudContactcenterinsightsV1SmartComposeSuggestionDataResponse' smart_compose_suggestion: Agent Assist Smart Compose suggestion data.
        :param 'GoogleCloudContactcenterinsightsV1SmartReplyDataResponse' smart_reply: Agent Assist Smart Reply data.
        :param 'GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse' start_boundary: The boundary in the conversation where the annotation starts, inclusive.
        """
        pulumi.set(__self__, "annotation_id", annotation_id)
        pulumi.set(__self__, "answer_feedback", answer_feedback)
        pulumi.set(__self__, "article_suggestion", article_suggestion)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "dialogflow_interaction", dialogflow_interaction)
        pulumi.set(__self__, "end_boundary", end_boundary)
        pulumi.set(__self__, "faq_answer", faq_answer)
        pulumi.set(__self__, "smart_compose_suggestion", smart_compose_suggestion)
        pulumi.set(__self__, "smart_reply", smart_reply)
        pulumi.set(__self__, "start_boundary", start_boundary)

    @property
    @pulumi.getter(name="annotationId")
    def annotation_id(self) -> str:
        """
        The unique identifier of the annotation. Format: projects/{project}/locations/{location}/conversationDatasets/{dataset}/conversationDataItems/{data_item}/conversationAnnotations/{annotation}
        """
        return pulumi.get(self, "annotation_id")

    @property
    @pulumi.getter(name="answerFeedback")
    def answer_feedback(self) -> 'outputs.GoogleCloudContactcenterinsightsV1AnswerFeedbackResponse':
        """
        The feedback that the customer has about the answer in `data`.
        """
        return pulumi.get(self, "answer_feedback")

    @property
    @pulumi.getter(name="articleSuggestion")
    def article_suggestion(self) -> 'outputs.GoogleCloudContactcenterinsightsV1ArticleSuggestionDataResponse':
        """
        Agent Assist Article Suggestion data.
        """
        return pulumi.get(self, "article_suggestion")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which this annotation was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dialogflowInteraction")
    def dialogflow_interaction(self) -> 'outputs.GoogleCloudContactcenterinsightsV1DialogflowInteractionDataResponse':
        """
        Dialogflow interaction data.
        """
        return pulumi.get(self, "dialogflow_interaction")

    @property
    @pulumi.getter(name="endBoundary")
    def end_boundary(self) -> 'outputs.GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse':
        """
        The boundary in the conversation where the annotation ends, inclusive.
        """
        return pulumi.get(self, "end_boundary")

    @property
    @pulumi.getter(name="faqAnswer")
    def faq_answer(self) -> 'outputs.GoogleCloudContactcenterinsightsV1FaqAnswerDataResponse':
        """
        Agent Assist FAQ answer data.
        """
        return pulumi.get(self, "faq_answer")

    @property
    @pulumi.getter(name="smartComposeSuggestion")
    def smart_compose_suggestion(self) -> 'outputs.GoogleCloudContactcenterinsightsV1SmartComposeSuggestionDataResponse':
        """
        Agent Assist Smart Compose suggestion data.
        """
        return pulumi.get(self, "smart_compose_suggestion")

    @property
    @pulumi.getter(name="smartReply")
    def smart_reply(self) -> 'outputs.GoogleCloudContactcenterinsightsV1SmartReplyDataResponse':
        """
        Agent Assist Smart Reply data.
        """
        return pulumi.get(self, "smart_reply")

    @property
    @pulumi.getter(name="startBoundary")
    def start_boundary(self) -> 'outputs.GoogleCloudContactcenterinsightsV1AnnotationBoundaryResponse':
        """
        The boundary in the conversation where the annotation starts, inclusive.
        """
        return pulumi.get(self, "start_boundary")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1SentimentDataResponse(dict):
    """
    The data for a sentiment annotation.
    """
    def __init__(__self__, *,
                 magnitude: float,
                 score: float):
        """
        The data for a sentiment annotation.
        :param float magnitude: A non-negative number from 0 to infinity which represents the abolute magnitude of sentiment regardless of score.
        :param float score: The sentiment score between -1.0 (negative) and 1.0 (positive).
        """
        pulumi.set(__self__, "magnitude", magnitude)
        pulumi.set(__self__, "score", score)

    @property
    @pulumi.getter
    def magnitude(self) -> float:
        """
        A non-negative number from 0 to infinity which represents the abolute magnitude of sentiment regardless of score.
        """
        return pulumi.get(self, "magnitude")

    @property
    @pulumi.getter
    def score(self) -> float:
        """
        The sentiment score between -1.0 (negative) and 1.0 (positive).
        """
        return pulumi.get(self, "score")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1SilenceDataResponse(dict):
    """
    The data for a silence annotation.
    """
    def __init__(__self__):
        """
        The data for a silence annotation.
        """
        pass


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1SmartComposeSuggestionDataResponse(dict):
    """
    Agent Assist Smart Compose suggestion data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceScore":
            suggest = "confidence_score"
        elif key == "queryRecord":
            suggest = "query_record"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1SmartComposeSuggestionDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1SmartComposeSuggestionDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1SmartComposeSuggestionDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence_score: float,
                 metadata: Mapping[str, str],
                 query_record: str,
                 suggestion: str):
        """
        Agent Assist Smart Compose suggestion data.
        :param float confidence_score: The system's confidence score that this suggestion is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
        :param Mapping[str, str] metadata: Map that contains metadata about the Smart Compose suggestion and the document from which it originates.
        :param str query_record: Name of the query record. Format: projects/{project}/locations/{location}/queryRecords/{query_record}
        :param str suggestion: The content of the suggestion.
        """
        pulumi.set(__self__, "confidence_score", confidence_score)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "query_record", query_record)
        pulumi.set(__self__, "suggestion", suggestion)

    @property
    @pulumi.getter(name="confidenceScore")
    def confidence_score(self) -> float:
        """
        The system's confidence score that this suggestion is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
        """
        return pulumi.get(self, "confidence_score")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Map that contains metadata about the Smart Compose suggestion and the document from which it originates.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="queryRecord")
    def query_record(self) -> str:
        """
        Name of the query record. Format: projects/{project}/locations/{location}/queryRecords/{query_record}
        """
        return pulumi.get(self, "query_record")

    @property
    @pulumi.getter
    def suggestion(self) -> str:
        """
        The content of the suggestion.
        """
        return pulumi.get(self, "suggestion")


@pulumi.output_type
class GoogleCloudContactcenterinsightsV1SmartReplyDataResponse(dict):
    """
    Agent Assist Smart Reply data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceScore":
            suggest = "confidence_score"
        elif key == "queryRecord":
            suggest = "query_record"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContactcenterinsightsV1SmartReplyDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContactcenterinsightsV1SmartReplyDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContactcenterinsightsV1SmartReplyDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence_score: float,
                 metadata: Mapping[str, str],
                 query_record: str,
                 reply: str):
        """
        Agent Assist Smart Reply data.
        :param float confidence_score: The system's confidence score that this reply is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
        :param Mapping[str, str] metadata: Map that contains metadata about the Smart Reply and the document from which it originates.
        :param str query_record: Name of the query record. Format: projects/{project}/locations/{location}/queryRecords/{query_record}
        :param str reply: The content of the reply.
        """
        pulumi.set(__self__, "confidence_score", confidence_score)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "query_record", query_record)
        pulumi.set(__self__, "reply", reply)

    @property
    @pulumi.getter(name="confidenceScore")
    def confidence_score(self) -> float:
        """
        The system's confidence score that this reply is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
        """
        return pulumi.get(self, "confidence_score")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Map that contains metadata about the Smart Reply and the document from which it originates.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="queryRecord")
    def query_record(self) -> str:
        """
        Name of the query record. Format: projects/{project}/locations/{location}/queryRecords/{query_record}
        """
        return pulumi.get(self, "query_record")

    @property
    @pulumi.getter
    def reply(self) -> str:
        """
        The content of the reply.
        """
        return pulumi.get(self, "reply")


