# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetRegionNotificationEndpointResult',
    'AwaitableGetRegionNotificationEndpointResult',
    'get_region_notification_endpoint',
    'get_region_notification_endpoint_output',
]

@pulumi.output_type
class GetRegionNotificationEndpointResult:
    def __init__(__self__, creation_timestamp=None, description=None, grpc_settings=None, kind=None, name=None, region=None, self_link=None):
        if creation_timestamp and not isinstance(creation_timestamp, str):
            raise TypeError("Expected argument 'creation_timestamp' to be a str")
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if grpc_settings and not isinstance(grpc_settings, dict):
            raise TypeError("Expected argument 'grpc_settings' to be a dict")
        pulumi.set(__self__, "grpc_settings", grpc_settings)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> str:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="grpcSettings")
    def grpc_settings(self) -> 'outputs.NotificationEndpointGrpcSettingsResponse':
        """
        Settings of the gRPC notification endpoint including the endpoint URL and the retry duration.
        """
        return pulumi.get(self, "grpc_settings")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of the resource. Always compute#notificationEndpoint for notification endpoints.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        URL of the region where the notification endpoint resides. This field applies only to the regional resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")


class AwaitableGetRegionNotificationEndpointResult(GetRegionNotificationEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionNotificationEndpointResult(
            creation_timestamp=self.creation_timestamp,
            description=self.description,
            grpc_settings=self.grpc_settings,
            kind=self.kind,
            name=self.name,
            region=self.region,
            self_link=self.self_link)


def get_region_notification_endpoint(notification_endpoint: Optional[str] = None,
                                     project: Optional[str] = None,
                                     region: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionNotificationEndpointResult:
    """
    Returns the specified NotificationEndpoint resource in the given region.
    """
    __args__ = dict()
    __args__['notificationEndpoint'] = notification_endpoint
    __args__['project'] = project
    __args__['region'] = region
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:compute/alpha:getRegionNotificationEndpoint', __args__, opts=opts, typ=GetRegionNotificationEndpointResult).value

    return AwaitableGetRegionNotificationEndpointResult(
        creation_timestamp=__ret__.creation_timestamp,
        description=__ret__.description,
        grpc_settings=__ret__.grpc_settings,
        kind=__ret__.kind,
        name=__ret__.name,
        region=__ret__.region,
        self_link=__ret__.self_link)


@_utilities.lift_output_func(get_region_notification_endpoint)
def get_region_notification_endpoint_output(notification_endpoint: Optional[pulumi.Input[str]] = None,
                                            project: Optional[pulumi.Input[Optional[str]]] = None,
                                            region: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRegionNotificationEndpointResult]:
    """
    Returns the specified NotificationEndpoint resource in the given region.
    """
    ...
