# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AssetUpdateRequest(Model):
    """AssetUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param running_speed_min:
    :type running_speed_min: float
    :param running_speed_max:
    :type running_speed_max: float
    :param running_speed_type: Possible values include: 'Invalid', 'Fixed',
     'Ranged', 'AutoTrack'
    :type running_speed_type: str or ~smartdiagnostics_sdk.models.enum
    :param running_speed_reference_monitoring_point_id:
    :type running_speed_reference_monitoring_point_id: str
    :param running_speed_sensor_role_type: Possible values include: 'Invalid',
     'CurrentPhaseA', 'PeakCurrentPhaseA', 'CurrentPhaseB',
     'PeakCurrentPhaseB', 'CurrentPhaseC', 'PeakCurrentPhaseC',
     'DifferentialPressure', 'Flow', 'Humidity', 'NodeTemperature',
     'NodeVoltage', 'PeakVibration', 'Pressure', 'RmsVibration',
     'SignalStrength', 'StandardAirVelocity', 'SupplyVoltage', 'Temperature',
     'TotalCurrent', 'VibrationXAxis', 'VibrationYAxis', 'Voltage', 'Current',
     'AtoDChannel1', 'AtoDChannel2', 'AtoDChannel3', 'AtoDChannel4',
     'AtoDChannel5', 'AtoDChannel6', 'OilTemperature', 'OilHumidity', 'X', 'Y',
     'Z', 'Custom', 'WirelessEfficiency', 'PacketSuccessRate', 'NodeHumidity',
     'BurstSuccessRate'
    :type running_speed_sensor_role_type: str or
     ~smartdiagnostics_sdk.models.enum
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param supplier:
    :type supplier: str
    :param manufacturer:
    :type manufacturer: str
    :param model_name:
    :type model_name: str
    :param location_notes:
    :type location_notes: str
    :param notes:
    :type notes: str
    :param generic_input:
    :type generic_input: str
    :param is_operator_view: Required.
    :type is_operator_view: bool
    :param type_id:
    :type type_id: int
    :param category_id:
    :type category_id: int
    :param size_id:
    :type size_id: int
    :param criticality_id:
    :type criticality_id: int
    :param asset_cost:
    :type asset_cost: float
    :param date_installed:
    :type date_installed: datetime
    :param annual_run_time:
    :type annual_run_time: float
    :param lost_production_cost:
    :type lost_production_cost: float
    :param overhaul_cost:
    :type overhaul_cost: float
    :param power_consumption:
    :type power_consumption: float
    :param life_expectancy:
    :type life_expectancy: float
    :param unscheduled_downtime:
    :type unscheduled_downtime: float
    :param running_speed_harmonic:
    :type running_speed_harmonic: float
    """

    _validation = {
        'active': {'required': True},
        'is_paused': {'required': True},
        'name': {'required': True, 'max_length': 100},
        'abbreviation': {'max_length': 5},
        'supplier': {'max_length': 128},
        'manufacturer': {'max_length': 128},
        'model_name': {'max_length': 128},
        'location_notes': {'max_length': 256},
        'notes': {'max_length': 2000},
        'generic_input': {'max_length': 2000},
        'is_operator_view': {'required': True},
    }

    _attribute_map = {
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'running_speed_min': {'key': 'RunningSpeedMin', 'type': 'float'},
        'running_speed_max': {'key': 'RunningSpeedMax', 'type': 'float'},
        'running_speed_type': {'key': 'RunningSpeedType', 'type': 'str'},
        'running_speed_reference_monitoring_point_id': {'key': 'RunningSpeedReferenceMonitoringPointId', 'type': 'str'},
        'running_speed_sensor_role_type': {'key': 'RunningSpeedSensorRoleType', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'supplier': {'key': 'Supplier', 'type': 'str'},
        'manufacturer': {'key': 'Manufacturer', 'type': 'str'},
        'model_name': {'key': 'ModelName', 'type': 'str'},
        'location_notes': {'key': 'LocationNotes', 'type': 'str'},
        'notes': {'key': 'Notes', 'type': 'str'},
        'generic_input': {'key': 'GenericInput', 'type': 'str'},
        'is_operator_view': {'key': 'IsOperatorView', 'type': 'bool'},
        'type_id': {'key': 'TypeId', 'type': 'int'},
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'size_id': {'key': 'SizeId', 'type': 'int'},
        'criticality_id': {'key': 'CriticalityId', 'type': 'int'},
        'asset_cost': {'key': 'AssetCost', 'type': 'float'},
        'date_installed': {'key': 'DateInstalled', 'type': 'iso-8601'},
        'annual_run_time': {'key': 'AnnualRunTime', 'type': 'float'},
        'lost_production_cost': {'key': 'LostProductionCost', 'type': 'float'},
        'overhaul_cost': {'key': 'OverhaulCost', 'type': 'float'},
        'power_consumption': {'key': 'PowerConsumption', 'type': 'float'},
        'life_expectancy': {'key': 'LifeExpectancy', 'type': 'float'},
        'unscheduled_downtime': {'key': 'UnscheduledDowntime', 'type': 'float'},
        'running_speed_harmonic': {'key': 'RunningSpeedHarmonic', 'type': 'float'},
    }

    def __init__(self, *, active: bool, is_paused: bool, name: str, is_operator_view: bool, running_speed_min: float=None, running_speed_max: float=None, running_speed_type=None, running_speed_reference_monitoring_point_id: str=None, running_speed_sensor_role_type=None, abbreviation: str=None, supplier: str=None, manufacturer: str=None, model_name: str=None, location_notes: str=None, notes: str=None, generic_input: str=None, type_id: int=None, category_id: int=None, size_id: int=None, criticality_id: int=None, asset_cost: float=None, date_installed=None, annual_run_time: float=None, lost_production_cost: float=None, overhaul_cost: float=None, power_consumption: float=None, life_expectancy: float=None, unscheduled_downtime: float=None, running_speed_harmonic: float=None, **kwargs) -> None:
        super(AssetUpdateRequest, self).__init__(**kwargs)
        self.active = active
        self.is_paused = is_paused
        self.running_speed_min = running_speed_min
        self.running_speed_max = running_speed_max
        self.running_speed_type = running_speed_type
        self.running_speed_reference_monitoring_point_id = running_speed_reference_monitoring_point_id
        self.running_speed_sensor_role_type = running_speed_sensor_role_type
        self.name = name
        self.abbreviation = abbreviation
        self.supplier = supplier
        self.manufacturer = manufacturer
        self.model_name = model_name
        self.location_notes = location_notes
        self.notes = notes
        self.generic_input = generic_input
        self.is_operator_view = is_operator_view
        self.type_id = type_id
        self.category_id = category_id
        self.size_id = size_id
        self.criticality_id = criticality_id
        self.asset_cost = asset_cost
        self.date_installed = date_installed
        self.annual_run_time = annual_run_time
        self.lost_production_cost = lost_production_cost
        self.overhaul_cost = overhaul_cost
        self.power_consumption = power_consumption
        self.life_expectancy = life_expectancy
        self.unscheduled_downtime = unscheduled_downtime
        self.running_speed_harmonic = running_speed_harmonic
