# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['imageedit']

package_data = \
{'': ['*'], 'imageedit': ['resources/*']}

install_requires = \
['Pillow>=8.1.2,<10',
 'blendmodes>=2020.2.1,<2022',
 'colourswatch>=2020.1,<2022',
 'layeredimage>=2020.5.6,<2022',
 'metprint>=2020.6.1,<2022',
 'svgtrace>=2020.0.2,<2022']

setup_kwargs = {
    'name': 'imageedit',
    'version': '2021',
    'description': 'Create various icon masks and shading effects with the imageedit library',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/ImageEdit.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/imageedit.svg?style=for-the-badge)](https://pypistats.org/packages/imageedit)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fimageedit)](https://pepy.tech/project/imageedit)\n[![PyPI Version](https://img.shields.io/pypi/v/imageedit.svg?style=for-the-badge)](https://pypi.org/project/imageedit)\n\n<!-- omit in toc -->\n# ImageEdit\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\n[**Now available on pypi.org!**](https://pypi.org/project/imageedit/)\n\nCreate various icon masks and shading effects with the imageedit library.\nSix example files under main: round.py, makeProjIcons.py, makePWAImages.py,\nmakeRetro.py, getPWAScreenshots.py and readWriteLayered.py.\n\nLeverages the following libraries to do the heavy lifting:\n```none\npillow\nlayeredimage\nsvgtrace\nblendmodes\n```\n\nHave a look under test/test_readWriteLayered for an example of converting an\nxcf to ora and png. Unfortunately, visibility of xcf is currently ignored :(\n\n- [Example Files](#example-files)\n- [Comparison to similar solutions](#comparison-to-similar-solutions)\n\t- [GUI](#gui)\n\t- [Web](#web)\n\t- [Advantages of this solution](#advantages-of-this-solution)\n\t- [Disadvantages of this solution](#disadvantages-of-this-solution)\n- [How to use out of the box](#how-to-use-out-of-the-box)\n\t- [makePWAImages](#makepwaimages)\n\t- [makeRetro](#makeretro)\n- [Documentation](#documentation)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n\nSee the documentation for each library for more information on things you\ncan use it for.\n\n## Example Files\n- getPWAScreenshots.py\n- makeProjIcons.py\n- makePWAImages.py\n- makeRetro.py\n- readWriteLayered.py\n- round.py\n\n## Comparison to similar solutions\n\nSimilar solutions include but are not limited to:\n\n### GUI\nhttps://www.getpaint.net/\n\n### Web\nhttps://realfavicongenerator.net/\n\n### Advantages of this solution\n- Lightweight: few dependencies required (python, pillow, blendmodes,\nlayeredimage, and svgtrace)\n- Quick: when given a regular or mask image it can produce many\nvariants in a relatively short amount of time\n- Customizable: write your own scripts to leverage imageEdit (python knowledge\nrequired)\n- Produce a PWA mask icon out of the box\n- SVG tracing lib doesn\'t require potrace/ pypotrace which can be challenging to\nset up on Windows\n- SVG tracing using imageTracerJs.py (https://github.com/jankovicsandras/imagetracerjs)\nis pretty good (requires pyppeteer: https://github.com/miyakogi/pyppeteer)\n\n### Disadvantages of this solution\n- Specific image dimensions needed out of the box: whilst this is something that\ncould be changed, maskable icons are 640x640 and regular icons are 512x512\n\n## How to use out of the box\n\n### makePWAImages\n\n1. Put regular 512x512 image or mask 640x640 image under main/input in this\nexample I am using lightfox.png\n\n\t<img src="readme-assets/examples/lightfox.png" alt="LightFox" width="128">\n\n2. Run ```makePWAImages.py``` and navigate to main/output/lightfox.png/pwa\n\n\t<div>\n\t<img src="readme-assets/examples/mask.png" alt="LightFox" width="128">\n\t<img src="readme-assets/examples/round-192.png" alt="LightFox" width="38">\n\t<img src="readme-assets/examples/round-512.png" alt="LightFox" width="102">\n\t<img src="readme-assets/examples/square-180.png" alt="LightFox" width="36">\n\t<img src="readme-assets/examples/squircle-256.png" alt="LightFox" width="52">\n\t</div>\n\n### makeRetro\n1. Put regular 512x512 image or mask 640x640 image under main/input. In this\n   example I am using BlendModes.png\n\n\t<img src="readme-assets/examples/blendmodes.png" alt="BlendModes" width="128">\n\n2. Run ```makeRetro.py``` and navigate to main/output/blendmodes.png/retro\n\tPersonal Computers\n\n\t<div>\n\t<img src="readme-assets/examples/3level.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/bbc-micro.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/zxspectrum.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/websafe.png" alt="BlendModes" width="128">\n\t</div>\n\n\tMobile Operating Systems\n\n\tiOS\n\n\t<div>\n\t<img src="readme-assets/examples/ios1.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/ios7.png" alt="BlendModes" width="128">\n\t</div>\n\n\tAndroid\n\n\t<div>\n\t<img src="readme-assets/examples/android2.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/android6.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/android7.png" alt="BlendModes" width="128">\n\t<img src="readme-assets/examples/android8.png" alt="BlendModes" width="128">\n\t</div>\n\n\n## Documentation\nSee the [Docs](/DOCS.md) for more information.\n\n## Install With PIP\n```python\npip install imageedit\n```\n\nHead to https://pypi.org/project/imageedit/ for more info\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.9.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n```powershell\nchoco install python\n```\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n```bash\nsudo apt install python3.9\n```\n\n## How to run\n### With VSCode\n1. Open the .py file in vscode\n2. Ensure a python 3.9 interpreter is selected (Ctrl+Shift+P > Python:Select\nInterpreter > Python 3.9)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n### From the Terminal\n```bash\n./[file].py\n```\n\n## Download Project\n### Clone\n#### Using The Command Line\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n```bash\n$ git clone https://github.com/FHPythonUtils/ImageEdit\n```\n\nMore information can be found at\n<https://help.github.com/en/articles/cloning-a-repository>\n\n#### Using GitHub Desktop\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\n<https://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop>\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n### Licence\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FredHappyface/Python.ImageEdit',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
