# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

from ccxt.base.exchange import Exchange
from ccxt.base.errors import ExchangeError
from ccxt.base.errors import PermissionDenied
from ccxt.base.errors import BadRequest
from ccxt.base.errors import BadSymbol
from ccxt.base.errors import InsufficientFunds
from ccxt.base.errors import InvalidOrder
from ccxt.base.errors import OrderNotFound
from ccxt.base.errors import RateLimitExceeded
from ccxt.base.precise import Precise


class alpaca(Exchange):

    def describe(self):
        return self.deep_extend(super(alpaca, self).describe(), {
            'id': 'alpaca',
            'name': 'Alpaca',
            'countries': ['US'],
            'rateLimit': 300,  # 200 calls per min --> 300 ms between calls
            'hostname': 'alpaca.markets',
            'urls': {
                'logo': 'https://user-images.githubusercontent.com/26471228/142237130-8f3a06c5-7e35-4fa1-9a82-28ac25795490.jpg',
                'www': 'https://alpaca.markets',
                'api': {
                    'public': 'https://api.alpaca.markets/{version}',
                    'private': 'https://api.alpaca.markets/{version}',
                    'cryptoPrivate': 'https://data.alpaca.markets/{version}',
                },
                'test': {
                    'public': 'https://paper-api.alpaca.markets/{version}',
                    'private': 'https://paper-api.alpaca.markets/{version}',
                    'cryptoPrivate': 'https://data.alpaca.markets/{version}',
                },
                'doc': 'https://alpaca.markets/docs/',
                'fees': 'https://alpaca.markets/support/what-are-the-fees-associated-with-crypto-trading/',
            },
            'has': {
                'CORS': None,
                'spot': True,
                'margin': None,
                'swap': None,
                'future': None,
                'option': None,
                'cancelOrder': True,
                'createOrder': True,
                'fetchBalance': 'emulated',
                'fetchMarkets': True,
                'fetchOpenOrders': True,
                'fetchOrder': True,
                'fetchOrderBook': 'emulated',
                'fetchTicker': True,
                'fetchTrades': True,
            },
            'api': {
                'public': {
                },
                'private': {
                    'get': [
                        'assets',
                        'account',
                        'orders',
                        'orders/{order_id}',
                        'positions',
                        'positions/{symbol}',
                        'account/activities/{activity_type}',
                    ],
                    'post': [
                        'orders',
                    ],
                    'delete': [
                        'orders',
                        'orders/{order_id}',
                    ],
                },
                'cryptoPrivate': {
                    'get': [
                        'crypto/{symbol}/quotes/latest',
                        'crypto/{symbol}/trades/latest',
                        'crypto/{symbol}/xbbo/latest',
                        'crypto/{symbol}/trades',
                    ],
                },
            },
            'requiredCredentials': {
                'apiKey': True,
                'secret': True,
            },
            'options': {
                'versions': {
                    'public': 'v2',
                    'private': 'v2',
                    'cryptoPrivate': 'v1beta1',  # crypto beta
                },
                'defaultExchange': 'CBSE',
                'exchanges': [
                    'CBSE',  # Coinbase
                    'FTX',
                    'GNSS',  # Genesis
                    'ERSX',  # ErisX
                ],
                'defaultTimeInForce': 'day',  # fok, gtc, ioc
                'clientOrderId': 'ccxt_{id}',
            },
            'exceptions': {
                'exact': {
                    'buying power or shares is not sufficient.': InsufficientFunds,
                    'order is not found': OrderNotFound,
                    'failed to cancel order': InvalidOrder,
                    'the order is not cancelable': InvalidOrder,
                    'position is not found': BadRequest,
                    'Failed to liquidate': InvalidOrder,
                    'position does not exist': BadRequest,
                },
                'broad': {
                    'input parameters are not recognized': BadRequest,
                    'invalid query parameters': BadRequest,
                    'unauthorized': PermissionDenied,
                    'too many requests': RateLimitExceeded,
                    'not found': BadSymbol,
                    'request is not authorized': PermissionDenied,
                    'forbidden': PermissionDenied,
                },
            },
        })

    def fetch_markets(self, params={}):
        request = {
            'asset_class': 'crypto',
            'tradeable': True,
        }
        assets = self.privateGetAssets(self.extend(request, params))
        # {
        #     "id": "904837e3-3b76-47ec-b432-046db621571b",
        #     "class": "us_equity",
        #     "exchange": "NASDAQ",
        #     "symbol": "AAPL",
        #     "status": "active",
        #     "tradable": True,
        #     "marginable": True,
        #     "shortable": True,
        #     "easy_to_borrow": True,
        #     "fractionable": True
        #   }
        ids = []
        for i in range(0, len(assets)):
            ids.append(assets[i]['symbol'])
        markets = []
        for i in range(0, len(ids)):
            id = ids[i]
            # will need to change if base or quote currency ticker` length changes
            base = id[0:3].upper()
            quote = id[3:6].upper()
            symbol = base + '/' + quote
            baseId = base.lower()
            quoteId = quote.lower()
            active = True
            taker = 0
            maker = 0
            percentage = False
            tierBased = False
            feeSide = None
            precision = {
                'price': None,
                'amount': None,
                'cost': None,
            }
            info = None
            spot = True
            markets.append({
                'id': id,
                'symbol': symbol,
                'base': base,
                'quote': quote,
                'baseId': baseId,
                'quoteId': quoteId,
                'active': active,
                'taker': taker,
                'maker': maker,
                'tierBased': percentage,
                'percentage': tierBased,
                'feeSide': feeSide,
                'type': 'spot',
                'spot': spot,
                'precision': precision,
                'limits': {
                    'amount': {
                        'min': None,
                        'max': None,
                    },
                },
                'info': info,
            })
        return markets

    def fetch_ticker(self, symbol, params={}):
        self.load_markets()
        market = self.market(symbol)
        id = market['id']
        request = {
            'symbol': id,
        }
        # specify exchange to avoid bidPrice > askPrice --- interexchange arbitrage opportunities
        # needed to add to pass orderbook test: assert(bids[0][0] <= asks[0][0])
        if not ('exchanges' in params):
            params['exchanges'] = self.safe_string(self.options, 'defaultExchange')
        response = self.cryptoPrivateGetCryptoSymbolXbboLatest(self.extend(request, params))
        # {
        #     "symbol": "BTCUSD",
        #     "xbbo": {
        #     "t": "2021-11-16T22:16:00.468860416Z",
        #     "ax": "FTX",
        #     "ap": 60564,
        #     "as": 0.36,
        #     "bx": "FTX",
        #     "bp": 60555,
        #     "bs": 0.36
        # }
        ticker = self.safe_value(response, 'xbbo', {})
        return self.parse_ticker(ticker, market)

    def fetch_trades(self, symbol, since=None, limit=None, params={}):
        self.load_markets()
        market = self.market(symbol)
        id = market['id']
        request = {
            'symbol': id,
        }
        if since is not None:
            request['start'] = self.iso8601(since)
        else:
            request['start'] = self.iso8601(self.milliseconds())
        if limit is not None:
            # hack to parse limit as integer
            request['limit'] = self.safe_integer({'limit': limit}, 'limit')
        response = self.cryptoPrivateGetCryptoSymbolTrades(self.extend(request, params))
        # {
        #     "symbol": "BTCUSD",
        #     "trades": [
        #          {
        #          "t": "2021-11-17T00:18:02.530806Z",
        #          "x": "CBSE",
        #          "p": 60011.36,
        #          "s": 0.00956419,
        #          "tks": "S",
        #          "i": 237168320
        #          },
        # }
        trades = self.safe_value(response, 'trades', {})
        return self.parse_trades(trades, market, since, limit)

    def fetch_order_book(self, symbol, limit=None, params={}):
        # Alpaca does not support level 2 depth orderbook
        # We emulate fetchOrderbook with single BBO
        self.load_markets()
        market = self.market(symbol)
        id = market['id']
        request = {
            'symbol': id,
        }
        # specify exchange to avoid bidPrice > askPrice --- interexchange arbitrage opportunities
        # needed to add to pass orderbook test: assert(bids[0][0] <= asks[0][0])
        if not ('exchanges' in params):
            params['exchanges'] = self.safe_string(self.options, 'defaultExchange')
        response = self.cryptoPrivateGetCryptoSymbolXbboLatest(self.extend(request, params))
        # {
        #     "symbol": "BTCUSD",
        #     "xbbo": {
        #     "t": "2021-11-16T22:16:00.468860416Z",
        #     "ax": "FTX",
        #     "ap": 60564,
        #     "as": 0.36,
        #     "bx": "FTX",
        #     "bp": 60555,
        #     "bs": 0.36
        # }
        quote = self.safe_value(response, 'xbbo', {})
        shallow_bid = [self.safe_number(quote, 'bp'), self.safe_number(quote, 'bs')]
        shallow_ask = [self.safe_number(quote, 'ap'), self.safe_number(quote, 'as')]
        timestamp = self.milliseconds()  # parseDate(self.safe_string(quote, 't'))
        orderbook = {
            'bids': [shallow_bid],
            'asks': [shallow_ask],
        }
        return self.parse_order_book(orderbook, symbol, timestamp)

    def fetch_balance(self, params={}):
        self.load_markets()
        free = {}
        used = {}
        total = {}
        currencies = {}
        accountResponse = self.privateGetAccount()
        # {
        #     "account_blocked": False,
        #     "account_number": "010203ABCD",
        #     "buying_power": "262113.632",
        #     "cash": "-23140.2",
        #     "created_at": "2019-06-12T22:47:07.99658Z",
        #     "currency": "USD",
        #     "daytrade_count": 0,
        #     "daytrading_buying_power": "262113.632",
        #     "equity": "103820.56",
        #     "id": "e6fe16f3-64a4-4921-8928-cadf02f92f98",
        #     "initial_margin": "63480.38",
        #     "last_equity": "103529.24",
        #     "last_maintenance_margin": "38000.832",
        #     "long_market_value": "126960.76",
        #     "maintenance_margin": "38088.228",
        #     "multiplier": "4",
        #     "pattern_day_trader": False,
        #     "portfolio_value": "103820.56",
        #     "regt_buying_power": "80680.36",
        #     "short_market_value": "0",
        #     "shorting_enabled": True,
        #     "sma": "0",
        #     "status": "ACTIVE",
        #     "trade_suspended_by_user": False,
        #     "trading_blocked": False,
        #     "transfers_blocked": False
        # }
        accountCurrency = self.safe_string(accountResponse, 'currency')
        accountCurrencyFree = self.safe_string(accountResponse, 'cash')
        free[accountCurrency] = accountCurrencyFree
        used[accountCurrency] = 0
        total[accountCurrency] = accountCurrencyFree
        currencies[accountCurrency] = {'free': accountCurrencyFree, 'used': 0, 'total': accountCurrencyFree}
        # initialize currencies
        symbols = self.symbols
        for i in range(0, len(symbols)):
            market = self.market(symbols[i])
            base = self.safe_string(market, 'base')
            free[base] = 0
            used[base] = 0
            total[base] = 0
            currencies[base] = {'free': 0, 'used': 0, 'total': 0}
        # fill in existing positions
        positions = self.privateGetPositions()
        # [
        #     {
        #         "asset_id": "ef145fe0-95cd-453a-8609-db7200ff0279",
        #         "symbol": "BTCUSD",
        #         "exchange": "crypto",
        #         "asset_class": "crypto",
        #         "asset_marginable": False,
        #         "qty": "0.0167",
        #         "avg_entry_price": "59506.1",
        #         "side": "long",
        #         "market_value": "988.423067",
        #         "cost_basis": "993.75187",
        #         "unrealized_pl": "-5.328803",
        #         "unrealized_plpc": "-0.0053623073936958",
        #         "unrealized_intraday_pl": "-5.328803",
        #         "unrealized_intraday_plpc": "-0.0053623073936958",
        #         "current_price": "59187.01",
        #         "lastday_price": "59440.5",
        #         "change_today": "-0.004264600735189"
        #     }
        # ]
        for i in range(0, len(positions)):
            position = positions[i]
            if self.safe_string(position, 'asset_class') == 'crypto':
                id = self.safe_string(position, 'symbol')
                market = self.markets_by_id[id]
                base = self.safe_string(market, 'base')
                amount = self.safe_number(position, 'qty')
                free[base] = amount
                used[base] = 0
                total[base] = amount
                currencies[base] = {'free': amount, 'used': 0, 'total': amount}
        timestamp = self.milliseconds()  # alpaca doesn't provide timestamps with account/positions data
        balance = {
            'info': None,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
        }
        balance = self.extend(balance, free, used, total, currencies)
        return self.safe_balance(balance)

    def create_order(self, symbol, type, side, amount, price=None, params={}):
        self.load_markets()
        market = self.market(symbol)
        id = market['id']
        request = {
            'symbol': id,
            'qty': amount,
            'side': side,
            'type': type,
        }
        if type == 'limit':
            request['limit_price'] = price
        if not ('timeInForce' in params):
            request['time_in_force'] = self.safe_string(self.options, 'defaultTimeInForce')
        clientOrderId = self.safe_string(self.options, 'clientOrderId')
        uuid = self.uuid()
        parts = uuid.split('-')
        random_id = ''.join(parts)
        request['client_order_id'] = self.implode_params(clientOrderId, {'id': random_id})
        order = self.privatePostOrders(self.extend(request, params))
        # {
        # "id": "61e69015-8549-4bfd-b9c3-01e75843f47d",
        # "client_order_id": "eb9e2aaa-f71a-4f51-b5b4-52a6c565dad4",
        # "created_at": "2021-03-16T18:38:01.942282Z",
        # "updated_at": "2021-03-16T18:38:01.942282Z",
        # "submitted_at": "2021-03-16T18:38:01.937734Z",
        # "filled_at": null,
        # "expired_at": null,
        # "canceled_at": null,
        # "failed_at": null,
        # "replaced_at": null,
        # "replaced_by": null,
        # "replaces": null,
        # "asset_id": "b0b6dd9d-8b9b-48a9-ba46-b9d54906e415",
        # "symbol": "AAPL",
        # "asset_class": "us_equity",
        # "notional": "500",
        # "qty": null,
        # "filled_qty": "0",
        # "filled_avg_price": null,
        # "order_class": "",
        # "order_type": "market",
        # "type": "market",
        # "side": "buy",
        # "time_in_force": "day",
        # "limit_price": null,
        # "stop_price": null,
        # "status": "accepted",
        # "extended_hours": False,
        # "legs": null,
        # "trail_percent": null,
        # "trail_price": null,
        # "hwm": null
        # }
        return self.parse_order(order, market)

    def cancel_order(self, id, symbol=None, params={}):
        # cancelling order by symbol not yet supported
        request = {
            'order_id': id,
        }
        response = self.privateDeleteOrdersOrderId(self.extend(request, params))
        # {
        #     "code": 40410000,
        #     "message": "order is not found."
        # }
        return self.safe_value(response, 'message', {})

    def fetch_order(self, id, symbol=None, params={}):
        # fetching order by symbol not yet supported
        self.load_markets()
        request = {
            'order_id': id,
        }
        order = self.privateGetOrdersOrderId(self.extend(request, params))
        # {
        #     "id": "61e69015-8549-4bfd-b9c3-01e75843f47d",
        #     "client_order_id": "eb9e2aaa-f71a-4f51-b5b4-52a6c565dad4",
        #     "created_at": "2021-03-16T18:38:01.942282Z",
        #     "updated_at": "2021-03-16T18:38:01.942282Z",
        #     "submitted_at": "2021-03-16T18:38:01.937734Z",
        #     "filled_at": null,
        #     "expired_at": null,
        #     "canceled_at": null,
        #     "failed_at": null,
        #     "replaced_at": null,
        #     "replaced_by": null,
        #     "replaces": null,
        #     "asset_id": "b0b6dd9d-8b9b-48a9-ba46-b9d54906e415",
        #     "symbol": "AAPL",
        #     "asset_class": "us_equity",
        #     "notional": "500",
        #     "qty": null,
        #     "filled_qty": "0",
        #     "filled_avg_price": null,
        #     "order_class": "",
        #     "order_type": "market",
        #     "type": "market",
        #     "side": "buy",
        #     "time_in_force": "day",
        #     "limit_price": null,
        #     "stop_price": null,
        #     "status": "accepted",
        #     "extended_hours": False,
        #     "legs": null,
        #     "trail_percent": null,
        #     "trail_price": null,
        #     "hwm": null
        # }
        _id = self.safe_string(order, 'symbol')
        market = self.safe_string(self.markets_by_id, _id)
        return self.parse_order(order, market)

    def fetch_open_orders(self, symbol=None, since=None, limit=None, params={}):
        # symbol, since, and limit filtering done by base class
        self.load_markets()
        # returns open orders by default
        _orders = self.privateGetOrders(params)
        # add symbols to orders to handle parseOrders
        ordersWithSymbols = []
        for i in range(0, len(_orders)):
            order = _orders[i]
            market = self.safe_string(self.markets_by_id, 'symbol')
            symbol = self.safe_string(market, 'symbol')
            order = self.extend(order, {'symbol': symbol})
            ordersWithSymbols.append(order)
        return self.parse_orders(ordersWithSymbols, None, since, limit)

    def parse_order(self, order, market=None):
        symbol = self.safe_string(order, 'symbol', '')
        if market is not None:
            symbol = market['symbol']
        alpacaStatus = self.safe_string(order, 'status')
        status = 'open'
        if alpacaStatus == 'filled':
            status = 'closed'
        elif alpacaStatus == 'canceled':
            status = 'canceled'
        elif alpacaStatus == 'expired':
            status = 'expired'
        return self.safeOrder2({
            'id': self.safe_string(order, 'id'),
            'clientOrderId': self.safe_string(order, 'client_order_id'),
            'timestamp': self.milliseconds(),
            'datetime': self.safe_string(order, 'submitted_at'),
            'lastTradeTimeStamp': None,
            'status': status,
            'symbol': symbol,
            'type': self.safe_string(order, 'order_type'),
            'timeInForce': self.safe_string(order, 'time_in_force'),
            'side': self.safe_string(order, 'side'),
            'price': self.safe_number(order, 'limit_price'),
            'average': self.safe_number(order, 'filled_avg_price'),
            'amount': self.safe_number(order, 'qty'),
            'filled': self.safe_number(order, 'filled_qty'),
            'remaining': None,
            'cost': None,
            'trades': None,
            'fee': {
                'currency': None,
                'cost': None,
                'rate': None,
            },
            'info': order,
        }, market)

    def parse_trade(self, trade, market=None):
        symbol = self.safe_string(trade, 'symbol', '')
        if market is not None:
            symbol = market['symbol']
        timestamp = self.milliseconds()  # parseDate(self.safe_string(quote, 't'))
        alpacaSide = self.safe_string(trade, 'tks')
        side = None
        if alpacaSide == 'B':
            side = 'buy'
        elif alpacaSide == 'S':
            side = 'sell'
        priceString = self.safe_string(trade, 'p')
        amountString = self.safe_string(trade, 's')
        price = self.parse_number(priceString)
        amount = self.parse_number(amountString)
        cost = self.parse_number(Precise.string_mul(priceString, amountString))
        return {
            'info': trade,
            'id': self.safe_string(trade, 'i'),
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'symbol': symbol,
            'order': None,
            'type': None,
            'side': side,
            'takerOrMaker': 'taker',
            'price': price,
            'amount': amount,
            'cost': cost,
            'fee': {
                'cost': None,
                'currency': None,
                'rate': None,
            },
        }

    def parse_ticker(self, ticker, market=None):
        symbol = market['symbol']
        timestamp = self.milliseconds()  # parseDate(self.safe_string(quote, 't'))
        return self.safe_ticker({
            'symbol': symbol,
            'info': ticker,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'high': None,
            'low': None,
            'bid': self.safe_number(ticker, 'bp'),
            'bidVolume': self.safe_number(ticker, 'bs'),
            'ask': self.safe_number(ticker, 'ap'),
            'askVolume': self.safe_number(ticker, 'as'),
            'vwap': None,
            'open': None,
            'close': None,
            'last': None,
            'previousClose': None,
            'change': None,
            'percentage': None,
            'average': None,
            'baseVolume': None,
            'quoteVolume': None,
        }, market)

    def sign(self, path, api='public', method='GET', params={}, headers=None, body=None):
        versions = self.safe_value(self.options, 'versions')
        version = self.safe_string(versions, api)
        endpoint = '/' + self.implode_params(path, params)
        url = self.implode_params(self.urls['api'][api], {'version': version})
        headers = headers if (headers is not None) else {}
        if (api == 'private') or (api == 'cryptoPrivate'):
            headers['APCA-API-KEY-ID'] = self.apiKey
            headers['APCA-API-SECRET-KEY'] = self.secret
        query = self.omit(params, self.extract_params(path))
        if query:
            if (method == 'GET') or (method == 'DELETE'):
                endpoint += '?' + self.urlencode(query)
            else:
                body = self.json(query)
                headers['Content-Type'] = 'application/json'
        url = url + endpoint
        return {'url': url, 'method': method, 'body': body, 'headers': headers}

    def handle_errors(self, code, reason, url, method, headers, body, response, requestHeaders, requestBody):
        if response is None:
            return  # default error handler
        # {
        #     "code": 40110000,
        #     "message": "request is not authorized"
        # }
        message = self.safe_value(response, 'message', None)
        if message is not None:
            feedback = self.id + ' ' + body
            self.throw_exactly_matched_exception(self.exceptions['exact'], message, feedback)
            self.throw_broadly_matched_exception(self.exceptions['broad'], message, feedback)
            raise ExchangeError(feedback)  # unknown message
