# coding: utf-8

"""
    PowerDNS Authoritative HTTP API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 0.0.13
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerdns_client.api_client import ApiClient


class ZonesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def axfr_export_zone(self, server_id, zone_id, **kwargs):  # noqa: E501
        """Returns the zone in AXFR format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.axfr_export_zone(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.axfr_export_zone_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
        else:
            (data) = self.axfr_export_zone_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
            return data

    def axfr_export_zone_with_http_info(self, server_id, zone_id, **kwargs):  # noqa: E501
        """Returns the zone in AXFR format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.axfr_export_zone_with_http_info(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method axfr_export_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `axfr_export_zone`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `axfr_export_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def axfr_retrieve_zone(self, server_id, zone_id, **kwargs):  # noqa: E501
        """Retrieve slave zone from its master.  # noqa: E501

        Fails when zone kind is not Slave, or slave is disabled in the configuration. Clients MUST NOT send a body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.axfr_retrieve_zone(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.axfr_retrieve_zone_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
        else:
            (data) = self.axfr_retrieve_zone_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
            return data

    def axfr_retrieve_zone_with_http_info(self, server_id, zone_id, **kwargs):  # noqa: E501
        """Retrieve slave zone from its master.  # noqa: E501

        Fails when zone kind is not Slave, or slave is disabled in the configuration. Clients MUST NOT send a body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.axfr_retrieve_zone_with_http_info(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method axfr_retrieve_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `axfr_retrieve_zone`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `axfr_retrieve_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}/axfr-retrieve', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_zone(self, server_id, zone_struct, **kwargs):  # noqa: E501
        """Creates a new domain, returns the Zone on creation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_zone(server_id, zone_struct, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param Zone zone_struct: The zone struct to patch with (required)
        :param bool rrsets: “true” (default) or “false”, whether to include the “rrsets” in the response Zone object.
        :return: Zone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_zone_with_http_info(server_id, zone_struct, **kwargs)  # noqa: E501
        else:
            (data) = self.create_zone_with_http_info(server_id, zone_struct, **kwargs)  # noqa: E501
            return data

    def create_zone_with_http_info(self, server_id, zone_struct, **kwargs):  # noqa: E501
        """Creates a new domain, returns the Zone on creation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_zone_with_http_info(server_id, zone_struct, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param Zone zone_struct: The zone struct to patch with (required)
        :param bool rrsets: “true” (default) or “false”, whether to include the “rrsets” in the response Zone object.
        :return: Zone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_struct', 'rrsets']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `create_zone`")  # noqa: E501
        # verify the required parameter 'zone_struct' is set
        if ('zone_struct' not in params or
                params['zone_struct'] is None):
            raise ValueError("Missing the required parameter `zone_struct` when calling `create_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501

        query_params = []
        if 'rrsets' in params:
            query_params.append(('rrsets', params['rrsets']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zone_struct' in params:
            body_params = params['zone_struct']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Zone',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_zone(self, server_id, zone_id, **kwargs):  # noqa: E501
        """Deletes this zone, all attached metadata and rrsets.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_zone(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_zone_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_zone_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
            return data

    def delete_zone_with_http_info(self, server_id, zone_id, **kwargs):  # noqa: E501
        """Deletes this zone, all attached metadata and rrsets.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_zone_with_http_info(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `delete_zone`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `delete_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_zone(self, server_id, zone_id, **kwargs):  # noqa: E501
        """zone managed by a server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_zone(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :param bool rrsets: “true” (default) or “false”, whether to include the “rrsets” in the response Zone object.
        :return: Zone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_zone_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_zone_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
            return data

    def list_zone_with_http_info(self, server_id, zone_id, **kwargs):  # noqa: E501
        """zone managed by a server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_zone_with_http_info(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :param bool rrsets: “true” (default) or “false”, whether to include the “rrsets” in the response Zone object.
        :return: Zone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id', 'rrsets']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `list_zone`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `list_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501

        query_params = []
        if 'rrsets' in params:
            query_params.append(('rrsets', params['rrsets']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Zone',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_zones(self, server_id, **kwargs):  # noqa: E501
        """List all Zones in a server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_zones(server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone: When set to the name of a zone, only this zone is returned. If no zone with that name exists, the response is an empty array. This can e.g. be used to check if a zone exists in the database without having to guess/encode the zone's id or to check if a zone exists. 
        :param bool dnssec: “true” (default) or “false”, whether to include the “dnssec” and ”edited_serial” fields in the Zone objects. Setting this to ”false” will make the query a lot faster.
        :return: list[Zone]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_zones_with_http_info(server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_zones_with_http_info(server_id, **kwargs)  # noqa: E501
            return data

    def list_zones_with_http_info(self, server_id, **kwargs):  # noqa: E501
        """List all Zones in a server  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_zones_with_http_info(server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone: When set to the name of a zone, only this zone is returned. If no zone with that name exists, the response is an empty array. This can e.g. be used to check if a zone exists in the database without having to guess/encode the zone's id or to check if a zone exists. 
        :param bool dnssec: “true” (default) or “false”, whether to include the “dnssec” and ”edited_serial” fields in the Zone objects. Setting this to ”false” will make the query a lot faster.
        :return: list[Zone]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone', 'dnssec']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_zones" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `list_zones`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'dnssec' in params:
            query_params.append(('dnssec', params['dnssec']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Zone]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notify_zone(self, server_id, zone_id, **kwargs):  # noqa: E501
        """Send a DNS NOTIFY to all slaves.  # noqa: E501

        Fails when zone kind is not Master or Slave, or master and slave are disabled in the configuration. Only works for Slave if renotify is on. Clients MUST NOT send a body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notify_zone(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.notify_zone_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
        else:
            (data) = self.notify_zone_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
            return data

    def notify_zone_with_http_info(self, server_id, zone_id, **kwargs):  # noqa: E501
        """Send a DNS NOTIFY to all slaves.  # noqa: E501

        Fails when zone kind is not Master or Slave, or master and slave are disabled in the configuration. Only works for Slave if renotify is on. Clients MUST NOT send a body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notify_zone_with_http_info(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notify_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `notify_zone`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `notify_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}/notify', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_zone(self, server_id, zone_id, zone_struct, **kwargs):  # noqa: E501
        """Creates/modifies/deletes RRsets present in the payload and their comments. Returns 204 No Content on success.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_zone(server_id, zone_id, zone_struct, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: (required)
        :param Zone zone_struct: The zone struct to patch with (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_zone_with_http_info(server_id, zone_id, zone_struct, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_zone_with_http_info(server_id, zone_id, zone_struct, **kwargs)  # noqa: E501
            return data

    def patch_zone_with_http_info(self, server_id, zone_id, zone_struct, **kwargs):  # noqa: E501
        """Creates/modifies/deletes RRsets present in the payload and their comments. Returns 204 No Content on success.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_zone_with_http_info(server_id, zone_id, zone_struct, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: (required)
        :param Zone zone_struct: The zone struct to patch with (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id', 'zone_struct']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `patch_zone`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `patch_zone`")  # noqa: E501
        # verify the required parameter 'zone_struct' is set
        if ('zone_struct' not in params or
                params['zone_struct'] is None):
            raise ValueError("Missing the required parameter `zone_struct` when calling `patch_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zone_struct' in params:
            body_params = params['zone_struct']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_zone(self, server_id, zone_id, zone_struct, **kwargs):  # noqa: E501
        """Modifies basic zone data (metadata).  # noqa: E501

        Allowed fields in client body: all except id, url and name. Returns 204 No Content on success.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_zone(server_id, zone_id, zone_struct, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: (required)
        :param Zone zone_struct: The zone struct to patch with (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_zone_with_http_info(server_id, zone_id, zone_struct, **kwargs)  # noqa: E501
        else:
            (data) = self.put_zone_with_http_info(server_id, zone_id, zone_struct, **kwargs)  # noqa: E501
            return data

    def put_zone_with_http_info(self, server_id, zone_id, zone_struct, **kwargs):  # noqa: E501
        """Modifies basic zone data (metadata).  # noqa: E501

        Allowed fields in client body: all except id, url and name. Returns 204 No Content on success.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_zone_with_http_info(server_id, zone_id, zone_struct, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: (required)
        :param Zone zone_struct: The zone struct to patch with (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id', 'zone_struct']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `put_zone`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `put_zone`")  # noqa: E501
        # verify the required parameter 'zone_struct' is set
        if ('zone_struct' not in params or
                params['zone_struct'] is None):
            raise ValueError("Missing the required parameter `zone_struct` when calling `put_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zone_struct' in params:
            body_params = params['zone_struct']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rectify_zone(self, server_id, zone_id, **kwargs):  # noqa: E501
        """Rectify the zone data.  # noqa: E501

        This does not take into account the API-RECTIFY metadata. Fails on slave zones and zones that do not have DNSSEC.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rectify_zone(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.rectify_zone_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
        else:
            (data) = self.rectify_zone_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
            return data

    def rectify_zone_with_http_info(self, server_id, zone_id, **kwargs):  # noqa: E501
        """Rectify the zone data.  # noqa: E501

        This does not take into account the API-RECTIFY metadata. Fails on slave zones and zones that do not have DNSSEC.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rectify_zone_with_http_info(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rectify_zone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `rectify_zone`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `rectify_zone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}/rectify', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
