# coding: utf-8

"""
    PowerDNS Authoritative HTTP API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 0.0.13
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerdns_client.api_client import ApiClient


class ZonemetadataApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_metadata(self, server_id, zone_id, metadata, **kwargs):  # noqa: E501
        """Creates a set of metadata entries  # noqa: E501

        Creates a set of metadata entries of given kind for the zone. Existing metadata entries for the zone with the same kind are not overwritten.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_metadata(server_id, zone_id, metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: (required)
        :param Metadata metadata: Metadata object with list of values to create (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_metadata_with_http_info(server_id, zone_id, metadata, **kwargs)  # noqa: E501
        else:
            (data) = self.create_metadata_with_http_info(server_id, zone_id, metadata, **kwargs)  # noqa: E501
            return data

    def create_metadata_with_http_info(self, server_id, zone_id, metadata, **kwargs):  # noqa: E501
        """Creates a set of metadata entries  # noqa: E501

        Creates a set of metadata entries of given kind for the zone. Existing metadata entries for the zone with the same kind are not overwritten.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_metadata_with_http_info(server_id, zone_id, metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: (required)
        :param Metadata metadata: Metadata object with list of values to create (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id', 'metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `create_metadata`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `create_metadata`")  # noqa: E501
        # verify the required parameter 'metadata' is set
        if ('metadata' not in params or
                params['metadata'] is None):
            raise ValueError("Missing the required parameter `metadata` when calling `create_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'metadata' in params:
            body_params = params['metadata']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}/metadata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_metadata(self, server_id, zone_id, metadata_kind, **kwargs):  # noqa: E501
        """Delete all items of a single kind of domain metadata.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_metadata(server_id, zone_id, metadata_kind, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :param str metadata_kind: The kind of metadata (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_metadata_with_http_info(server_id, zone_id, metadata_kind, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_metadata_with_http_info(server_id, zone_id, metadata_kind, **kwargs)  # noqa: E501
            return data

    def delete_metadata_with_http_info(self, server_id, zone_id, metadata_kind, **kwargs):  # noqa: E501
        """Delete all items of a single kind of domain metadata.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_metadata_with_http_info(server_id, zone_id, metadata_kind, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :param str metadata_kind: The kind of metadata (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id', 'metadata_kind']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `delete_metadata`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `delete_metadata`")  # noqa: E501
        # verify the required parameter 'metadata_kind' is set
        if ('metadata_kind' not in params or
                params['metadata_kind'] is None):
            raise ValueError("Missing the required parameter `metadata_kind` when calling `delete_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501
        if 'metadata_kind' in params:
            path_params['metadata_kind'] = params['metadata_kind']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}/metadata/{metadata_kind}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metadata(self, server_id, zone_id, metadata_kind, **kwargs):  # noqa: E501
        """Get the content of a single kind of domain metadata as a Metadata object.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metadata(server_id, zone_id, metadata_kind, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :param str metadata_kind: The kind of metadata (required)
        :return: Metadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_metadata_with_http_info(server_id, zone_id, metadata_kind, **kwargs)  # noqa: E501
        else:
            (data) = self.get_metadata_with_http_info(server_id, zone_id, metadata_kind, **kwargs)  # noqa: E501
            return data

    def get_metadata_with_http_info(self, server_id, zone_id, metadata_kind, **kwargs):  # noqa: E501
        """Get the content of a single kind of domain metadata as a Metadata object.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metadata_with_http_info(server_id, zone_id, metadata_kind, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :param str metadata_kind: The kind of metadata (required)
        :return: Metadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id', 'metadata_kind']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `get_metadata`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `get_metadata`")  # noqa: E501
        # verify the required parameter 'metadata_kind' is set
        if ('metadata_kind' not in params or
                params['metadata_kind'] is None):
            raise ValueError("Missing the required parameter `metadata_kind` when calling `get_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501
        if 'metadata_kind' in params:
            path_params['metadata_kind'] = params['metadata_kind']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}/metadata/{metadata_kind}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Metadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_metadata(self, server_id, zone_id, **kwargs):  # noqa: E501
        """Get all the Metadata associated with the zone.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_metadata(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :return: list[Metadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_metadata_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_metadata_with_http_info(server_id, zone_id, **kwargs)  # noqa: E501
            return data

    def list_metadata_with_http_info(self, server_id, zone_id, **kwargs):  # noqa: E501
        """Get all the Metadata associated with the zone.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_metadata_with_http_info(server_id, zone_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: The id of the zone to retrieve (required)
        :return: list[Metadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `list_metadata`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `list_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Metadata]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_metadata(self, server_id, zone_id, metadata_kind, metadata, **kwargs):  # noqa: E501
        """Replace the content of a single kind of domain metadata.  # noqa: E501

        Creates a set of metadata entries of given kind for the zone. Existing metadata entries for the zone with the same kind are removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_metadata(server_id, zone_id, metadata_kind, metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: (required)
        :param str metadata_kind: The kind of metadata (required)
        :param Metadata metadata: metadata to add/create (required)
        :return: Metadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_metadata_with_http_info(server_id, zone_id, metadata_kind, metadata, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_metadata_with_http_info(server_id, zone_id, metadata_kind, metadata, **kwargs)  # noqa: E501
            return data

    def modify_metadata_with_http_info(self, server_id, zone_id, metadata_kind, metadata, **kwargs):  # noqa: E501
        """Replace the content of a single kind of domain metadata.  # noqa: E501

        Creates a set of metadata entries of given kind for the zone. Existing metadata entries for the zone with the same kind are removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_metadata_with_http_info(server_id, zone_id, metadata_kind, metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve (required)
        :param str zone_id: (required)
        :param str metadata_kind: The kind of metadata (required)
        :param Metadata metadata: metadata to add/create (required)
        :return: Metadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'zone_id', 'metadata_kind', 'metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `modify_metadata`")  # noqa: E501
        # verify the required parameter 'zone_id' is set
        if ('zone_id' not in params or
                params['zone_id'] is None):
            raise ValueError("Missing the required parameter `zone_id` when calling `modify_metadata`")  # noqa: E501
        # verify the required parameter 'metadata_kind' is set
        if ('metadata_kind' not in params or
                params['metadata_kind'] is None):
            raise ValueError("Missing the required parameter `metadata_kind` when calling `modify_metadata`")  # noqa: E501
        # verify the required parameter 'metadata' is set
        if ('metadata' not in params or
                params['metadata'] is None):
            raise ValueError("Missing the required parameter `metadata` when calling `modify_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'zone_id' in params:
            path_params['zone_id'] = params['zone_id']  # noqa: E501
        if 'metadata_kind' in params:
            path_params['metadata_kind'] = params['metadata_kind']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'metadata' in params:
            body_params = params['metadata']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/zones/{zone_id}/metadata/{metadata_kind}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Metadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
