# coding: utf-8

"""
    PowerDNS Authoritative HTTP API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 0.0.13
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerdns_client.api_client import ApiClient


class TsigkeyApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_tsig_key(self, server_id, tsigkey, **kwargs):  # noqa: E501
        """Add a TSIG key  # noqa: E501

        This methods add a new TSIGKey. The actual key can be generated by the server or be provided by the client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tsig_key(server_id, tsigkey, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server (required)
        :param TSIGKey tsigkey: The TSIGKey to add (required)
        :return: TSIGKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_tsig_key_with_http_info(server_id, tsigkey, **kwargs)  # noqa: E501
        else:
            (data) = self.create_tsig_key_with_http_info(server_id, tsigkey, **kwargs)  # noqa: E501
            return data

    def create_tsig_key_with_http_info(self, server_id, tsigkey, **kwargs):  # noqa: E501
        """Add a TSIG key  # noqa: E501

        This methods add a new TSIGKey. The actual key can be generated by the server or be provided by the client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tsig_key_with_http_info(server_id, tsigkey, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server (required)
        :param TSIGKey tsigkey: The TSIGKey to add (required)
        :return: TSIGKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'tsigkey']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tsig_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `create_tsig_key`")  # noqa: E501
        # verify the required parameter 'tsigkey' is set
        if ('tsigkey' not in params or
                params['tsigkey'] is None):
            raise ValueError("Missing the required parameter `tsigkey` when calling `create_tsig_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tsigkey' in params:
            body_params = params['tsigkey']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/tsigkeys', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TSIGKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tsig_key(self, server_id, tsigkey_id, **kwargs):  # noqa: E501
        """Delete the TSIGKey with tsigkey_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tsig_key(server_id, tsigkey_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve the key from (required)
        :param str tsigkey_id: The id of the TSIGkey. Should match the \"id\" field in the TSIGKey object (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tsig_key_with_http_info(server_id, tsigkey_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tsig_key_with_http_info(server_id, tsigkey_id, **kwargs)  # noqa: E501
            return data

    def delete_tsig_key_with_http_info(self, server_id, tsigkey_id, **kwargs):  # noqa: E501
        """Delete the TSIGKey with tsigkey_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tsig_key_with_http_info(server_id, tsigkey_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve the key from (required)
        :param str tsigkey_id: The id of the TSIGkey. Should match the \"id\" field in the TSIGKey object (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'tsigkey_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tsig_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `delete_tsig_key`")  # noqa: E501
        # verify the required parameter 'tsigkey_id' is set
        if ('tsigkey_id' not in params or
                params['tsigkey_id'] is None):
            raise ValueError("Missing the required parameter `tsigkey_id` when calling `delete_tsig_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'tsigkey_id' in params:
            path_params['tsigkey_id'] = params['tsigkey_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/tsigkeys/{tsigkey_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tsig_key(self, server_id, tsigkey_id, **kwargs):  # noqa: E501
        """Get a specific TSIGKeys on the server, including the actual key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tsig_key(server_id, tsigkey_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve the key from (required)
        :param str tsigkey_id: The id of the TSIGkey. Should match the \"id\" field in the TSIGKey object (required)
        :return: TSIGKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tsig_key_with_http_info(server_id, tsigkey_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tsig_key_with_http_info(server_id, tsigkey_id, **kwargs)  # noqa: E501
            return data

    def get_tsig_key_with_http_info(self, server_id, tsigkey_id, **kwargs):  # noqa: E501
        """Get a specific TSIGKeys on the server, including the actual key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tsig_key_with_http_info(server_id, tsigkey_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve the key from (required)
        :param str tsigkey_id: The id of the TSIGkey. Should match the \"id\" field in the TSIGKey object (required)
        :return: TSIGKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'tsigkey_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tsig_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `get_tsig_key`")  # noqa: E501
        # verify the required parameter 'tsigkey_id' is set
        if ('tsigkey_id' not in params or
                params['tsigkey_id'] is None):
            raise ValueError("Missing the required parameter `tsigkey_id` when calling `get_tsig_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'tsigkey_id' in params:
            path_params['tsigkey_id'] = params['tsigkey_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/tsigkeys/{tsigkey_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TSIGKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_tsig_keys(self, server_id, **kwargs):  # noqa: E501
        """Get all TSIGKeys on the server, except the actual key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tsig_keys(server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server (required)
        :return: list[TSIGKey]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_tsig_keys_with_http_info(server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_tsig_keys_with_http_info(server_id, **kwargs)  # noqa: E501
            return data

    def list_tsig_keys_with_http_info(self, server_id, **kwargs):  # noqa: E501
        """Get all TSIGKeys on the server, except the actual key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tsig_keys_with_http_info(server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server (required)
        :return: list[TSIGKey]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_tsig_keys" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `list_tsig_keys`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/tsigkeys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TSIGKey]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_tsig_key(self, server_id, tsigkey_id, tsigkey, **kwargs):  # noqa: E501
        """put_tsig_key  # noqa: E501

        The TSIGKey at tsigkey_id can be changed in multiple ways:  * Changing the Name, this will remove the key with tsigkey_id after adding.  * Changing the Algorithm  * Changing the Key  Only the relevant fields have to be provided in the request body.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_tsig_key(server_id, tsigkey_id, tsigkey, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve the key from (required)
        :param str tsigkey_id: The id of the TSIGkey. Should match the \"id\" field in the TSIGKey object (required)
        :param TSIGKey tsigkey: A (possibly stripped down) TSIGKey object with the new values (required)
        :return: TSIGKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_tsig_key_with_http_info(server_id, tsigkey_id, tsigkey, **kwargs)  # noqa: E501
        else:
            (data) = self.put_tsig_key_with_http_info(server_id, tsigkey_id, tsigkey, **kwargs)  # noqa: E501
            return data

    def put_tsig_key_with_http_info(self, server_id, tsigkey_id, tsigkey, **kwargs):  # noqa: E501
        """put_tsig_key  # noqa: E501

        The TSIGKey at tsigkey_id can be changed in multiple ways:  * Changing the Name, this will remove the key with tsigkey_id after adding.  * Changing the Algorithm  * Changing the Key  Only the relevant fields have to be provided in the request body.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_tsig_key_with_http_info(server_id, tsigkey_id, tsigkey, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server_id: The id of the server to retrieve the key from (required)
        :param str tsigkey_id: The id of the TSIGkey. Should match the \"id\" field in the TSIGKey object (required)
        :param TSIGKey tsigkey: A (possibly stripped down) TSIGKey object with the new values (required)
        :return: TSIGKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server_id', 'tsigkey_id', 'tsigkey']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_tsig_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server_id' is set
        if ('server_id' not in params or
                params['server_id'] is None):
            raise ValueError("Missing the required parameter `server_id` when calling `put_tsig_key`")  # noqa: E501
        # verify the required parameter 'tsigkey_id' is set
        if ('tsigkey_id' not in params or
                params['tsigkey_id'] is None):
            raise ValueError("Missing the required parameter `tsigkey_id` when calling `put_tsig_key`")  # noqa: E501
        # verify the required parameter 'tsigkey' is set
        if ('tsigkey' not in params or
                params['tsigkey'] is None):
            raise ValueError("Missing the required parameter `tsigkey` when calling `put_tsig_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server_id' in params:
            path_params['server_id'] = params['server_id']  # noqa: E501
        if 'tsigkey_id' in params:
            path_params['tsigkey_id'] = params['tsigkey_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tsigkey' in params:
            body_params = params['tsigkey']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/servers/{server_id}/tsigkeys/{tsigkey_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TSIGKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
