"""OSEF private types definition."""
__version__ = "1.11.0"

# Standard imports
from enum import Enum, IntEnum

# !!! Warning !!!
# !!! This file has been auto generated, do not attempt to edit it !!!
# Important: all words use little-endian representation, unless specified otherwise


class OsefTypes(IntEnum):
    """OSEF types."""

    AUGMENTED_CLOUD = 1
    NUMBER_OF_POINTS = 2
    SPHERICAL_COORDINATES = 3
    REFLECTIVITIES = 4
    _BACKGROUND_FLAGS = 5
    CARTESIAN_COORDINATES = 6
    _BGR_COLORS = 7
    _OBJECT_DETECTION_FRAME = 8
    _IMAGE_DIMENSION = 9
    NUMBER_OF_OBJECTS = 10
    _CLOUD_FRAME = 11
    TIMESTAMP_MICROSECOND = 12
    _AZIMUTHS_COLUMN = 13
    NUMBER_OF_LAYERS = 14
    _CLOUD_PROCESSING = 15
    _RANGE_AZIMUTH = 16
    _BOUNDING_BOXES_ARRAY = 17
    CLASS_ID_ARRAY = 18
    _CONFIDENCE_ARRAY = 19
    TIMESTAMPED_DATA = 20
    _PERCEPT = 21
    _BGR_IMAGE_FRAME = 23
    POSE = 24
    SCAN_FRAME = 25
    TRACKED_OBJECTS = 26
    BBOX_SIZES = 27
    SPEED_VECTORS = 28
    POSE_ARRAY = 29
    OBJECT_ID = 30
    CARTESIAN_COORDINATES_4F = 31
    SPHERICAL_COORDINATES_4F = 32
    ZONES_DEF = 33
    ZONE = 34
    ZONE_VERTICES = 35
    ZONE_NAME = 36
    _ZONE_UUID = 37
    ZONES_OBJECTS_BINDING = 38
    OBJECT_PROPERTIES = 39
    _IMU_PACKET = 40
    _TIMESTAMP_LIDAR_VELODYNE = 41
    POSE_RELATIVE = 42
    _GRAVITY = 43
    EGO_MOTION = 44
    _PREDICTED_POSITION = 45
    GEOGRAPHIC_POSE = 46
    OBJECT_ID_32_BITS = 47
    ZONES_OBJECTS_BINDING_32_BITS = 48
    _BACKGROUND_BITS = 49
    _GROUND_PLANE_BITS = 50
    _AZIMUTHS = 51
    _ELEVATIONS = 52
    _DISTANCES = 53
    _LIDAR_MODEL = 54
    SLAM_POSE_ARRAY = 55
    ZONE_VERTICAL_LIMITS = 56
    GEOGRAPHIC_POSE_PRECISE = 57
    _ROAD_MARKINGS_BITS = 58
    SMOOTHED_POSE = 59
    _INTERACTIVE_REQUEST = 60
    _INTERACTIVE_RESPONSE = 61
    _INTERACTIVE_REQUEST_ID = 62
    _INTERACTIVE_REQUEST_BACKGROUND_HEADER = 63
    _INTERACTIVE_RESPONSE_BACKGROUND_HEADER = 64
    _INTERACTIVE_REQUEST_BACKGROUND_DATA = 65
    _INTERACTIVE_RESPONSE_BACKGROUND_DATA = 66
    _INTERACTIVE_REQUEST_PINGPONG = 67
    _INTERACTIVE_RESPONSE_PINGPONG = 68
    _HEIGHT_MAP = 69
    _HEIGHT_MAP_POINTS = 70
    DIVERGENCE_INDICATOR = 71
    _CARLA_TAG_ARRAY = 72
    _BACKGROUND_SCENE_PARAMS = 73
    _BACKGROUND_SCENE_PARAMS_GENERAL = 74
    _BACKGROUND_SCENE_PARAMS_ELEVATIONS = 75
    _BACKGROUND_SCENE_FRAGMENT = 76
    _BACKGROUND_SCENE_FRAGMENT_INFO = 77
    _BACKGROUND_SCENE_FRAGMENT_DISTANCES = 78
    GEOGRAPHIC_POSE_ARRAY = 79
    GEOGRAPHIC_SPEED = 80
    GEOGRAPHIC_SPEED_ARRAY = 81
    _INSTANTANEOUS_TRANSLATION_SPEED = 82
    _INSTANTANEOUS_ROTATION_SPEED = 83
    _FILTERED_TRANSLATION_SPEED = 84
    _FILTERED_ROTATION_SPEED = 85
    REFERENCE_MAP_BITS = 86
    _CARTESIAN_COVARIANCE = 87
    _CYLINDRICAL_COVARIANCE = 88


class OsefKeys(Enum):
    """OSEF type keys."""

    """
    Augmented Cloud
    **Output when**: Augmented Cloud is enabled.
    **Purpose**: An augmented cloud represents a cloud of points. Each point can have attributes, all of which are
    optional, which describe its position, physical property, movement, etc...
    Contains following sub-TLVs:
    - exactly one:     Number of Points               (NUMBER_OF_POINTS)
    - exactly one:     Number of Layers               (NUMBER_OF_LAYERS)
    - none or one:     Spherical Coordinates          (SPHERICAL_COORDINATES) [DEPRECATED USAGE]
    - none or one:     Reflectivities                 (REFLECTIVITIES)
    - none or one:     Background Flags               (BACKGROUND_FLAGS) [DEPRECATED USAGE]
    - none or one:     Cartesian Coordinates          (CARTESIAN_COORDINATES)
    - none or one:     BGR Colors                     (BGR_COLORS)
    - none or one:     Azimuths Column                (AZIMUTHS_COLUMN)
    - none or one:     Cloud Processing               (CLOUD_PROCESSING)
    - none or one:     Percept                        (PERCEPT)
    - none or one:     Object ID 32 Bits              (OBJECT_ID_32_BITS)
    - none or one:     Cartesian Coordinates 4F       (CARTESIAN_COORDINATES_4F) [DEPRECATED USAGE]
    - none or one:     Background Bits                (BACKGROUND_BITS)
    - none or one:     Ground Plane Bits              (GROUND_PLANE_BITS)
    - none or one:     Azimuths                       (AZIMUTHS)
    - none or one:     Elevations                     (ELEVATIONS)
    - none or one:     Distances                      (DISTANCES)
    - none or one:     Road Markings Bits             (ROAD_MARKINGS_BITS)
    - none or one:     Carla Tag Array                (CARLA_TAG_ARRAY)
    - none or one:     Reference Map Bits             (REFERENCE_MAP_BITS)
    """
    AUGMENTED_CLOUD = "augmented_cloud"

    """
    Number of Points
    **Output when**: Augmented Cloud is enabled.
    **Format**: Contains 32 bits unsigned int value.
    **Purpose**: Represents the number of points in the point cloud.
    """
    NUMBER_OF_POINTS = "number_of_points"

    """
    Spherical Coordinates
    Contains list of spherical single-precision float coordinates, three per point:
    * azimuth : degrees, range [ 0.0 .. 360.0 ]
    * elevation : degrees, range [ -90.0 .. +90.0 ]
    * distance : meters, range [ 0.0 ..  +inf ]
    """
    SPHERICAL_COORDINATES = "spherical_coordinates"

    """
    Reflectivities
    **Output when**: Augmented Cloud is enabled.
    **Format**: list of unsigned 8-bits integers.
    **Purpose**: Contains list of reflectivity values.
    Diffuse reflectors report values from 0 to 100 for reflectivities from 0% to 100%.
    Retroreflectors report values from 101 to 255, where 255 represents an ideal reflection.
    """
    REFLECTIVITIES = "reflectivities"

    """
    Background Flags
    **Instead, use**: "Background bits" (Type 49)
    Contains a list of boolean values encoded on an unsigned 8-bits integer:
    * 0 means the point is not part of the background
    * all other values mean the point is part of the background
    The background is defined as the objects which were frequently detected in the past.
    On the contrary the foreground is composed of objects that were not seen before (i.e. they appeared recently and/or
    they are moving).
    """
    _BACKGROUND_FLAGS = "background_flags"

    """
    Cartesian Coordinates
    **Output when**: Augmented Cloud is enabled.
    Contains list of Cartesian single-precision float coordinates, three per point:
    * x : meters, range [ -inf .. +inf ]
    * y : meters, range [ -inf .. +inf ]
    * z : meters, range [ -inf .. +inf ]
    **Coordinate Frame**:
    - Passthrough & Mobile: Relative to LiDAR Coordinate Frame.
    - Static: in Absolute/World Frame, which is:
        - Single-LiDAR: On-Ground LiDAR Coordinate Frame.
        - Multi-LiDARs: Map Coordinate Frame.
    """
    CARTESIAN_COORDINATES = "cartesian_coordinates"

    """
    BGR Colors
    Contain list of BGR colors, encoded as three consecutive unsigned 8-bits integers:
    * blue  : range [ 0 .. 255 ]
    * green : range [ 0 .. 255 ]
    * red   : range [ 0 .. 255 ]
    """
    _BGR_COLORS = "bgr_colors"

    """
    Object Detection Frame
    Group all classification results relative to an image.
    Contains following sub-TLVs:
    - exactly one:     Number of Objects              (NUMBER_OF_OBJECTS)
    - none or one:     Timestamp Microsecond          (TIMESTAMP_MICROSECOND)
    - exactly one:     Bounding Boxes Array           (BOUNDING_BOXES_ARRAY)
    - exactly one:     Class ID Array                 (CLASS_ID_ARRAY)
    - none or one:     Confidence Array               (CONFIDENCE_ARRAY)
    """
    _OBJECT_DETECTION_FRAME = "object_detection_frame"

    """
    Image Dimension
    Contain following concatenated data:
    * image_width   : in pixel, unsigned 32-bits integer, range [ 0 .. 2^32 [
    * image_height  : in pixel, unsigned 32-bits integer, range [ 0 .. 2^32 [
    """
    _IMAGE_DIMENSION = "image_dimension"

    """
    Number of Objects
    **Output when**: Tracking is enabled.
    **Purpose**: Number of tracked objects.
    **Format**: unsigned 32-bits integer, range [ 0 .. 2^32 [
    """
    NUMBER_OF_OBJECTS = "number_of_objects"

    """
    Cloud Frame
    Contains following sub-TLVs:
    - exactly one:     Augmented Cloud                (AUGMENTED_CLOUD)
    - exactly one:     Range Azimuth                  (RANGE_AZIMUTH)
    - none or one:     Timestamp Lidar Velodyne       (TIMESTAMP_LIDAR_VELODYNE)
    """
    _CLOUD_FRAME = "cloud_frame"

    """
    Timestamp Microsecond
    **Output when**: Always.
    **Purpose**: Describes a unix timestamp with microsecond precision, same as struct timeval of UNIX <sys/time.h>.
    **Format**: Contains concatenation of:
    * UNIX time in seconds,   unsigned 32-bits integer, range [ 0 .. 2^32 [
    * remaining microseconds, unsigned 32-bits integer, range [ 0 .. 1000000 [
    """
    TIMESTAMP_MICROSECOND = "timestamp_microsecond"

    """
    Azimuths Column
    Contains list of azimuth values in degrees expressed as single-precision floats.
    This azimuth value is computed before corrections due to:
      * The time between each laser firing
      * The correction when lasers of the same firing sequence are not aligned
    The range is [ 0.0 .. 360.0 [.
    """
    _AZIMUTHS_COLUMN = "azimuths_column"

    """
    Number of Layers
    **Output when**: Augmented Cloud is enabled.
    **Format**: Contains 32 bits unsigned int value.
    **Purpose**: Represents the number of layers of the point cloud.
    0 indicates that this cloud does not have a 2D structure.
    """
    NUMBER_OF_LAYERS = "number_of_layers"

    """
    Cloud Processing
    Contains a 64 bits bitfield, representing the processing that have been applied.
    If no bit are set this means that no processing have been done on this cloud.
    * Bit 0 : The background points have been removed
    """
    _CLOUD_PROCESSING = "cloud_processing"

    """
    Range Azimuth
    Range of azimuth values for the points contained in a given lidar packet.
    Contains exactly two 32 bits floats. The first one marks the beginning of the range, the second the end.
      The range is [ 0.0 .. 360.0 [.
    """
    _RANGE_AZIMUTH = "range_azimuth"

    """
    Bounding Boxes Array
    Contains list of bounding boxes dimensions, four per box:
    * x_min : percentage of the image size, 32-bits floating-point, range [ 0 .. 1 ]
    * y_min : percentage of the image size, 32-bits floating-point, range [ 0 .. 1 ]
    * x_max : percentage of the image size, 32-bits floating-point, range [ 0 .. 1 ]
    * y_max : percentage of the image size, 32-bits floating-point, range [ 0 .. 1 ]
    """
    _BOUNDING_BOXES_ARRAY = "bounding_boxes_array"

    """
    Class ID Array
    **Output when**: Tracking is enabled.
    **Format**: list of signed 32 bits integers, using enum CLASS ID.
    **Purpose**: Contains list of class IDs. For further details, see:
    [Classification](https://docs.outsight.ai/software/understanding-osef-data/object-tracking-data#classification)
    """
    CLASS_ID_ARRAY = "class_id_array"

    """
    Confidence Array
    Contains list of confidences, one per element:
    32-bits floating-point, range [ 0.0 .. 1.0 ]
    """
    _CONFIDENCE_ARRAY = "confidence_array"

    """
    Timestamped Data
    **Output when**: Always.
    Contains following sub-TLVs:
    - exactly one:     Timestamp Microsecond          (TIMESTAMP_MICROSECOND)
    - none or one:     Object Detection Frame         (OBJECT_DETECTION_FRAME)
    - none or one:     Cloud Frame                    (CLOUD_FRAME)
    - none or one:     Scan Frame                     (SCAN_FRAME)
    """
    TIMESTAMPED_DATA = "timestamped_data"

    """
    Percept
    Contains list of percept classes represented as unsigned 16-bits integer, using enum PERCEPT ID.
    """
    _PERCEPT = "percept"

    """
    BGR Image Frame
    Contains following sub-TLVs:
    - exactly one:     BGR Colors                     (BGR_COLORS)
    - exactly one:     Image Dimension                (IMAGE_DIMENSION)
    """
    _BGR_IMAGE_FRAME = "bgr_image_frame"

    """
    Pose
    **Output when**: Slam is enabled.
    **Purpose**: Pose of the LiDAR.
    **Format**: Concatenation of 12 floats of 32-bits each, in this order:
    - Tx, Ty and Tz, representing the translation vector T to get the position coordinates in meters
    - Rxx, Ryx, Rzx, Rxy, Ryy, Rzy, Rxz, Ryz and Rzz represent the rotation matrix R (given column-wise) defining the
    orientation
    As a consequence, considering a device in a pose defined by T and R, you can compute the coordinates Xabs in the
    absolute referential from the coordinates Xrel in device referential using the vectorial formula:
    ```
    Xabs = R * Xrel + T
    ```
    with:
    ```
        [Rxx Rxy Rxz]
    R = [Ryx Ryy Ryz]
        [Rzx Rzy Rzz]
        [Tx]
    T = [Ty]
        [Tz]
    ```
    **Coordinate Frame**:
    Absolute/World Frame, which is:
    - Ego-Motion: Initial pose of the LiDAR.
    - Relocalization: Map Coordinate Frame.
    """
    POSE = "pose"

    """
    Scan Frame
    **Output when**: Always.
    Contains following sub-TLVs:
    - none or one:     Augmented Cloud                (AUGMENTED_CLOUD)
    - none or one:     Pose                           (POSE)
    - none or one:     Geographic Pose                (GEOGRAPHIC_POSE)
    - none or one:     Geographic Pose Precise        (GEOGRAPHIC_POSE_PRECISE)
    - none or one:     Geographic Speed               (GEOGRAPHIC_SPEED)
    - none or one:     Ego Motion                     (EGO_MOTION)
    - none or one:     Tracked Objects                (TRACKED_OBJECTS)
    - none or one:     Zones Def                      (ZONES_DEF)
    - none or one:     Zones Objects Binding          (ZONES_OBJECTS_BINDING) [DEPRECATED USAGE]
    - none or one:     Zones Objects Binding 32 Bits  (ZONES_OBJECTS_BINDING_32_BITS)
    - none or one:     Height Map                     (HEIGHT_MAP)
    """
    SCAN_FRAME = "scan_frame"

    """
    Tracked Objects
    **Output when**: Tracking is enabled.
    **Purpose**: Properties of tracked objects, which includes centroid, bbox, speed...
    For further details, see: [Object Tracking
    Data](https://docs.outsight.ai/software/understanding-osef-data/object-tracking-data).
    Contains following sub-TLVs:
    - exactly one:     Number of Objects              (NUMBER_OF_OBJECTS)
    - exactly one:     Object ID 32 Bits              (OBJECT_ID_32_BITS)
    - none or one:     Class ID Array                 (CLASS_ID_ARRAY)
    - none or one:     Bbox Sizes                     (BBOX_SIZES)
    - none or one:     Speed Vectors                  (SPEED_VECTORS)
    - none or one:     Pose Array                     (POSE_ARRAY)
    - none or one:     Slam Pose Array                (SLAM_POSE_ARRAY)
    - none or one:     Object Properties              (OBJECT_PROPERTIES)
    - none or one:     Geographic Pose Array          (GEOGRAPHIC_POSE_ARRAY)
    - none or one:     Geographic Speed Array         (GEOGRAPHIC_SPEED_ARRAY)
    """
    TRACKED_OBJECTS = "tracked_objects"

    """
    Bbox Sizes
    **Output when**: Tracking is enabled.
    **Purpose**: Define bounding boxes around each tracked object.
    The bounding box is extended/cropped in a way to always touch the ground along the z axis.
    A bounding box is defined by its 3 dimensions, on x, y, z axes, centered on Pose Array.
    **Format**: Array of bounding box sizes, three single-precision floats per object:
    * x : meters, range [ -inf .. +inf ]
    * y : meters, range [ -inf .. +inf ]
    * z : meters, range [ -inf .. +inf ]
    """
    BBOX_SIZES = "bbox_sizes"

    """
    Speed Vectors
    **Output when**: Tracking is enabled.
    **Purpose**: Speed vectors, one for each tracked object.
    Speed vectors are defined on x, y, z axes, centered on Pose Array.
    **Format**: Array of speed vectors, three single-precision floats per object:
    * x : meters per second, range [ -inf .. +inf ]
    * y : meters per second, range [ -inf .. +inf ]
    * z : meters per second, range [ -inf .. +inf ]
    """
    SPEED_VECTORS = "speed_vectors"

    """
    Pose Array
    **Output when**: Tracking is enabled.
    **Purpose**: Contains the poses defining the bounding box of a tracked object.
    **Format**: 12 floats of 32-bits per object:
    * Tx, Ty and Tz represent the translation vector T to get the position coordinates in meters.
    * Rxx, Rxy, Rxz, Ryx, Ryy, Ryz, Rzx, Rzy and Rzz represent the rotation matrix R defining the orientation.
    As a consequence, considering a device in a pose defined by T and R, you can compute the coordinates Xabs in the
    absolute referential from the coordinates Xrel in device referential using the vectorial formula:
    Xabs = R * Xrel + T
    **Coordinate Frame**:
    Absolute/World Frame, which is:
    - Single-LiDAR configuration: On-Ground LiDAR Coordinate Frame.
    - Multi-LiDARs configuration: Map Coordinate Frame.
    """
    POSE_ARRAY = "pose_array"

    """
    Object ID
    **Instead, use**: "Object ID 32 bits" (Type 47)
    """
    OBJECT_ID = "object_id"

    """
    Cartesian Coordinates 4F
    **Instead, use**: "Cartesian Coordinates" (Type 6)
    Alternative way to represent coordinates, where a fourth float is added.
    It can be more efficient to construct if an application aligns the points to use SIMD on 128 bits words.
    Contains list of cartesian single-precision float coordinates, four per point:
    * x : meters, range [ -inf .. +inf ]
    * y : meters, range [ -inf .. +inf ]
    * z : meters, range [ -inf .. +inf ]
    * w : unused, for 128 bits alignment only
    """
    CARTESIAN_COORDINATES_4F = "cartesian_coordinates_4f"

    """
    Spherical Coordinates 4F
    Alternative way to represent coordinates, where a fourth float is added.
    It can be more efficient to construct if an application aligns the points to use SIMD on 128 bits words.
    Contains list of spherical single-precision float coordinates, four per point:
    * azimuth   : degrees, range [ 0.0 .. 360.0 ]
    * elevation : degrees, range [ -90.0 .. +90.0 ]
    * distance  : meters,  range [ 0.0 ..  +inf ]
    * w         : unused, for 128 bits alignment only
    """
    SPHERICAL_COORDINATES_4F = "spherical_coordinates_4f"

    """
    Zones Def
    **Output when**: Tracking is enabled, and at least a zone is defined.
    **Purpose**: Definition of the event zones. They represent spatial areas of interest.
    Their order is important, since the index is used to identify a zone in type 48.
    Contains following sub-TLVs:
    - zero to many:    Zone                           (ZONE)
    """
    ZONES_DEF = "zones_def"

    """
    Zone
    **Output when**: Tracking is enabled, and at least a zone is defined.
    **Purpose**: Defines one zone.
    Contains following sub-TLVs:
    - exactly one:     Zone Vertices                  (ZONE_VERTICES)
    - exactly one:     Zone Name                      (ZONE_NAME)
    - none or one:     Zone UUID                      (ZONE_UUID)
    - none or one:     Zone Vertical Limits           (ZONE_VERTICAL_LIMITS)
    """
    ZONE = "zone"

    """
    Zone Vertices
    **Output when**: Tracking is enabled, and a zone has been defined.
    **Purpose**: Vertices of the polygon defining the zone.
    They are defined on the ground, so the z coordinate is absent.
    **Format**: Contains list of cartesian single-precision float coordinates, two per point.
    * x : meters, range [ -inf .. +inf ]
    * y : meters, range [ -inf .. +inf ]
    There must be at least 3 vertices, so at least 6 floats.
    """
    ZONE_VERTICES = "zone_vertices"

    """
    Zone Name
    **Output when**: Tracking is enabled, and at least a zone is defined.
    **Purpose**: User-defined name to the zone, do not use as unique identifier.
    **Format**: It is UTF-8 encoded and null-terminated.
    """
    ZONE_NAME = "zone_name"

    """
    Zone UUID
    128 bits UUID of the zone in BIG-endian representation.
    UUID 00112233-4455-6677-8899-aabbccddeeff is encoded as the bytes 00 11 22 33 44 55 66 77 88 99 aa bb cc dd ee ff.
    It enables to keep the identity of a zone across renaming or resizing.
    """
    _ZONE_UUID = "zone_uuid"

    """
    Zones Objects Binding
    **Instead, use**: "Zones Objects Binding 32 bits" (Type 48)
    Concatenation of 0 to N couples of:
    * an unsigned 64-bits integer, representing the ID of an object (see type 30)
    * an unsigned 32-bits integer, representing the index of the zone (the n-th type 34 of type 33)
    Each object-zone couple means that the object is considered by the algorithm to be in the zone.
    """
    ZONES_OBJECTS_BINDING = "zones_objects_binding"

    """
    Object Properties
    **Output when**: Tracking is enabled.
    **Purpose**: Properties of the object.
    **Format**: One byte per object, each bit of this can represent different properties.
    * 1st bit: 1 if the object has a proper orientation (like a cuboid), 0 otherwise (like a cylinder).
    * 2nd bit: 1 if the object has been seen in the last scan, 0 if it was not seen.
    * 3rd bit: 1 if the object has a valid slam pose, 0 otherwise. See type 55 (Slam Pose Array) for more information.
    * 4th bit: 1 if the object is static (e.g. traffic signs, poles...), 0 otherwise
    * 5th bit: reserved for later use
    * 6th bit: reserved for later use
    * 7th bit: reserved for later use
    * 8th bit: reserved for later use
    """
    OBJECT_PROPERTIES = "object_properties"

    """
    IMU Packet
    Contains the following data:
    * Time when the IMU packet was received
    * Byte [0,3]: UNIX time in seconds,   unsigned 32-bits integer, range [ 0 .. 2^32 [
    * Byte [4,7]: remaining microseconds, unsigned 32-bits integer, range [ 0 .. 1000000 [
    * Acceleration vector
    * Byte [8,11] x : meters / second^2, 32 bits float, range [ -inf .. +inf ]
    * Byte [12,15] y : meters / second^2, 32 bits float, range [ -inf .. +inf ]
    * Byte [16,19] z : meters / second^2, 32 bits float, range [ -inf .. +inf ]
    * Angular velocity vector
    * Byte [20,23] x : degrees / second, 32 bits float, range [ -inf .. +inf ]
    * Byte [24,27] x : degrees / second, 32 bits float, range [ -inf .. +inf ]
    * Byte [28,31] x : degrees / second, 32 bits float, range [ -inf .. +inf ]
    """
    _IMU_PACKET = "imu_packet"

    """
    Timestamp Lidar Velodyne
    Describes a timestamp with microsecond precision. This timestamp is in the lidar reference system, and uses the
    Velodyne format. This means that this timestamp is the time spent since the beginning of the hour.
    Contains concatenation of:
    * UNIX time in seconds,   unsigned 32-bits integer, range [ 0 .. 2^32 [
    * remaining microseconds, unsigned 32-bits integer, range [ 0 .. 1000000 [
    """
    _TIMESTAMP_LIDAR_VELODYNE = "timestamp_lidar_velodyne"

    """
    Pose Relative
    **Output when**: Slam is enabled.
    **Purpose**: This pose represents the movement of the device between two scans.
    So the position of the current scan can be computed from the one of the previous scan using the following vectorial
    formula:
    ```
    Xcurrent = R * Xprevious + T
    ```
    with:
    ```
        [Rxx Rxy Rxz]
    R = [Ryx Ryy Ryz]
        [Rzx Rzy Rzz]
        [Tx]
    T = [Ty]
        [Tz]
    ```
    **Format**: Concatenation of 12 floats of 32-bits each, in this order:
    - Tx, Ty and Tz, representing the translation vector T to get the position coordinates in meters
    - Rxx, Ryx, Rzx, Rxy, Ryy, Rzy, Rxz, Ryz and Rzz, representing the rotation matrix R (given column-wise) defining
    the orientation
    **Coordinate Frame**: relative to the pose of the previous scan.
    """
    POSE_RELATIVE = "pose_relative"

    """
    Gravity
    Concatenation of 3 floats of 32-bits each [x, y, z], this is the direction of the gravity in the acquisition sensor
    reference frame.
    The vector is either normalised if valid, or [0, 0, 0] if invalid.
    """
    _GRAVITY = "gravity"

    """
    Ego Motion
    **Output when**: SLAM is enabled.
    Contains following sub-TLVs:
    - exactly one:     Pose Relative                  (POSE_RELATIVE)
    - none or one:     Predicted Position             (PREDICTED_POSITION)
    - none or one:     Smoothed Pose                  (SMOOTHED_POSE)
    - none or one:     Divergence Indicator           (DIVERGENCE_INDICATOR)
    - none or one:     Instantaneous Translation Speed (INSTANTANEOUS_TRANSLATION_SPEED)
    - none or one:     Instantaneous Rotation Speed   (INSTANTANEOUS_ROTATION_SPEED)
    - none or one:     Filtered Translation Speed     (FILTERED_TRANSLATION_SPEED)
    - none or one:     Filtered Rotation Speed        (FILTERED_ROTATION_SPEED)
    - none or one:     Cartesian covariance           (CARTESIAN_COVARIANCE)
    - none or one:     Cylindrical covariance         (CYLINDRICAL_COVARIANCE)
    """
    EGO_MOTION = "ego_motion"

    """
    Predicted Position
    **Output when**: Slam is enabled.
    **Purpose**: Cartesian coordinates of the predicted position in slam.
    The time of prediction is set at startup, and defaults to 1 second.
    **Format**: Contains 3 floats.
    **Coordinate Frame**: relative to the LiDAR Coordinate Frame.
    """
    _PREDICTED_POSITION = "predicted_position"

    """
    Geographic Pose
    **Deprecated since**: 5.3
    **Instead, use**: "Geographic Pose Precise" (Type 57)
    **Purpose**: Represents the geographic pose, output from the relocalization processing, expressed in decimal
    degrees notation (latitude, longitude & heading).
    **Format**: Concatenation of 3 single precision (32 bits) floats [lat, long, heading].
    * Single-precision floating-point (float32) : latitude in decimal degrees, range [ -90.0 .. 90.0 ]
    * Single-precision floating-point (float32) : longitude in decimal degrees, range [ -180.0 .. 180.0 ]
    * Single-precision floating-point (float32) : heading in decimal degrees, range [ 0.0 .. 360.0 [
    """
    GEOGRAPHIC_POSE = "geographic_pose"

    """
    Object ID 32 Bits
    **Output when**: Tracking is enabled.
    **Format**: Array of unsigned 32-bits integers. Each element of the array is an Object ID.
    **Purpose**: Give a unique identifier (ID) to each detected object.
    Optionally, this ID can also be used to establish a link between detected objects
    and the defined Zones, or the points of a Augmented Cloud.
    When used as leaf of Tracked Objects:
    - The number of elements of the array is equal to the Number of Objects (type 10).
    - Each ID represents a distinct detected object.
    - The affectation of an ID to an object is arbitrary and permanent,
      it remains the same throughout the tracking phase.
    When used as leaf of Augmented Cloud:
    - The number of elements of the array is equal to the Number of Points (type 2).
    - Each specified ID indicates to which object the point belongs.
    - The special value 0 is used to mean 'no object'.
      For instance, if the object ID of a point is 0,
      it means that this point does not belong to any object.
    The Object ID is also used in Zones Objects Binding 32 Bits (type 48), combined with Zone identifier.
    """
    OBJECT_ID_32_BITS = "object_id_32_bits"

    """
    Zones Objects Binding 32 Bits
    **Output when**: Tracking is enabled, and at least one zone has been defined.
    **Purpose**: This type is used to know with tracked objects are in which event zones.
    The binary payload is the concatenation of 0 to N couples of:
    * an unsigned 32-bits integer, representing the ID of an object (see 47)
    * an unsigned 32-bits integer, representing the index of the event zone (the n-th type 34 of type 33)
    Each object-zone couple means that the object is considered by the algorithm to be in the zone.
    """
    ZONES_OBJECTS_BINDING_32_BITS = "zones_objects_binding_32_bits"

    """
    Background Bits
    Contains a padded list of bits, 1 bit per point of the cloud. If the bit is set, the point is a background point.
    The background is defined as the objects which were frequently detected in the past.
    On the contrary the foreground is composed of objects that were not seen before (i.e. they appeared recently and/or
    they are moving).
    """
    _BACKGROUND_BITS = "background_bits"

    """
    Ground Plane Bits
    Contains a padded list of bits, 1 bit per point of the cloud. If the bit is set, the point belongs to the ground.
    """
    _GROUND_PLANE_BITS = "ground_plane_bits"

    """
    Azimuths
    Contains list of azimuth coordinates.
    The definition of this angle can be found
    [here](https://docs.outsight.ai/software/coordinate-conventions#lidar-reference-frame).
    The azimuths are in degrees and expressed as single-precision floats. Several values are concatenated so the
    information of n points are given at once.
    The range of each value is [ 0.0 .. 360.0 [. 360.0 [.
    """
    _AZIMUTHS = "azimuths"

    """
    Elevations
    Contains list of elevation values in degrees expressed as single-precision floats.
    The definition of the elevation can be found
    [here](https://docs.outsight.ai/software/coordinate-conventions#lidar-reference-frame).
    The range is [ -90.0 .. +90.0 [.
    """
    _ELEVATIONS = "elevations"

    """
    Distances
    Contains list of distance values in meters expressed as single-precision floats.
    The definition of the distance can be found
    [here](https://docs.outsight.ai/software/coordinate-conventions#lidar-reference-frame).
    The range is [ 0.0 .. +inf [.
    """
    _DISTANCES = "distances"

    """
    LiDAR Model
    One unsigned 8-bits integer representing a model of LiDAR, using enum LIDAR MODEL ID.
    """
    _LIDAR_MODEL = "lidar_model"

    """
    Slam Pose Array
    **Output when**: Tracking/objects_super_resolution is enabled.
    **Purpose**: Pose of tracked objects. It is similar to type 29 "Pose Array", but it is more accurate since
    it uses a SLAM algorithm and not just a box fitting algorithm.
    The position part follows an arbitrary point on the object, which is not necessarily its center.
    The orientation part is arbitrary for the first predicted pose, then follows the rotation of the object.
    The SLAM algorithm may not run on all tracked objects. When the SLAM does not run on an object,
    let say on object number 5, all floats of the related pose in this array, e.g. the fifth, are equal to zero.
    Moreover, the related element of type 39 "Object properties", e.g. the fifth, has its third bit equal to zero.
    For further details see: [Spatial Data / Static
    Tracking](https://docs.outsight.ai/software/understanding-osef-data/spatial-data-tracking).
    **Format**: The binary payload is a repetition of the following content, one per tracked object:
    * single-precision floats Tx, Ty and Tz represent the translation vector T to get the position coordinates in
    meters.
    * single-precision floats Rxx, Rxy, Rxz, Ryx, Ryy, Ryz, Rzx, Rzy and Rzz represent the rotation matrix R defining
    the orientation.
    **Coordinate Frame**:
    Absolute/world, which is:
    - Single-LiDAR: On-Ground LiDAR Coordinate Frame.
    - Multi-LiDARs: Map Coordinate Frame.
    """
    SLAM_POSE_ARRAY = "slam_pose_array"

    """
    Zone Vertical Limits
    **Output when**: Tracking is enabled, and at least a zone has been defined with Vertical Limits.
    **Format**: The binary value is the concatenation of:
    * one single-precision float, elevation, in meters
    * one single-precision float, height, in meters
    **Purpose**: Optional zone configuration which adds a filtering depending on the vertical position of objects.
    It is part of the definition of the zone.
    Only objects whose altitude is between elevation and elevation + height will be considered in the zone.
    """
    ZONE_VERTICAL_LIMITS = "zone_vertical_limits"

    """
    Geographic Pose Precise
    **Output when**: Relocalization in a reference map and georeferencing are enabled.
    So in processing config: slam.enable set to true, slam.reference_map defined and slam.georeferencing set to true.
    **Purpose**: Represents the geographic pose, output from the relocalization processing, expressed in decimal
    degrees notation (latitude, longitude & heading).
    **Format**: Concatenation of 2 double precision (64 bits) and a single precision (32 bits) floats [lat, long,
    heading].
    * Double-precision floating-point (float64) : latitude in decimal degrees, range [ -90.0 .. 90.0 ]
    * Double-precision floating-point (float64) : longitude in decimal degrees, range [ -180.0 .. 180.0 ]
    * Single-precision floating-point (float32) : heading in decimal degrees, range [ 0.0 .. 360.0 [
    """
    GEOGRAPHIC_POSE_PRECISE = "geographic_pose_precise"

    """
    Road Markings Bits
    Contains a padded (up to a byte) list of bits, 1 bit per point of the cloud. If the bit is set, the point belongs
    to a road marking.
    """
    _ROAD_MARKINGS_BITS = "road_markings_bits"

    """
    Smoothed Pose
    **Output when**: SLAM is enabled.
    **Purpose**: Smoothed pose of the absolute LiDAR pose will introduce a slight delay.
    **Format**: Concatenation of 12 floats of 32-bits each, see type Pose for more details.
    """
    SMOOTHED_POSE = "smoothed_pose"

    """
    Interactive Request
    A Request to a device, where a Timestamp and a Request ID are mandatory.
    """
    _INTERACTIVE_REQUEST = "interactive_request"

    """
    Interactive Response
    A Response made by a device.
    """
    _INTERACTIVE_RESPONSE = "interactive_response"

    """
    Interactive Request ID
    An ID to identify to which request is associated the response.
    **Format**: unsigned 32-bits integer.
    """
    _INTERACTIVE_REQUEST_ID = "interactive_request_id"

    """
    Interactive Request Background Header
    Request background header.
    """
    _INTERACTIVE_REQUEST_BACKGROUND_HEADER = "interactive_request_background_header"

    """
    Interactive Response Background Header
    Response background header.
    """
    _INTERACTIVE_RESPONSE_BACKGROUND_HEADER = "interactive_response_background_header"

    """
    Interactive Request Background Data
    Request background data.
    """
    _INTERACTIVE_REQUEST_BACKGROUND_DATA = "interactive_request_background_data"

    """
    Interactive Response Background Data
    Response background data.
    """
    _INTERACTIVE_RESPONSE_BACKGROUND_DATA = "interactive_response_background_data"

    """
    Interactive Request PingPong
    Request pingpong.
    **Format**: binary payload
    """
    _INTERACTIVE_REQUEST_PINGPONG = "interactive_request_pingpong"

    """
    Interactive Response PingPong
    Response pingpong.
    **Format**: The same binary payload as in the request
    """
    _INTERACTIVE_RESPONSE_PINGPONG = "interactive_response_pingpong"

    """
    Height Map
    Height map of a configurable zone of interest.
    **Output when**: generated by height_map app.
    """
    _HEIGHT_MAP = "height_map"

    """
    Height Map Points
    Points that define the height map and provide the height data.
    The height map is defined as a two-dimensional horizontal grid in the Lidar frame, with given dimensions and number
    of cells.
    The properties of the height map, such as size, number of cells, height offset, etc, are defined by the height_map
    app configuration.
    Every points of the augmented cloud are used to build the height map, with no distinction if it is a point of the
    ground, a motion point or any other flag.
    A point of the cloud is associated with a cell if its projected point on the grid is in the cell.
    The height map provides one height information per cell, the height value depends on the way it is computed by the
    app (a cell with no points will have a nan value).
    The Height Map Points is defined as an array of points, with one point per cell of the height map.
    The x and y coordinates represent the center of the cell in the Lidar frame, the third value is the height of the
    cell computed by the app with the points of the cell.
    **Format**: Contains list of Cartesian single-precision float coordinates, three per point:
    * x : meters, range [ -inf .. +inf ]
    * y : meters, range [ -inf .. +inf ]
    * z : meters, range [ -inf .. +inf ]
    """
    _HEIGHT_MAP_POINTS = "height_map_points"

    """
    Divergence Indicator
    **Since**: 5.6.0
    **Output when**: Ego-Motion or Relocalization is enabled.
    **Format**: One float value.
    **Purpose**: Indicates if SLAM seems to have diverged.
    - 0 means SLAM algorithm does not seem to have diverged.
    - 1 means SLAM algorithm seems to have diverged, the associated pose is not trustworthy.
    """
    DIVERGENCE_INDICATOR = "divergence_indicator"

    """
    Carla Tag Array
    **Output when**: generated by Carla Scenario Generator.
    **Format**: list of unsigned 8-bits integers, using enum Carla Tag enum.
    **Purpose**: keeps the tag value, attributed by the Carla Simulator, to each point of the pointcloud.
    """
    _CARLA_TAG_ARRAY = "carla_tag_array"

    """
    Background Scene Params
    **Output when**: Multi-LiDARS Tracking is enabled, in the background stream between edge and fusion.
    **Purpose**: All params to initialize the background scene and be able to interpret Background Stream Fragment
    (type 76) packets
    """
    _BACKGROUND_SCENE_PARAMS = "background_scene_params"

    """
    Background Scene Params General
    **Output when**: Multi-LiDARS Tracking is enabled, in the background stream between edge and fusion.
    **Format**: the following concatenated values:
      * width: 32-bits unsigned integer, number of columns of the background scene array
      * height: 32-bits unsigned integer, number of rows of the background scene array
      * first azimuth: single-precision float, azimuth of the first column of the background scene array, in degrees
      * azimuth step: single-precision float, difference between the azimuths of two consecutive columns of the
    background scene array, in degrees
    """
    _BACKGROUND_SCENE_PARAMS_GENERAL = "background_scene_params_general"

    """
    Background Scene Params Elevations
    **Output when**: generated by Carla Scenario Generator.
    **Format**: list of single precision floats, each one representing the elevation of a row in the background scene
    array, in degrees
    """
    _BACKGROUND_SCENE_PARAMS_ELEVATIONS = "background_scene_params_elevations"

    """
    Background Scene Fragment
    **Output when**: Multi-LiDARS Tracking is enabled, in the background stream between edge and fusion.
    **Purpose**: A fragment of the background scene array
    """
    _BACKGROUND_SCENE_FRAGMENT = "background_scene_fragment"

    """
    Background Scene Fragment Info
    **Output when**: in background stream between edge and fusion, in tracking mode
    **Format**: the following concatenated values:
      * first_index: 32-bites unsigned integer, index of the first cell in background scene array, computed as x *
    height + y, the second cell index is first_index+1, etc., with a rollover on width * height
      * cells_number: 32-bites unsigned integer, number of cells contained in the fragment
    """
    _BACKGROUND_SCENE_FRAGMENT_INFO = "background_scene_fragment_info"

    """
    Background Scene Fragment Distances
    **Output when**: Multi-LiDARS Tracking is enabled, in the background stream between edge and fusion.
    **Format**: list of single precision floats, each one representing the farthest background distance for the
    corresponding cell
    """
    _BACKGROUND_SCENE_FRAGMENT_DISTANCES = "background_scene_fragment_distances"

    """
    Geographic Pose Array
    **Output when**: Tracking is enabled and georeferencing is activated.
    **Purpose**: Represents the geographic pose, output from the relocalization processing, expressed in decimal
    degrees notation (latitude, longitude & heading) of each tracked object.
    **Format**: Concatenation of 2 double precision (64 bits) and a single precision (32 bits) floats [lat, long,
    heading], one for each tracked object.
    * Double-precision floating-point (float64): latitude in decimal degrees, range [ -90.0 .. 90.0 ]
    * Double-precision floating-point (float64): longitude in decimal degrees, range [ -180.0 .. 180.0 ]
    * Single-precision floating-point (float32): heading in decimal degrees, range [ 0.0 .. 360.0 [
    """
    GEOGRAPHIC_POSE_ARRAY = "geographic_pose_array"

    """
    Geographic Speed
    **Output when**: Georeferencing is activated.
    **Purpose**: Represents speed of mobile platform (on which LiDAR is mounted) as speed in m/s and geographic heading
    in decimal degrees.
    **Format**: Concatenation of two single-precision (32-bits) floats per object:
    * v: absolute speed in meters per second, range [ 0 .. +inf ]
    * heading: speed vector heading in decimal degrees, range [ 0.0 .. 360.0 [
    """
    GEOGRAPHIC_SPEED = "geographic_speed"

    """
    Geographic Speed Array
    **Output when**: Tracking is enabled and georeferencing is activated.
    **Purpose**: Represents speed of tracked objects represented as speed in m/s and geographic heading in decimal
    degrees.
    **Format**: Array of geographic speeds, two single-precision (32 bits) floats per object:
    * v: absolute speed in meters per second, range [ 0 .. +inf ]
    * heading: speed vector heading in decimal degrees, range [ 0.0 .. 360.0 [
    """
    GEOGRAPHIC_SPEED_ARRAY = "geographic_speed_array"

    """
    Instantaneous Translation Speed
    **Output when**: SLAM is enabled and its speed_measurement module is enabled.
    **Purpose**: Represents the instantaneous translation speed of the device (m/s).
    **Format**: Array of 3 single precision (32 bits) floats, representing the translation speed on each direction.
    """
    _INSTANTANEOUS_TRANSLATION_SPEED = "instantaneous_translation_speed"

    """
    Instantaneous Rotation Speed
    **Output when**: SLAM is enabled and its speed_measurement module is enabled.
    **Purpose**: Represents the instantaneous rotation speed of the device (rad/s).
    **Format**: Array of 3 single precision (32 bits) floats, representing the rotation speed around each axis.
    """
    _INSTANTANEOUS_ROTATION_SPEED = "instantaneous_rotation_speed"

    """
    Filtered Translation Speed
    **Output when**: SLAM is enabled and its speed_measurement module is enabled.
    **Purpose**: Represents the filtered translation speed of the device (m/s). An averaging filter smooths the
    evolution of the speed. A short delay will appear due to the filtering (usually around 1 sec).
    **Format**: Array of 3 single precision (32 bits) floats, representing the translation speed on each direction.
    """
    _FILTERED_TRANSLATION_SPEED = "filtered_translation_speed"

    """
    Filtered Rotation Speed
    **Output when**: SLAM is enabled and its speed_measurement module is enabled.
    **Purpose**: Represents the filtered rotation speed of the device (rad/s). An averaging filter smooths the
    evolution of the speed. A short delay will appear due to the filtering (usually around 1 sec).
    **Format**: Array of 3 single precision (32 bits) floats, representing the rotation speed around each axis.
    """
    _FILTERED_ROTATION_SPEED = "filtered_rotation_speed"

    """
    Reference Map Bits
    **Output when**: SLAM is enabled and its mapping module is enabled.
    **Purpose**: SLAM identifies potential points of interest within the point cloud, and the mapping module selects
    some of them to build the map. Theses bits identify the points that are selected to generate the output map.
    **Format**: Padded list of bits, 1 bit per point of the cloud. If the bit is set, the point is part of the
    reference map.
    """
    REFERENCE_MAP_BITS = "reference_map_bits"

    """
    Cartesian covariance
    **Output when**: SLAM is enabled and compute_covariance option is set to true.
    **Purpose**: Represents the cartesian covariances (m²). It estimates the confidence of the algorithm, and how
    trustworthy is the position.
    **Format**: Array of 3 single precision (32 bits) floats, representing the covariance of x, y and z measurements.
    """
    _CARTESIAN_COVARIANCE = "cartesian_covariance"

    """
    Cylindrical covariance
    **Output when**: SLAM is enabled and compute_covariance option is set to true.
    **Purpose**: Represents the cylindrical covariances (°²). It estimates the confidence of the algorithm, and how
    trustworthy is the orientation.
    **Format**: Array of 3 single precision (32 bits) floats, representing the covariance of roll (rotation around X
    axis), pitch (rotation around Y axis) and yaw (rotation around Z axis) measurements.
    """
    _CYLINDRICAL_COVARIANCE = "cylindrical_covariance"


class ClassId(IntEnum):
    """Tracked object class ID"""

    UNKNOWN = 0
    PERSON = 1
    LUGGAGE = 2
    TROLLEY = 3
    DEPRECATED = 4
    TRUCK = 5
    CAR = 6
    VAN = 7
    TWO_WHEELER = 8
    MASK = 9
    NO_MASK = 10
    LANDMARK = 11


class PerceptId(IntEnum):
    """Percept class ID"""

    DEFAULT = 0
    ROAD = 1
    VEGETATION = 2
    GROUND = 3
    SIGN = 4
    BUILDING = 5
    FLAT_GND = 6
    UNKNOWN = 7
    MARKING = 8
    OBJECT = 9
    WALL = 10


class LidarModelId(IntEnum):
    """Lidar model ID"""

    UNKNOWN = 0
    VELODYNE_VLP16 = 1
    VELODYNE_VLP32 = 2
    VELODYNE_VLS128 = 3
    VELODYNE_HDL32 = 4
    ROBOSENSE_BPEARL_V1 = 5
    ROBOSENSE_BPEARL_V2 = 6
    ROBOSENSE_RS32 = 7
    ROBOSENSE_HELIOS = 8
    LIVOX_HORIZON = 9
    LIVOX_AVIA = 10
    LIVOX_MID70 = 11
    OUSTER = 12
    OUTSIGHT_SA01 = 13
    HESAI_PANDARXT32 = 14
    HESAI_PANDARQT64 = 15
    FAKE_LIDAR = 16
    HESAI_PANDARXT32M2X = 17
    ROBOSENSE_M1 = 18
    LIVOX_HAP_TX = 19
    INNOVIZ_ONE_EAGLE = 20
    INNOVIZ_ONE_FALCON = 21


class CarlaTag(IntEnum):
    """Carla Tag"""

    UNLABELED = 0
    BUILDING = 1
    FENCE = 2
    OTHER = 3
    PEDESTRIAN = 4
    POLE = 5
    ROADLINE = 6
    ROAD = 7
    SIDEWALK = 8
    VEGETATION = 9
    VEHICLES = 10
    WALL = 11
    TRAFFICSIGN = 12
    SKY = 13
    GROUND = 14
    BRIDGE = 15
    RAILTRACK = 16
    GUARDRAIL = 17
    TRAFFICLIGHT = 18
    STATIC = 19
    DYNAMIC = 20
    WATER = 21
    TERRAIN = 22
