#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['hue', 'hue.api', 'hue.cli']

package_data = \
{'': ['*']}

install_requires = \
['httpx ~=0.17.1', 'typer[all] ~=0.3.2']

extras_require = \
{'dev': ['black ~=20.8b1',
         'bump2version ~=1.0.1',
         'coverage ~=5.5',
         'flake8 ~=3.9.1',
         'pre-commit ~=2.12.1',
         'tox ~=3.23.0'],
 'test': ['Faker ~=8.1.0', 'pytest ~=6.2.3']}

entry_points = \
{'console_scripts': ['hue = hue.cli:app']}

setup(name='hue-api',
      version='0.3.1',
      description='Async API for controlling Hue Lights',
      author='Nirantak Raghav',
      author_email='hey@nirantak.com',
      url='https://github.com/nirantak/hue-api',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='~=3.7',
     )
