# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://docs.mailslurp.com/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class SentEmailDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'user_id': 'str',
        'inbox_id': 'str',
        'domain_id': 'str',
        'to': 'list[str]',
        '_from': 'str',
        'reply_to': 'str',
        'cc': 'list[str]',
        'bcc': 'list[str]',
        'attachments': 'list[str]',
        'subject': 'str',
        'body_md5_hash': 'str',
        'body': 'str',
        'to_contacts': 'list[str]',
        'to_group': 'str',
        'charset': 'str',
        'is_html': 'bool',
        'sent_at': 'datetime',
        'pixel_ids': 'list[str]',
        'message_id': 'str',
        'message_ids': 'list[str]',
        'virtual_send': 'bool',
        'template_id': 'str',
        'template_variables': 'dict(str, object)',
        'html': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'user_id': 'userId',
        'inbox_id': 'inboxId',
        'domain_id': 'domainId',
        'to': 'to',
        '_from': 'from',
        'reply_to': 'replyTo',
        'cc': 'cc',
        'bcc': 'bcc',
        'attachments': 'attachments',
        'subject': 'subject',
        'body_md5_hash': 'bodyMD5Hash',
        'body': 'body',
        'to_contacts': 'toContacts',
        'to_group': 'toGroup',
        'charset': 'charset',
        'is_html': 'isHTML',
        'sent_at': 'sentAt',
        'pixel_ids': 'pixelIds',
        'message_id': 'messageId',
        'message_ids': 'messageIds',
        'virtual_send': 'virtualSend',
        'template_id': 'templateId',
        'template_variables': 'templateVariables',
        'html': 'html'
    }

    def __init__(self, id=None, user_id=None, inbox_id=None, domain_id=None, to=None, _from=None, reply_to=None, cc=None, bcc=None, attachments=None, subject=None, body_md5_hash=None, body=None, to_contacts=None, to_group=None, charset=None, is_html=None, sent_at=None, pixel_ids=None, message_id=None, message_ids=None, virtual_send=None, template_id=None, template_variables=None, html=None, local_vars_configuration=None):  # noqa: E501
        """SentEmailDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._user_id = None
        self._inbox_id = None
        self._domain_id = None
        self._to = None
        self.__from = None
        self._reply_to = None
        self._cc = None
        self._bcc = None
        self._attachments = None
        self._subject = None
        self._body_md5_hash = None
        self._body = None
        self._to_contacts = None
        self._to_group = None
        self._charset = None
        self._is_html = None
        self._sent_at = None
        self._pixel_ids = None
        self._message_id = None
        self._message_ids = None
        self._virtual_send = None
        self._template_id = None
        self._template_variables = None
        self._html = None
        self.discriminator = None

        self.id = id
        self.user_id = user_id
        self.inbox_id = inbox_id
        self.domain_id = domain_id
        self.to = to
        self._from = _from
        self.reply_to = reply_to
        self.cc = cc
        self.bcc = bcc
        self.attachments = attachments
        self.subject = subject
        self.body_md5_hash = body_md5_hash
        self.body = body
        self.to_contacts = to_contacts
        self.to_group = to_group
        self.charset = charset
        self.is_html = is_html
        self.sent_at = sent_at
        self.pixel_ids = pixel_ids
        self.message_id = message_id
        self.message_ids = message_ids
        self.virtual_send = virtual_send
        self.template_id = template_id
        self.template_variables = template_variables
        if html is not None:
            self.html = html

    @property
    def id(self):
        """Gets the id of this SentEmailDto.  # noqa: E501

        ID of sent email  # noqa: E501

        :return: The id of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SentEmailDto.

        ID of sent email  # noqa: E501

        :param id: The id of this SentEmailDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def user_id(self):
        """Gets the user_id of this SentEmailDto.  # noqa: E501

        User ID  # noqa: E501

        :return: The user_id of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this SentEmailDto.

        User ID  # noqa: E501

        :param user_id: The user_id of this SentEmailDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and user_id is None:  # noqa: E501
            raise ValueError("Invalid value for `user_id`, must not be `None`")  # noqa: E501

        self._user_id = user_id

    @property
    def inbox_id(self):
        """Gets the inbox_id of this SentEmailDto.  # noqa: E501

        Inbox ID email was sent from  # noqa: E501

        :return: The inbox_id of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._inbox_id

    @inbox_id.setter
    def inbox_id(self, inbox_id):
        """Sets the inbox_id of this SentEmailDto.

        Inbox ID email was sent from  # noqa: E501

        :param inbox_id: The inbox_id of this SentEmailDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and inbox_id is None:  # noqa: E501
            raise ValueError("Invalid value for `inbox_id`, must not be `None`")  # noqa: E501

        self._inbox_id = inbox_id

    @property
    def domain_id(self):
        """Gets the domain_id of this SentEmailDto.  # noqa: E501

        Domain ID  # noqa: E501

        :return: The domain_id of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._domain_id

    @domain_id.setter
    def domain_id(self, domain_id):
        """Sets the domain_id of this SentEmailDto.

        Domain ID  # noqa: E501

        :param domain_id: The domain_id of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._domain_id = domain_id

    @property
    def to(self):
        """Gets the to of this SentEmailDto.  # noqa: E501

        Recipients email was sent to  # noqa: E501

        :return: The to of this SentEmailDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._to

    @to.setter
    def to(self, to):
        """Sets the to of this SentEmailDto.

        Recipients email was sent to  # noqa: E501

        :param to: The to of this SentEmailDto.  # noqa: E501
        :type: list[str]
        """

        self._to = to

    @property
    def _from(self):
        """Gets the _from of this SentEmailDto.  # noqa: E501

        Sent from address  # noqa: E501

        :return: The _from of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self.__from

    @_from.setter
    def _from(self, _from):
        """Sets the _from of this SentEmailDto.

        Sent from address  # noqa: E501

        :param _from: The _from of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self.__from = _from

    @property
    def reply_to(self):
        """Gets the reply_to of this SentEmailDto.  # noqa: E501


        :return: The reply_to of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._reply_to

    @reply_to.setter
    def reply_to(self, reply_to):
        """Sets the reply_to of this SentEmailDto.


        :param reply_to: The reply_to of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._reply_to = reply_to

    @property
    def cc(self):
        """Gets the cc of this SentEmailDto.  # noqa: E501


        :return: The cc of this SentEmailDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._cc

    @cc.setter
    def cc(self, cc):
        """Sets the cc of this SentEmailDto.


        :param cc: The cc of this SentEmailDto.  # noqa: E501
        :type: list[str]
        """

        self._cc = cc

    @property
    def bcc(self):
        """Gets the bcc of this SentEmailDto.  # noqa: E501


        :return: The bcc of this SentEmailDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._bcc

    @bcc.setter
    def bcc(self, bcc):
        """Sets the bcc of this SentEmailDto.


        :param bcc: The bcc of this SentEmailDto.  # noqa: E501
        :type: list[str]
        """

        self._bcc = bcc

    @property
    def attachments(self):
        """Gets the attachments of this SentEmailDto.  # noqa: E501

        Array of IDs of attachments that were sent with this email  # noqa: E501

        :return: The attachments of this SentEmailDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this SentEmailDto.

        Array of IDs of attachments that were sent with this email  # noqa: E501

        :param attachments: The attachments of this SentEmailDto.  # noqa: E501
        :type: list[str]
        """

        self._attachments = attachments

    @property
    def subject(self):
        """Gets the subject of this SentEmailDto.  # noqa: E501


        :return: The subject of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """Sets the subject of this SentEmailDto.


        :param subject: The subject of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._subject = subject

    @property
    def body_md5_hash(self):
        """Gets the body_md5_hash of this SentEmailDto.  # noqa: E501

        MD5 Hash  # noqa: E501

        :return: The body_md5_hash of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._body_md5_hash

    @body_md5_hash.setter
    def body_md5_hash(self, body_md5_hash):
        """Sets the body_md5_hash of this SentEmailDto.

        MD5 Hash  # noqa: E501

        :param body_md5_hash: The body_md5_hash of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._body_md5_hash = body_md5_hash

    @property
    def body(self):
        """Gets the body of this SentEmailDto.  # noqa: E501

        Sent email body  # noqa: E501

        :return: The body of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """Sets the body of this SentEmailDto.

        Sent email body  # noqa: E501

        :param body: The body of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._body = body

    @property
    def to_contacts(self):
        """Gets the to_contacts of this SentEmailDto.  # noqa: E501


        :return: The to_contacts of this SentEmailDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._to_contacts

    @to_contacts.setter
    def to_contacts(self, to_contacts):
        """Sets the to_contacts of this SentEmailDto.


        :param to_contacts: The to_contacts of this SentEmailDto.  # noqa: E501
        :type: list[str]
        """

        self._to_contacts = to_contacts

    @property
    def to_group(self):
        """Gets the to_group of this SentEmailDto.  # noqa: E501


        :return: The to_group of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._to_group

    @to_group.setter
    def to_group(self, to_group):
        """Sets the to_group of this SentEmailDto.


        :param to_group: The to_group of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._to_group = to_group

    @property
    def charset(self):
        """Gets the charset of this SentEmailDto.  # noqa: E501


        :return: The charset of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._charset

    @charset.setter
    def charset(self, charset):
        """Sets the charset of this SentEmailDto.


        :param charset: The charset of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._charset = charset

    @property
    def is_html(self):
        """Gets the is_html of this SentEmailDto.  # noqa: E501


        :return: The is_html of this SentEmailDto.  # noqa: E501
        :rtype: bool
        """
        return self._is_html

    @is_html.setter
    def is_html(self, is_html):
        """Sets the is_html of this SentEmailDto.


        :param is_html: The is_html of this SentEmailDto.  # noqa: E501
        :type: bool
        """

        self._is_html = is_html

    @property
    def sent_at(self):
        """Gets the sent_at of this SentEmailDto.  # noqa: E501


        :return: The sent_at of this SentEmailDto.  # noqa: E501
        :rtype: datetime
        """
        return self._sent_at

    @sent_at.setter
    def sent_at(self, sent_at):
        """Sets the sent_at of this SentEmailDto.


        :param sent_at: The sent_at of this SentEmailDto.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and sent_at is None:  # noqa: E501
            raise ValueError("Invalid value for `sent_at`, must not be `None`")  # noqa: E501

        self._sent_at = sent_at

    @property
    def pixel_ids(self):
        """Gets the pixel_ids of this SentEmailDto.  # noqa: E501


        :return: The pixel_ids of this SentEmailDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._pixel_ids

    @pixel_ids.setter
    def pixel_ids(self, pixel_ids):
        """Sets the pixel_ids of this SentEmailDto.


        :param pixel_ids: The pixel_ids of this SentEmailDto.  # noqa: E501
        :type: list[str]
        """

        self._pixel_ids = pixel_ids

    @property
    def message_id(self):
        """Gets the message_id of this SentEmailDto.  # noqa: E501


        :return: The message_id of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id):
        """Sets the message_id of this SentEmailDto.


        :param message_id: The message_id of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._message_id = message_id

    @property
    def message_ids(self):
        """Gets the message_ids of this SentEmailDto.  # noqa: E501


        :return: The message_ids of this SentEmailDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._message_ids

    @message_ids.setter
    def message_ids(self, message_ids):
        """Sets the message_ids of this SentEmailDto.


        :param message_ids: The message_ids of this SentEmailDto.  # noqa: E501
        :type: list[str]
        """

        self._message_ids = message_ids

    @property
    def virtual_send(self):
        """Gets the virtual_send of this SentEmailDto.  # noqa: E501


        :return: The virtual_send of this SentEmailDto.  # noqa: E501
        :rtype: bool
        """
        return self._virtual_send

    @virtual_send.setter
    def virtual_send(self, virtual_send):
        """Sets the virtual_send of this SentEmailDto.


        :param virtual_send: The virtual_send of this SentEmailDto.  # noqa: E501
        :type: bool
        """

        self._virtual_send = virtual_send

    @property
    def template_id(self):
        """Gets the template_id of this SentEmailDto.  # noqa: E501


        :return: The template_id of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._template_id

    @template_id.setter
    def template_id(self, template_id):
        """Sets the template_id of this SentEmailDto.


        :param template_id: The template_id of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._template_id = template_id

    @property
    def template_variables(self):
        """Gets the template_variables of this SentEmailDto.  # noqa: E501


        :return: The template_variables of this SentEmailDto.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._template_variables

    @template_variables.setter
    def template_variables(self, template_variables):
        """Sets the template_variables of this SentEmailDto.


        :param template_variables: The template_variables of this SentEmailDto.  # noqa: E501
        :type: dict(str, object)
        """

        self._template_variables = template_variables

    @property
    def html(self):
        """Gets the html of this SentEmailDto.  # noqa: E501


        :return: The html of this SentEmailDto.  # noqa: E501
        :rtype: bool
        """
        return self._html

    @html.setter
    def html(self, html):
        """Sets the html of this SentEmailDto.


        :param html: The html of this SentEmailDto.  # noqa: E501
        :type: bool
        """

        self._html = html

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SentEmailDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SentEmailDto):
            return True

        return self.to_dict() != other.to_dict()
