# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://docs.mailslurp.com/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class PageableObject(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'offset': 'int',
        'sort': 'Sort',
        'page_number': 'int',
        'page_size': 'int',
        'paged': 'bool',
        'unpaged': 'bool'
    }

    attribute_map = {
        'offset': 'offset',
        'sort': 'sort',
        'page_number': 'pageNumber',
        'page_size': 'pageSize',
        'paged': 'paged',
        'unpaged': 'unpaged'
    }

    def __init__(self, offset=None, sort=None, page_number=None, page_size=None, paged=None, unpaged=None, local_vars_configuration=None):  # noqa: E501
        """PageableObject - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._offset = None
        self._sort = None
        self._page_number = None
        self._page_size = None
        self._paged = None
        self._unpaged = None
        self.discriminator = None

        if offset is not None:
            self.offset = offset
        if sort is not None:
            self.sort = sort
        if page_number is not None:
            self.page_number = page_number
        if page_size is not None:
            self.page_size = page_size
        if paged is not None:
            self.paged = paged
        if unpaged is not None:
            self.unpaged = unpaged

    @property
    def offset(self):
        """Gets the offset of this PageableObject.  # noqa: E501


        :return: The offset of this PageableObject.  # noqa: E501
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """Sets the offset of this PageableObject.


        :param offset: The offset of this PageableObject.  # noqa: E501
        :type: int
        """

        self._offset = offset

    @property
    def sort(self):
        """Gets the sort of this PageableObject.  # noqa: E501


        :return: The sort of this PageableObject.  # noqa: E501
        :rtype: Sort
        """
        return self._sort

    @sort.setter
    def sort(self, sort):
        """Sets the sort of this PageableObject.


        :param sort: The sort of this PageableObject.  # noqa: E501
        :type: Sort
        """

        self._sort = sort

    @property
    def page_number(self):
        """Gets the page_number of this PageableObject.  # noqa: E501


        :return: The page_number of this PageableObject.  # noqa: E501
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number):
        """Sets the page_number of this PageableObject.


        :param page_number: The page_number of this PageableObject.  # noqa: E501
        :type: int
        """

        self._page_number = page_number

    @property
    def page_size(self):
        """Gets the page_size of this PageableObject.  # noqa: E501


        :return: The page_size of this PageableObject.  # noqa: E501
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size):
        """Sets the page_size of this PageableObject.


        :param page_size: The page_size of this PageableObject.  # noqa: E501
        :type: int
        """

        self._page_size = page_size

    @property
    def paged(self):
        """Gets the paged of this PageableObject.  # noqa: E501


        :return: The paged of this PageableObject.  # noqa: E501
        :rtype: bool
        """
        return self._paged

    @paged.setter
    def paged(self, paged):
        """Sets the paged of this PageableObject.


        :param paged: The paged of this PageableObject.  # noqa: E501
        :type: bool
        """

        self._paged = paged

    @property
    def unpaged(self):
        """Gets the unpaged of this PageableObject.  # noqa: E501


        :return: The unpaged of this PageableObject.  # noqa: E501
        :rtype: bool
        """
        return self._unpaged

    @unpaged.setter
    def unpaged(self, unpaged):
        """Sets the unpaged of this PageableObject.


        :param unpaged: The unpaged of this PageableObject.  # noqa: E501
        :type: bool
        """

        self._unpaged = unpaged

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PageableObject):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PageableObject):
            return True

        return self.to_dict() != other.to_dict()
