"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormat = exports.ClassificationString = exports.SerializationLibrary = exports.OutputFormat = exports.InputFormat = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Absolute class name of the Hadoop `InputFormat` to use when reading table files.
 */
class InputFormat {
    constructor(className) {
        this.className = className;
    }
}
_a = JSII_RTTI_SYMBOL_1;
InputFormat[_a] = { fqn: "@aws-cdk/aws-glue-alpha.InputFormat", version: "2.73.0-alpha.0" };
/**
 * InputFormat for Avro files.
 *
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/ql/io/avro/AvroContainerInputFormat.html
 */
InputFormat.AVRO = new InputFormat('org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat');
/**
 * InputFormat for Cloudtrail Logs.
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
 */
InputFormat.CLOUDTRAIL = new InputFormat('com.amazon.emr.cloudtrail.CloudTrailInputFormat');
/**
 * InputFormat for Orc files.
 *
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/ql/io/orc/OrcInputFormat.html
 */
InputFormat.ORC = new InputFormat('org.apache.hadoop.hive.ql.io.orc.OrcInputFormat');
/**
 * InputFormat for Parquet files.
 *
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/ql/io/parquet/MapredParquetInputFormat.html
 */
InputFormat.PARQUET = new InputFormat('org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat');
/**
 * An InputFormat for plain text files. Files are broken into lines. Either linefeed or
 * carriage-return are used to signal end of line. Keys are the position in the file, and
 * values are the line of text.
 * JSON & CSV files are examples of this InputFormat
 *
 * @see https://hadoop.apache.org/docs/stable/api/org/apache/hadoop/mapred/TextInputFormat.html
 */
InputFormat.TEXT = new InputFormat('org.apache.hadoop.mapred.TextInputFormat');
exports.InputFormat = InputFormat;
/**
 * Absolute class name of the Hadoop `OutputFormat` to use when writing table files.
 */
class OutputFormat {
    constructor(className) {
        this.className = className;
    }
}
_b = JSII_RTTI_SYMBOL_1;
OutputFormat[_b] = { fqn: "@aws-cdk/aws-glue-alpha.OutputFormat", version: "2.73.0-alpha.0" };
/**
 * Writes text data with a null key (value only).
 *
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/ql/io/HiveIgnoreKeyTextOutputFormat.html
 */
OutputFormat.HIVE_IGNORE_KEY_TEXT = new OutputFormat('org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat');
/**
 * OutputFormat for Avro files.
 *
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/ql/io/avro/AvroContainerOutputFormat.html
 */
OutputFormat.AVRO = new InputFormat('org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat');
/**
 * OutputFormat for Orc files.
 *
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/ql/io/orc/OrcOutputFormat.html
 */
OutputFormat.ORC = new InputFormat('org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat');
/**
 * OutputFormat for Parquet files.
 *
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/ql/io/parquet/MapredParquetOutputFormat.html
 */
OutputFormat.PARQUET = new OutputFormat('org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat');
exports.OutputFormat = OutputFormat;
/**
 * Serialization library to use when serializing/deserializing (SerDe) table records.
 *
 * @see https://cwiki.apache.org/confluence/display/Hive/SerDe
 */
class SerializationLibrary {
    constructor(className) {
        this.className = className;
    }
}
_c = JSII_RTTI_SYMBOL_1;
SerializationLibrary[_c] = { fqn: "@aws-cdk/aws-glue-alpha.SerializationLibrary", version: "2.73.0-alpha.0" };
/**
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/serde2/avro/AvroSerDe.html
 */
SerializationLibrary.AVRO = new SerializationLibrary('org.apache.hadoop.hive.serde2.avro.AvroSerDe');
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
 */
SerializationLibrary.CLOUDTRAIL = new SerializationLibrary('com.amazon.emr.hive.serde.CloudTrailSerde');
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/grok.html
 */
SerializationLibrary.GROK = new SerializationLibrary('com.amazonaws.glue.serde.GrokSerDe');
/**
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hive/hcatalog/data/JsonSerDe.html
 */
SerializationLibrary.HIVE_JSON = new SerializationLibrary('org.apache.hive.hcatalog.data.JsonSerDe');
/**
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/serde2/lazy/LazySimpleSerDe.html
 */
SerializationLibrary.LAZY_SIMPLE = new SerializationLibrary('org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe');
/**
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/serde2/OpenCSVSerde.html
 */
SerializationLibrary.OPEN_CSV = new SerializationLibrary('org.apache.hadoop.hive.serde2.OpenCSVSerde');
/**
 * @see https://github.com/rcongiu/Hive-JSON-Serde
 */
SerializationLibrary.OPENX_JSON = new SerializationLibrary('org.openx.data.jsonserde.JsonSerDe');
/**
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/ql/io/orc/OrcSerde.html
 */
SerializationLibrary.ORC = new SerializationLibrary('org.apache.hadoop.hive.ql.io.orc.OrcSerde');
/**
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/ql/io/parquet/serde/ParquetHiveSerDe.html
 */
SerializationLibrary.PARQUET = new SerializationLibrary('org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe');
/**
 * @see https://svn.apache.org/repos/infra/websites/production/hive/content/javadocs/r3.1.3/api/org/apache/hadoop/hive/serde2/RegexSerDe.html
 */
SerializationLibrary.REGEXP = new SerializationLibrary('org.apache.hadoop.hive.serde2.RegexSerDe');
exports.SerializationLibrary = SerializationLibrary;
/**
 * Classification string given to tables with this data format.
 *
 * @see https://docs.aws.amazon.com/glue/latest/dg/add-classifier.html#classifier-built-in
 */
class ClassificationString {
    constructor(value) {
        this.value = value;
    }
}
_d = JSII_RTTI_SYMBOL_1;
ClassificationString[_d] = { fqn: "@aws-cdk/aws-glue-alpha.ClassificationString", version: "2.73.0-alpha.0" };
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-avro
 */
ClassificationString.AVRO = new ClassificationString('avro');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-csv
 */
ClassificationString.CSV = new ClassificationString('csv');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-json
 */
ClassificationString.JSON = new ClassificationString('json');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-xml
 */
ClassificationString.XML = new ClassificationString('xml');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-parquet
 */
ClassificationString.PARQUET = new ClassificationString('parquet');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-orc
 */
ClassificationString.ORC = new ClassificationString('orc');
exports.ClassificationString = ClassificationString;
/**
 * Defines the input/output formats and ser/de for a single DataFormat.
 */
class DataFormat {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_glue_alpha_DataFormatProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DataFormat);
            }
            throw error;
        }
        this.inputFormat = props.inputFormat;
        this.outputFormat = props.outputFormat;
        this.serializationLibrary = props.serializationLibrary;
        this.classificationString = props.classificationString;
    }
}
_e = JSII_RTTI_SYMBOL_1;
DataFormat[_e] = { fqn: "@aws-cdk/aws-glue-alpha.DataFormat", version: "2.73.0-alpha.0" };
/**
 * DataFormat for Apache Web Server Logs. Also works for CloudFront logs
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/apache.html
 */
DataFormat.APACHE_LOGS = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.REGEXP,
});
/**
 * DataFormat for Apache Avro
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/avro.html
 */
DataFormat.AVRO = new DataFormat({
    inputFormat: InputFormat.AVRO,
    outputFormat: OutputFormat.AVRO,
    serializationLibrary: SerializationLibrary.AVRO,
    classificationString: ClassificationString.AVRO,
});
/**
 * DataFormat for CloudTrail logs stored on S3
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
 */
DataFormat.CLOUDTRAIL_LOGS = new DataFormat({
    inputFormat: InputFormat.CLOUDTRAIL,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.CLOUDTRAIL,
});
/**
 * DataFormat for CSV Files
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/csv.html
 */
DataFormat.CSV = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.OPEN_CSV,
    classificationString: ClassificationString.CSV,
});
/**
 * Stored as plain text files in JSON format.
 * Uses OpenX Json SerDe for serialization and deseralization.
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/json.html
 */
DataFormat.JSON = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.OPENX_JSON,
    classificationString: ClassificationString.JSON,
});
/**
 * DataFormat for Logstash Logs, using the GROK SerDe
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/grok.html
 */
DataFormat.LOGSTASH = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.GROK,
});
/**
 * DataFormat for Apache ORC (Optimized Row Columnar)
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/orc.html
 */
DataFormat.ORC = new DataFormat({
    inputFormat: InputFormat.ORC,
    outputFormat: OutputFormat.ORC,
    serializationLibrary: SerializationLibrary.ORC,
    classificationString: ClassificationString.ORC,
});
/**
 * DataFormat for Apache Parquet
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/parquet.html
 */
DataFormat.PARQUET = new DataFormat({
    inputFormat: InputFormat.PARQUET,
    outputFormat: OutputFormat.PARQUET,
    serializationLibrary: SerializationLibrary.PARQUET,
    classificationString: ClassificationString.PARQUET,
});
/**
 * DataFormat for TSV (Tab-Separated Values)
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/lazy-simple-serde.html
 */
DataFormat.TSV = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.LAZY_SIMPLE,
});
exports.DataFormat = DataFormat;
//# sourceMappingURL=data:application/json;base64,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