"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchLogGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const core_1 = require("@aws-cdk/core");
const log_group_resource_policy_1 = require("./log-group-resource-policy");
const util_1 = require("./util");
/**
 * Use an AWS CloudWatch LogGroup as an event rule target.
 */
class CloudWatchLogGroup {
    constructor(logGroup, props = {}) {
        this.logGroup = logGroup;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_events_targets_LogGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchLogGroup);
            }
            throw error;
        }
    }
    /**
     * Returns a RuleTarget that can be used to log an event into a CloudWatch LogGroup
     */
    bind(_rule, _id) {
        // Use a custom resource to set the log group resource policy since it is not supported by CDK and cfn.
        const resourcePolicyId = `EventsLogGroupPolicy${cdk.Names.nodeUniqueId(_rule.node)}`;
        const logGroupStack = cdk.Stack.of(this.logGroup);
        if (!this.logGroup.node.tryFindChild(resourcePolicyId)) {
            new log_group_resource_policy_1.LogGroupResourcePolicy(logGroupStack, resourcePolicyId, {
                policyStatements: [new iam.PolicyStatement({
                        effect: iam.Effect.ALLOW,
                        actions: ['logs:PutLogEvents', 'logs:CreateLogStream'],
                        resources: [this.logGroup.logGroupArn],
                        principals: [new iam.ServicePrincipal('events.amazonaws.com')],
                    })],
            });
        }
        return {
            ...util_1.bindBaseTargetConfig(this.props),
            arn: logGroupStack.formatArn({
                service: 'logs',
                resource: 'log-group',
                arnFormat: core_1.ArnFormat.COLON_RESOURCE_NAME,
                resourceName: this.logGroup.logGroupName,
            }),
            input: this.props.event,
            targetResource: this.logGroup,
        };
    }
}
exports.CloudWatchLogGroup = CloudWatchLogGroup;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchLogGroup[_a] = { fqn: "@aws-cdk/aws-events-targets.CloudWatchLogGroup", version: "1.165.0" };
//# sourceMappingURL=data:application/json;base64,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