/*
 * Decompiled with CFR 0.152.
 */
package pyboof;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.struct.Configuration;
import boofcv.struct.feature.TupleDesc;
import georegression.struct.point.Point2D_F64;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastArray;
import py4j.GatewayServer;
import pyboof.BoofMemoryMapped;

public class PyBoofEntryPoint {
    public static BoofMemoryMapped mmap;
    public static String buildDate;

    public static void nothing() {
    }

    public static void main(String[] args) {
        GatewayServer gatewayServer = new GatewayServer(new PyBoofEntryPoint());
        gatewayServer.start();
        System.out.println("Gateway Server Started");
    }

    public static void setMaxThreads(int maxThreads) {
        boolean bl = BoofConcurrency.USE_CONCURRENT = maxThreads > 1;
        if (BoofConcurrency.USE_CONCURRENT) {
            BoofConcurrency.setMaxThreads(maxThreads);
        }
    }

    public static String getBuildDate() {
        return buildDate;
    }

    public static void setBuildDate(String buildDate) {
        PyBoofEntryPoint.buildDate = buildDate;
    }

    public static void initializeMmap(String filePath, int sizeMB) {
        mmap = new BoofMemoryMapped(filePath, sizeMB);
    }

    public static ConfigThreshold createGlobalThreshold(ThresholdType type) {
        return ConfigThreshold.global(type);
    }

    public static FastArray listToFastArray(List list, Class type) {
        FastArray ret = new FastArray(type, list.size());
        for (int i = 0; i < list.size(); ++i) {
            ret.add(list.get(i));
        }
        return ret;
    }

    public static <T> DogArray<T> createDogArray(Class<T> type) {
        return new DogArray<Object>(type, () -> {
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static List<TupleDesc> extractFeatures(DetectDescribePoint alg, boolean copy) {
        int N = alg.getNumberOfFeatures();
        ArrayList<TupleDesc> array = new ArrayList<TupleDesc>();
        for (int i = 0; i < N; ++i) {
            if (copy) {
                array.add((TupleDesc)alg.getDescription(i).copy());
                continue;
            }
            array.add((TupleDesc)alg.getDescription(i));
        }
        return array;
    }

    public static List<Point2D_F64> extractPoints(DetectDescribePoint alg, boolean copy) {
        int N = alg.getNumberOfFeatures();
        ArrayList<Point2D_F64> array = new ArrayList<Point2D_F64>();
        for (int i = 0; i < N; ++i) {
            if (copy) {
                array.add(alg.getLocation(i).copy());
                continue;
            }
            array.add(alg.getLocation(i));
        }
        return array;
    }

    public static List<String> getPublicFields(String classPath) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Field[] fields;
            for (Field f : fields = Class.forName(classPath).getFields()) {
                list.add(f.getName());
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Can't find class " + classPath);
            System.exit(1);
        }
        return list;
    }

    public static List<String> getPublicFields(Class typeClass) {
        Field[] fields;
        ArrayList<String> list = new ArrayList<String>();
        for (Field f : fields = typeClass.getFields()) {
            list.add(f.getName());
        }
        return list;
    }

    public static boolean isConfigClass(Object o) {
        return o instanceof Configuration;
    }

    public static boolean isClass(Class c, String path) {
        try {
            Class<?> found = Class.forName(path);
            return c.isAssignableFrom(found) || found.isAssignableFrom(c);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

