/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple.ops;

import java.io.PrintStream;
import org.ejml.concurrency.EjmlConcurrency;
import org.ejml.data.Complex_F64;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.CommonOps_MT_FDRM;
import org.ejml.dense.row.MatrixFeatures_FDRM;
import org.ejml.dense.row.NormOps_FDRM;
import org.ejml.dense.row.mult.VectorVectorMult_FDRM;
import org.ejml.ops.MatrixIO;
import org.ejml.simple.SimpleOperations;

public class SimpleOperations_FDRM
implements SimpleOperations<FMatrixRMaj> {
    @Override
    public void set(FMatrixRMaj A2, int row, int column, double value) {
        A2.set(row, column, (float)value);
    }

    @Override
    public void set(FMatrixRMaj A2, int row, int column, double real, double imaginary) {
        throw new IllegalArgumentException("Does not support imaginary values");
    }

    @Override
    public double get(FMatrixRMaj A2, int row, int column) {
        return A2.get(row, column);
    }

    @Override
    public void get(FMatrixRMaj A2, int row, int column, Complex_F64 value) {
        value.real = A2.get(row, column);
        value.imaginary = 0.0;
    }

    @Override
    public void fill(FMatrixRMaj A2, double value) {
        CommonOps_FDRM.fill(A2, (float)value);
    }

    @Override
    public void transpose(FMatrixRMaj input, FMatrixRMaj output) {
        if (EjmlConcurrency.useConcurrent(input)) {
            CommonOps_MT_FDRM.transpose(input, output);
        } else {
            CommonOps_FDRM.transpose(input, output);
        }
    }

    @Override
    public void mult(FMatrixRMaj A2, FMatrixRMaj B, FMatrixRMaj output) {
        if (EjmlConcurrency.useConcurrent(A2)) {
            CommonOps_MT_FDRM.mult(A2, B, output);
        } else {
            CommonOps_FDRM.mult(A2, B, output);
        }
    }

    @Override
    public void multTransA(FMatrixRMaj A2, FMatrixRMaj B, FMatrixRMaj output) {
        if (EjmlConcurrency.useConcurrent(A2)) {
            CommonOps_MT_FDRM.multTransA(A2, B, output);
        } else {
            CommonOps_FDRM.multTransA(A2, B, output);
        }
    }

    @Override
    public void kron(FMatrixRMaj A2, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FDRM.kron(A2, B, output);
    }

    @Override
    public void plus(FMatrixRMaj A2, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FDRM.add(A2, B, output);
    }

    @Override
    public void minus(FMatrixRMaj A2, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FDRM.subtract(A2, B, output);
    }

    @Override
    public void minus(FMatrixRMaj A2, double b, FMatrixRMaj output) {
        CommonOps_FDRM.subtract(A2, (float)b, output);
    }

    @Override
    public void plus(FMatrixRMaj A2, double b, FMatrixRMaj output) {
        CommonOps_FDRM.add(A2, (float)b, output);
    }

    @Override
    public void plus(FMatrixRMaj A2, double beta, FMatrixRMaj b, FMatrixRMaj output) {
        CommonOps_FDRM.add(A2, (float)beta, b, output);
    }

    @Override
    public void plus(double alpha, FMatrixRMaj A2, double beta, FMatrixRMaj b, FMatrixRMaj output) {
        CommonOps_FDRM.add((float)alpha, A2, (float)beta, b, output);
    }

    @Override
    public double dot(FMatrixRMaj A2, FMatrixRMaj v) {
        return VectorVectorMult_FDRM.innerProd(A2, v);
    }

    @Override
    public void scale(FMatrixRMaj A2, double val2, FMatrixRMaj output) {
        CommonOps_FDRM.scale((float)val2, A2, output);
    }

    @Override
    public void divide(FMatrixRMaj A2, double val2, FMatrixRMaj output) {
        CommonOps_FDRM.divide(A2, (float)val2, output);
    }

    @Override
    public boolean invert(FMatrixRMaj A2, FMatrixRMaj output) {
        return CommonOps_FDRM.invert(A2, output);
    }

    @Override
    public void setIdentity(FMatrixRMaj A2) {
        CommonOps_FDRM.setIdentity(A2);
    }

    @Override
    public void pseudoInverse(FMatrixRMaj A2, FMatrixRMaj output) {
        CommonOps_FDRM.pinv(A2, output);
    }

    @Override
    public boolean solve(FMatrixRMaj A2, FMatrixRMaj X2, FMatrixRMaj B) {
        return CommonOps_FDRM.solve(A2, B, X2);
    }

    @Override
    public void zero(FMatrixRMaj A2) {
        A2.zero();
    }

    @Override
    public double normF(FMatrixRMaj A2) {
        return NormOps_FDRM.normF(A2);
    }

    @Override
    public double conditionP2(FMatrixRMaj A2) {
        return NormOps_FDRM.conditionP2(A2);
    }

    @Override
    public double determinant(FMatrixRMaj A2) {
        return CommonOps_FDRM.det(A2);
    }

    @Override
    public double trace(FMatrixRMaj A2) {
        return CommonOps_FDRM.trace(A2);
    }

    @Override
    public void setRow(FMatrixRMaj A2, int row, int startColumn, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A2.set(row, startColumn + i, (float)values[i]);
        }
    }

    @Override
    public void setColumn(FMatrixRMaj A2, int column, int startRow, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A2.set(startRow + i, column, (float)values[i]);
        }
    }

    @Override
    public void extract(FMatrixRMaj src, int srcY0, int srcY1, int srcX0, int srcX1, FMatrixRMaj dst, int dstY0, int dstX0) {
        CommonOps_FDRM.extract(src, srcY0, srcY1, srcX0, srcX1, dst, dstY0, dstX0);
    }

    @Override
    public FMatrixRMaj diag(FMatrixRMaj A2) {
        FMatrixRMaj output;
        if (MatrixFeatures_FDRM.isVector(A2)) {
            int N = Math.max(A2.numCols, A2.numRows);
            output = new FMatrixRMaj(N, N);
            CommonOps_FDRM.diag(output, N, A2.data);
        } else {
            int N = Math.min(A2.numCols, A2.numRows);
            output = new FMatrixRMaj(N, 1);
            CommonOps_FDRM.extractDiag(A2, output);
        }
        return output;
    }

    @Override
    public boolean hasUncountable(FMatrixRMaj M) {
        return MatrixFeatures_FDRM.hasUncountable(M);
    }

    @Override
    public void changeSign(FMatrixRMaj a) {
        CommonOps_FDRM.changeSign(a);
    }

    @Override
    public double elementMaxAbs(FMatrixRMaj A2) {
        return CommonOps_FDRM.elementMaxAbs(A2);
    }

    @Override
    public double elementMinAbs(FMatrixRMaj A2) {
        return CommonOps_FDRM.elementMinAbs(A2);
    }

    @Override
    public double elementSum(FMatrixRMaj A2) {
        return CommonOps_FDRM.elementSum(A2);
    }

    @Override
    public void elementMult(FMatrixRMaj A2, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FDRM.elementMult(A2, B, output);
    }

    @Override
    public void elementDiv(FMatrixRMaj A2, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FDRM.elementDiv(A2, B, output);
    }

    @Override
    public void elementPower(FMatrixRMaj A2, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FDRM.elementPower(A2, B, output);
    }

    @Override
    public void elementPower(FMatrixRMaj A2, double b, FMatrixRMaj output) {
        CommonOps_FDRM.elementPower(A2, (float)b, output);
    }

    @Override
    public void elementExp(FMatrixRMaj A2, FMatrixRMaj output) {
        CommonOps_FDRM.elementExp(A2, output);
    }

    @Override
    public void elementLog(FMatrixRMaj A2, FMatrixRMaj output) {
        CommonOps_FDRM.elementLog(A2, output);
    }

    @Override
    public boolean isIdentical(FMatrixRMaj A2, FMatrixRMaj B, double tol) {
        return MatrixFeatures_FDRM.isIdentical(A2, B, (float)tol);
    }

    @Override
    public void print(PrintStream out, Matrix mat, String format) {
        MatrixIO.print(out, (FMatrixRMaj)mat, format);
    }
}

