/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.misc;

import org.ejml.UtilEjml;
import org.ejml.data.ElementLocation;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.Matrix;
import org.jetbrains.annotations.Nullable;

public class ImplCommonOps_FDRM {
    public static void extract(FMatrixRMaj src, int srcY0, int srcX0, FMatrixRMaj dst, int dstY0, int dstX0, int numRows, int numCols) {
        for (int y = 0; y < numRows; ++y) {
            int indexSrc = src.getIndex(y + srcY0, srcX0);
            int indexDst = dst.getIndex(y + dstY0, dstX0);
            System.arraycopy(src.data, indexSrc, dst.data, indexDst, numCols);
        }
    }

    public static float elementMax(FMatrixD1 a, @Nullable ElementLocation loc) {
        int size = a.getNumElements();
        int bestIndex = 0;
        float max = a.get(0);
        for (int i = 1; i < size; ++i) {
            float val2 = a.get(i);
            if (!(val2 >= max)) continue;
            bestIndex = i;
            max = val2;
        }
        if (loc != null) {
            loc.row = bestIndex / a.numCols;
            loc.col = bestIndex % a.numCols;
        }
        return max;
    }

    public static float elementMaxAbs(FMatrixD1 a, @Nullable ElementLocation loc) {
        int size = a.getNumElements();
        int bestIndex = 0;
        float max = 0.0f;
        for (int i = 0; i < size; ++i) {
            float val2 = Math.abs(a.get(i));
            if (!(val2 > max)) continue;
            bestIndex = i;
            max = val2;
        }
        if (loc != null) {
            loc.row = bestIndex / a.numCols;
            loc.col = bestIndex % a.numCols;
        }
        return max;
    }

    public static float elementMin(FMatrixD1 a, @Nullable ElementLocation loc) {
        int size = a.getNumElements();
        int bestIndex = 0;
        float min = a.get(0);
        for (int i = 1; i < size; ++i) {
            float val2 = a.get(i);
            if (!(val2 < min)) continue;
            bestIndex = i;
            min = val2;
        }
        if (loc != null) {
            loc.row = bestIndex / a.numCols;
            loc.col = bestIndex % a.numCols;
        }
        return min;
    }

    public static float elementMinAbs(FMatrixD1 a, @Nullable ElementLocation loc) {
        int size = a.getNumElements();
        int bestIndex = 0;
        float min = Float.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            float val2 = Math.abs(a.get(i));
            if (!(val2 < min)) continue;
            bestIndex = i;
            min = val2;
        }
        if (loc != null) {
            loc.row = bestIndex / a.numCols;
            loc.col = bestIndex % a.numCols;
        }
        return min;
    }

    public static void elementMult(FMatrixD1 A2, FMatrixD1 B) {
        UtilEjml.checkSameShape((Matrix)A2, (Matrix)B, true);
        int length = A2.getNumElements();
        for (int i = 0; i < length; ++i) {
            A2.times(i, B.get(i));
        }
    }

    public static <T extends FMatrixD1> T elementMult(T A2, T B, @Nullable T output) {
        UtilEjml.checkSameShape(A2, B, true);
        output = UtilEjml.reshapeOrDeclare(output, A2);
        int length = A2.getNumElements();
        for (int i = 0; i < length; ++i) {
            output.set(i, A2.get(i) * B.get(i));
        }
        return output;
    }

    public static void elementDiv(FMatrixD1 A2, FMatrixD1 B) {
        UtilEjml.checkSameShape((Matrix)A2, (Matrix)B, true);
        int length = A2.getNumElements();
        for (int i = 0; i < length; ++i) {
            A2.div(i, B.get(i));
        }
    }

    public static <T extends FMatrixD1> T elementDiv(T A2, T B, @Nullable T output) {
        UtilEjml.checkSameShape(A2, B, true);
        output = UtilEjml.reshapeOrDeclare(output, A2);
        int length = A2.getNumElements();
        for (int i = 0; i < length; ++i) {
            output.set(i, A2.get(i) / B.get(i));
        }
        return output;
    }

    public static float elementSum(FMatrixD1 mat) {
        float total = 0.0f;
        int size = mat.getNumElements();
        for (int i = 0; i < size; ++i) {
            total += mat.get(i);
        }
        return total;
    }

    public static float elementSumAbs(FMatrixD1 mat) {
        float total = 0.0f;
        int size = mat.getNumElements();
        for (int i = 0; i < size; ++i) {
            total += Math.abs(mat.get(i));
        }
        return total;
    }

    public static <T extends FMatrixD1> T elementPower(T A2, T B, @Nullable T output) {
        UtilEjml.checkSameShape(A2, B, true);
        output = UtilEjml.reshapeOrDeclare(output, A2);
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = (float)Math.pow(A2.data[i], B.data[i]);
        }
        return output;
    }

    public static <T extends FMatrixD1> T elementPower(float a, T B, @Nullable T output) {
        output = UtilEjml.reshapeOrDeclare(output, B);
        int size = B.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = (float)Math.pow(a, B.data[i]);
        }
        return output;
    }

    public static <T extends FMatrixD1> T elementPower(T A2, float b, @Nullable T output) {
        output = UtilEjml.reshapeOrDeclare(output, A2);
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = (float)Math.pow(A2.data[i], b);
        }
        return output;
    }

    public static <T extends FMatrixD1> T elementLog(T A2, @Nullable T output) {
        output = UtilEjml.reshapeOrDeclare(output, A2);
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = (float)Math.log(A2.data[i]);
        }
        return output;
    }

    public static <T extends FMatrixD1> T elementExp(T A2, @Nullable T output) {
        output = UtilEjml.reshapeOrDeclare(output, A2);
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = (float)Math.exp(A2.data[i]);
        }
        return output;
    }
}

