/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row;

import org.ejml.UtilEjml;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.MatrixFeatures_FDRM;
import org.ejml.dense.row.SingularOps_FDRM;
import org.ejml.dense.row.factory.DecompositionFactory_FDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F32;

public class NormOps_FDRM {
    public static void normalizeF(FMatrixRMaj A2) {
        float val2 = NormOps_FDRM.normF(A2);
        if (val2 == 0.0f) {
            return;
        }
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            A2.div(i, val2);
        }
    }

    public static float conditionP(FMatrixRMaj A2, float p) {
        if (p == 2.0f) {
            return NormOps_FDRM.conditionP2(A2);
        }
        if (A2.numRows == A2.numCols) {
            FMatrixRMaj A_inv = new FMatrixRMaj(A2.numRows, A2.numCols);
            if (!CommonOps_FDRM.invert(A2, A_inv)) {
                throw new IllegalArgumentException("A can't be inverted.");
            }
            return NormOps_FDRM.normP(A2, p) * NormOps_FDRM.normP(A_inv, p);
        }
        FMatrixRMaj pinv = new FMatrixRMaj(A2.numCols, A2.numRows);
        CommonOps_FDRM.pinv(A2, pinv);
        return NormOps_FDRM.normP(A2, p) * NormOps_FDRM.normP(pinv, p);
    }

    public static float conditionP2(FMatrixRMaj A2) {
        SingularValueDecomposition_F32<FMatrixRMaj> svd = DecompositionFactory_FDRM.svd(A2.numRows, A2.numCols, false, false, true);
        svd.decompose(A2);
        float[] singularValues = svd.getSingularValues();
        int n = SingularOps_FDRM.rank(svd, UtilEjml.TEST_F32);
        if (n == 0) {
            return 0.0f;
        }
        float smallest = Float.MAX_VALUE;
        float largest = Float.MIN_VALUE;
        for (float s : singularValues) {
            if (s < smallest) {
                smallest = s;
            }
            if (!(s > largest)) continue;
            largest = s;
        }
        return largest / smallest;
    }

    public static float fastNormF(FMatrixD1 a) {
        float total = 0.0f;
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            float val2 = a.get(i);
            total += val2 * val2;
        }
        return (float)Math.sqrt(total);
    }

    public static float normF(FMatrixD1 a) {
        float total = 0.0f;
        float scale = CommonOps_FDRM.elementMaxAbs(a);
        if (scale == 0.0f) {
            return 0.0f;
        }
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            float val2 = a.get(i) / scale;
            total += val2 * val2;
        }
        return scale * (float)Math.sqrt(total);
    }

    public static float elementP(FMatrix1Row A2, float p) {
        if (p == 1.0f) {
            return CommonOps_FDRM.elementSumAbs(A2);
        }
        if (p == 2.0f) {
            return NormOps_FDRM.normF(A2);
        }
        float max = CommonOps_FDRM.elementMaxAbs(A2);
        if (max == 0.0f) {
            return 0.0f;
        }
        float total = 0.0f;
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            float a = A2.get(i) / max;
            total += (float)Math.pow(Math.abs(a), p);
        }
        return max * (float)Math.pow(total, 1.0f / p);
    }

    public static float fastElementP(FMatrixD1 A2, float p) {
        if (p == 2.0f) {
            return NormOps_FDRM.fastNormF(A2);
        }
        float total = 0.0f;
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            float a = A2.get(i);
            total += (float)Math.pow(Math.abs(a), p);
        }
        return (float)Math.pow(total, 1.0f / p);
    }

    public static float normP(FMatrixRMaj A2, float p) {
        if (p == 1.0f) {
            return NormOps_FDRM.normP1(A2);
        }
        if (p == 2.0f) {
            return NormOps_FDRM.normP2(A2);
        }
        if (Float.isInfinite(p)) {
            return NormOps_FDRM.normPInf(A2);
        }
        if (MatrixFeatures_FDRM.isVector(A2)) {
            return NormOps_FDRM.elementP(A2, p);
        }
        throw new IllegalArgumentException("Doesn't support induced norms yet.");
    }

    public static float fastNormP(FMatrixRMaj A2, float p) {
        if (p == 1.0f) {
            return NormOps_FDRM.normP1(A2);
        }
        if (p == 2.0f) {
            return NormOps_FDRM.fastNormP2(A2);
        }
        if (Float.isInfinite(p)) {
            return NormOps_FDRM.normPInf(A2);
        }
        if (MatrixFeatures_FDRM.isVector(A2)) {
            return NormOps_FDRM.fastElementP(A2, p);
        }
        throw new IllegalArgumentException("Doesn't support induced norms yet.");
    }

    public static float normP1(FMatrixRMaj A2) {
        if (MatrixFeatures_FDRM.isVector(A2)) {
            return CommonOps_FDRM.elementSumAbs(A2);
        }
        return NormOps_FDRM.inducedP1(A2);
    }

    public static float normP2(FMatrixRMaj A2) {
        if (MatrixFeatures_FDRM.isVector(A2)) {
            return NormOps_FDRM.normF(A2);
        }
        return NormOps_FDRM.inducedP2(A2);
    }

    public static float fastNormP2(FMatrixRMaj A2) {
        if (MatrixFeatures_FDRM.isVector(A2)) {
            return NormOps_FDRM.fastNormF(A2);
        }
        return NormOps_FDRM.inducedP2(A2);
    }

    public static float normPInf(FMatrixRMaj A2) {
        if (MatrixFeatures_FDRM.isVector(A2)) {
            return CommonOps_FDRM.elementMaxAbs(A2);
        }
        return NormOps_FDRM.inducedPInf(A2);
    }

    public static float inducedP1(FMatrixRMaj A2) {
        float max = 0.0f;
        int m = A2.numRows;
        int n = A2.numCols;
        for (int j = 0; j < n; ++j) {
            float total = 0.0f;
            for (int i = 0; i < m; ++i) {
                total += Math.abs(A2.get(i, j));
            }
            if (!(total > max)) continue;
            max = total;
        }
        return max;
    }

    public static float inducedP2(FMatrixRMaj A2) {
        SingularValueDecomposition_F32<FMatrixRMaj> svd = DecompositionFactory_FDRM.svd(A2.numRows, A2.numCols, false, false, true);
        if (!svd.decompose(A2)) {
            throw new RuntimeException("Decomposition failed");
        }
        float[] singularValues = svd.getSingularValues();
        return UtilEjml.max(singularValues, 0, singularValues.length);
    }

    public static float inducedPInf(FMatrixRMaj A2) {
        float max = 0.0f;
        int m = A2.numRows;
        int n = A2.numCols;
        for (int i = 0; i < m; ++i) {
            float total = 0.0f;
            for (int j = 0; j < n; ++j) {
                total += Math.abs(A2.get(i, j));
            }
            if (!(total > max)) continue;
            max = total;
        }
        return max;
    }
}

