/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.List;

public class QuickSortComparable<T extends Comparable<T>> {
    private int M = 7;
    private final int NSTACK;
    private final int[] istack;

    public QuickSortComparable() {
        this(65, 7);
    }

    public QuickSortComparable(int NSTACK, int M) {
        this.M = M;
        this.NSTACK = NSTACK;
        this.istack = new int[NSTACK];
    }

    public void sort(T[] arr, int length) {
        int jstack = -1;
        int l = 0;
        int ir = length - 1;
        while (true) {
            int i;
            T a;
            int j;
            if (ir - l < this.M) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    for (i = j - 1; i >= l && arr[i].compareTo(a) > 0; --i) {
                        arr[i + 1] = arr[i];
                    }
                    arr[i + 1] = a;
                }
                if (jstack < 0) break;
                ir = this.istack[jstack--];
                l = this.istack[jstack--];
                continue;
            }
            int k = l + ir >>> 1;
            T temp = arr[k];
            arr[k] = arr[l + 1];
            arr[l + 1] = temp;
            if (arr[l].compareTo(arr[ir]) > 0) {
                temp = arr[l];
                arr[l] = arr[ir];
                arr[ir] = temp;
            }
            if (arr[l + 1].compareTo(arr[ir]) > 0) {
                temp = arr[l + 1];
                arr[l + 1] = arr[ir];
                arr[ir] = temp;
            }
            if (arr[l].compareTo(arr[l + 1]) > 0) {
                temp = arr[l];
                arr[l] = arr[l + 1];
                arr[l + 1] = temp;
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            while (true) {
                if (arr[++i].compareTo(a) < 0) {
                    continue;
                }
                while (arr[--j].compareTo(a) > 0) {
                }
                if (j < i) break;
                temp = arr[i];
                arr[i] = arr[j];
                arr[j] = temp;
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            if ((jstack += 2) >= this.NSTACK) {
                throw new RuntimeException("NSTACK too small");
            }
            if (ir - i + 1 >= j - l) {
                this.istack[jstack] = ir;
                this.istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            this.istack[jstack] = j - 1;
            this.istack[jstack - 1] = l;
            l = i;
        }
    }

    public void sort(List<T> arr, int length) {
        int jstack = -1;
        int l = 0;
        int ir = length - 1;
        while (true) {
            int i;
            Comparable a;
            int j;
            if (ir - l < this.M) {
                for (j = l + 1; j <= ir; ++j) {
                    a = (Comparable)arr.get(j);
                    for (i = j - 1; i >= l && ((Comparable)arr.get(i)).compareTo(a) > 0; --i) {
                        arr.set(i + 1, (Comparable)arr.get(i));
                    }
                    arr.set(i + 1, a);
                }
                if (jstack < 0) break;
                ir = this.istack[jstack--];
                l = this.istack[jstack--];
                continue;
            }
            int k = l + ir >>> 1;
            QuickSortComparable.swap(arr, k, l + 1);
            if (((Comparable)arr.get(l)).compareTo((Comparable)arr.get(ir)) > 0) {
                QuickSortComparable.swap(arr, l, ir);
            }
            if (((Comparable)arr.get(l + 1)).compareTo((Comparable)arr.get(ir)) > 0) {
                QuickSortComparable.swap(arr, l + 1, ir);
            }
            if (((Comparable)arr.get(l)).compareTo((Comparable)arr.get(l + 1)) > 0) {
                QuickSortComparable.swap(arr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = (Comparable)arr.get(l + 1);
            while (true) {
                if (((Comparable)arr.get(++i)).compareTo(a) < 0) {
                    continue;
                }
                while (((Comparable)arr.get(--j)).compareTo(a) > 0) {
                }
                if (j < i) break;
                QuickSortComparable.swap(arr, i, j);
            }
            arr.set(l + 1, (Comparable)arr.get(j));
            arr.set(j, a);
            if ((jstack += 2) >= this.NSTACK) {
                throw new RuntimeException("NSTACK too small");
            }
            if (ir - i + 1 >= j - l) {
                this.istack[jstack] = ir;
                this.istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            this.istack[jstack] = j - 1;
            this.istack[jstack - 1] = l;
            l = i;
        }
    }

    private static <T> void swap(List<T> list, int indexA, int indexB) {
        T tmp = list.get(indexA);
        list.set(indexA, list.get(indexB));
        list.set(indexB, tmp);
    }

    public void sort(T[] arr, int length, int[] indexes) {
        int i;
        for (i = 0; i < length; ++i) {
            indexes[i] = i;
        }
        int jstack = -1;
        int l = 0;
        int ir = length - 1;
        while (true) {
            int temp;
            T a;
            int j;
            if (ir - l < this.M) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[indexes[j]];
                    temp = indexes[j];
                    for (i = j - 1; i >= l && arr[indexes[i]].compareTo(a) > 0; --i) {
                        indexes[i + 1] = indexes[i];
                    }
                    indexes[i + 1] = temp;
                }
                if (jstack < 0) break;
                ir = this.istack[jstack--];
                l = this.istack[jstack--];
                continue;
            }
            int k = l + ir >>> 1;
            temp = indexes[k];
            indexes[k] = indexes[l + 1];
            indexes[l + 1] = temp;
            if (arr[indexes[l]].compareTo(arr[indexes[ir]]) > 0) {
                temp = indexes[l];
                indexes[l] = indexes[ir];
                indexes[ir] = temp;
            }
            if (arr[indexes[l + 1]].compareTo(arr[indexes[ir]]) > 0) {
                temp = indexes[l + 1];
                indexes[l + 1] = indexes[ir];
                indexes[ir] = temp;
            }
            if (arr[indexes[l]].compareTo(arr[indexes[l + 1]]) > 0) {
                temp = indexes[l];
                indexes[l] = indexes[l + 1];
                indexes[l + 1] = temp;
            }
            i = l + 1;
            j = ir;
            a = arr[indexes[l + 1]];
            while (true) {
                if (arr[indexes[++i]].compareTo(a) < 0) {
                    continue;
                }
                while (arr[indexes[--j]].compareTo(a) > 0) {
                }
                if (j < i) break;
                temp = indexes[i];
                indexes[i] = indexes[j];
                indexes[j] = temp;
            }
            temp = indexes[l + 1];
            indexes[l + 1] = indexes[j];
            indexes[j] = temp;
            if ((jstack += 2) >= this.NSTACK) {
                throw new RuntimeException("NSTACK too small");
            }
            if (ir - i + 1 >= j - l) {
                this.istack[jstack] = ir;
                this.istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            this.istack[jstack] = j - 1;
            this.istack[jstack - 1] = l;
            l = i;
        }
    }
}

