/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.quasinewton;

import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;

public class EquationsBFGS {
    public static void update(DMatrixRMaj H, DMatrixRMaj s, DMatrixRMaj y, DMatrixRMaj tempV0, DMatrixRMaj tempV1) {
        double p = VectorVectorMult_DDRM.innerProd(y, s);
        if (p == 0.0) {
            return;
        }
        p = 1.0 / p;
        double sBs = VectorVectorMult_DDRM.innerProdA(s, H, s);
        if (sBs == 0.0) {
            return;
        }
        CommonOps_DDRM.mult(H, s, tempV0);
        CommonOps_DDRM.multTransA(s, H, tempV1);
        VectorVectorMult_DDRM.rank1Update(-p, H, tempV0, y);
        VectorVectorMult_DDRM.rank1Update(-p, H, y, tempV1);
        VectorVectorMult_DDRM.rank1Update(p * (p * sBs + 1.0), H, y, y);
    }

    public static void inverseUpdate(DMatrixRMaj H, DMatrixRMaj s, DMatrixRMaj y, DMatrixRMaj tempV0, DMatrixRMaj tempV1) {
        double alpha = VectorVectorMult_DDRM.innerProdA(y, H, y);
        double p = 1.0 / VectorVectorMult_DDRM.innerProd(s, y);
        CommonOps_DDRM.mult(H, y, tempV0);
        CommonOps_DDRM.multTransA(y, H, tempV1);
        VectorVectorMult_DDRM.rank1Update(-p, H, tempV0, s);
        VectorVectorMult_DDRM.rank1Update(-p, H, s, tempV1);
        VectorVectorMult_DDRM.rank1Update(p * alpha * p + p, H, s, s);
    }

    public static void conjugateUpdateD(DMatrixRMaj C, DMatrixRMaj d, DMatrixRMaj y, double step, DMatrixRMaj tempV0) {
        DMatrixRMaj z = tempV0;
        CommonOps_DDRM.multTransA(C, y, z);
        double dTd = VectorVectorMult_DDRM.innerProd(d, d);
        double dTz = VectorVectorMult_DDRM.innerProd(d, z);
        double middleScale = -dTd / dTz;
        double rightScale = dTd / Math.sqrt(-dTd * dTz / step);
        int N = d.getNumElements();
        for (int i = 0; i < N; ++i) {
            int n = i;
            d.data[n] = d.data[n] + (middleScale * z.data[i] + rightScale * d.data[i]);
        }
    }

    public static void conjugateUpdateC(DMatrixRMaj C, DMatrixRMaj d, DMatrixRMaj y, double step, DMatrixRMaj tempV0, DMatrixRMaj tempV1) {
        DMatrixRMaj z = tempV0;
        CommonOps_DDRM.multTransA(C, y, z);
        double dTd = VectorVectorMult_DDRM.innerProd(d, d);
        double dTz = VectorVectorMult_DDRM.innerProd(d, z);
        double middleScale = -dTd / dTz;
        double rightScale = dTd / Math.sqrt(-dTd * dTz / step);
        int N = d.getNumElements();
        for (int i = 0; i < N; ++i) {
            int n = i;
            d.data[n] = d.data[n] + (middleScale * z.data[i] + rightScale * d.data[i]);
        }
    }
}

