/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.lmeds;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.ddogleg.DDoglegConcurrency;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.lmeds.LeastMedianOfSquares;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.Factory;
import org.jetbrains.annotations.Nullable;
import pabeles.concurrency.GrowArray;

public class LeastMedianOfSquares_MT<Model, Point>
extends LeastMedianOfSquares<Model, Point> {
    final GrowArray<LeastMedianOfSquares.TrialHelper> helpers;
    final Object lock = new Object();
    volatile int bestMedianTrial;
    @Nullable
    volatile LeastMedianOfSquares.TrialHelper bestHelper;

    public LeastMedianOfSquares_MT(long randSeed, int totalCycles, double maxMedianError, double inlierFraction, ModelManager<Model> modelManager, Class<Point> pointType) {
        super(randSeed, totalCycles, maxMedianError, inlierFraction, modelManager, pointType);
        this.helpers = new GrowArray<LeastMedianOfSquares.TrialHelper>(() -> new LeastMedianOfSquares.TrialHelper(), a -> a.initialize(this.matchToInput.length), LeastMedianOfSquares.TrialHelper.class);
    }

    public LeastMedianOfSquares_MT(long randSeed, int totalCycles, ModelManager<Model> modelManager, Class<Point> pointType) {
        this(randSeed, totalCycles, Double.MAX_VALUE, 0.0, modelManager, pointType);
    }

    @Override
    public boolean process(List<Point> dataSet) {
        if (dataSet.size() < this.sampleSize) {
            return false;
        }
        this.checkTrialGenerators();
        int N = dataSet.size();
        if (this.matchToInput.length < N) {
            this.matchToInput = new int[N];
        }
        this.bestMedian = Double.MAX_VALUE;
        this.helpers.reset();
        DDoglegConcurrency.loopFor(0, this.totalCycles, 1, this.helpers, (helper, trial) -> {
            Ransac.randomDraw(helper.selectedIdx, N, this.sampleSize, (Random)this.trialRNG.get(trial));
            Ransac.addSelect(helper.selectedIdx, this.sampleSize, dataSet, helper.initialSample);
            if (!helper.modelGenerator.generate(helper.initialSample, helper.candidate)) {
                return;
            }
            helper.modelDistance.setModel(helper.candidate);
            helper.modelDistance.distances(dataSet, helper.errors.data);
            double median = QuickSelect.select(helper.errors.data, (int)((double)N * this.errorFraction + 0.5), N);
            if (median > this.bestMedian) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if (median > this.bestMedian) {
                    return;
                }
                if (median == this.bestMedian && this.bestMedianTrial < trial) {
                    return;
                }
                helper.swapModels();
                this.bestMedian = median;
                this.bestMedianTrial = trial;
                this.bestHelper = helper;
            }
        });
        this.helper = Objects.requireNonNull(this.bestHelper);
        this.computeInlierSet(dataSet, N, Objects.requireNonNull(this.helper));
        return this.bestMedian <= this.maxMedianError;
    }

    @Override
    public void setModel(Factory<ModelGenerator<Model, Point>> factoryGenerator, Factory<DistanceFromModel<Model, Point>> factoryDistance) {
        this.factoryGenerator = factoryGenerator;
        this.factoryDistance = factoryDistance;
        this.helpers.releaseInternalArray();
        this.helpers.resize(1);
        this.sampleSize = this.helpers.get((int)0).modelGenerator.getMinimumPoints();
    }
}

