/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.ddogleg.clustering.PointDistance;
import org.ddogleg.clustering.kmeans.InitializeKMeans;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.LArrayAccessor;

public class InitializeStandard<P>
implements InitializeKMeans<P> {
    protected Random rand;
    protected DogArray_I32 unused = new DogArray_I32();
    protected Set<Integer> used = new HashSet<Integer>();

    @Override
    public void initialize(PointDistance<P> distance, long randomSeed) {
        this.rand = new Random(randomSeed);
    }

    @Override
    public void selectSeeds(LArrayAccessor<P> points, int requestedSeeds, DogArray<P> selectedSeeds) {
        selectedSeeds.reserve(requestedSeeds);
        selectedSeeds.resize(0);
        if (points.size() == 0 || requestedSeeds == 0) {
            return;
        }
        if (points.size() <= requestedSeeds) {
            for (int i = 0; i < points.size(); ++i) {
                points.getCopy(i, selectedSeeds.grow());
            }
        } else if (requestedSeeds * 2 > points.size()) {
            int i;
            this.unused.resize(points.size());
            for (i = 0; i < points.size(); ++i) {
                this.unused.set(i, i);
            }
            for (i = 0; i < requestedSeeds; ++i) {
                int index = this.unused.removeSwap(this.rand.nextInt(this.unused.size));
                points.getCopy(index, selectedSeeds.grow());
            }
        } else {
            this.used.clear();
            while (selectedSeeds.size() < requestedSeeds) {
                int index = this.rand.nextInt(points.size());
                if (this.used.contains(index)) continue;
                points.getCopy(index, selectedSeeds.grow());
                this.used.add(index);
            }
        }
    }

    @Override
    public InitializeKMeans<P> newInstanceThread() {
        return new InitializeStandard<P>();
    }
}

