/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.gmm;

import java.io.Serializable;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class GaussianGmm_F64
implements Serializable {
    public DMatrixRMaj mean;
    public DMatrixRMaj covariance;
    public double weight;

    public GaussianGmm_F64(int DOF) {
        this.mean = new DMatrixRMaj(DOF, 1);
        this.covariance = new DMatrixRMaj(DOF, DOF);
    }

    public GaussianGmm_F64() {
    }

    public void zero() {
        CommonOps_DDRM.fill(this.mean, 0.0);
        CommonOps_DDRM.fill(this.covariance, 0.0);
        this.weight = 0.0;
    }

    public void addMean(double[] point, double responsibility) {
        for (int i = 0; i < this.mean.numRows; ++i) {
            int n = i;
            this.mean.data[n] = this.mean.data[n] + responsibility * point[i];
        }
        this.weight += responsibility;
    }

    public void addCovariance(double[] difference, double responsibility) {
        int j;
        int i;
        int N = this.mean.numRows;
        for (i = 0; i < N; ++i) {
            for (j = i; j < N; ++j) {
                int n = i * N + j;
                this.covariance.data[n] = this.covariance.data[n] + responsibility * difference[i] * difference[j];
            }
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < i; ++j) {
                this.covariance.data[i * N + j] = this.covariance.data[j * N + i];
            }
        }
    }

    public void setMean(double[] point) {
        System.arraycopy(point, 0, this.mean.data, 0, this.mean.numRows);
    }

    public GaussianGmm_F64 copy() {
        GaussianGmm_F64 out = new GaussianGmm_F64(this.mean.getNumElements());
        out.mean.setTo(this.mean);
        out.covariance.setTo(this.covariance);
        out.weight = this.weight;
        return out;
    }

    public DMatrixRMaj getMean() {
        return this.mean;
    }

    public void setMean(DMatrixRMaj mean) {
        this.mean = mean;
    }

    public DMatrixRMaj getCovariance() {
        return this.covariance;
    }

    public void setCovariance(DMatrixRMaj covariance) {
        this.covariance = covariance;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }
}

