/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.tree;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class MaterialTreeCellRenderer
extends DefaultTreeCellRenderer {
    protected Color foreground;
    protected Color background;
    protected Color selectedBackground;
    protected Color selectedForeground;

    public MaterialTreeCellRenderer() {
        this.installColors();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        this.setBorder(UIManager.getBorder("Tree.border"));
        if (isSelected) {
            this.setBackgroundSelectionColor(this.selectedBackground);
            this.setTextSelectionColor(this.selectedForeground);
        } else {
            this.setBackgroundNonSelectionColor(this.background);
            this.setTextNonSelectionColor(this.foreground);
        }
        return this;
    }

    @Override
    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    @Override
    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    @Override
    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    protected void installColors() {
        this.background = UIManager.getColor("Tree.background");
        this.foreground = UIManager.getColor("Tree.foreground");
        this.selectedBackground = UIManager.getColor("Tree.selectionBackground");
        this.selectedForeground = UIManager.getColor("Tree.selectionForeground");
    }
}

