/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.tabbedpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import mdlaf.MaterialLookAndFeel;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;

public class BasicTabbedPaneUIAdapter
extends BasicTabbedPaneUI
implements SwingConstants {
    protected Color selectedColor;
    protected boolean tabsOverlapBorder;
    protected boolean tabsOpaque = true;
    protected boolean contentOpaque = true;
    protected Insets currentPadInsets = new Insets(0, 0, 0, 0);
    protected Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    protected Component visibleComponent;
    protected Vector<View> htmlViews;
    protected Hashtable<Integer, Integer> mnemonicToIndexMap;
    protected InputMap mnemonicInputMap;
    protected ScrollableTabSupport tabScroller;
    protected TabContainer tabContainer;
    protected int focusIndex;
    protected Handler handler;
    protected int rolloverTabIndex;
    protected boolean isRunsDirty;
    protected boolean calculatedBaseline;
    protected int baseline;
    protected static int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    protected static int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    protected static final int CROP_SEGMENT = 12;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.tabPane = (JTabbedPane)c;
        this.calculatedBaseline = false;
        this.rolloverTabIndex = -1;
        this.focusIndex = -1;
        c.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        c.setLayout(null);
        this.tabPane = null;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new MaterialTabbedPaneScrollLayout();
        }
        return new MaterialTabbedPaneLayout();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof MaterialTabbedPaneScrollLayout;
    }

    @Override
    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
        }
        this.installTabContainer();
    }

    protected void installTabContainer() {
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Component tabComponent = this.tabPane.getTabComponentAt(i);
            if (tabComponent == null) continue;
            if (this.tabContainer == null) {
                this.tabContainer = new TabContainer();
            }
            this.tabContainer.add(tabComponent);
        }
        if (this.tabContainer == null) {
            return;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.tabPanel.add(this.tabContainer);
        } else {
            this.tabPane.add(this.tabContainer);
        }
    }

    @Override
    protected JButton createScrollButton(int direction) {
        if (direction != 5 && direction != 1 && direction != 3 && direction != 7) {
            throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
        }
        return new ScrollableTabButton(direction);
    }

    @Override
    protected void uninstallComponents() {
        this.uninstallTabContainer();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    private void uninstallTabContainer() {
        if (this.tabContainer == null) {
            return;
        }
        this.tabContainer.notifyTabbedPane = false;
        this.tabContainer.removeAll();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabContainer.remove(this.tabScroller.croppedEdge);
            this.tabScroller.tabPanel.remove(this.tabContainer);
        } else {
            this.tabPane.remove(this.tabContainer);
        }
        this.tabContainer = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.selectedColor = UIManager.getColor("TabbedPane.selected");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    @Override
    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    @Override
    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    @Override
    protected ChangeListener createChangeListener() {
        return this.getHandler();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void updateMnemonics() {
        this.resetMnemonics();
        for (int counter = this.tabPane.getTabCount() - 1; counter >= 0; --counter) {
            int mnemonic = this.tabPane.getMnemonicAt(counter);
            if (mnemonic <= 0) continue;
            this.addMnemonic(counter, mnemonic);
        }
    }

    protected void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    protected void addMnemonic(int index, int mnemonic) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, MaterialLookAndFeel.getFocusAcceleratorKeyMask()), "setSelectedIndex");
        this.mnemonicToIndexMap.put(mnemonic, index);
    }

    protected void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new ComponentInputMapUIResource(this.tabPane);
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 2));
        SwingUtilities.replaceUIInputMap(this.tabPane, 2, this.mnemonicInputMap);
    }

    protected void setRolloverTab(int x, int y) {
        this.setRolloverTab(this.tabForCoordinate(this.tabPane, x, y, false));
    }

    @Override
    protected void setRolloverTab(int index) {
        this.rolloverTabIndex = index;
    }

    @Override
    protected int getRolloverTab() {
        return this.rolloverTabIndex;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        int baseline = this.calculateBaselineIfNecessary();
        if (baseline != -1) {
            int placement = this.tabPane.getTabPlacement();
            Insets insets = this.tabPane.getInsets();
            Insets tabAreaInsets = this.getTabAreaInsets(placement);
            switch (placement) {
                case 1: {
                    return baseline += insets.top + tabAreaInsets.top;
                }
                case 3: {
                    baseline = height - insets.bottom - tabAreaInsets.bottom - this.maxTabHeight + baseline;
                    return baseline;
                }
                case 2: 
                case 4: {
                    return baseline += insets.top + tabAreaInsets.top;
                }
            }
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        super.getBaselineResizeBehavior(c);
        switch (this.tabPane.getTabPlacement()) {
            case 1: 
            case 2: 
            case 4: {
                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
            }
            case 3: {
                return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
            }
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    @Override
    protected int getBaseline(int tab) {
        if (this.tabPane.getTabComponentAt(tab) != null) {
            int offset = this.getBaselineOffset();
            if (offset != 0) {
                return -1;
            }
            Component c = this.tabPane.getTabComponentAt(tab);
            Dimension pref = c.getPreferredSize();
            Insets tabInsets = this.getTabInsets(this.tabPane.getTabPlacement(), tab);
            int cellHeight = this.maxTabHeight - tabInsets.top - tabInsets.bottom;
            return c.getBaseline(pref.width, pref.height) + (cellHeight - pref.height) / 2 + tabInsets.top;
        }
        View view = this.getTextViewForTab(tab);
        if (view != null) {
            int viewHeight = (int)view.getPreferredSpan(1);
            int baseline = BasicHTML.getHTMLBaseline(view, (int)view.getPreferredSpan(0), viewHeight);
            if (baseline >= 0) {
                return this.maxTabHeight / 2 - viewHeight / 2 + baseline + this.getBaselineOffset();
            }
            return -1;
        }
        FontMetrics metrics = this.getFontMetrics();
        int fontHeight = metrics.getHeight();
        int fontBaseline = metrics.getAscent();
        return this.maxTabHeight / 2 - fontHeight / 2 + fontBaseline + this.getBaselineOffset();
    }

    @Override
    protected int getBaselineOffset() {
        switch (this.tabPane.getTabPlacement()) {
            case 1: {
                if (this.tabPane.getTabCount() > 1) {
                    return 1;
                }
                return -1;
            }
            case 3: {
                if (this.tabPane.getTabCount() > 1) {
                    return -1;
                }
                return 1;
            }
        }
        return this.maxTabHeight % 2;
    }

    protected int calculateBaselineIfNecessary() {
        if (!this.calculatedBaseline) {
            this.calculatedBaseline = true;
            this.baseline = -1;
            if (this.tabPane.getTabCount() > 0) {
                this.calculateBaseline();
            }
        }
        return this.baseline;
    }

    protected void calculateBaseline() {
        int tabCount = this.tabPane.getTabCount();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.maxTabHeight = this.calculateMaxTabHeight(tabPlacement);
        this.baseline = this.getBaseline(0);
        if (this.isHorizontalTabPlacement()) {
            for (int i = 1; i < tabCount; ++i) {
                if (this.getBaseline(i) == this.baseline) continue;
                this.baseline = -1;
                break;
            }
        } else {
            FontMetrics fontMetrics = this.getFontMetrics();
            int fontHeight = fontMetrics.getHeight();
            int height = this.calculateTabHeight(tabPlacement, 0, fontHeight);
            for (int i = 1; i < tabCount; ++i) {
                int newHeight = this.calculateTabHeight(tabPlacement, i, fontHeight);
                if (height == newHeight) continue;
                this.baseline = -1;
                break;
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (this.tabsOverlapBorder) {
            this.paintContentBorder(g, tabPlacement, selectedIndex);
        }
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(g, tabPlacement, selectedIndex);
        }
        if (!this.tabsOverlapBorder) {
            this.paintContentBorder(g, tabPlacement, selectedIndex);
        }
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        int tabCount = this.tabPane.getTabCount();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = g.getClipBounds();
        for (int i = this.runCount - 1; i >= 0; --i) {
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            for (int j = start; j <= end; ++j) {
                if (j == selectedIndex || !this.rects[j].intersects(clipRect)) continue;
                this.paintTab(g, tabPlacement, this.rects, j, iconRect, textRect);
            }
        }
        if (selectedIndex >= 0 && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(g, tabPlacement, this.rects, selectedIndex, iconRect, textRect);
        }
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean isSelected;
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean bl = isSelected = selectedIndex == tabIndex;
        if (this.tabsOpaque || this.tabPane.isOpaque()) {
            this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        }
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = SwingUtilities2.getFontMetrics(this.tabPane, g, font);
        Icon icon = this.getIconForTab(tabIndex);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        if (this.tabPane.getTabComponentAt(tabIndex) == null) {
            String clippedTitle = title;
            if (this.scrollableTabLayoutEnabled() && this.tabScroller.croppedEdge.isParamsSet() && this.tabScroller.croppedEdge.getTabIndex() == tabIndex && this.isHorizontalTabPlacement()) {
                int availTextWidth = this.tabScroller.croppedEdge.getCropline() - (textRect.x - tabRect.x) - this.tabScroller.croppedEdge.getCroppedSideWidth();
                clippedTitle = SwingUtilities2.clipStringIfNecessary(null, metrics, title, availTextWidth);
            } else if (!this.scrollableTabLayoutEnabled() && this.isHorizontalTabPlacement()) {
                clippedTitle = SwingUtilities2.clipStringIfNecessary(null, metrics, title, textRect.width);
            }
            this.paintText(g, tabPlacement, font, metrics, tabIndex, clippedTitle, textRect, isSelected);
            this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
    }

    protected boolean isHorizontalTabPlacement() {
        return this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3;
    }

    protected static Polygon createCroppedTabShape(int tabPlacement, Rectangle tabRect, int cropline) {
        int ostart;
        int end;
        int start;
        int rlen;
        switch (tabPlacement) {
            case 2: 
            case 4: {
                rlen = tabRect.width;
                start = tabRect.x;
                end = tabRect.x + tabRect.width;
                ostart = tabRect.y + tabRect.height;
                break;
            }
            default: {
                rlen = tabRect.height;
                start = tabRect.y;
                end = tabRect.y + tabRect.height;
                ostart = tabRect.x + tabRect.width;
            }
        }
        int rcnt = rlen / 12;
        if (rlen % 12 > 0) {
            ++rcnt;
        }
        int npts = 2 + rcnt * 8;
        int[] xp = new int[npts];
        int[] yp = new int[npts];
        int pcnt = 0;
        xp[pcnt] = ostart;
        yp[pcnt++] = end;
        xp[pcnt] = ostart;
        yp[pcnt++] = start;
        block3: for (int i = 0; i < rcnt; ++i) {
            for (int j = 0; j < xCropLen.length; ++j) {
                xp[pcnt] = cropline - xCropLen[j];
                yp[pcnt] = start + i * 12 + yCropLen[j];
                if (yp[pcnt] >= end) {
                    yp[pcnt] = end;
                    ++pcnt;
                    continue block3;
                }
                ++pcnt;
            }
        }
        if (tabPlacement == 1 || tabPlacement == 3) {
            return new Polygon(xp, yp, pcnt);
        }
        return new Polygon(yp, xp, pcnt);
    }

    protected void paintCroppedTabEdge(Graphics g) {
        int tabIndex = this.tabScroller.croppedEdge.getTabIndex();
        int cropline = this.tabScroller.croppedEdge.getCropline();
        switch (this.tabPane.getTabPlacement()) {
            case 2: 
            case 4: {
                int x = this.rects[tabIndex].x;
                int y = cropline;
                g.setColor(this.shadow);
                for (int xx = x; xx <= x + this.rects[tabIndex].width; xx += 12) {
                    for (int i = 0; i < xCropLen.length; i += 2) {
                        g.drawLine(xx + yCropLen[i], y - xCropLen[i], xx + yCropLen[i + 1] - 1, y - xCropLen[i + 1]);
                    }
                }
                break;
            }
            default: {
                int y;
                int x = cropline;
                g.setColor(this.shadow);
                for (int yy = y = this.rects[tabIndex].y; yy <= y + this.rects[tabIndex].height; yy += 12) {
                    for (int i = 0; i < xCropLen.length; i += 2) {
                        g.drawLine(x - xCropLen[i], yy + yCropLen[i], x - xCropLen[i + 1], yy + yCropLen[i + 1] - 1);
                    }
                }
            }
        }
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    @Override
    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, g, iconRect.x, iconRect.y);
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                Color selectedFG;
                Color fg = this.tabPane.getForegroundAt(tabIndex);
                if (isSelected && fg instanceof UIResource && (selectedFG = UIManager.getColor("TabbedPane.selectedForeground")) != null) {
                    fg = selectedFG;
                }
                g.setColor(fg);
                SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        String propKey = isSelected ? "selectedLabelShift" : "labelShift";
        int nudge = DefaultLookup.getInt(this.tabPane, this, "TabbedPane." + propKey, 1);
        switch (tabPlacement) {
            case 2: {
                return nudge;
            }
            case 4: {
                return -nudge;
            }
        }
        return tabRect.width % 2;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = isSelected ? DefaultLookup.getInt(this.tabPane, this, "TabbedPane.selectedLabelShift", -1) : DefaultLookup.getInt(this.tabPane, this, "TabbedPane.labelShift", 1);
        switch (tabPlacement) {
            case 3: {
                return -nudge;
            }
            case 2: 
            case 4: {
                return tabRect.height % 2;
            }
        }
        return nudge;
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRect = rects[tabIndex];
        if (this.tabPane.hasFocus() && isSelected) {
            int h;
            int w;
            int y;
            int x;
            g.setColor(this.focus);
            switch (tabPlacement) {
                case 2: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h = tabRect.height - 6;
                    break;
                }
                case 4: {
                    x = tabRect.x + 2;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h = tabRect.height - 6;
                    break;
                }
                case 3: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 2;
                    w = tabRect.width - 6;
                    h = tabRect.height - 5;
                    break;
                }
                default: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 6;
                    h = tabRect.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.lightHighlight);
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.drawLine(x, y + 2, x, y + h - 3);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 2, y, x + w - 1, y);
                g.setColor(this.shadow);
                g.drawLine(x + 2, y + h - 2, x + w - 1, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                break;
            }
            case 4: {
                g.drawLine(x, y, x + w - 3, y);
                g.setColor(this.shadow);
                g.drawLine(x, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                g.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
                break;
            }
            case 3: {
                g.drawLine(x, y, x, y + h - 3);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.setColor(this.shadow);
                g.drawLine(x + 2, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y, x + w - 2, y + h - 3);
                g.setColor(this.darkShadow);
                g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 3);
                break;
            }
            default: {
                g.drawLine(x, y + 2, x, y + h - 1);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 2, y, x + w - 3, y);
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 1);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
            }
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(!isSelected || this.selectedColor == null ? this.tabPane.getBackgroundAt(tabIndex) : this.selectedColor);
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y + 1, w - 1, h - 3);
                break;
            }
            case 4: {
                g.fillRect(x, y + 1, w - 2, h - 3);
                break;
            }
            case 3: {
                g.fillRect(x + 1, y, w - 3, h - 1);
                break;
            }
            default: {
                g.fillRect(x + 1, y + 1, w - 3, h - 1);
            }
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (this.tabsOverlapBorder) {
                    x -= tabAreaInsets.right;
                }
                w -= x - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (!this.tabsOverlapBorder) break;
                w += tabAreaInsets.left;
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (!this.tabsOverlapBorder) break;
                h += tabAreaInsets.top;
                break;
            }
            default: {
                y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (this.tabsOverlapBorder) {
                    y -= tabAreaInsets.bottom;
                }
                h -= y - insets.top;
            }
        }
        if (this.tabPane.getTabCount() > 0 && (this.contentOpaque || this.tabPane.isOpaque())) {
            Color color = UIManager.getColor("TabbedPane.contentAreaColor");
            if (color != null) {
                g.setColor(color);
            } else if (this.selectedColor == null || selectedIndex == -1) {
                g.setColor(this.tabPane.getBackground());
            } else {
                g.setColor(this.selectedColor);
            }
            g.fillRect(x, y, w, h);
        }
        this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 2, y);
        } else {
            g.drawLine(x, y, selRect.x - 1, y);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y, x + w - 2, y);
            } else {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y, x + w - 2, y);
            }
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x, y, x, y + h - 2);
        } else {
            g.drawLine(x, y, x, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x, selRect.y + selRect.height, x, y + h - 2);
            }
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else {
            g.drawLine(x + 1, y + h - 2, selRect.x - 1, y + h - 2);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(this.shadow);
                g.drawLine(selRect.x + selRect.width, y + h - 2, x + w - 2, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 1, y + h - 1);
            }
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 3);
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        } else {
            g.drawLine(x + w - 2, y + 1, x + w - 2, selRect.y - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, selRect.y + selRect.height, x + w - 2, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 2);
            }
        }
    }

    protected void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            MaterialTabbedPaneLayout layout = (MaterialTabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.ensureCurrentLayout();
        Rectangle tabRect = new Rectangle();
        return this.getTabBounds(i, tabRect);
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        return this.tabForCoordinate(pane, x, y, true);
    }

    protected int tabForCoordinate(JTabbedPane pane, int x, int y, boolean validateIfNecessary) {
        if (validateIfNecessary) {
            this.ensureCurrentLayout();
        }
        if (this.isRunsDirty) {
            return -1;
        }
        Point p = new Point(x, y);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(x, y, p);
            Rectangle viewRect = this.tabScroller.viewport.getViewRect();
            if (!viewRect.contains(p)) {
                return -1;
            }
        }
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this.rects[i].contains(p.x, p.y)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.width = this.rects[tabIndex].width;
        dest.height = this.rects[tabIndex].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point vpp = this.tabScroller.viewport.getLocation();
            Point viewp = this.tabScroller.viewport.getViewPosition();
            dest.x = this.rects[tabIndex].x + vpp.x - viewp.x;
            dest.y = this.rects[tabIndex].y + vpp.y - viewp.y;
        } else {
            dest.x = this.rects[tabIndex].x;
            dest.y = this.rects[tabIndex].y;
        }
        return dest;
    }

    protected int getClosestTab(int x, int y) {
        int want;
        int tabCount;
        int min = 0;
        int max = tabCount = Math.min(this.rects.length, this.tabPane.getTabCount());
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean useX = tabPlacement == 1 || tabPlacement == 3;
        int n = want = useX ? x : y;
        while (min != max) {
            int maxLoc;
            int minLoc;
            int current = (max + min) / 2;
            if (useX) {
                minLoc = this.rects[current].x;
                maxLoc = minLoc + this.rects[current].width;
            } else {
                minLoc = this.rects[current].y;
                maxLoc = minLoc + this.rects[current].height;
            }
            if (want < minLoc) {
                max = current;
                if (min != max) continue;
                return Math.max(0, current - 1);
            }
            if (want >= maxLoc) {
                min = current;
                if (max - min > 1) continue;
                return Math.max(current + 1, tabCount - 1);
            }
            return current;
        }
        return min;
    }

    protected Point translatePointToTabPanel(int srcx, int srcy, Point dest) {
        Point vpp = this.tabScroller.viewport.getLocation();
        Point viewp = this.tabScroller.viewport.getViewPosition();
        dest.x = srcx - vpp.x + viewp.x;
        dest.y = srcy - vpp.y + viewp.y;
        return dest;
    }

    @Override
    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    @Override
    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane && this.visibleComponent.isVisible()) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    @Override
    protected void assureRectsCreated(int tabCount) {
        int rectArrayLen = this.rects.length;
        if (tabCount != rectArrayLen) {
            Rectangle[] tempRectArray = new Rectangle[tabCount];
            System.arraycopy(this.rects, 0, tempRectArray, 0, Math.min(rectArrayLen, tabCount));
            this.rects = tempRectArray;
            for (int rectIndex = rectArrayLen; rectIndex < tabCount; ++rectIndex) {
                this.rects[rectIndex] = new Rectangle();
            }
        }
    }

    @Override
    protected void expandTabRunsArray() {
        int rectLen = this.tabRuns.length;
        int[] newArray = new int[rectLen + 10];
        System.arraycopy(this.tabRuns, 0, newArray, 0, this.runCount);
        this.tabRuns = newArray;
    }

    @Override
    protected int getRunForTab(int tabCount, int tabIndex) {
        for (int i = 0; i < this.runCount; ++i) {
            int first = this.tabRuns[i];
            int last = this.lastTabInRun(tabCount, i);
            if (tabIndex < first || tabIndex > last) continue;
            return i;
        }
        return 0;
    }

    @Override
    protected int lastTabInRun(int tabCount, int run) {
        int nextRun;
        if (this.runCount == 1) {
            return tabCount - 1;
        }
        int n = nextRun = run == this.runCount - 1 ? 0 : run + 1;
        if (this.tabRuns[nextRun] == 0) {
            return tabCount - 1;
        }
        return this.tabRuns[nextRun] - 1;
    }

    @Override
    protected int getTabRunOverlay(int tabPlacement) {
        return this.tabRunOverlay;
    }

    @Override
    protected int getTabRunIndent(int tabPlacement, int run) {
        return 0;
    }

    @Override
    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1;
    }

    @Override
    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    @Override
    protected Icon getIconForTab(int tabIndex) {
        return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(tabIndex) ? this.tabPane.getDisabledIconAt(tabIndex) : this.tabPane.getIconAt(tabIndex);
    }

    @Override
    protected View getTextViewForTab(int tabIndex) {
        if (this.htmlViews != null) {
            return this.htmlViews.elementAt(tabIndex);
        }
        return null;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int height = 0;
        Component c = this.tabPane.getTabComponentAt(tabIndex);
        if (c != null) {
            height = c.getPreferredSize().height;
        } else {
            View v = this.getTextViewForTab(tabIndex);
            height = v != null ? (height += (int)v.getPreferredSpan(1)) : (height += fontHeight);
            Icon icon = this.getIconForTab(tabIndex);
            if (icon != null) {
                height = Math.max(height, icon.getIconHeight());
            }
        }
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        return height += tabInsets.top + tabInsets.bottom + 2;
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics();
        int tabCount = this.tabPane.getTabCount();
        int result = 0;
        int fontHeight = metrics.getHeight();
        for (int i = 0; i < tabCount; ++i) {
            result = Math.max(this.calculateTabHeight(tabPlacement, i, fontHeight), result);
        }
        return result;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        int width = tabInsets.left + tabInsets.right + 3;
        Component tabComponent = this.tabPane.getTabComponentAt(tabIndex);
        if (tabComponent != null) {
            width += tabComponent.getPreferredSize().width;
        } else {
            View v;
            Icon icon = this.getIconForTab(tabIndex);
            if (icon != null) {
                width += icon.getIconWidth() + this.textIconGap;
            }
            if ((v = this.getTextViewForTab(tabIndex)) != null) {
                width += (int)v.getPreferredSpan(0);
            } else {
                String title = this.tabPane.getTitleAt(tabIndex);
                width += SwingUtilities2.stringWidth(this.tabPane, metrics, title);
            }
        }
        return width;
    }

    @Override
    protected int calculateMaxTabWidth(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics();
        int tabCount = this.tabPane.getTabCount();
        int result = 0;
        for (int i = 0; i < tabCount; ++i) {
            result = Math.max(this.calculateTabWidth(tabPlacement, i, metrics), result);
        }
        return result;
    }

    @Override
    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return horizRunCount > 0 ? horizRunCount * (maxTabHeight - tabRunOverlay) + tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom : 0;
    }

    @Override
    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return vertRunCount > 0 ? vertRunCount * (maxTabWidth - tabRunOverlay) + tabRunOverlay + tabAreaInsets.left + tabAreaInsets.right : 0;
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        return this.tabInsets;
    }

    @Override
    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        BasicTabbedPaneUIAdapter.rotateInsets(this.selectedTabPadInsets, this.currentPadInsets, tabPlacement);
        return this.currentPadInsets;
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        BasicTabbedPaneUIAdapter.rotateInsets(this.tabAreaInsets, this.currentTabAreaInsets, tabPlacement);
        return this.currentTabAreaInsets;
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        return this.contentBorderInsets;
    }

    @Override
    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        return this.tabPane.getFontMetrics(font);
    }

    @Override
    protected void navigateSelectedTab(int direction) {
        int tabPlacement = this.tabPane.getTabPlacement();
        int current = DefaultLookup.getBoolean(this.tabPane, this, "TabbedPane.selectionFollowsFocus", true) ? this.tabPane.getSelectedIndex() : this.getFocusIndex();
        int tabCount = this.tabPane.getTabCount();
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        if (tabCount <= 0) {
            return;
        }
        block0 : switch (tabPlacement) {
            case 2: 
            case 4: {
                switch (direction) {
                    case 12: {
                        this.selectNextTab(current);
                        break block0;
                    }
                    case 13: {
                        this.selectPreviousTab(current);
                        break block0;
                    }
                    case 1: {
                        this.selectPreviousTabInRun(current);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(current);
                        break block0;
                    }
                    case 7: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 3: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (direction) {
                    case 12: {
                        this.selectNextTab(current);
                        break block0;
                    }
                    case 13: {
                        this.selectPreviousTab(current);
                        break block0;
                    }
                    case 1: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 5: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 3: {
                        if (leftToRight) {
                            this.selectNextTabInRun(current);
                            break block0;
                        }
                        this.selectPreviousTabInRun(current);
                        break block0;
                    }
                    case 7: {
                        if (leftToRight) {
                            this.selectPreviousTabInRun(current);
                            break block0;
                        }
                        this.selectNextTabInRun(current);
                        break block0;
                    }
                }
            }
        }
    }

    @Override
    protected void selectNextTabInRun(int current) {
        int tabCount = this.tabPane.getTabCount();
        int tabIndex = this.getNextTabIndexInRun(tabCount, current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndexInRun(tabCount, tabIndex);
        }
        this.navigateTo(tabIndex);
    }

    @Override
    protected void selectPreviousTabInRun(int current) {
        int tabCount = this.tabPane.getTabCount();
        int tabIndex = this.getPreviousTabIndexInRun(tabCount, current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndexInRun(tabCount, tabIndex);
        }
        this.navigateTo(tabIndex);
    }

    @Override
    protected void selectNextTab(int current) {
        int tabIndex = this.getNextTabIndex(current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndex(tabIndex);
        }
        this.navigateTo(tabIndex);
    }

    @Override
    protected void selectPreviousTab(int current) {
        int tabIndex = this.getPreviousTabIndex(current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndex(tabIndex);
        }
        this.navigateTo(tabIndex);
    }

    @Override
    protected void selectAdjacentRunTab(int tabPlacement, int tabIndex, int offset) {
        int newIndex;
        if (this.runCount < 2) {
            return;
        }
        Rectangle r = this.rects[tabIndex];
        switch (tabPlacement) {
            case 2: 
            case 4: {
                newIndex = this.tabForCoordinate(this.tabPane, r.x + r.width / 2 + offset, r.y + r.height / 2);
                break;
            }
            default: {
                newIndex = this.tabForCoordinate(this.tabPane, r.x + r.width / 2, r.y + r.height / 2 + offset);
            }
        }
        if (newIndex != -1) {
            while (!this.tabPane.isEnabledAt(newIndex) && newIndex != tabIndex) {
                newIndex = this.getNextTabIndex(newIndex);
            }
            this.navigateTo(newIndex);
        }
    }

    protected void navigateTo(int index) {
        if (DefaultLookup.getBoolean(this.tabPane, this, "TabbedPane.selectionFollowsFocus", true)) {
            this.tabPane.setSelectedIndex(index);
        } else {
            this.setFocusIndex(index, true);
        }
    }

    void setFocusIndex(int index, boolean repaint) {
        if (repaint && !this.isRunsDirty) {
            this.repaintTab(this.focusIndex);
            this.focusIndex = index;
            this.repaintTab(this.focusIndex);
        } else {
            this.focusIndex = index;
        }
    }

    protected void repaintTab(int index) {
        if (!this.isRunsDirty && index >= 0 && index < this.tabPane.getTabCount()) {
            this.tabPane.repaint(this.getTabBounds(this.tabPane, index));
        }
    }

    protected void validateFocusIndex() {
        if (this.focusIndex >= this.tabPane.getTabCount()) {
            this.setFocusIndex(this.tabPane.getSelectedIndex(), false);
        }
    }

    @Override
    protected int getFocusIndex() {
        return this.focusIndex;
    }

    @Override
    protected int getTabRunOffset(int tabPlacement, int tabCount, int tabIndex, boolean forward) {
        int offset;
        int run = this.getRunForTab(tabCount, tabIndex);
        switch (tabPlacement) {
            case 2: {
                if (run == 0) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? this.maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                offset = forward ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (run == 0) {
                    offset = forward ? this.maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                offset = forward ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (run == 0) {
                    offset = forward ? this.maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                offset = forward ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                offset = run == 0 ? (forward ? -(this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (run == this.runCount - 1 ? (forward ? this.maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (forward ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return offset;
    }

    @Override
    protected int getPreviousTabIndex(int base) {
        int tabIndex = base - 1 >= 0 ? base - 1 : this.tabPane.getTabCount() - 1;
        return tabIndex >= 0 ? tabIndex : 0;
    }

    @Override
    protected int getNextTabIndex(int base) {
        return (base + 1) % this.tabPane.getTabCount();
    }

    @Override
    protected int getNextTabIndexInRun(int tabCount, int base) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        int next = this.getNextTabIndex(base);
        if (next == this.tabRuns[this.getNextTabRun(currentRun)]) {
            return this.tabRuns[currentRun];
        }
        return next;
    }

    @Override
    protected int getPreviousTabIndexInRun(int tabCount, int base) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        if (base == this.tabRuns[currentRun]) {
            int previous = this.tabRuns[this.getNextTabRun(currentRun)] - 1;
            return previous != -1 ? previous : tabCount - 1;
        }
        return this.getPreviousTabIndex(base);
    }

    @Override
    protected int getPreviousTabRun(int baseRun) {
        int runIndex = baseRun - 1 >= 0 ? baseRun - 1 : this.runCount - 1;
        return runIndex >= 0 ? runIndex : 0;
    }

    @Override
    protected int getNextTabRun(int baseRun) {
        return (baseRun + 1) % this.runCount;
    }

    protected static void rotateInsets(Insets topInsets, Insets targetInsets, int targetPlacement) {
        switch (targetPlacement) {
            case 2: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.top;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.bottom;
                break;
            }
            case 3: {
                targetInsets.top = topInsets.bottom;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.top;
                targetInsets.right = topInsets.right;
                break;
            }
            case 4: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.top;
                break;
            }
            default: {
                targetInsets.top = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.bottom;
                targetInsets.right = topInsets.right;
            }
        }
    }

    boolean requestFocusForVisibleComponent() {
        return SwingUtilities2.tabbedPaneChangeFocusTo(this.getVisibleComponent());
    }

    protected Vector<View> createHTMLVector() {
        Vector<View> htmlViews = new Vector<View>();
        int count = this.tabPane.getTabCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                String title = this.tabPane.getTitleAt(i);
                if (BasicHTML.isHTMLString(title)) {
                    htmlViews.addElement(BasicHTML.createHTMLView(this.tabPane, title));
                    continue;
                }
                htmlViews.addElement(null);
            }
        }
        return htmlViews;
    }

    protected class CroppedEdge
    extends JPanel
    implements UIResource {
        protected Shape shape;
        protected int tabIndex;
        protected int cropline;
        protected int cropx;
        protected int cropy;

        public CroppedEdge() {
            this.setOpaque(false);
        }

        public void setParams(int tabIndex, int cropline, int cropx, int cropy) {
            this.tabIndex = tabIndex;
            this.cropline = cropline;
            this.cropx = cropx;
            this.cropy = cropy;
            Rectangle tabRect = BasicTabbedPaneUIAdapter.this.rects[tabIndex];
            this.setBounds(tabRect);
            this.shape = BasicTabbedPaneUIAdapter.createCroppedTabShape(BasicTabbedPaneUIAdapter.this.tabPane.getTabPlacement(), tabRect, cropline);
            if (this.getParent() == null && BasicTabbedPaneUIAdapter.this.tabContainer != null) {
                BasicTabbedPaneUIAdapter.this.tabContainer.add((Component)this, 0);
            }
        }

        public void resetParams() {
            this.shape = null;
            if (this.getParent() == BasicTabbedPaneUIAdapter.this.tabContainer && BasicTabbedPaneUIAdapter.this.tabContainer != null) {
                BasicTabbedPaneUIAdapter.this.tabContainer.remove(this);
            }
        }

        public boolean isParamsSet() {
            return this.shape != null;
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        public int getCropline() {
            return this.cropline;
        }

        public int getCroppedSideWidth() {
            return 3;
        }

        protected Color getBgColor() {
            Color bg;
            Container parent = BasicTabbedPaneUIAdapter.this.tabPane.getParent();
            if (parent != null && (bg = parent.getBackground()) != null) {
                return bg;
            }
            return UIManager.getColor("control");
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isParamsSet() && g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                g2.clipRect(0, 0, this.getWidth(), this.getHeight());
                g2.setColor(this.getBgColor());
                g2.translate(this.cropx, this.cropy);
                g2.fill(this.shape);
                BasicTabbedPaneUIAdapter.this.paintCroppedTabEdge(g);
                g2.translate(-this.cropx, -this.cropy);
            }
        }
    }

    protected class TabContainer
    extends JPanel
    implements UIResource {
        protected boolean notifyTabbedPane;

        public TabContainer() {
            super(null);
            this.notifyTabbedPane = true;
            this.setOpaque(false);
        }

        @Override
        public void remove(Component comp) {
            int index = BasicTabbedPaneUIAdapter.this.tabPane.indexOfTabComponent(comp);
            super.remove(comp);
            if (this.notifyTabbedPane && index != -1) {
                BasicTabbedPaneUIAdapter.this.tabPane.setTabComponentAt(index, null);
            }
        }

        protected void removeUnusedTabComponents() {
            for (Component c : this.getComponents()) {
                int index;
                if (c instanceof UIResource || (index = BasicTabbedPaneUIAdapter.this.tabPane.indexOfTabComponent(c)) != -1) continue;
                super.remove(c);
            }
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return BasicTabbedPaneUIAdapter.this.tabScroller != null && !BasicTabbedPaneUIAdapter.this.tabScroller.croppedEdge.isParamsSet();
        }

        @Override
        public void doLayout() {
            if (BasicTabbedPaneUIAdapter.this.scrollableTabLayoutEnabled()) {
                BasicTabbedPaneUIAdapter.this.tabScroller.tabPanel.repaint();
                BasicTabbedPaneUIAdapter.this.tabScroller.updateView();
            } else {
                BasicTabbedPaneUIAdapter.this.tabPane.repaint(this.getBounds());
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        @Override
        public void focusGained(FocusEvent e) {
            BasicTabbedPaneUIAdapter.this.getHandler().focusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            BasicTabbedPaneUIAdapter.this.getHandler().focusLost(e);
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            BasicTabbedPaneUIAdapter.this.getHandler().mousePressed(e);
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            BasicTabbedPaneUIAdapter.this.getHandler().stateChanged(e);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            BasicTabbedPaneUIAdapter.this.getHandler().propertyChange(e);
        }
    }

    protected class Handler
    implements ChangeListener,
    ContainerListener,
    FocusListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener {
        protected Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            String name = e.getPropertyName();
            boolean isScrollLayout = BasicTabbedPaneUIAdapter.this.scrollableTabLayoutEnabled();
            if (name == "mnemonicAt") {
                BasicTabbedPaneUIAdapter.this.updateMnemonics();
                pane.repaint();
            } else if (name == "displayedMnemonicIndexAt") {
                pane.repaint();
            } else if (name == "indexForTitle") {
                BasicTabbedPaneUIAdapter.this.calculatedBaseline = false;
                Integer index = (Integer)e.getNewValue();
                if (BasicTabbedPaneUIAdapter.this.htmlViews != null) {
                    BasicTabbedPaneUIAdapter.this.htmlViews.removeElementAt(index);
                }
                this.updateHtmlViews(index);
            } else if (name == "tabLayoutPolicy") {
                BasicTabbedPaneUIAdapter.this.uninstallUI(pane);
                BasicTabbedPaneUIAdapter.this.installUI(pane);
                BasicTabbedPaneUIAdapter.this.calculatedBaseline = false;
            } else if (name == "tabPlacement") {
                if (BasicTabbedPaneUIAdapter.this.scrollableTabLayoutEnabled()) {
                    BasicTabbedPaneUIAdapter.this.tabScroller.createButtons();
                }
                BasicTabbedPaneUIAdapter.this.calculatedBaseline = false;
            } else if (name == "opaque" && isScrollLayout) {
                boolean newVal = (Boolean)e.getNewValue();
                BasicTabbedPaneUIAdapter.this.tabScroller.tabPanel.setOpaque(newVal);
                BasicTabbedPaneUIAdapter.this.tabScroller.viewport.setOpaque(newVal);
            } else if (name == "background" && isScrollLayout) {
                Color newVal = (Color)e.getNewValue();
                BasicTabbedPaneUIAdapter.this.tabScroller.tabPanel.setBackground(newVal);
                BasicTabbedPaneUIAdapter.this.tabScroller.viewport.setBackground(newVal);
                Color newColor = BasicTabbedPaneUIAdapter.this.selectedColor == null ? newVal : BasicTabbedPaneUIAdapter.this.selectedColor;
                BasicTabbedPaneUIAdapter.this.tabScroller.scrollForwardButton.setBackground(newColor);
                BasicTabbedPaneUIAdapter.this.tabScroller.scrollBackwardButton.setBackground(newColor);
            } else if (name == "indexForTabComponent") {
                Component c;
                if (BasicTabbedPaneUIAdapter.this.tabContainer != null) {
                    BasicTabbedPaneUIAdapter.this.tabContainer.removeUnusedTabComponents();
                }
                if ((c = BasicTabbedPaneUIAdapter.this.tabPane.getTabComponentAt((Integer)e.getNewValue())) != null) {
                    if (BasicTabbedPaneUIAdapter.this.tabContainer == null) {
                        BasicTabbedPaneUIAdapter.this.installTabContainer();
                    } else {
                        BasicTabbedPaneUIAdapter.this.tabContainer.add(c);
                    }
                }
                BasicTabbedPaneUIAdapter.this.tabPane.revalidate();
                BasicTabbedPaneUIAdapter.this.tabPane.repaint();
                BasicTabbedPaneUIAdapter.this.calculatedBaseline = false;
            } else if (name == "indexForNullComponent") {
                BasicTabbedPaneUIAdapter.this.isRunsDirty = true;
                this.updateHtmlViews((Integer)e.getNewValue());
            } else if (name == "font") {
                BasicTabbedPaneUIAdapter.this.calculatedBaseline = false;
            }
        }

        protected void updateHtmlViews(int index) {
            String title = BasicTabbedPaneUIAdapter.this.tabPane.getTitleAt(index);
            boolean isHTML = BasicHTML.isHTMLString(title);
            if (isHTML) {
                if (BasicTabbedPaneUIAdapter.this.htmlViews == null) {
                    BasicTabbedPaneUIAdapter.this.htmlViews = BasicTabbedPaneUIAdapter.this.createHTMLVector();
                } else {
                    View v = BasicHTML.createHTMLView(BasicTabbedPaneUIAdapter.this.tabPane, title);
                    BasicTabbedPaneUIAdapter.this.htmlViews.insertElementAt(v, index);
                }
            } else if (BasicTabbedPaneUIAdapter.this.htmlViews != null) {
                BasicTabbedPaneUIAdapter.this.htmlViews.insertElementAt(null, index);
            }
            BasicTabbedPaneUIAdapter.this.updateMnemonics();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            tabPane.revalidate();
            tabPane.repaint();
            BasicTabbedPaneUIAdapter.this.setFocusIndex(tabPane.getSelectedIndex(), false);
            if (BasicTabbedPaneUIAdapter.this.scrollableTabLayoutEnabled()) {
                BasicTabbedPaneUIAdapter.this.ensureCurrentLayout();
                int index = tabPane.getSelectedIndex();
                if (index < BasicTabbedPaneUIAdapter.this.rects.length && index != -1) {
                    BasicTabbedPaneUIAdapter.this.tabScroller.tabPanel.scrollRectToVisible((Rectangle)BasicTabbedPaneUIAdapter.this.rects[index].clone());
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BasicTabbedPaneUIAdapter.this.setRolloverTab(e.getX(), e.getY());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BasicTabbedPaneUIAdapter.this.setRolloverTab(-1);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!BasicTabbedPaneUIAdapter.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = BasicTabbedPaneUIAdapter.this.tabForCoordinate(BasicTabbedPaneUIAdapter.this.tabPane, e.getX(), e.getY());
            if (tabIndex >= 0 && BasicTabbedPaneUIAdapter.this.tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex != BasicTabbedPaneUIAdapter.this.tabPane.getSelectedIndex()) {
                    BasicTabbedPaneUIAdapter.this.tabPane.setSelectedIndex(tabIndex);
                } else if (BasicTabbedPaneUIAdapter.this.tabPane.isRequestFocusEnabled()) {
                    BasicTabbedPaneUIAdapter.this.tabPane.requestFocus();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BasicTabbedPaneUIAdapter.this.setRolloverTab(e.getX(), e.getY());
        }

        @Override
        public void focusGained(FocusEvent e) {
            BasicTabbedPaneUIAdapter.this.setFocusIndex(BasicTabbedPaneUIAdapter.this.tabPane.getSelectedIndex(), true);
        }

        @Override
        public void focusLost(FocusEvent e) {
            BasicTabbedPaneUIAdapter.this.repaintTab(BasicTabbedPaneUIAdapter.this.focusIndex);
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            BasicTabbedPaneUIAdapter.this.isRunsDirty = true;
            this.updateHtmlViews(tp.indexOfComponent(child));
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            Integer indexObj = (Integer)tp.getClientProperty("__index_to_remove__");
            if (indexObj != null) {
                int index = indexObj;
                if (BasicTabbedPaneUIAdapter.this.htmlViews != null && BasicTabbedPaneUIAdapter.this.htmlViews.size() > index) {
                    BasicTabbedPaneUIAdapter.this.htmlViews.removeElementAt(index);
                }
                tp.putClientProperty("__index_to_remove__", null);
            }
            BasicTabbedPaneUIAdapter.this.isRunsDirty = true;
            BasicTabbedPaneUIAdapter.this.updateMnemonics();
            BasicTabbedPaneUIAdapter.this.validateFocusIndex();
        }
    }

    protected class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int direction) {
            super(direction, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }
    }

    protected class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            super(null);
            this.setOpaque(BasicTabbedPaneUIAdapter.this.tabPane.isOpaque());
            Color bgColor = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (bgColor == null) {
                bgColor = BasicTabbedPaneUIAdapter.this.tabPane.getBackground();
            }
            this.setBackground(bgColor);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            BasicTabbedPaneUIAdapter.this.paintTabArea(g, BasicTabbedPaneUIAdapter.this.tabPane.getTabPlacement(), BasicTabbedPaneUIAdapter.this.tabPane.getSelectedIndex());
            if (BasicTabbedPaneUIAdapter.this.tabScroller.croppedEdge.isParamsSet() && BasicTabbedPaneUIAdapter.this.tabContainer == null) {
                Rectangle croppedRect = BasicTabbedPaneUIAdapter.this.rects[BasicTabbedPaneUIAdapter.this.tabScroller.croppedEdge.getTabIndex()];
                g.translate(croppedRect.x, croppedRect.y);
                BasicTabbedPaneUIAdapter.this.tabScroller.croppedEdge.paintComponent(g);
                g.translate(-croppedRect.x, -croppedRect.y);
            }
        }

        @Override
        public void doLayout() {
            if (this.getComponentCount() > 0) {
                Component child = this.getComponent(0);
                child.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    protected class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setName("TabbedPane.scrollableViewport");
            this.setScrollMode(0);
            this.setOpaque(BasicTabbedPaneUIAdapter.this.tabPane.isOpaque());
            Color bgColor = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (bgColor == null) {
                bgColor = BasicTabbedPaneUIAdapter.this.tabPane.getBackground();
            }
            this.setBackground(bgColor);
        }
    }

    protected class ScrollableTabSupport
    implements ActionListener,
    ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public JButton scrollForwardButton;
        public JButton scrollBackwardButton;
        public CroppedEdge croppedEdge;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int tabPlacement) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.croppedEdge = new CroppedEdge();
            this.createButtons();
        }

        void createButtons() {
            int tabPlacement;
            if (this.scrollForwardButton != null) {
                BasicTabbedPaneUIAdapter.this.tabPane.remove(this.scrollForwardButton);
                this.scrollForwardButton.removeActionListener(this);
                BasicTabbedPaneUIAdapter.this.tabPane.remove(this.scrollBackwardButton);
                this.scrollBackwardButton.removeActionListener(this);
            }
            if ((tabPlacement = BasicTabbedPaneUIAdapter.this.tabPane.getTabPlacement()) == 1 || tabPlacement == 3) {
                this.scrollForwardButton = BasicTabbedPaneUIAdapter.this.createScrollButton(3);
                this.scrollBackwardButton = BasicTabbedPaneUIAdapter.this.createScrollButton(7);
            } else {
                this.scrollForwardButton = BasicTabbedPaneUIAdapter.this.createScrollButton(5);
                this.scrollBackwardButton = BasicTabbedPaneUIAdapter.this.createScrollButton(1);
            }
            this.scrollForwardButton.addActionListener(this);
            this.scrollBackwardButton.addActionListener(this);
            BasicTabbedPaneUIAdapter.this.tabPane.add(this.scrollForwardButton);
            BasicTabbedPaneUIAdapter.this.tabPane.add(this.scrollBackwardButton);
        }

        public void scrollForward(int tabPlacement) {
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            if (tabPlacement == 1 || tabPlacement == 3 ? viewRect.width >= viewSize.width - viewRect.x : viewRect.height >= viewSize.height - viewRect.y) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int tabPlacement) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int tabPlacement, int index) {
            this.leadingTabIndex = index;
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            switch (tabPlacement) {
                case 1: 
                case 3: {
                    int n = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[this.leadingTabIndex].x;
                    if (viewSize.width - this.tabViewPosition.x >= viewRect.width) break;
                    Dimension extentSize = new Dimension(viewSize.width - this.tabViewPosition.x, viewRect.height);
                    this.viewport.setExtentSize(extentSize);
                    break;
                }
                case 2: 
                case 4: {
                    int n = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[this.leadingTabIndex].y;
                    if (viewSize.height - this.tabViewPosition.y >= viewRect.height) break;
                    Dimension extentSize = new Dimension(viewRect.width, viewSize.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(extentSize);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateView();
        }

        protected void updateView() {
            int tabPlacement = BasicTabbedPaneUIAdapter.this.tabPane.getTabPlacement();
            int tabCount = BasicTabbedPaneUIAdapter.this.tabPane.getTabCount();
            BasicTabbedPaneUIAdapter.this.assureRectsCreated(tabCount);
            Rectangle vpRect = this.viewport.getBounds();
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            this.leadingTabIndex = BasicTabbedPaneUIAdapter.this.getClosestTab(viewRect.x, viewRect.y);
            if (this.leadingTabIndex + 1 < tabCount) {
                switch (tabPlacement) {
                    case 1: 
                    case 3: {
                        if (((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[this.leadingTabIndex].x >= viewRect.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[this.leadingTabIndex].y >= viewRect.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets contentInsets = BasicTabbedPaneUIAdapter.this.getContentBorderInsets(tabPlacement);
            switch (tabPlacement) {
                case 2: {
                    BasicTabbedPaneUIAdapter.this.tabPane.repaint(vpRect.x + vpRect.width, vpRect.y, contentInsets.left, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUIAdapter.this.tabPane.repaint(vpRect.x - contentInsets.right, vpRect.y, contentInsets.right, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUIAdapter.this.tabPane.repaint(vpRect.x, vpRect.y - contentInsets.bottom, vpRect.width, contentInsets.bottom);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                    break;
                }
                default: {
                    BasicTabbedPaneUIAdapter.this.tabPane.repaint(vpRect.x, vpRect.y + vpRect.height, vpRect.width, contentInsets.top);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionKey;
            Action action;
            ActionMap map = BasicTabbedPaneUIAdapter.this.tabPane.getActionMap();
            if (map != null && (action = map.get(actionKey = e.getSource() == this.scrollForwardButton ? "scrollTabsForwardAction" : "scrollTabsBackwardAction")) != null && action.isEnabled()) {
                action.actionPerformed(new ActionEvent(BasicTabbedPaneUIAdapter.this.tabPane, 1001, null, e.getWhen(), e.getModifiers()));
            }
        }

        public String toString() {
            return "viewport.viewSize=" + this.viewport.getViewSize() + "\nviewport.viewRectangle=" + this.viewport.getViewRect() + "\nleadingTabIndex=" + this.leadingTabIndex + "\ntabViewPosition=" + this.tabViewPosition;
        }
    }

    private class MaterialTabbedPaneScrollLayout
    extends MaterialTabbedPaneLayout {
        private MaterialTabbedPaneScrollLayout() {
        }

        @Override
        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return BasicTabbedPaneUIAdapter.this.calculateMaxTabHeight(tabPlacement);
        }

        @Override
        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return BasicTabbedPaneUIAdapter.this.calculateMaxTabWidth(tabPlacement);
        }

        @Override
        public void layoutContainer(Container parent) {
            BasicTabbedPaneUIAdapter.this.setRolloverTab(-1);
            int tabPlacement = BasicTabbedPaneUIAdapter.this.tabPane.getTabPlacement();
            int tabCount = BasicTabbedPaneUIAdapter.this.tabPane.getTabCount();
            Insets insets = BasicTabbedPaneUIAdapter.this.tabPane.getInsets();
            int selectedIndex = BasicTabbedPaneUIAdapter.this.tabPane.getSelectedIndex();
            Component visibleComponent = BasicTabbedPaneUIAdapter.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component selectedComponent = null;
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    BasicTabbedPaneUIAdapter.this.setVisibleComponent(null);
                }
            } else {
                selectedComponent = BasicTabbedPaneUIAdapter.this.tabPane.getComponentAt(selectedIndex);
            }
            if (BasicTabbedPaneUIAdapter.this.tabPane.getTabCount() == 0) {
                BasicTabbedPaneUIAdapter.this.tabScroller.croppedEdge.resetParams();
                BasicTabbedPaneUIAdapter.this.tabScroller.scrollForwardButton.setVisible(false);
                BasicTabbedPaneUIAdapter.this.tabScroller.scrollBackwardButton.setVisible(false);
                return;
            }
            boolean shouldChangeFocus = false;
            if (selectedComponent != null) {
                if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                    shouldChangeFocus = true;
                }
                BasicTabbedPaneUIAdapter.this.setVisibleComponent(selectedComponent);
            }
            Insets contentInsets = BasicTabbedPaneUIAdapter.this.getContentBorderInsets(tabPlacement);
            Rectangle bounds = BasicTabbedPaneUIAdapter.this.tabPane.getBounds();
            int numChildren = BasicTabbedPaneUIAdapter.this.tabPane.getComponentCount();
            if (numChildren > 0) {
                int ch;
                int cw;
                int cy;
                int cx;
                int ty;
                int tx;
                int th;
                int tw;
                switch (tabPlacement) {
                    case 2: {
                        tw = BasicTabbedPaneUIAdapter.this.calculateTabAreaWidth(tabPlacement, BasicTabbedPaneUIAdapter.this.runCount, BasicTabbedPaneUIAdapter.this.maxTabWidth);
                        th = bounds.height - insets.top - insets.bottom;
                        tx = insets.left;
                        ty = insets.top;
                        cx = tx + tw + contentInsets.left;
                        cy = ty + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                        break;
                    }
                    case 4: {
                        tw = BasicTabbedPaneUIAdapter.this.calculateTabAreaWidth(tabPlacement, BasicTabbedPaneUIAdapter.this.runCount, BasicTabbedPaneUIAdapter.this.maxTabWidth);
                        th = bounds.height - insets.top - insets.bottom;
                        tx = bounds.width - insets.right - tw;
                        ty = insets.top;
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                        break;
                    }
                    case 3: {
                        tw = bounds.width - insets.left - insets.right;
                        th = BasicTabbedPaneUIAdapter.this.calculateTabAreaHeight(tabPlacement, BasicTabbedPaneUIAdapter.this.runCount, BasicTabbedPaneUIAdapter.this.maxTabHeight);
                        tx = insets.left;
                        ty = bounds.height - insets.bottom - th;
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                        break;
                    }
                    default: {
                        tw = bounds.width - insets.left - insets.right;
                        th = BasicTabbedPaneUIAdapter.this.calculateTabAreaHeight(tabPlacement, BasicTabbedPaneUIAdapter.this.runCount, BasicTabbedPaneUIAdapter.this.maxTabHeight);
                        tx = insets.left;
                        ty = insets.top;
                        cx = tx + contentInsets.left;
                        cy = ty + th + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    }
                }
                for (int i = 0; i < numChildren; ++i) {
                    Component child = BasicTabbedPaneUIAdapter.this.tabPane.getComponent(i);
                    if (BasicTabbedPaneUIAdapter.this.tabScroller != null && child == BasicTabbedPaneUIAdapter.this.tabScroller.viewport) {
                        JViewport viewport = (JViewport)child;
                        Rectangle viewRect = viewport.getViewRect();
                        int vw = tw;
                        int vh = th;
                        Dimension butSize = BasicTabbedPaneUIAdapter.this.tabScroller.scrollForwardButton.getPreferredSize();
                        switch (tabPlacement) {
                            case 2: 
                            case 4: {
                                int totalTabHeight = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[tabCount - 1].y + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[tabCount - 1].height;
                                if (totalTabHeight <= th) break;
                                int n = vh = th > 2 * butSize.height ? th - 2 * butSize.height : 0;
                                if (totalTabHeight - viewRect.y > vh) break;
                                vh = totalTabHeight - viewRect.y;
                                break;
                            }
                            default: {
                                int totalTabWidth = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[tabCount - 1].x + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[tabCount - 1].width;
                                if (totalTabWidth <= tw) break;
                                int n = vw = tw > 2 * butSize.width ? tw - 2 * butSize.width : 0;
                                if (totalTabWidth - viewRect.x > vw) break;
                                vw = totalTabWidth - viewRect.x;
                            }
                        }
                        child.setBounds(tx, ty, vw, vh);
                        continue;
                    }
                    if (BasicTabbedPaneUIAdapter.this.tabScroller != null && (child == BasicTabbedPaneUIAdapter.this.tabScroller.scrollForwardButton || child == BasicTabbedPaneUIAdapter.this.tabScroller.scrollBackwardButton)) {
                        Component scrollbutton = child;
                        Dimension bsize = scrollbutton.getPreferredSize();
                        int bx = 0;
                        int by = 0;
                        int bw = bsize.width;
                        int bh = bsize.height;
                        boolean visible = false;
                        switch (tabPlacement) {
                            case 2: 
                            case 4: {
                                int totalTabHeight = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[tabCount - 1].y + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[tabCount - 1].height;
                                if (totalTabHeight <= th) break;
                                visible = true;
                                bx = tabPlacement == 2 ? tx + tw - bsize.width : tx;
                                by = child == BasicTabbedPaneUIAdapter.this.tabScroller.scrollForwardButton ? bounds.height - insets.bottom - bsize.height : bounds.height - insets.bottom - 2 * bsize.height;
                                break;
                            }
                            default: {
                                int totalTabWidth = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[tabCount - 1].x + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[tabCount - 1].width;
                                if (totalTabWidth <= tw) break;
                                visible = true;
                                bx = child == BasicTabbedPaneUIAdapter.this.tabScroller.scrollForwardButton ? bounds.width - insets.left - bsize.width : bounds.width - insets.left - 2 * bsize.width;
                                by = tabPlacement == 1 ? ty + th - bsize.height : ty;
                            }
                        }
                        child.setVisible(visible);
                        if (!visible) continue;
                        child.setBounds(bx, by, bw, bh);
                        continue;
                    }
                    child.setBounds(cx, cy, cw, ch);
                }
                super.layoutTabComponents();
                this.layoutCroppedEdge();
                if (shouldChangeFocus && !BasicTabbedPaneUIAdapter.this.requestFocusForVisibleComponent()) {
                    BasicTabbedPaneUIAdapter.this.tabPane.requestFocus();
                }
            }
        }

        protected void layoutCroppedEdge() {
            BasicTabbedPaneUIAdapter.this.tabScroller.croppedEdge.resetParams();
            Rectangle viewRect = BasicTabbedPaneUIAdapter.this.tabScroller.viewport.getViewRect();
            block3: for (int i = 0; i < BasicTabbedPaneUIAdapter.this.rects.length; ++i) {
                Rectangle tabRect = BasicTabbedPaneUIAdapter.this.rects[i];
                switch (BasicTabbedPaneUIAdapter.this.tabPane.getTabPlacement()) {
                    case 2: 
                    case 4: {
                        int cropline = viewRect.y + viewRect.height;
                        if (tabRect.y >= cropline || tabRect.y + tabRect.height <= cropline) continue block3;
                        BasicTabbedPaneUIAdapter.this.tabScroller.croppedEdge.setParams(i, cropline - tabRect.y - 1, -BasicTabbedPaneUIAdapter.this.currentTabAreaInsets.left, 0);
                        continue block3;
                    }
                    default: {
                        int cropline = viewRect.x + viewRect.width;
                        if (tabRect.x >= cropline - 1 || tabRect.x + tabRect.width <= cropline) continue block3;
                        BasicTabbedPaneUIAdapter.this.tabScroller.croppedEdge.setParams(i, cropline - tabRect.x - 1, 0, -BasicTabbedPaneUIAdapter.this.currentTabAreaInsets.top);
                    }
                }
            }
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            int rightMargin;
            int i;
            FontMetrics metrics = BasicTabbedPaneUIAdapter.this.getFontMetrics();
            Dimension size = BasicTabbedPaneUIAdapter.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUIAdapter.this.tabPane.getInsets();
            Insets tabAreaInsets = BasicTabbedPaneUIAdapter.this.getTabAreaInsets(tabPlacement);
            int fontHeight = metrics.getHeight();
            int selectedIndex = BasicTabbedPaneUIAdapter.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = BasicTabbedPaneUIAdapter.this.tabPane.getComponentOrientation().isLeftToRight();
            int x = tabAreaInsets.left;
            int y = tabAreaInsets.top;
            int totalWidth = 0;
            int totalHeight = 0;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    BasicTabbedPaneUIAdapter.this.maxTabWidth = BasicTabbedPaneUIAdapter.this.calculateMaxTabWidth(tabPlacement);
                    break;
                }
                default: {
                    BasicTabbedPaneUIAdapter.this.maxTabHeight = BasicTabbedPaneUIAdapter.this.calculateMaxTabHeight(tabPlacement);
                }
            }
            BasicTabbedPaneUIAdapter.this.runCount = 0;
            BasicTabbedPaneUIAdapter.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            BasicTabbedPaneUIAdapter.this.selectedRun = 0;
            BasicTabbedPaneUIAdapter.this.runCount = 1;
            for (i = 0; i < tabCount; ++i) {
                Rectangle rect = BasicTabbedPaneUIAdapter.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i - 1].x + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i - 1].width;
                    } else {
                        ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).tabRuns[0] = 0;
                        BasicTabbedPaneUIAdapter.this.maxTabWidth = 0;
                        totalHeight += BasicTabbedPaneUIAdapter.this.maxTabHeight;
                        rect.x = x;
                    }
                    rect.width = BasicTabbedPaneUIAdapter.this.calculateTabWidth(tabPlacement, i, metrics);
                    totalWidth = rect.x + rect.width;
                    BasicTabbedPaneUIAdapter.this.maxTabWidth = Math.max(BasicTabbedPaneUIAdapter.this.maxTabWidth, rect.width);
                    rect.y = y;
                    rect.height = BasicTabbedPaneUIAdapter.this.maxTabHeight;
                    continue;
                }
                if (i > 0) {
                    rect.y = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i - 1].y + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i - 1].height;
                } else {
                    ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).tabRuns[0] = 0;
                    BasicTabbedPaneUIAdapter.this.maxTabHeight = 0;
                    totalWidth = BasicTabbedPaneUIAdapter.this.maxTabWidth;
                    rect.y = y;
                }
                rect.height = BasicTabbedPaneUIAdapter.this.calculateTabHeight(tabPlacement, i, fontHeight);
                totalHeight = rect.y + rect.height;
                BasicTabbedPaneUIAdapter.this.maxTabHeight = Math.max(BasicTabbedPaneUIAdapter.this.maxTabHeight, rect.height);
                rect.x = x;
                rect.width = BasicTabbedPaneUIAdapter.this.maxTabWidth;
            }
            if (BasicTabbedPaneUIAdapter.this.tabsOverlapBorder) {
                this.padSelectedTab(tabPlacement, selectedIndex);
            }
            if (!leftToRight && !verticalTabRuns) {
                rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (i = 0; i < tabCount; ++i) {
                    ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i].x = rightMargin - ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i].x - ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i].width;
                }
            }
            rightMargin = size.width / 2;
            for (i = 0; i < tabCount; ++i) {
                ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i].x = rightMargin + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i].width;
            }
            BasicTabbedPaneUIAdapter.this.tabScroller.tabPanel.setPreferredSize(new Dimension(totalWidth, totalHeight));
            BasicTabbedPaneUIAdapter.this.tabScroller.tabPanel.invalidate();
        }
    }

    public class MaterialTabbedPaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean minimum) {
            int tabPlacement = BasicTabbedPaneUIAdapter.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUIAdapter.this.tabPane.getInsets();
            Insets contentInsets = BasicTabbedPaneUIAdapter.this.getContentBorderInsets(tabPlacement);
            Insets tabAreaInsets = BasicTabbedPaneUIAdapter.this.getTabAreaInsets(tabPlacement);
            Dimension zeroSize = new Dimension(0, 0);
            int height = 0;
            int width = 0;
            int cWidth = 0;
            int cHeight = 0;
            for (int i = 0; i < BasicTabbedPaneUIAdapter.this.tabPane.getTabCount(); ++i) {
                Dimension size;
                Component component = BasicTabbedPaneUIAdapter.this.tabPane.getComponentAt(i);
                if (component == null) continue;
                Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
                if (size == null) continue;
                cHeight = Math.max(size.height, cHeight);
                cWidth = Math.max(size.width, cWidth);
            }
            width += cWidth;
            height += cHeight;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    height = Math.max(height, BasicTabbedPaneUIAdapter.this.calculateMaxTabHeight(tabPlacement));
                    int tabExtent = this.preferredTabAreaWidth(tabPlacement, height - tabAreaInsets.top - tabAreaInsets.bottom);
                    width += tabExtent;
                    break;
                }
                default: {
                    width = Math.max(width, BasicTabbedPaneUIAdapter.this.calculateMaxTabWidth(tabPlacement));
                    int tabExtent = this.preferredTabAreaHeight(tabPlacement, width - tabAreaInsets.left - tabAreaInsets.right);
                    height += tabExtent;
                }
            }
            return new Dimension(width + insets.left + insets.right + contentInsets.left + contentInsets.right, height + insets.bottom + insets.top + contentInsets.top + contentInsets.bottom);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            FontMetrics metrics = BasicTabbedPaneUIAdapter.this.getFontMetrics();
            int tabCount = BasicTabbedPaneUIAdapter.this.tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int rows = 1;
                int x = 0;
                int maxTabHeight = BasicTabbedPaneUIAdapter.this.calculateMaxTabHeight(tabPlacement);
                for (int i = 0; i < tabCount; ++i) {
                    int tabWidth = BasicTabbedPaneUIAdapter.this.calculateTabWidth(tabPlacement, i, metrics);
                    if (x != 0 && x + tabWidth > width) {
                        ++rows;
                        x = 0;
                    }
                    x += tabWidth;
                }
                total = BasicTabbedPaneUIAdapter.this.calculateTabAreaHeight(tabPlacement, rows, maxTabHeight);
            }
            return total;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            FontMetrics metrics = BasicTabbedPaneUIAdapter.this.getFontMetrics();
            int tabCount = BasicTabbedPaneUIAdapter.this.tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int columns = 1;
                int y = 0;
                int fontHeight = metrics.getHeight();
                BasicTabbedPaneUIAdapter.this.maxTabWidth = BasicTabbedPaneUIAdapter.this.calculateMaxTabWidth(tabPlacement);
                for (int i = 0; i < tabCount; ++i) {
                    int tabHeight = BasicTabbedPaneUIAdapter.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    if (y != 0 && y + tabHeight > height) {
                        ++columns;
                        y = 0;
                    }
                    y += tabHeight;
                }
                total = BasicTabbedPaneUIAdapter.this.calculateTabAreaWidth(tabPlacement, columns, BasicTabbedPaneUIAdapter.this.maxTabWidth);
            }
            return total;
        }

        @Override
        public void layoutContainer(Container parent) {
            BasicTabbedPaneUIAdapter.this.setRolloverTab(-1);
            int tabPlacement = BasicTabbedPaneUIAdapter.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUIAdapter.this.tabPane.getInsets();
            int selectedIndex = BasicTabbedPaneUIAdapter.this.tabPane.getSelectedIndex();
            Component visibleComponent = BasicTabbedPaneUIAdapter.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component selectedComponent = null;
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    BasicTabbedPaneUIAdapter.this.setVisibleComponent(null);
                }
            } else {
                selectedComponent = BasicTabbedPaneUIAdapter.this.tabPane.getComponentAt(selectedIndex);
            }
            int totalTabWidth = 0;
            int totalTabHeight = 0;
            Insets contentInsets = BasicTabbedPaneUIAdapter.this.getContentBorderInsets(tabPlacement);
            boolean shouldChangeFocus = false;
            if (selectedComponent != null) {
                if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                    shouldChangeFocus = true;
                }
                BasicTabbedPaneUIAdapter.this.setVisibleComponent(selectedComponent);
            }
            Rectangle bounds = BasicTabbedPaneUIAdapter.this.tabPane.getBounds();
            int numChildren = BasicTabbedPaneUIAdapter.this.tabPane.getComponentCount();
            if (numChildren > 0) {
                int cy;
                int cx;
                switch (tabPlacement) {
                    case 2: {
                        totalTabWidth = BasicTabbedPaneUIAdapter.this.calculateTabAreaWidth(tabPlacement, BasicTabbedPaneUIAdapter.this.runCount, BasicTabbedPaneUIAdapter.this.maxTabWidth);
                        cx = insets.left + totalTabWidth + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        break;
                    }
                    case 4: {
                        totalTabWidth = BasicTabbedPaneUIAdapter.this.calculateTabAreaWidth(tabPlacement, BasicTabbedPaneUIAdapter.this.runCount, BasicTabbedPaneUIAdapter.this.maxTabWidth);
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        break;
                    }
                    case 3: {
                        totalTabHeight = BasicTabbedPaneUIAdapter.this.calculateTabAreaHeight(tabPlacement, BasicTabbedPaneUIAdapter.this.runCount, BasicTabbedPaneUIAdapter.this.maxTabHeight);
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        break;
                    }
                    default: {
                        totalTabHeight = BasicTabbedPaneUIAdapter.this.calculateTabAreaHeight(tabPlacement, BasicTabbedPaneUIAdapter.this.runCount, BasicTabbedPaneUIAdapter.this.maxTabHeight);
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + totalTabHeight + contentInsets.top;
                    }
                }
                int cw = bounds.width - totalTabWidth - insets.left - insets.right - contentInsets.left - contentInsets.right;
                int ch = bounds.height - totalTabHeight - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                for (int i = 0; i < numChildren; ++i) {
                    Component child = BasicTabbedPaneUIAdapter.this.tabPane.getComponent(i);
                    if (child == BasicTabbedPaneUIAdapter.this.tabContainer) {
                        int tabContainerWidth = totalTabWidth == 0 ? bounds.width : totalTabWidth + insets.left + insets.right + contentInsets.left + contentInsets.right;
                        int tabContainerHeight = totalTabHeight == 0 ? bounds.height : totalTabHeight + insets.top + insets.bottom + contentInsets.top + contentInsets.bottom;
                        int tabContainerX = 0;
                        int tabContainerY = 0;
                        if (tabPlacement == 3) {
                            tabContainerY = bounds.height - tabContainerHeight;
                        } else if (tabPlacement == 4) {
                            tabContainerX = bounds.width - tabContainerWidth;
                        }
                        child.setBounds(tabContainerX, tabContainerY, tabContainerWidth, tabContainerHeight);
                        continue;
                    }
                    child.setBounds(cx, cy, cw, ch);
                }
            }
            this.layoutTabComponents();
            if (shouldChangeFocus && !BasicTabbedPaneUIAdapter.this.requestFocusForVisibleComponent()) {
                BasicTabbedPaneUIAdapter.this.tabPane.requestFocus();
            }
        }

        public void calculateLayoutInfo() {
            int tabCount = BasicTabbedPaneUIAdapter.this.tabPane.getTabCount();
            BasicTabbedPaneUIAdapter.this.assureRectsCreated(tabCount);
            this.calculateTabRects(BasicTabbedPaneUIAdapter.this.tabPane.getTabPlacement(), tabCount);
            BasicTabbedPaneUIAdapter.this.isRunsDirty = false;
        }

        protected void layoutTabComponents() {
            if (BasicTabbedPaneUIAdapter.this.tabContainer == null) {
                return;
            }
            Rectangle rect = new Rectangle();
            Point delta = new Point(-BasicTabbedPaneUIAdapter.this.tabContainer.getX(), -BasicTabbedPaneUIAdapter.this.tabContainer.getY());
            if (BasicTabbedPaneUIAdapter.this.scrollableTabLayoutEnabled()) {
                BasicTabbedPaneUIAdapter.this.translatePointToTabPanel(0, 0, delta);
            }
            for (int i = 0; i < BasicTabbedPaneUIAdapter.this.tabPane.getTabCount(); ++i) {
                Component c = BasicTabbedPaneUIAdapter.this.tabPane.getTabComponentAt(i);
                if (c == null) continue;
                BasicTabbedPaneUIAdapter.this.getTabBounds(i, rect);
                Dimension preferredSize = c.getPreferredSize();
                Insets insets = BasicTabbedPaneUIAdapter.this.getTabInsets(BasicTabbedPaneUIAdapter.this.tabPane.getTabPlacement(), i);
                int outerX = rect.x + insets.left + delta.x;
                int outerY = rect.y + insets.top + delta.y;
                int outerWidth = rect.width - insets.left - insets.right;
                int outerHeight = rect.height - insets.top - insets.bottom;
                int x = outerX + (outerWidth - preferredSize.width) / 2;
                int y = outerY + (outerHeight - preferredSize.height) / 2;
                int tabPlacement = BasicTabbedPaneUIAdapter.this.tabPane.getTabPlacement();
                boolean isSeleceted = i == BasicTabbedPaneUIAdapter.this.tabPane.getSelectedIndex();
                c.setBounds(x + BasicTabbedPaneUIAdapter.this.getTabLabelShiftX(tabPlacement, i, isSeleceted), y + BasicTabbedPaneUIAdapter.this.getTabLabelShiftY(tabPlacement, i, isSeleceted), preferredSize.width, preferredSize.height);
            }
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Rectangle rect;
            int i;
            int returnAt;
            int y;
            int x;
            FontMetrics metrics = BasicTabbedPaneUIAdapter.this.getFontMetrics();
            Dimension size = BasicTabbedPaneUIAdapter.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUIAdapter.this.tabPane.getInsets();
            Insets tabAreaInsets = BasicTabbedPaneUIAdapter.this.getTabAreaInsets(tabPlacement);
            int fontHeight = metrics.getHeight();
            int selectedIndex = BasicTabbedPaneUIAdapter.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = BasicTabbedPaneUIAdapter.this.tabPane.getComponentOrientation().isLeftToRight();
            switch (tabPlacement) {
                case 2: {
                    BasicTabbedPaneUIAdapter.this.maxTabWidth = BasicTabbedPaneUIAdapter.this.calculateMaxTabWidth(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUIAdapter.this.maxTabWidth = BasicTabbedPaneUIAdapter.this.calculateMaxTabWidth(tabPlacement);
                    x = size.width - insets.right - tabAreaInsets.right - BasicTabbedPaneUIAdapter.this.maxTabWidth;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUIAdapter.this.maxTabHeight = BasicTabbedPaneUIAdapter.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = size.height - insets.bottom - tabAreaInsets.bottom - BasicTabbedPaneUIAdapter.this.maxTabHeight;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                    break;
                }
                default: {
                    BasicTabbedPaneUIAdapter.this.maxTabHeight = BasicTabbedPaneUIAdapter.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                }
            }
            int tabRunOverlay = BasicTabbedPaneUIAdapter.this.getTabRunOverlay(tabPlacement);
            BasicTabbedPaneUIAdapter.this.runCount = 0;
            BasicTabbedPaneUIAdapter.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            for (i = 0; i < tabCount; ++i) {
                rect = BasicTabbedPaneUIAdapter.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i - 1].x + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i - 1].width;
                    } else {
                        ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).tabRuns[0] = 0;
                        BasicTabbedPaneUIAdapter.this.runCount = 1;
                        BasicTabbedPaneUIAdapter.this.maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = BasicTabbedPaneUIAdapter.this.calculateTabWidth(tabPlacement, i, metrics);
                    BasicTabbedPaneUIAdapter.this.maxTabWidth = Math.max(BasicTabbedPaneUIAdapter.this.maxTabWidth, rect.width);
                    if (rect.x != x && rect.x + rect.width > returnAt) {
                        if (BasicTabbedPaneUIAdapter.this.runCount > BasicTabbedPaneUIAdapter.this.tabRuns.length - 1) {
                            BasicTabbedPaneUIAdapter.this.expandTabRunsArray();
                        }
                        ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).tabRuns[((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).runCount] = i;
                        BasicTabbedPaneUIAdapter.this.runCount++;
                        rect.x = x;
                    }
                    rect.y = y;
                    rect.height = BasicTabbedPaneUIAdapter.this.maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i - 1].y + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i - 1].height;
                    } else {
                        ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).tabRuns[0] = 0;
                        BasicTabbedPaneUIAdapter.this.runCount = 1;
                        BasicTabbedPaneUIAdapter.this.maxTabHeight = 0;
                        rect.y = y;
                    }
                    rect.height = BasicTabbedPaneUIAdapter.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    BasicTabbedPaneUIAdapter.this.maxTabHeight = Math.max(BasicTabbedPaneUIAdapter.this.maxTabHeight, rect.height);
                    if (rect.y != y && rect.y + rect.height > returnAt) {
                        if (BasicTabbedPaneUIAdapter.this.runCount > BasicTabbedPaneUIAdapter.this.tabRuns.length - 1) {
                            BasicTabbedPaneUIAdapter.this.expandTabRunsArray();
                        }
                        ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).tabRuns[((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).runCount] = i;
                        BasicTabbedPaneUIAdapter.this.runCount++;
                        rect.y = y;
                    }
                    rect.x = x;
                    rect.width = BasicTabbedPaneUIAdapter.this.maxTabWidth;
                }
                if (i != selectedIndex) continue;
                BasicTabbedPaneUIAdapter.this.selectedRun = BasicTabbedPaneUIAdapter.this.runCount - 1;
            }
            if (BasicTabbedPaneUIAdapter.this.runCount > 1) {
                this.normalizeTabRuns(tabPlacement, tabCount, verticalTabRuns ? y : x, returnAt);
                BasicTabbedPaneUIAdapter.this.selectedRun = BasicTabbedPaneUIAdapter.this.getRunForTab(tabCount, selectedIndex);
                if (BasicTabbedPaneUIAdapter.this.shouldRotateTabRuns(tabPlacement)) {
                    this.rotateTabRuns(tabPlacement, BasicTabbedPaneUIAdapter.this.selectedRun);
                }
            }
            for (i = BasicTabbedPaneUIAdapter.this.runCount - 1; i >= 0; --i) {
                int j;
                int end;
                int start = BasicTabbedPaneUIAdapter.this.tabRuns[i];
                int next = BasicTabbedPaneUIAdapter.this.tabRuns[i == BasicTabbedPaneUIAdapter.this.runCount - 1 ? 0 : i + 1];
                int n = end = next != 0 ? next - 1 : tabCount - 1;
                if (!verticalTabRuns) {
                    for (j = start; j <= end; ++j) {
                        rect = BasicTabbedPaneUIAdapter.this.rects[j];
                        rect.y = y;
                        rect.x += BasicTabbedPaneUIAdapter.this.getTabRunIndent(tabPlacement, i);
                    }
                    if (BasicTabbedPaneUIAdapter.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, returnAt);
                    }
                    if (tabPlacement == 3) {
                        y -= BasicTabbedPaneUIAdapter.this.maxTabHeight - tabRunOverlay;
                        continue;
                    }
                    y += BasicTabbedPaneUIAdapter.this.maxTabHeight - tabRunOverlay;
                    continue;
                }
                for (j = start; j <= end; ++j) {
                    rect = BasicTabbedPaneUIAdapter.this.rects[j];
                    rect.x = x;
                    rect.y += BasicTabbedPaneUIAdapter.this.getTabRunIndent(tabPlacement, i);
                }
                if (BasicTabbedPaneUIAdapter.this.shouldPadTabRun(tabPlacement, i)) {
                    this.padTabRun(tabPlacement, start, end, returnAt);
                }
                if (tabPlacement == 4) {
                    x -= BasicTabbedPaneUIAdapter.this.maxTabWidth - tabRunOverlay;
                    continue;
                }
                x += BasicTabbedPaneUIAdapter.this.maxTabWidth - tabRunOverlay;
            }
            this.padSelectedTab(tabPlacement, selectedIndex);
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (i = 0; i < tabCount; ++i) {
                    ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i].x = rightMargin - ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i].x - ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i].width;
                }
            }
            int dimensionTab = BasicTabbedPaneUIAdapter.this.maxTabWidth * tabCount;
            int rightMargin = size.width / 2 - dimensionTab / 2;
            for (i = 0; i < tabCount; ++i) {
                ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i].x += rightMargin;
            }
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            for (int i = 0; i < selectedRun; ++i) {
                int save = BasicTabbedPaneUIAdapter.this.tabRuns[0];
                for (int j = 1; j < BasicTabbedPaneUIAdapter.this.runCount; ++j) {
                    ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).tabRuns[j - 1] = BasicTabbedPaneUIAdapter.this.tabRuns[j];
                }
                ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).tabRuns[((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).runCount - 1] = save;
            }
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            int run = BasicTabbedPaneUIAdapter.this.runCount - 1;
            boolean keepAdjusting = true;
            double weight = 1.25;
            while (keepAdjusting) {
                int prevLastLen;
                int end;
                int last = BasicTabbedPaneUIAdapter.this.lastTabInRun(tabCount, run);
                int prevLast = BasicTabbedPaneUIAdapter.this.lastTabInRun(tabCount, run - 1);
                if (!verticalTabRuns) {
                    end = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[last].x + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[last].width;
                    prevLastLen = (int)((double)BasicTabbedPaneUIAdapter.this.maxTabWidth * weight);
                } else {
                    end = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[last].y + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[last].height;
                    prevLastLen = (int)((double)BasicTabbedPaneUIAdapter.this.maxTabHeight * weight * 2.0);
                }
                if (max - end > prevLastLen) {
                    ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).tabRuns[run] = prevLast;
                    if (!verticalTabRuns) {
                        ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[prevLast].x = start;
                    } else {
                        ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[prevLast].y = start;
                    }
                    for (int i = prevLast + 1; i <= last; ++i) {
                        if (!verticalTabRuns) {
                            ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i].x = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i - 1].x + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i - 1].width;
                            continue;
                        }
                        ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i].y = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i - 1].y + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[i - 1].height;
                    }
                } else if (run == BasicTabbedPaneUIAdapter.this.runCount - 1) {
                    keepAdjusting = false;
                }
                if (run - 1 > 0) {
                    --run;
                    continue;
                }
                run = BasicTabbedPaneUIAdapter.this.runCount - 1;
                weight += 0.25;
            }
        }

        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            Rectangle lastRect = BasicTabbedPaneUIAdapter.this.rects[end];
            if (tabPlacement == 1 || tabPlacement == 3) {
                int runWidth = lastRect.x + lastRect.width - ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[start].x;
                int deltaWidth = max - (lastRect.x + lastRect.width);
                float factor = (float)deltaWidth / (float)runWidth;
                for (int j = start; j <= end; ++j) {
                    Rectangle pastRect = BasicTabbedPaneUIAdapter.this.rects[j];
                    if (j > start) {
                        pastRect.x = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[j - 1].x + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[j - 1].width;
                    }
                    pastRect.width += Math.round((float)pastRect.width * factor);
                }
                lastRect.width = max - lastRect.x;
            } else {
                int runHeight = lastRect.y + lastRect.height - ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[start].y;
                int deltaHeight = max - (lastRect.y + lastRect.height);
                float factor = (float)deltaHeight / (float)runHeight;
                for (int j = start; j <= end; ++j) {
                    Rectangle pastRect = BasicTabbedPaneUIAdapter.this.rects[j];
                    if (j > start) {
                        pastRect.y = ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[j - 1].y + ((BasicTabbedPaneUIAdapter)BasicTabbedPaneUIAdapter.this).rects[j - 1].height;
                    }
                    pastRect.height += Math.round((float)pastRect.height * factor);
                }
                lastRect.height = max - lastRect.y;
            }
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
            if (selectedIndex >= 0) {
                Rectangle selRect = BasicTabbedPaneUIAdapter.this.rects[selectedIndex];
                Insets padInsets = BasicTabbedPaneUIAdapter.this.getSelectedTabPadInsets(tabPlacement);
                selRect.x -= padInsets.left;
                selRect.width += padInsets.left + padInsets.right;
                selRect.y -= padInsets.top;
                selRect.height += padInsets.top + padInsets.bottom;
                if (!BasicTabbedPaneUIAdapter.this.scrollableTabLayoutEnabled()) {
                    Dimension size = BasicTabbedPaneUIAdapter.this.tabPane.getSize();
                    Insets insets = BasicTabbedPaneUIAdapter.this.tabPane.getInsets();
                    if (tabPlacement == 2 || tabPlacement == 4) {
                        int bottom;
                        int top = insets.top - selRect.y;
                        if (top > 0) {
                            selRect.y += top;
                            selRect.height -= top;
                        }
                        if ((bottom = selRect.y + selRect.height + insets.bottom - size.height) > 0) {
                            selRect.height -= bottom;
                        }
                    } else {
                        int right;
                        int left = insets.left - selRect.x;
                        if (left > 0) {
                            selRect.x += left;
                            selRect.width -= left;
                        }
                        if ((right = selRect.x + selRect.width + insets.right - size.width) > 0) {
                            selRect.width -= right;
                        }
                    }
                }
            }
        }
    }
}

