/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.animation;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

class MaterialUIStaticMovement
implements MouseListener {
    private Color before;
    private Color after;
    private Color strongOnClick;

    public MaterialUIStaticMovement(Color before, Color after, Color strongOnClick) {
        this.before = before;
        this.after = after;
        this.strongOnClick = strongOnClick;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e == null) {
            return;
        }
        this.setColorComponent(e, this.strongOnClick);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e == null) {
            return;
        }
        this.setColorComponent(e, this.after);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e == null) {
            return;
        }
        this.setColorComponent(e, this.after);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e == null) {
            return;
        }
        this.setColorComponent(e, this.before);
    }

    private void setColorComponent(MouseEvent e, Color colorComponent) {
        if (e == null || colorComponent == null) {
            throw new IllegalArgumentException("The argument is/are null");
        }
        JComponent component = (JComponent)e.getSource();
        if (component.isEnabled()) {
            component.setBackground(colorComponent);
        }
    }
}

