/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.shapes;

import georegression.metric.Area2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Quadrilateral_F64
implements Serializable {
    public Point2D_F64 a;
    public Point2D_F64 b;
    public Point2D_F64 c;
    public Point2D_F64 d;

    public Quadrilateral_F64() {
        this.a = new Point2D_F64();
        this.b = new Point2D_F64();
        this.c = new Point2D_F64();
        this.d = new Point2D_F64();
    }

    public Quadrilateral_F64(Quadrilateral_F64 quad) {
        this();
        this.a.setTo(quad.a);
        this.b.setTo(quad.b);
        this.c.setTo(quad.c);
        this.d.setTo(quad.d);
    }

    public Quadrilateral_F64(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        this.a = new Point2D_F64(x0, y0);
        this.b = new Point2D_F64(x1, y1);
        this.c = new Point2D_F64(x2, y2);
        this.d = new Point2D_F64(x3, y3);
    }

    public Quadrilateral_F64(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c, Point2D_F64 d) {
        this(a, b, c, d, true);
    }

    public Quadrilateral_F64(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c, Point2D_F64 d, boolean copy) {
        if (copy) {
            this.a = new Point2D_F64(a);
            this.b = new Point2D_F64(b);
            this.c = new Point2D_F64(c);
            this.d = new Point2D_F64(d);
        } else {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }
    }

    public double area() {
        return Area2D_F64.quadrilateral(this);
    }

    public Point2D_F64 get(int index) {
        switch (index) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.d;
            }
        }
        throw new IllegalArgumentException("Requested index out of range. " + index);
    }

    public Point2D_F64 getA() {
        return this.a;
    }

    public void setA(Point2D_F64 a) {
        this.a = a;
    }

    public Point2D_F64 getB() {
        return this.b;
    }

    public void setB(Point2D_F64 b) {
        this.b = b;
    }

    public Point2D_F64 getC() {
        return this.c;
    }

    public void setC(Point2D_F64 c) {
        this.c = c;
    }

    public Point2D_F64 getD() {
        return this.d;
    }

    public void setD(Point2D_F64 d) {
        this.d = d;
    }

    public LineSegment2D_F64 getLine(int which, LineSegment2D_F64 storage) {
        if (storage == null) {
            storage = new LineSegment2D_F64();
        }
        switch (which) {
            case 0: {
                storage.a.setTo(this.a);
                storage.b.setTo(this.b);
                break;
            }
            case 1: {
                storage.a.setTo(this.b);
                storage.b.setTo(this.c);
                break;
            }
            case 2: {
                storage.a.setTo(this.c);
                storage.b.setTo(this.d);
                break;
            }
            case 3: {
                storage.a.setTo(this.d);
                storage.b.setTo(this.a);
                break;
            }
            default: {
                throw new IllegalArgumentException("Requested index out of range. " + which);
            }
        }
        return storage;
    }

    public double getSideLength(int which) {
        return Math.sqrt(this.getSideLength2(which));
    }

    public double getSideLength2(int which) {
        switch (which) {
            case 0: {
                return this.a.distance2(this.b);
            }
            case 1: {
                return this.b.distance2(this.c);
            }
            case 2: {
                return this.c.distance2(this.d);
            }
            case 3: {
                return this.d.distance2(this.a);
            }
        }
        throw new IllegalArgumentException("Requested index out of range. " + which);
    }

    public void setTo(Quadrilateral_F64 quad) {
        this.a.setTo(quad.a);
        this.b.setTo(quad.b);
        this.c.setTo(quad.c);
        this.d.setTo(quad.d);
    }

    public List<Point2D_F64> convert(@Nullable List<Point2D_F64> storage, boolean copy) {
        if (storage == null) {
            storage = new ArrayList<Point2D_F64>();
        } else {
            storage.clear();
        }
        if (copy) {
            for (int i = 0; i < 4; ++i) {
                storage.add(this.get(i).copy());
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                storage.add(this.get(i));
            }
        }
        return storage;
    }

    public void setTo(List<Point2D_F64> list) {
        if (list.size() != 4) {
            throw new IllegalArgumentException("List must have size of 4");
        }
        this.a.setTo(list.get(0));
        this.b.setTo(list.get(1));
        this.c.setTo(list.get(2));
        this.d.setTo(list.get(3));
    }

    public Quadrilateral_F64 copy() {
        return new Quadrilateral_F64(this);
    }

    public boolean isEquals(Quadrilateral_F64 quad, double tol) {
        tol *= tol;
        if (this.a.distance2(quad.a) > tol) {
            return false;
        }
        if (this.b.distance2(quad.b) > tol) {
            return false;
        }
        if (this.c.distance2(quad.c) > tol) {
            return false;
        }
        return this.d.distance2(quad.d) <= tol;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + '}';
    }
}

