/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.line;

import georegression.struct.GeoTuple_F32;
import georegression.struct.point.Point3D_F32;
import java.io.Serializable;

public class LineSegment3D_F32
implements Serializable {
    public Point3D_F32 a = new Point3D_F32();
    public Point3D_F32 b = new Point3D_F32();

    public LineSegment3D_F32() {
    }

    public LineSegment3D_F32(Point3D_F32 a, Point3D_F32 b) {
        this.setTo(a, b);
    }

    public LineSegment3D_F32(float x0, float y0, float z0, float x1, float y1, float z1) {
        this.setTo(x0, y0, z0, x1, y1, z1);
    }

    public static LineSegment3D_F32 wrap(Point3D_F32 a, Point3D_F32 b) {
        LineSegment3D_F32 ret = new LineSegment3D_F32();
        ret.a = a;
        ret.b = b;
        return ret;
    }

    public void setTo(LineSegment3D_F32 l) {
        this.a.setTo(l.a);
        this.b.setTo(l.b);
    }

    public void setTo(Point3D_F32 a, Point3D_F32 b) {
        this.a.setTo(a);
        this.b.setTo(b);
    }

    public void setTo(float x0, float y0, float z0, float x1, float y1, float z1) {
        this.a.setTo(x0, y0, z0);
        this.b.setTo(x1, y1, z1);
    }

    public Point3D_F32 getA() {
        return this.a;
    }

    public void setA(Point3D_F32 a) {
        this.a = a;
    }

    public Point3D_F32 getB() {
        return this.b;
    }

    public void setB(Point3D_F32 b) {
        this.b = b;
    }

    public float slopeX() {
        return this.b.x - this.a.x;
    }

    public float slopeY() {
        return this.b.y - this.a.y;
    }

    public float getLength() {
        return this.a.distance((GeoTuple_F32)this.b);
    }

    public float getLength2() {
        return this.a.distance2((GeoTuple_F32)this.b);
    }

    public LineSegment3D_F32 copy() {
        return new LineSegment3D_F32(this.a, this.b);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{a=" + this.a + ", b=" + this.b + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LineSegment3D_F32)) {
            return false;
        }
        LineSegment3D_F32 o = (LineSegment3D_F32)obj;
        return this.a.equals(o.a) && this.b.equals(o.b);
    }

    public int hashCode() {
        return this.a.hashCode() + this.b.hashCode();
    }
}

