/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.curve;

import java.io.Serializable;
import org.ejml.FancyPrint;
import org.ejml.UtilEjml;

public class ConicGeneral_F64
implements Serializable {
    public double A;
    public double B;
    public double C;
    public double D;
    public double E;
    public double F;

    public ConicGeneral_F64(double a, double b, double c, double d, double e, double f) {
        this.A = a;
        this.B = b;
        this.C = c;
        this.D = d;
        this.E = e;
        this.F = f;
    }

    public ConicGeneral_F64(ConicGeneral_F64 original) {
        this.setTo(original);
    }

    public ConicGeneral_F64() {
    }

    public double evaluate(double x, double y) {
        return this.A * x * x + this.B * x * y + this.C * y * y + this.D * x + this.E * y + this.F;
    }

    public boolean hasUncountable() {
        return UtilEjml.isUncountable(this.A) || UtilEjml.isUncountable(this.B) || UtilEjml.isUncountable(this.C) || UtilEjml.isUncountable(this.D) || UtilEjml.isUncountable(this.E) || UtilEjml.isUncountable(this.F);
    }

    public boolean isEllipse(double tol) {
        return this.B * this.B + tol < 4.0 * this.A * this.C;
    }

    public boolean isParabola(double tol) {
        return Math.abs(this.B * this.B - 4.0 * this.A * this.C) <= tol;
    }

    public boolean isHyperbola(double tol) {
        return this.B * this.B - tol > 4.0 * this.A * this.C;
    }

    public void setTo(ConicGeneral_F64 original) {
        this.A = original.A;
        this.B = original.B;
        this.C = original.C;
        this.D = original.D;
        this.E = original.E;
        this.F = original.F;
    }

    public void setTo(double a, double b, double c, double d, double e, double f) {
        this.A = a;
        this.B = b;
        this.C = c;
        this.D = d;
        this.E = e;
        this.F = f;
    }

    public ConicGeneral_F64 copy() {
        return new ConicGeneral_F64(this.A, this.B, this.C, this.D, this.E, this.F);
    }

    public String toString() {
        FancyPrint fp = new FancyPrint();
        return "ConicGeneral_F64{A=" + fp.p(this.A) + ", B=" + fp.p(this.B) + ", C=" + fp.p(this.C) + ", D=" + fp.p(this.D) + ", E=" + fp.p(this.E) + ", F=" + fp.p(this.F) + '}';
    }
}

