/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple;

public abstract class GeoTuple_F32<T extends GeoTuple_F32>
extends GeoTuple<T> {
    public boolean isIdentical(T t, float tol) {
        if (((GeoTuple)t).getDimension() != this.getDimension()) {
            return false;
        }
        int N = this.getDimension();
        for (int i = 0; i < N; ++i) {
            float diff = Math.abs(this.getIdx(i) - ((GeoTuple_F32)t).getIdx(i));
            if (!(diff > tol)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T copy() {
        GeoTuple_F32 ret = (GeoTuple_F32)this.createNewInstance();
        int N = this.getDimension();
        for (int i = 0; i < N; ++i) {
            ret.setIdx(i, this.getIdx(i));
        }
        return (T)ret;
    }

    public float norm() {
        return (float)Math.sqrt(this.normSq());
    }

    public float normSq() {
        float total = 0.0f;
        int N = this.getDimension();
        for (int i = 0; i < N; ++i) {
            float a = this.getIdx(i);
            total += a * a;
        }
        return total;
    }

    public float distance(T t) {
        return (float)Math.sqrt(this.distance2(t));
    }

    public float distance2(T t) {
        if (((GeoTuple)t).getDimension() != this.getDimension()) {
            throw new IllegalArgumentException("Dimension of input tuple does not match");
        }
        float total = 0.0f;
        int N = this.getDimension();
        for (int i = 0; i < N; ++i) {
            float diff = Math.abs(this.getIdx(i) - ((GeoTuple_F32)t).getIdx(i));
            total += diff * diff;
        }
        return total;
    }

    public abstract float getIdx(int var1);

    public abstract void setIdx(int var1, float var2);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoTuple_F32)) {
            return false;
        }
        GeoTuple_F32 o = (GeoTuple_F32)obj;
        int N = this.getDimension();
        if (N != o.getDimension()) {
            return false;
        }
        for (int i = 0; i < N; ++i) {
            if (this.getIdx(i) == o.getIdx(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int N = this.getDimension();
        int hash = 0;
        for (int i = 0; i < N; ++i) {
            hash += Float.hashCode(this.getIdx(i));
        }
        return hash;
    }
}

